/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.qtesla;

import org.bouncycastle.pqc.crypto.qtesla.CommonFunction;

class Pack {
    Pack() {
    }

    public static void encodePrivateKeyI(byte[] privateKey, int[] secretPolynomial, int[] errorPolynomial, byte[] seed, int seedOffset) {
        int i;
        int j = 0;
        for (i = 0; i < 512; i += 4) {
            privateKey[j + 0] = (byte)secretPolynomial[i + 0];
            privateKey[j + 1] = (byte)(secretPolynomial[i + 0] >> 8 & 3 | secretPolynomial[i + 1] << 2);
            privateKey[j + 2] = (byte)(secretPolynomial[i + 1] >> 6 & 0xF | secretPolynomial[i + 2] << 4);
            privateKey[j + 3] = (byte)(secretPolynomial[i + 2] >> 4 & 0x3F | secretPolynomial[i + 3] << 6);
            privateKey[j + 4] = (byte)(secretPolynomial[i + 3] >> 2);
            j += 5;
        }
        for (i = 0; i < 512; i += 4) {
            privateKey[j + 0] = (byte)errorPolynomial[i + 0];
            privateKey[j + 1] = (byte)(errorPolynomial[i + 0] >> 8 & 3 | errorPolynomial[i + 1] << 2);
            privateKey[j + 2] = (byte)(errorPolynomial[i + 1] >> 6 & 0xF | errorPolynomial[i + 2] << 4);
            privateKey[j + 3] = (byte)(errorPolynomial[i + 2] >> 4 & 0x3F | errorPolynomial[i + 3] << 6);
            privateKey[j + 4] = (byte)(errorPolynomial[i + 3] >> 2);
            j += 5;
        }
        System.arraycopy(seed, seedOffset, privateKey, 1280, 64);
    }

    public static void encodePrivateKeyIIISize(byte[] privateKey, int[] secretPolynomial, int[] errorPolynomial, byte[] seed, int seedOffset) {
        int i;
        for (i = 0; i < 1024; ++i) {
            privateKey[i] = (byte)secretPolynomial[i];
        }
        for (i = 0; i < 1024; ++i) {
            privateKey[1024 + i] = (byte)errorPolynomial[i];
        }
        System.arraycopy(seed, seedOffset, privateKey, 2048, 64);
    }

    public static void encodePrivateKeyIIISpeed(byte[] privateKey, int[] secretPolynomial, int[] errorPolynomial, byte[] seed, int seedOffset) {
        int i;
        int j = 0;
        for (i = 0; i < 1024; i += 8) {
            privateKey[j + 0] = (byte)secretPolynomial[i + 0];
            privateKey[j + 1] = (byte)(secretPolynomial[i + 0] >> 8 & 1 | secretPolynomial[i + 1] << 1);
            privateKey[j + 2] = (byte)(secretPolynomial[i + 1] >> 7 & 3 | secretPolynomial[i + 2] << 2);
            privateKey[j + 3] = (byte)(secretPolynomial[i + 2] >> 6 & 7 | secretPolynomial[i + 3] << 3);
            privateKey[j + 4] = (byte)(secretPolynomial[i + 3] >> 5 & 0xF | secretPolynomial[i + 4] << 4);
            privateKey[j + 5] = (byte)(secretPolynomial[i + 4] >> 4 & 0x1F | secretPolynomial[i + 5] << 5);
            privateKey[j + 6] = (byte)(secretPolynomial[i + 5] >> 3 & 0x3F | secretPolynomial[i + 6] << 6);
            privateKey[j + 7] = (byte)(secretPolynomial[i + 6] >> 2 & 0x7F | secretPolynomial[i + 7] << 7);
            privateKey[j + 8] = (byte)(secretPolynomial[i + 7] >> 1);
            j += 9;
        }
        for (i = 0; i < 1024; i += 8) {
            privateKey[j + 0] = (byte)errorPolynomial[i + 0];
            privateKey[j + 1] = (byte)(errorPolynomial[i + 0] >> 8 & 1 | errorPolynomial[i + 1] << 1);
            privateKey[j + 2] = (byte)(errorPolynomial[i + 1] >> 7 & 3 | errorPolynomial[i + 2] << 2);
            privateKey[j + 3] = (byte)(errorPolynomial[i + 2] >> 6 & 7 | errorPolynomial[i + 3] << 3);
            privateKey[j + 4] = (byte)(errorPolynomial[i + 3] >> 5 & 0xF | errorPolynomial[i + 4] << 4);
            privateKey[j + 5] = (byte)(errorPolynomial[i + 4] >> 4 & 0x1F | errorPolynomial[i + 5] << 5);
            privateKey[j + 6] = (byte)(errorPolynomial[i + 5] >> 3 & 0x3F | errorPolynomial[i + 6] << 6);
            privateKey[j + 7] = (byte)(errorPolynomial[i + 6] >> 2 & 0x7F | errorPolynomial[i + 7] << 7);
            privateKey[j + 8] = (byte)(errorPolynomial[i + 7] >> 1);
            j += 9;
        }
        System.arraycopy(seed, seedOffset, privateKey, 2304, 64);
    }

    public static void decodePrivateKeyI(byte[] seed, short[] secretPolynomial, short[] errorPolynomial, byte[] privateKey) {
        int i;
        int j = 0;
        int temporary = 0;
        for (i = 0; i < 512; i += 4) {
            temporary = privateKey[j + 0] & 0xFF;
            secretPolynomial[i + 0] = (short)temporary;
            temporary = privateKey[j + 1] & 0xFF;
            temporary = temporary << 30 >> 22;
            int n = i + 0;
            secretPolynomial[n] = (short)(secretPolynomial[n] | (short)temporary);
            temporary = privateKey[j + 1] & 0xFF;
            secretPolynomial[i + 1] = (short)(temporary >>= 2);
            temporary = privateKey[j + 2] & 0xFF;
            temporary = temporary << 28 >> 22;
            int n2 = i + 1;
            secretPolynomial[n2] = (short)(secretPolynomial[n2] | (short)temporary);
            temporary = privateKey[j + 2] & 0xFF;
            secretPolynomial[i + 2] = (short)(temporary >>= 4);
            temporary = privateKey[j + 3] & 0xFF;
            temporary = temporary << 26 >> 22;
            int n3 = i + 2;
            secretPolynomial[n3] = (short)(secretPolynomial[n3] | (short)temporary);
            temporary = privateKey[j + 3] & 0xFF;
            secretPolynomial[i + 3] = (short)(temporary >>= 6);
            temporary = privateKey[j + 4];
            temporary = (short)temporary << 2;
            int n4 = i + 3;
            secretPolynomial[n4] = (short)(secretPolynomial[n4] | (short)temporary);
            j += 5;
        }
        for (i = 0; i < 512; i += 4) {
            temporary = privateKey[j + 0] & 0xFF;
            errorPolynomial[i + 0] = (short)temporary;
            temporary = privateKey[j + 1] & 0xFF;
            temporary = temporary << 30 >> 22;
            int n = i + 0;
            errorPolynomial[n] = (short)(errorPolynomial[n] | (short)temporary);
            temporary = privateKey[j + 1] & 0xFF;
            errorPolynomial[i + 1] = (short)(temporary >>= 2);
            temporary = privateKey[j + 2] & 0xFF;
            temporary = temporary << 28 >> 22;
            int n5 = i + 1;
            errorPolynomial[n5] = (short)(errorPolynomial[n5] | (short)temporary);
            temporary = privateKey[j + 2] & 0xFF;
            errorPolynomial[i + 2] = (short)(temporary >>= 4);
            temporary = privateKey[j + 3] & 0xFF;
            temporary = temporary << 26 >> 22;
            int n6 = i + 2;
            errorPolynomial[n6] = (short)(errorPolynomial[n6] | (short)temporary);
            temporary = privateKey[j + 3] & 0xFF;
            errorPolynomial[i + 3] = (short)(temporary >>= 6);
            temporary = privateKey[j + 4];
            temporary = (short)temporary << 2;
            int n7 = i + 3;
            errorPolynomial[n7] = (short)(errorPolynomial[n7] | (short)temporary);
            j += 5;
        }
        System.arraycopy(privateKey, 1280, seed, 0, 64);
    }

    public static void decodePrivateKeyIIISize(byte[] seed, short[] secretPolynomial, short[] errorPolynomial, byte[] privateKey) {
        int i;
        for (i = 0; i < 1024; ++i) {
            secretPolynomial[i] = privateKey[i];
        }
        for (i = 0; i < 1024; ++i) {
            errorPolynomial[i] = privateKey[1024 + i];
        }
        System.arraycopy(privateKey, 2048, seed, 0, 64);
    }

    public static void decodePrivateKeyIIISpeed(byte[] seed, short[] secretPolynomial, short[] errorPolynomial, byte[] privateKey) {
        int i;
        int j = 0;
        int temporary = 0;
        for (i = 0; i < 1024; i += 8) {
            temporary = privateKey[j + 0] & 0xFF;
            secretPolynomial[i + 0] = (short)temporary;
            temporary = privateKey[j + 1] & 0xFF;
            temporary = temporary << 31 >> 23;
            int n = i + 0;
            secretPolynomial[n] = (short)(secretPolynomial[n] | (short)temporary);
            temporary = privateKey[j + 1] & 0xFF;
            secretPolynomial[i + 1] = (short)(temporary >>= 1);
            temporary = privateKey[j + 2] & 0xFF;
            temporary = temporary << 30 >> 23;
            int n2 = i + 1;
            secretPolynomial[n2] = (short)(secretPolynomial[n2] | (short)temporary);
            temporary = privateKey[j + 2] & 0xFF;
            secretPolynomial[i + 2] = (short)(temporary >>= 2);
            temporary = privateKey[j + 3] & 0xFF;
            temporary = temporary << 29 >> 23;
            int n3 = i + 2;
            secretPolynomial[n3] = (short)(secretPolynomial[n3] | (short)temporary);
            temporary = privateKey[j + 3] & 0xFF;
            secretPolynomial[i + 3] = (short)(temporary >>= 3);
            temporary = privateKey[j + 4] & 0xFF;
            temporary = temporary << 28 >> 23;
            int n4 = i + 3;
            secretPolynomial[n4] = (short)(secretPolynomial[n4] | (short)temporary);
            temporary = privateKey[j + 4] & 0xFF;
            secretPolynomial[i + 4] = (short)(temporary >>= 4);
            temporary = privateKey[j + 5] & 0xFF;
            temporary = temporary << 27 >> 23;
            int n5 = i + 4;
            secretPolynomial[n5] = (short)(secretPolynomial[n5] | (short)temporary);
            temporary = privateKey[j + 5] & 0xFF;
            secretPolynomial[i + 5] = (short)(temporary >>= 5);
            temporary = privateKey[j + 6] & 0xFF;
            temporary = temporary << 26 >> 23;
            int n6 = i + 5;
            secretPolynomial[n6] = (short)(secretPolynomial[n6] | (short)temporary);
            temporary = privateKey[j + 6] & 0xFF;
            secretPolynomial[i + 6] = (short)(temporary >>= 6);
            temporary = privateKey[j + 7] & 0xFF;
            temporary = temporary << 25 >> 23;
            int n7 = i + 6;
            secretPolynomial[n7] = (short)(secretPolynomial[n7] | (short)temporary);
            temporary = privateKey[j + 7] & 0xFF;
            secretPolynomial[i + 7] = (short)(temporary >>= 7);
            temporary = privateKey[j + 8];
            temporary = (short)temporary << 1;
            int n8 = i + 7;
            secretPolynomial[n8] = (short)(secretPolynomial[n8] | (short)temporary);
            j += 9;
        }
        for (i = 0; i < 1024; i += 8) {
            temporary = privateKey[j + 0] & 0xFF;
            errorPolynomial[i + 0] = (short)temporary;
            temporary = privateKey[j + 1] & 0xFF;
            temporary = temporary << 31 >> 23;
            int n = i + 0;
            errorPolynomial[n] = (short)(errorPolynomial[n] | (short)temporary);
            temporary = privateKey[j + 1] & 0xFF;
            errorPolynomial[i + 1] = (short)(temporary >>= 1);
            temporary = privateKey[j + 2] & 0xFF;
            temporary = temporary << 30 >> 23;
            int n9 = i + 1;
            errorPolynomial[n9] = (short)(errorPolynomial[n9] | (short)temporary);
            temporary = privateKey[j + 2] & 0xFF;
            errorPolynomial[i + 2] = (short)(temporary >>= 2);
            temporary = privateKey[j + 3] & 0xFF;
            temporary = temporary << 29 >> 23;
            int n10 = i + 2;
            errorPolynomial[n10] = (short)(errorPolynomial[n10] | (short)temporary);
            temporary = privateKey[j + 3] & 0xFF;
            errorPolynomial[i + 3] = (short)(temporary >>= 3);
            temporary = privateKey[j + 4] & 0xFF;
            temporary = temporary << 28 >> 23;
            int n11 = i + 3;
            errorPolynomial[n11] = (short)(errorPolynomial[n11] | (short)temporary);
            temporary = privateKey[j + 4] & 0xFF;
            errorPolynomial[i + 4] = (short)(temporary >>= 4);
            temporary = privateKey[j + 5] & 0xFF;
            temporary = temporary << 27 >> 23;
            int n12 = i + 4;
            errorPolynomial[n12] = (short)(errorPolynomial[n12] | (short)temporary);
            temporary = privateKey[j + 5] & 0xFF;
            errorPolynomial[i + 5] = (short)(temporary >>= 5);
            temporary = privateKey[j + 6] & 0xFF;
            temporary = temporary << 26 >> 23;
            int n13 = i + 5;
            errorPolynomial[n13] = (short)(errorPolynomial[n13] | (short)temporary);
            temporary = privateKey[j + 6] & 0xFF;
            errorPolynomial[i + 6] = (short)(temporary >>= 6);
            temporary = privateKey[j + 7] & 0xFF;
            temporary = temporary << 25 >> 23;
            int n14 = i + 6;
            errorPolynomial[n14] = (short)(errorPolynomial[n14] | (short)temporary);
            temporary = privateKey[j + 7] & 0xFF;
            errorPolynomial[i + 7] = (short)(temporary >>= 7);
            temporary = privateKey[j + 8];
            temporary = (short)temporary << 1;
            int n15 = i + 7;
            errorPolynomial[n15] = (short)(errorPolynomial[n15] | (short)temporary);
            j += 9;
        }
        System.arraycopy(privateKey, 2304, seed, 0, 64);
    }

    public static void packPrivateKey(byte[] privateKey, long[] secretPolynomial, long[] errorPolynomial, byte[] seed, int seedOffset, int n, int k) {
        for (int i = 0; i < n; ++i) {
            privateKey[i] = (byte)secretPolynomial[i];
        }
        for (int j = 0; j < k; ++j) {
            for (int i = 0; i < n; ++i) {
                privateKey[n + j * n + i] = (byte)errorPolynomial[j * n + i];
            }
        }
        System.arraycopy(seed, seedOffset, privateKey, n + k * n, 64);
    }

    public static void encodePublicKey(byte[] publicKey, int[] T, byte[] seedA, int seedAOffset, int n, int qLogarithm) {
        int j = 0;
        for (int i = 0; i < n * qLogarithm / 32; i += qLogarithm) {
            CommonFunction.store32(publicKey, 4 * (i + 0), T[j + 0] | T[j + 1] << 23);
            CommonFunction.store32(publicKey, 4 * (i + 1), T[j + 1] >> 9 | T[j + 2] << 14);
            CommonFunction.store32(publicKey, 4 * (i + 2), T[j + 2] >> 18 | T[j + 3] << 5 | T[j + 4] << 28);
            CommonFunction.store32(publicKey, 4 * (i + 3), T[j + 4] >> 4 | T[j + 5] << 19);
            CommonFunction.store32(publicKey, 4 * (i + 4), T[j + 5] >> 13 | T[j + 6] << 10);
            CommonFunction.store32(publicKey, 4 * (i + 5), T[j + 6] >> 22 | T[j + 7] << 1 | T[j + 8] << 24);
            CommonFunction.store32(publicKey, 4 * (i + 6), T[j + 8] >> 8 | T[j + 9] << 15);
            CommonFunction.store32(publicKey, 4 * (i + 7), T[j + 9] >> 17 | T[j + 10] << 6 | T[j + 11] << 29);
            CommonFunction.store32(publicKey, 4 * (i + 8), T[j + 11] >> 3 | T[j + 12] << 20);
            CommonFunction.store32(publicKey, 4 * (i + 9), T[j + 12] >> 12 | T[j + 13] << 11);
            CommonFunction.store32(publicKey, 4 * (i + 10), T[j + 13] >> 21 | T[j + 14] << 2 | T[j + 15] << 25);
            CommonFunction.store32(publicKey, 4 * (i + 11), T[j + 15] >> 7 | T[j + 16] << 16);
            CommonFunction.store32(publicKey, 4 * (i + 12), T[j + 16] >> 16 | T[j + 17] << 7 | T[j + 18] << 30);
            CommonFunction.store32(publicKey, 4 * (i + 13), T[j + 18] >> 2 | T[j + 19] << 21);
            CommonFunction.store32(publicKey, 4 * (i + 14), T[j + 19] >> 11 | T[j + 20] << 12);
            CommonFunction.store32(publicKey, 4 * (i + 15), T[j + 20] >> 20 | T[j + 21] << 3 | T[j + 22] << 26);
            CommonFunction.store32(publicKey, 4 * (i + 16), T[j + 22] >> 6 | T[j + 23] << 17);
            CommonFunction.store32(publicKey, 4 * (i + 17), T[j + 23] >> 15 | T[j + 24] << 8 | T[j + 25] << 31);
            CommonFunction.store32(publicKey, 4 * (i + 18), T[j + 25] >> 1 | T[j + 26] << 22);
            CommonFunction.store32(publicKey, 4 * (i + 19), T[j + 26] >> 10 | T[j + 27] << 13);
            CommonFunction.store32(publicKey, 4 * (i + 20), T[j + 27] >> 19 | T[j + 28] << 4 | T[j + 29] << 27);
            CommonFunction.store32(publicKey, 4 * (i + 21), T[j + 29] >> 5 | T[j + 30] << 18);
            CommonFunction.store32(publicKey, 4 * (i + 22), T[j + 30] >> 14 | T[j + 31] << 9);
            j += 32;
        }
        System.arraycopy(seedA, seedAOffset, publicKey, n * qLogarithm / 8, 32);
    }

    public static void encodePublicKeyIIISpeed(byte[] publicKey, int[] T, byte[] seedA, int seedAOffset) {
        int j = 0;
        for (int i = 0; i < 768; i += 3) {
            CommonFunction.store32(publicKey, 4 * (i + 0), T[j + 0] | T[j + 1] << 24);
            CommonFunction.store32(publicKey, 4 * (i + 1), T[j + 1] >> 8 | T[j + 2] << 16);
            CommonFunction.store32(publicKey, 4 * (i + 2), T[j + 2] >> 16 | T[j + 3] << 8);
            j += 4;
        }
        System.arraycopy(seedA, seedAOffset, publicKey, 3072, 32);
    }

    public static void encodePublicKeyIP(byte[] publicKey, long[] T, byte[] seedA, int seedAOffset) {
        int j = 0;
        for (int i = 0; i < 3712; i += 29) {
            CommonFunction.store32(publicKey, 4 * (i + 0), (int)(T[j + 0] | T[j + 1] << 29));
            CommonFunction.store32(publicKey, 4 * (i + 1), (int)(T[j + 1] >> 3 | T[j + 2] << 26));
            CommonFunction.store32(publicKey, 4 * (i + 2), (int)(T[j + 2] >> 6 | T[j + 3] << 23));
            CommonFunction.store32(publicKey, 4 * (i + 3), (int)(T[j + 3] >> 9 | T[j + 4] << 20));
            CommonFunction.store32(publicKey, 4 * (i + 4), (int)(T[j + 4] >> 12 | T[j + 5] << 17));
            CommonFunction.store32(publicKey, 4 * (i + 5), (int)(T[j + 5] >> 15 | T[j + 6] << 14));
            CommonFunction.store32(publicKey, 4 * (i + 6), (int)(T[j + 6] >> 18 | T[j + 7] << 11));
            CommonFunction.store32(publicKey, 4 * (i + 7), (int)(T[j + 7] >> 21 | T[j + 8] << 8));
            CommonFunction.store32(publicKey, 4 * (i + 8), (int)(T[j + 8] >> 24 | T[j + 9] << 5));
            CommonFunction.store32(publicKey, 4 * (i + 9), (int)(T[j + 9] >> 27 | T[j + 10] << 2 | T[j + 11] << 31));
            CommonFunction.store32(publicKey, 4 * (i + 10), (int)(T[j + 11] >> 1 | T[j + 12] << 28));
            CommonFunction.store32(publicKey, 4 * (i + 11), (int)(T[j + 12] >> 4 | T[j + 13] << 25));
            CommonFunction.store32(publicKey, 4 * (i + 12), (int)(T[j + 13] >> 7 | T[j + 14] << 22));
            CommonFunction.store32(publicKey, 4 * (i + 13), (int)(T[j + 14] >> 10 | T[j + 15] << 19));
            CommonFunction.store32(publicKey, 4 * (i + 14), (int)(T[j + 15] >> 13 | T[j + 16] << 16));
            CommonFunction.store32(publicKey, 4 * (i + 15), (int)(T[j + 16] >> 16 | T[j + 17] << 13));
            CommonFunction.store32(publicKey, 4 * (i + 16), (int)(T[j + 17] >> 19 | T[j + 18] << 10));
            CommonFunction.store32(publicKey, 4 * (i + 17), (int)(T[j + 18] >> 22 | T[j + 19] << 7));
            CommonFunction.store32(publicKey, 4 * (i + 18), (int)(T[j + 19] >> 25 | T[j + 20] << 4));
            CommonFunction.store32(publicKey, 4 * (i + 19), (int)(T[j + 20] >> 28 | T[j + 21] << 1 | T[j + 22] << 30));
            CommonFunction.store32(publicKey, 4 * (i + 20), (int)(T[j + 22] >> 2 | T[j + 23] << 27));
            CommonFunction.store32(publicKey, 4 * (i + 21), (int)(T[j + 23] >> 5 | T[j + 24] << 24));
            CommonFunction.store32(publicKey, 4 * (i + 22), (int)(T[j + 24] >> 8 | T[j + 25] << 21));
            CommonFunction.store32(publicKey, 4 * (i + 23), (int)(T[j + 25] >> 11 | T[j + 26] << 18));
            CommonFunction.store32(publicKey, 4 * (i + 24), (int)(T[j + 26] >> 14 | T[j + 27] << 15));
            CommonFunction.store32(publicKey, 4 * (i + 25), (int)(T[j + 27] >> 17 | T[j + 28] << 12));
            CommonFunction.store32(publicKey, 4 * (i + 26), (int)(T[j + 28] >> 20 | T[j + 29] << 9));
            CommonFunction.store32(publicKey, 4 * (i + 27), (int)(T[j + 29] >> 23 | T[j + 30] << 6));
            CommonFunction.store32(publicKey, 4 * (i + 28), (int)(T[j + 30] >> 26 | T[j + 31] << 3));
            j += 32;
        }
        System.arraycopy(seedA, seedAOffset, publicKey, 14848, 32);
    }

    public static void encodePublicKeyIIIP(byte[] publicKey, long[] T, byte[] seedA, int seedAOffset) {
        int j = 0;
        for (int i = 0; i < 9920; i += 31) {
            for (int index = 0; index < 31; ++index) {
                CommonFunction.store32(publicKey, 4 * (i + index), (int)(T[j + index] >> index | T[j + index + 1] << 31 - index));
            }
            j += 32;
        }
        System.arraycopy(seedA, seedAOffset, publicKey, 39680, 32);
    }

    public static void decodePublicKey(int[] publicKey, byte[] seedA, int seedAOffset, byte[] publicKeyInput, int n, int qLogarithm) {
        int j = 0;
        int mask = (1 << qLogarithm) - 1;
        for (int i = 0; i < n; i += 32) {
            publicKey[i + 0] = CommonFunction.load32(publicKeyInput, 4 * (j + 0)) & mask;
            publicKey[i + 1] = (CommonFunction.load32(publicKeyInput, 4 * (j + 0)) >>> 23 | CommonFunction.load32(publicKeyInput, 4 * (j + 1)) << 9) & mask;
            publicKey[i + 2] = (CommonFunction.load32(publicKeyInput, 4 * (j + 1)) >>> 14 | CommonFunction.load32(publicKeyInput, 4 * (j + 2)) << 18) & mask;
            publicKey[i + 3] = CommonFunction.load32(publicKeyInput, 4 * (j + 2)) >>> 5 & mask;
            publicKey[i + 4] = (CommonFunction.load32(publicKeyInput, 4 * (j + 2)) >>> 28 | CommonFunction.load32(publicKeyInput, 4 * (j + 3)) << 4) & mask;
            publicKey[i + 5] = (CommonFunction.load32(publicKeyInput, 4 * (j + 3)) >>> 19 | CommonFunction.load32(publicKeyInput, 4 * (j + 4)) << 13) & mask;
            publicKey[i + 6] = (CommonFunction.load32(publicKeyInput, 4 * (j + 4)) >>> 10 | CommonFunction.load32(publicKeyInput, 4 * (j + 5)) << 22) & mask;
            publicKey[i + 7] = CommonFunction.load32(publicKeyInput, 4 * (j + 5)) >>> 1 & mask;
            publicKey[i + 8] = (CommonFunction.load32(publicKeyInput, 4 * (j + 5)) >>> 24 | CommonFunction.load32(publicKeyInput, 4 * (j + 6)) << 8) & mask;
            publicKey[i + 9] = (CommonFunction.load32(publicKeyInput, 4 * (j + 6)) >>> 15 | CommonFunction.load32(publicKeyInput, 4 * (j + 7)) << 17) & mask;
            publicKey[i + 10] = CommonFunction.load32(publicKeyInput, 4 * (j + 7)) >>> 6 & mask;
            publicKey[i + 11] = (CommonFunction.load32(publicKeyInput, 4 * (j + 7)) >>> 29 | CommonFunction.load32(publicKeyInput, 4 * (j + 8)) << 3) & mask;
            publicKey[i + 12] = (CommonFunction.load32(publicKeyInput, 4 * (j + 8)) >>> 20 | CommonFunction.load32(publicKeyInput, 4 * (j + 9)) << 12) & mask;
            publicKey[i + 13] = (CommonFunction.load32(publicKeyInput, 4 * (j + 9)) >>> 11 | CommonFunction.load32(publicKeyInput, 4 * (j + 10)) << 21) & mask;
            publicKey[i + 14] = CommonFunction.load32(publicKeyInput, 4 * (j + 10)) >>> 2 & mask;
            publicKey[i + 15] = (CommonFunction.load32(publicKeyInput, 4 * (j + 10)) >>> 25 | CommonFunction.load32(publicKeyInput, 4 * (j + 11)) << 7) & mask;
            publicKey[i + 16] = (CommonFunction.load32(publicKeyInput, 4 * (j + 11)) >>> 16 | CommonFunction.load32(publicKeyInput, 4 * (j + 12)) << 16) & mask;
            publicKey[i + 17] = CommonFunction.load32(publicKeyInput, 4 * (j + 12)) >>> 7 & mask;
            publicKey[i + 18] = (CommonFunction.load32(publicKeyInput, 4 * (j + 12)) >>> 30 | CommonFunction.load32(publicKeyInput, 4 * (j + 13)) << 2) & mask;
            publicKey[i + 19] = (CommonFunction.load32(publicKeyInput, 4 * (j + 13)) >>> 21 | CommonFunction.load32(publicKeyInput, 4 * (j + 14)) << 11) & mask;
            publicKey[i + 20] = (CommonFunction.load32(publicKeyInput, 4 * (j + 14)) >>> 12 | CommonFunction.load32(publicKeyInput, 4 * (j + 15)) << 20) & mask;
            publicKey[i + 21] = CommonFunction.load32(publicKeyInput, 4 * (j + 15)) >>> 3 & mask;
            publicKey[i + 22] = (CommonFunction.load32(publicKeyInput, 4 * (j + 15)) >>> 26 | CommonFunction.load32(publicKeyInput, 4 * (j + 16)) << 6) & mask;
            publicKey[i + 23] = (CommonFunction.load32(publicKeyInput, 4 * (j + 16)) >>> 17 | CommonFunction.load32(publicKeyInput, 4 * (j + 17)) << 15) & mask;
            publicKey[i + 24] = CommonFunction.load32(publicKeyInput, 4 * (j + 17)) >>> 8 & mask;
            publicKey[i + 25] = (CommonFunction.load32(publicKeyInput, 4 * (j + 17)) >>> 31 | CommonFunction.load32(publicKeyInput, 4 * (j + 18)) << 1) & mask;
            publicKey[i + 26] = (CommonFunction.load32(publicKeyInput, 4 * (j + 18)) >>> 22 | CommonFunction.load32(publicKeyInput, 4 * (j + 19)) << 10) & mask;
            publicKey[i + 27] = (CommonFunction.load32(publicKeyInput, 4 * (j + 19)) >>> 13 | CommonFunction.load32(publicKeyInput, 4 * (j + 20)) << 19) & mask;
            publicKey[i + 28] = CommonFunction.load32(publicKeyInput, 4 * (j + 20)) >>> 4 & mask;
            publicKey[i + 29] = (CommonFunction.load32(publicKeyInput, 4 * (j + 20)) >>> 27 | CommonFunction.load32(publicKeyInput, 4 * (j + 21)) << 5) & mask;
            publicKey[i + 30] = (CommonFunction.load32(publicKeyInput, 4 * (j + 21)) >>> 18 | CommonFunction.load32(publicKeyInput, 4 * (j + 22)) << 14) & mask;
            publicKey[i + 31] = CommonFunction.load32(publicKeyInput, 4 * (j + 22)) >>> 9;
            j += qLogarithm;
        }
        System.arraycopy(publicKeyInput, n * qLogarithm / 8, seedA, seedAOffset, 32);
    }

    public static void decodePublicKeyIIISpeed(int[] publicKey, byte[] seedA, int seedAOffset, byte[] publicKeyInput) {
        int j = 0;
        int mask = 0xFFFFFF;
        for (int i = 0; i < 1024; i += 4) {
            publicKey[i + 0] = CommonFunction.load32(publicKeyInput, 4 * (j + 0)) & mask;
            publicKey[i + 1] = (CommonFunction.load32(publicKeyInput, 4 * (j + 0)) >>> 24 | CommonFunction.load32(publicKeyInput, 4 * (j + 1)) << 8) & mask;
            publicKey[i + 2] = (CommonFunction.load32(publicKeyInput, 4 * (j + 1)) >>> 16 | CommonFunction.load32(publicKeyInput, 4 * (j + 2)) << 16) & mask;
            publicKey[i + 3] = CommonFunction.load32(publicKeyInput, 4 * (j + 2)) >>> 8;
            j += 3;
        }
        System.arraycopy(publicKeyInput, 3072, seedA, seedAOffset, 32);
    }

    public static void decodePublicKeyIP(int[] publicKey, byte[] seedA, int seedAOffset, byte[] publicKeyInput) {
        int j = 0;
        int mask = 0x1FFFFFFF;
        for (int i = 0; i < 4096; i += 32) {
            publicKey[i + 0] = CommonFunction.load32(publicKeyInput, 4 * (j + 0)) & mask;
            publicKey[i + 1] = (CommonFunction.load32(publicKeyInput, 4 * (j + 0)) >>> 29 | CommonFunction.load32(publicKeyInput, 4 * (j + 1)) << 3) & mask;
            publicKey[i + 2] = (CommonFunction.load32(publicKeyInput, 4 * (j + 1)) >>> 26 | CommonFunction.load32(publicKeyInput, 4 * (j + 2)) << 6) & mask;
            publicKey[i + 3] = (CommonFunction.load32(publicKeyInput, 4 * (j + 2)) >>> 23 | CommonFunction.load32(publicKeyInput, 4 * (j + 3)) << 9) & mask;
            publicKey[i + 4] = (CommonFunction.load32(publicKeyInput, 4 * (j + 3)) >>> 20 | CommonFunction.load32(publicKeyInput, 4 * (j + 4)) << 12) & mask;
            publicKey[i + 5] = (CommonFunction.load32(publicKeyInput, 4 * (j + 4)) >>> 17 | CommonFunction.load32(publicKeyInput, 4 * (j + 5)) << 15) & mask;
            publicKey[i + 6] = (CommonFunction.load32(publicKeyInput, 4 * (j + 5)) >>> 14 | CommonFunction.load32(publicKeyInput, 4 * (j + 6)) << 18) & mask;
            publicKey[i + 7] = (CommonFunction.load32(publicKeyInput, 4 * (j + 6)) >>> 11 | CommonFunction.load32(publicKeyInput, 4 * (j + 7)) << 21) & mask;
            publicKey[i + 8] = (CommonFunction.load32(publicKeyInput, 4 * (j + 7)) >>> 8 | CommonFunction.load32(publicKeyInput, 4 * (j + 8)) << 24) & mask;
            publicKey[i + 9] = (CommonFunction.load32(publicKeyInput, 4 * (j + 8)) >>> 5 | CommonFunction.load32(publicKeyInput, 4 * (j + 9)) << 27) & mask;
            publicKey[i + 10] = CommonFunction.load32(publicKeyInput, 4 * (j + 9)) >>> 2 & mask;
            publicKey[i + 11] = (CommonFunction.load32(publicKeyInput, 4 * (j + 9)) >>> 31 | CommonFunction.load32(publicKeyInput, 4 * (j + 10)) << 1) & mask;
            publicKey[i + 12] = (CommonFunction.load32(publicKeyInput, 4 * (j + 10)) >>> 28 | CommonFunction.load32(publicKeyInput, 4 * (j + 11)) << 4) & mask;
            publicKey[i + 13] = (CommonFunction.load32(publicKeyInput, 4 * (j + 11)) >>> 25 | CommonFunction.load32(publicKeyInput, 4 * (j + 12)) << 7) & mask;
            publicKey[i + 14] = (CommonFunction.load32(publicKeyInput, 4 * (j + 12)) >>> 22 | CommonFunction.load32(publicKeyInput, 4 * (j + 13)) << 10) & mask;
            publicKey[i + 15] = (CommonFunction.load32(publicKeyInput, 4 * (j + 13)) >>> 19 | CommonFunction.load32(publicKeyInput, 4 * (j + 14)) << 13) & mask;
            publicKey[i + 16] = (CommonFunction.load32(publicKeyInput, 4 * (j + 14)) >>> 16 | CommonFunction.load32(publicKeyInput, 4 * (j + 15)) << 16) & mask;
            publicKey[i + 17] = (CommonFunction.load32(publicKeyInput, 4 * (j + 15)) >>> 13 | CommonFunction.load32(publicKeyInput, 4 * (j + 16)) << 19) & mask;
            publicKey[i + 18] = (CommonFunction.load32(publicKeyInput, 4 * (j + 16)) >>> 10 | CommonFunction.load32(publicKeyInput, 4 * (j + 17)) << 22) & mask;
            publicKey[i + 19] = (CommonFunction.load32(publicKeyInput, 4 * (j + 17)) >>> 7 | CommonFunction.load32(publicKeyInput, 4 * (j + 18)) << 25) & mask;
            publicKey[i + 20] = (CommonFunction.load32(publicKeyInput, 4 * (j + 18)) >>> 4 | CommonFunction.load32(publicKeyInput, 4 * (j + 19)) << 28) & mask;
            publicKey[i + 21] = CommonFunction.load32(publicKeyInput, 4 * (j + 19)) >>> 1 & mask;
            publicKey[i + 22] = (CommonFunction.load32(publicKeyInput, 4 * (j + 19)) >>> 30 | CommonFunction.load32(publicKeyInput, 4 * (j + 20)) << 2) & mask;
            publicKey[i + 23] = (CommonFunction.load32(publicKeyInput, 4 * (j + 20)) >>> 27 | CommonFunction.load32(publicKeyInput, 4 * (j + 21)) << 5) & mask;
            publicKey[i + 24] = (CommonFunction.load32(publicKeyInput, 4 * (j + 21)) >>> 24 | CommonFunction.load32(publicKeyInput, 4 * (j + 22)) << 8) & mask;
            publicKey[i + 25] = (CommonFunction.load32(publicKeyInput, 4 * (j + 22)) >>> 21 | CommonFunction.load32(publicKeyInput, 4 * (j + 23)) << 11) & mask;
            publicKey[i + 26] = (CommonFunction.load32(publicKeyInput, 4 * (j + 23)) >>> 18 | CommonFunction.load32(publicKeyInput, 4 * (j + 24)) << 14) & mask;
            publicKey[i + 27] = (CommonFunction.load32(publicKeyInput, 4 * (j + 24)) >>> 15 | CommonFunction.load32(publicKeyInput, 4 * (j + 25)) << 17) & mask;
            publicKey[i + 28] = (CommonFunction.load32(publicKeyInput, 4 * (j + 25)) >>> 12 | CommonFunction.load32(publicKeyInput, 4 * (j + 26)) << 20) & mask;
            publicKey[i + 29] = (CommonFunction.load32(publicKeyInput, 4 * (j + 26)) >>> 9 | CommonFunction.load32(publicKeyInput, 4 * (j + 27)) << 23) & mask;
            publicKey[i + 30] = (CommonFunction.load32(publicKeyInput, 4 * (j + 27)) >>> 6 | CommonFunction.load32(publicKeyInput, 4 * (j + 28)) << 26) & mask;
            publicKey[i + 31] = CommonFunction.load32(publicKeyInput, 4 * (j + 28)) >>> 3;
            j += 29;
        }
        System.arraycopy(publicKeyInput, 14848, seedA, seedAOffset, 32);
    }

    public static void decodePublicKeyIIIP(int[] publicKey, byte[] seedA, int seedAOffset, byte[] publicKeyInput) {
        int j = 0;
        int mask = Integer.MAX_VALUE;
        for (int i = 0; i < 10240; i += 32) {
            publicKey[i] = CommonFunction.load32(publicKeyInput, 4 * j) & mask;
            for (int index = 1; index < 31; ++index) {
                publicKey[i + index] = (CommonFunction.load32(publicKeyInput, 4 * (j + index - 1)) >>> 32 - index | CommonFunction.load32(publicKeyInput, 4 * (j + index)) << index) & mask;
            }
            publicKey[i + 31] = CommonFunction.load32(publicKeyInput, 4 * (j + 31 - 1)) >>> 1;
            j += 31;
        }
        System.arraycopy(publicKeyInput, 39680, seedA, seedAOffset, 32);
    }

    public static void encodeSignature(byte[] signature, int signatureOffset, byte[] C, int cOffset, int[] Z, int n, int d) {
        int j = 0;
        for (int i = 0; i < n * d / 32; i += d) {
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 0), Z[j + 0] & 0x1FFFFF | Z[j + 1] << 21);
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 1), Z[j + 1] >>> 11 & 0x3FF | (Z[j + 2] & 0x1FFFFF) << 10 | Z[j + 3] << 31);
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 2), Z[j + 3] >>> 1 & 0xFFFFF | Z[j + 4] << 20);
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 3), Z[j + 4] >>> 12 & 0x1FF | (Z[j + 5] & 0x1FFFFF) << 9 | Z[j + 6] << 30);
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 4), Z[j + 6] >>> 2 & 0x7FFFF | Z[j + 7] << 19);
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 5), Z[j + 7] >>> 13 & 0xFF | (Z[j + 8] & 0x1FFFFF) << 8 | Z[j + 9] << 29);
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 6), Z[j + 9] >>> 3 & 0x3FFFF | Z[j + 10] << 18);
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 7), Z[j + 10] >>> 14 & 0x7F | (Z[j + 11] & 0x1FFFFF) << 7 | Z[j + 12] << 28);
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 8), Z[j + 12] >>> 4 & 0x1FFFF | Z[j + 13] << 17);
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 9), Z[j + 13] >>> 15 & 0x3F | (Z[j + 14] & 0x1FFFFF) << 6 | Z[j + 15] << 27);
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 10), Z[j + 15] >>> 5 & 0xFFFF | Z[j + 16] << 16);
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 11), Z[j + 16] >>> 16 & 0x1F | (Z[j + 17] & 0x1FFFFF) << 5 | Z[j + 18] << 26);
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 12), Z[j + 18] >>> 6 & Short.MAX_VALUE | Z[j + 19] << 15);
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 13), Z[j + 19] >>> 17 & 0xF | (Z[j + 20] & 0x1FFFFF) << 4 | Z[j + 21] << 25);
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 14), Z[j + 21] >>> 7 & 0x3FFF | Z[j + 22] << 14);
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 15), Z[j + 22] >>> 18 & 7 | (Z[j + 23] & 0x1FFFFF) << 3 | Z[j + 24] << 24);
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 16), Z[j + 24] >>> 8 & 0x1FFF | Z[j + 25] << 13);
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 17), Z[j + 25] >>> 19 & 3 | (Z[j + 26] & 0x1FFFFF) << 2 | Z[j + 27] << 23);
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 18), Z[j + 27] >>> 9 & 0xFFF | Z[j + 28] << 12);
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 19), Z[j + 28] >>> 20 & 1 | (Z[j + 29] & 0x1FFFFF) << 1 | Z[j + 30] << 22);
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 20), Z[j + 30] >>> 10 & 0x7FF | Z[j + 31] << 11);
            j += 32;
        }
        System.arraycopy(C, cOffset, signature, signatureOffset + n * d / 8, 32);
    }

    public static void encodeSignatureIIISpeed(byte[] signature, int signatureOffset, byte[] C, int cOffset, int[] Z) {
        int j = 0;
        for (int i = 0; i < 704; i += 11) {
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 0), Z[j + 0] & 0x3FFFFF | Z[j + 1] << 22);
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 1), Z[j + 1] >>> 10 & 0xFFF | Z[j + 2] << 12);
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 2), Z[j + 2] >>> 20 & 3 | (Z[j + 3] & 0x3FFFFF) << 2 | Z[j + 4] << 24);
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 3), Z[j + 4] >>> 8 & 0x3FFF | Z[j + 5] << 14);
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 4), Z[j + 5] >>> 18 & 0xF | (Z[j + 6] & 0x3FFFFF) << 4 | Z[j + 7] << 26);
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 5), Z[j + 7] >>> 6 & 0xFFFF | Z[j + 8] << 16);
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 6), Z[j + 8] >>> 16 & 0x3F | (Z[j + 9] & 0x3FFFFF) << 6 | Z[j + 10] << 28);
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 7), Z[j + 10] >>> 4 & 0x3FFFF | Z[j + 11] << 18);
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 8), Z[j + 11] >>> 14 & 0xFF | (Z[j + 12] & 0x3FFFFF) << 8 | Z[j + 13] << 30);
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 9), Z[j + 13] >>> 2 & 0xFFFFF | Z[j + 14] << 20);
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 10), Z[j + 14] >>> 12 & 0x3FF | Z[j + 15] << 10);
            j += 16;
        }
        System.arraycopy(C, cOffset, signature, signatureOffset + 2816, 32);
    }

    public static void encodeSignatureIP(byte[] signature, int signatureOffset, byte[] C, int cOffset, long[] Z) {
        int j = 0;
        for (int i = 0; i < 704; i += 11) {
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 0), (int)(Z[j + 0] & 0x3FFFFFL | Z[j + 1] << 22));
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 1), (int)(Z[j + 1] >>> 10 & 0xFFFL | Z[j + 2] << 12));
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 2), (int)(Z[j + 2] >>> 20 & 3L | (Z[j + 3] & 0x3FFFFFL) << 2 | Z[j + 4] << 24));
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 3), (int)(Z[j + 4] >>> 8 & 0x3FFFL | Z[j + 5] << 14));
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 4), (int)(Z[j + 5] >>> 18 & 0xFL | (Z[j + 6] & 0x3FFFFFL) << 4 | Z[j + 7] << 26));
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 5), (int)(Z[j + 7] >>> 6 & 0xFFFFL | Z[j + 8] << 16));
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 6), (int)(Z[j + 8] >>> 16 & 0x3FL | (Z[j + 9] & 0x3FFFFFL) << 6 | Z[j + 10] << 28));
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 7), (int)(Z[j + 10] >>> 4 & 0x3FFFFL | Z[j + 11] << 18));
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 8), (int)(Z[j + 11] >>> 14 & 0xFFL | (Z[j + 12] & 0x3FFFFFL) << 8 | Z[j + 13] << 30));
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 9), (int)(Z[j + 13] >>> 2 & 0xFFFFFL | Z[j + 14] << 20));
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 10), (int)(Z[j + 14] >>> 12 & 0x3FFL | Z[j + 15] << 10));
            j += 16;
        }
        System.arraycopy(C, cOffset, signature, signatureOffset + 2816, 32);
    }

    public static void encodeSignatureIIIP(byte[] signature, int signatureOffset, byte[] C, int cOffset, long[] Z) {
        int j = 0;
        for (int i = 0; i < 1536; i += 3) {
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 0), (int)(Z[j + 0] & 0xFFFFFFL | Z[j + 1] << 24));
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 1), (int)(Z[j + 1] >>> 8 & 0xFFFFL | Z[j + 2] << 16));
            CommonFunction.store32(signature, signatureOffset + 4 * (i + 2), (int)(Z[j + 2] >>> 16 & 0xFFL | Z[j + 3] << 8));
            j += 4;
        }
        System.arraycopy(C, cOffset, signature, signatureOffset + 6144, 32);
    }

    public static void decodeSignature(byte[] C, int[] Z, byte[] signature, int signatureOffset, int n, int d) {
        int j = 0;
        for (int i = 0; i < n; i += 32) {
            Z[i + 0] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 0)) << 11 >> 11;
            Z[i + 1] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 0)) >>> 21 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 1)) << 22 >> 11;
            Z[i + 2] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 1)) << 1 >> 11;
            Z[i + 3] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 1)) >>> 31 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 2)) << 12 >> 11;
            Z[i + 4] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 2)) >>> 20 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 3)) << 23 >> 11;
            Z[i + 5] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 3)) << 2 >> 11;
            Z[i + 6] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 3)) >>> 30 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 4)) << 13 >> 11;
            Z[i + 7] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 4)) >>> 19 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 5)) << 24 >> 11;
            Z[i + 8] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 5)) << 3 >> 11;
            Z[i + 9] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 5)) >>> 29 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 6)) << 14 >> 11;
            Z[i + 10] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 6)) >>> 18 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 7)) << 25 >> 11;
            Z[i + 11] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 7)) << 4 >> 11;
            Z[i + 12] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 7)) >>> 28 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 8)) << 15 >> 11;
            Z[i + 13] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 8)) >>> 17 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 9)) << 26 >> 11;
            Z[i + 14] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 9)) << 5 >> 11;
            Z[i + 15] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 9)) >>> 27 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 10)) << 16 >> 11;
            Z[i + 16] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 10)) >>> 16 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 11)) << 27 >> 11;
            Z[i + 17] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 11)) << 6 >> 11;
            Z[i + 18] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 11)) >>> 26 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 12)) << 17 >> 11;
            Z[i + 19] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 12)) >>> 15 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 13)) << 28 >> 11;
            Z[i + 20] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 13)) << 7 >> 11;
            Z[i + 21] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 13)) >>> 25 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 14)) << 18 >> 11;
            Z[i + 22] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 14)) >>> 14 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 15)) << 29 >> 11;
            Z[i + 23] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 15)) << 8 >> 11;
            Z[i + 24] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 15)) >>> 24 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 16)) << 19 >> 11;
            Z[i + 25] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 16)) >>> 13 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 17)) << 30 >> 11;
            Z[i + 26] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 17)) << 9 >> 11;
            Z[i + 27] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 17)) >>> 23 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 18)) << 20 >> 11;
            Z[i + 28] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 18)) >>> 12 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 19)) << 31 >> 11;
            Z[i + 29] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 19)) << 10 >> 11;
            Z[i + 30] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 19)) >>> 22 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 20)) << 21 >> 11;
            Z[i + 31] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 20)) >> 11;
            j += d;
        }
        System.arraycopy(signature, signatureOffset + n * d / 8, C, 0, 32);
    }

    public static void decodeSignatureIIISpeed(byte[] C, int[] Z, byte[] signature, int signatureOffset) {
        int j = 0;
        for (int i = 0; i < 1024; i += 16) {
            Z[i + 0] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 0)) << 10 >> 10;
            Z[i + 1] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 0)) >>> 22 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 1)) << 20 >> 10;
            Z[i + 2] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 1)) >>> 12 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 2)) << 30 >> 10;
            Z[i + 3] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 2)) << 8 >> 10;
            Z[i + 4] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 2)) >>> 24 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 3)) << 18 >> 10;
            Z[i + 5] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 3)) >>> 14 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 4)) << 28 >> 10;
            Z[i + 6] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 4)) << 6 >> 10;
            Z[i + 7] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 4)) >>> 26 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 5)) << 16 >> 10;
            Z[i + 8] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 5)) >>> 16 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 6)) << 26 >> 10;
            Z[i + 9] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 6)) << 4 >> 10;
            Z[i + 10] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 6)) >>> 28 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 7)) << 14 >> 10;
            Z[i + 11] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 7)) >>> 18 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 8)) << 24 >> 10;
            Z[i + 12] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 8)) << 2 >> 10;
            Z[i + 13] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 8)) >>> 30 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 9)) << 12 >> 10;
            Z[i + 14] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 9)) >>> 20 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 10)) << 22 >> 10;
            Z[i + 15] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 10)) >> 10;
            j += 11;
        }
        System.arraycopy(signature, signatureOffset + 2816, C, 0, 32);
    }

    public static void decodeSignatureIP(byte[] C, long[] Z, byte[] signature, int signatureOffset) {
        int j = 0;
        for (int i = 0; i < 1024; i += 16) {
            Z[i + 0] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 0)) << 10 >> 10;
            Z[i + 1] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 0)) >>> 22 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 1)) << 20 >> 10;
            Z[i + 2] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 1)) >>> 12 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 2)) << 30 >> 10;
            Z[i + 3] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 2)) << 8 >> 10;
            Z[i + 4] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 2)) >>> 24 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 3)) << 18 >> 10;
            Z[i + 5] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 3)) >>> 14 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 4)) << 28 >> 10;
            Z[i + 6] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 4)) << 6 >> 10;
            Z[i + 7] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 4)) >>> 26 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 5)) << 16 >> 10;
            Z[i + 8] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 5)) >>> 16 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 6)) << 26 >> 10;
            Z[i + 9] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 6)) << 4 >> 10;
            Z[i + 10] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 6)) >>> 28 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 7)) << 14 >> 10;
            Z[i + 11] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 7)) >>> 18 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 8)) << 24 >> 10;
            Z[i + 12] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 8)) << 2 >> 10;
            Z[i + 13] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 8)) >>> 30 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 9)) << 12 >> 10;
            Z[i + 14] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 9)) >>> 20 | CommonFunction.load32(signature, signatureOffset + 4 * (j + 10)) << 22 >> 10;
            Z[i + 15] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 10)) >> 10;
            j += 11;
        }
        System.arraycopy(signature, signatureOffset + 2816, C, 0, 32);
    }

    public static void decodeSignatureIIIP(byte[] C, long[] Z, byte[] signature, int signatureOffset) {
        int j = 0;
        for (int i = 0; i < 2048; i += 4) {
            Z[i + 0] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 0)) << 8 >> 8;
            Z[i + 1] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 0)) >>> 24 & 0xFF | CommonFunction.load32(signature, signatureOffset + 4 * (j + 1)) << 16 >> 8;
            Z[i + 2] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 1)) >>> 16 & 0xFFFF | CommonFunction.load32(signature, signatureOffset + 4 * (j + 2)) << 24 >> 8;
            Z[i + 3] = CommonFunction.load32(signature, signatureOffset + 4 * (j + 2)) >> 8;
            j += 3;
        }
        System.arraycopy(signature, signatureOffset + 6144, C, 0, 32);
    }
}

