/*
 * Decompiled with CFR 0.152.
 */
package com.thinweb.tds;

import java.io.UnsupportedEncodingException;
import java.util.Hashtable;

final class EncodingHelper {
    private String name;
    private boolean wideChars;
    private String converted;
    private static byte[] convArray;
    private static Hashtable knownEncodings;
    private static boolean initialized;
    static Class class$com$internetcds$jdbc$tds$EncodingHelper;
    static /* synthetic */ Class class$com$thinweb$tds$EncodingHelper;

    private EncodingHelper(String string, boolean bl) {
        this.name = string;
        this.wideChars = bl;
        if (!bl) {
            this.converted = this.getString(convArray);
        }
    }

    public boolean canBeConverted(String string) {
        if (this.isDBCS()) {
            throw new IllegalStateException(this.name + " is a DBCS charset");
        }
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (this.converted.indexOf(string.charAt(n2)) == -1) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public byte[] getBytes(String string) {
        try {
            return string.getBytes(this.name);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return string.getBytes();
        }
    }

    public static EncodingHelper getHelper(String string) {
        if (!initialized) {
            Class clazz = class$com$thinweb$tds$EncodingHelper == null ? (class$com$thinweb$tds$EncodingHelper = EncodingHelper.class$("com.thinweb.tds.EncodingHelper")) : class$com$thinweb$tds$EncodingHelper;
            synchronized (clazz) {
                if (!initialized) {
                    EncodingHelper.initialize();
                }
            }
        }
        return (EncodingHelper)knownEncodings.get(string);
    }

    public String getString(byte[] byArray) {
        return this.getString(byArray, 0, byArray.length);
    }

    public String getString(byte[] byArray, int n, int n2) {
        try {
            return new String(byArray, n, n2, this.name);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(byArray, n, n2);
        }
    }

    private static synchronized void initialize() {
        convArray = new byte[256];
        int n = 0;
        while (n < 256) {
            EncodingHelper.convArray[n] = (byte)n;
            ++n;
        }
        knownEncodings = new Hashtable();
        EncodingHelper encodingHelper = new EncodingHelper("ISO8859_1", false);
        knownEncodings.put("iso_1", encodingHelper);
        knownEncodings.put("cp1252", encodingHelper);
        try {
            "a".getBytes("Cp437");
            knownEncodings.put("cp437", new EncodingHelper("Cp437", false));
            knownEncodings.put("cp850", new EncodingHelper("Cp850", false));
            knownEncodings.put("cp1250", new EncodingHelper("Cp1250", false));
            knownEncodings.put("cp1251", new EncodingHelper("Cp1251", false));
            knownEncodings.put("cp1253", new EncodingHelper("Cp1253", false));
            knownEncodings.put("cp1254", new EncodingHelper("Cp1254", false));
            knownEncodings.put("cp1255", new EncodingHelper("Cp1255", false));
            knownEncodings.put("cp1256", new EncodingHelper("Cp1256", false));
            knownEncodings.put("cp1257", new EncodingHelper("Cp1257", false));
            knownEncodings.put("cp874", new EncodingHelper("MS874", true));
            knownEncodings.put("cp932", new EncodingHelper("MS932", true));
            knownEncodings.put("cp932", new EncodingHelper("MS936", true));
            knownEncodings.put("cp949", new EncodingHelper("MS949", true));
            knownEncodings.put("cp950", new EncodingHelper("MS950", true));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        initialized = true;
    }

    public boolean isDBCS() {
        return this.wideChars;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        EncodingHelper.initialize();
    }
}

