/*
 * Decompiled with CFR 0.152.
 */
package com.thinweb.tds;

import com.thinweb.tds.Column;
import com.thinweb.tds.TdsException;
import java.util.Vector;

public final class Columns {
    private Vector columns = new Vector();
    private int columnCount = 0;
    Vector tables;

    boolean autoIncrementWasSet(int n) {
        return ((Column)this.columns.elementAt(n - 1)).autoIncrementWasSet();
    }

    Column getColumn(int n) {
        return (Column)this.columns.elementAt(n - 1);
    }

    int getColumnCount() {
        return this.columnCount;
    }

    Vector getColumns() {
        return this.columns;
    }

    int getDisplaySize(int n) {
        return ((Column)this.columns.elementAt(n - 1)).getDisplaySize();
    }

    String getLabel(int n) {
        return ((Column)this.columns.elementAt(n - 1)).getLabel();
    }

    String getName(int n) {
        return ((Column)this.columns.elementAt(n - 1)).getName();
    }

    int getPrecision(int n) {
        return ((Column)this.columns.elementAt(n - 1)).getPrecision();
    }

    int getScale(int n) {
        return ((Column)this.columns.elementAt(n - 1)).getScale();
    }

    int getType(int n) {
        return ((Column)this.columns.elementAt(n - 1)).getType();
    }

    boolean isAutoIncrement(int n) {
        return ((Column)this.columns.elementAt(n - 1)).isAutoIncrement();
    }

    int isNullable(int n) {
        return ((Column)this.columns.elementAt(n - 1)).isNullable();
    }

    boolean isReadOnly(int n) {
        return ((Column)this.columns.elementAt(n - 1)).isReadOnly();
    }

    Columns merge(Columns columns) throws TdsException {
        if (this.columns.size() != columns.columns.size()) {
            throw new TdsException(" Mismatch in number of columns");
        }
        int n = 1;
        while (n <= this.columnCount) {
            if (this.getName(n) == null) {
                this.setName(n, columns.getName(n));
            } else if (columns.getName(n) != null) {
                throw new TdsException("Trying to merge two non-null columns");
            }
            if (this.getDisplaySize(n) == -1) {
                this.setDisplaySize(n, columns.getDisplaySize(n));
            } else if (columns.getDisplaySize(n) != -1) {
                throw new TdsException("Trying to merge two non-null columns");
            }
            if (this.getLabel(n) == null) {
                this.setLabel(n, columns.getLabel(n));
            } else if (columns.getLabel(n) != null) {
                throw new TdsException("Trying to merge two non-null columns");
            }
            if (this.getType(n) == -1) {
                this.setType(n, columns.getType(n));
            } else if (columns.getType(n) != -1) {
                throw new TdsException("Trying to merge two non-null columns");
            }
            if (this.getPrecision(n) == -1) {
                this.setPrecision(n, columns.getPrecision(n));
            } else if (columns.getPrecision(n) != -1) {
                throw new TdsException("Trying to merge two non-null columns");
            }
            if (this.getScale(n) == -1) {
                this.setScale(n, columns.getScale(n));
            } else if (columns.getScale(n) != -1) {
                throw new TdsException("Trying to merge two non-null columns");
            }
            if (this.nullableWasSet(n) && columns.nullableWasSet(n)) {
                throw new TdsException("Trying to merge two non-null columns");
            }
            if (!this.nullableWasSet(n) && columns.nullableWasSet(n)) {
                this.setNullable(n, columns.isNullable(n));
            }
            if (this.readOnlyWasSet(n) && columns.readOnlyWasSet(n)) {
                throw new TdsException("Trying to merge two non-null columns");
            }
            if (!this.readOnlyWasSet(n) && columns.readOnlyWasSet(n)) {
                this.setReadOnly(n, columns.isReadOnly(n));
            }
            if (this.autoIncrementWasSet(n) && columns.autoIncrementWasSet(n)) {
                throw new TdsException("Trying to merge two non-null columns");
            }
            if (!this.autoIncrementWasSet(n) && columns.autoIncrementWasSet(n)) {
                this.setAutoIncrement(n, columns.isAutoIncrement(n));
            }
            ++n;
        }
        return this;
    }

    boolean nullableWasSet(int n) {
        return this.isNullable(n) != 2;
    }

    boolean readOnlyWasSet(int n) {
        return ((Column)this.columns.elementAt(n - 1)).readOnlyWasSet();
    }

    private void resize(int n) {
        if (n > this.columnCount) {
            this.columnCount = n;
        }
        if (this.columns.size() <= n) {
            this.columns.setSize(n + 1);
        }
        if (this.columns.elementAt(n - 1) == null) {
            this.columns.setElementAt(new Column(), n - 1);
        }
    }

    void setAutoIncrement(int n, boolean bl) {
        this.resize(n);
        ((Column)this.columns.elementAt(n - 1)).setAutoIncrement(bl);
    }

    void setColumns(Vector vector) {
        this.columns = vector;
    }

    void setDisplaySize(int n, int n2) {
        this.resize(n);
        ((Column)this.columns.elementAt(n - 1)).setDisplaySize(n2);
    }

    void setLabel(int n, String string) {
        ((Column)this.columns.elementAt(n - 1)).setLabel(string);
    }

    void setName(int n, String string) {
        this.resize(n);
        if (this.columns.elementAt(n - 1) == null) {
            this.columns.setElementAt(new Column(), n - 1);
        }
        ((Column)this.columns.elementAt(n - 1)).setName(string);
    }

    void setNullable(int n, int n2) {
        this.resize(n);
        ((Column)this.columns.elementAt(n - 1)).setNullable(n2);
    }

    void setPrecision(int n, int n2) {
        this.resize(n);
        ((Column)this.columns.elementAt(n - 1)).setPrecision(n2);
    }

    void setReadOnly(int n, boolean bl) {
        this.resize(n);
        ((Column)this.columns.elementAt(n - 1)).setReadOnly(bl);
    }

    void setScale(int n, int n2) {
        this.resize(n);
        ((Column)this.columns.elementAt(n - 1)).setScale(n2);
    }

    void setType(int n, int n2) {
        this.resize(n);
        ((Column)this.columns.elementAt(n - 1)).setType(n2);
    }
}

