/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.pojo.tools.objects;

import com.intersys.cache.CacheClassBuilder;
import com.intersys.cache.ClassGenerationConstants;
import com.intersys.classes.Compiler.LG.JavaBlock;
import com.intersys.classes.Compiler.LG.JavaBlockNameSet;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheRunTimeException;
import com.intersys.objects.ObjectServerInfo;
import com.intersys.objects.reflect.CacheIndexInfo;
import com.intersys.objects.reflect.CacheRelationshipInfo;
import com.intersys.objects.reflect.TypeModifiers;
import com.intersys.pojo.tools.objects.DefaultMappingProvider;
import com.intersys.pojo.tools.objects.JavaCacheClassMapper;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CacheClassGenerator
extends JavaCacheClassMapper
implements TypeModifiers,
ClassGenerationConstants {
    private CacheClassBuilder.InternalAPI mBuilder;
    protected boolean mDeleteOldClasses = true;

    public CacheClassGenerator(CacheClassBuilder cacheClassBuilder) {
        this.mBuilder = (CacheClassBuilder.InternalAPI)cacheClassBuilder;
    }

    protected void enableVersionChecking(Field field, Set set, Set set2) throws Exception {
        ObjectServerInfo objectServerInfo = this.mBuilder.getServerVersion();
        if (objectServerInfo.getMajorObjectVersion() < 6 && objectServerInfo.getMinorObjectVersion() < 2) {
            this.enableVersionChecking51J(field.getName());
            return;
        }
        this.mapField(field, set, set2);
        String string = this.mMappingTool.cacheFieldNameFor(field, set);
        this.mBuilder.createParameter(null, "VERSIONPROPERTY", string);
    }

    private void enableVersionChecking51J(String string) throws Exception {
        if (!string.equals("_Version")) {
            throw new CacheException("This implementation only supports _Version for version checking.");
        }
        this.mBuilder.createParameter(null, "VERSIONCHECKING", 1);
    }

    protected void handleIdField(Class clazz, String string, int n) throws Exception {
        switch (n) {
            case 0: {
                this.setupIdPlaceHolder(string);
                break;
            }
            case 1: {
                this.createIDKey(string + "Key", string);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid ID type: " + n + " for class " + clazz.getName());
            }
        }
    }

    private void setupIdPlaceHolder(String string) throws Exception {
        JavaBlock javaBlock = (JavaBlock)this.mBuilder.getClientProjectionSettings(null);
        javaBlock.setIdPlaceholder(string);
    }

    protected void generateField(Object object, Set set, Set set2, Class clazz, String string, String string2) throws Exception {
        boolean bl = this.mMappingTool.isMemberTransient(object);
        if (bl) {
            return;
        }
        String string3 = DefaultMappingProvider.javaFieldNameFor(object);
        int n = this.mMappingTool.getPropertyKind(object);
        String string4 = this.mMappingTool.cacheFieldNameFor(object, set);
        CacheClassGenerator.processExceptions(object, set2);
        Map map = this.mMappingTool.getPropertyParameters(object);
        this.generateField(string4, string3, n, object, string, string2, clazz, map);
    }

    private void generateField(String string, String string2, int n, Object object, String string3, String string4, Class clazz, Map map) throws Exception {
        boolean bl = clazz != null && !clazz.isArray();
        switch (n) {
            case 0: {
                Object object2 = this.mMappingTool.relationshipFor(object);
                if (object2 == null) {
                    this.writeSimpleAttribute(string, string3, string4, map);
                    break;
                }
                this.writeRelationship(string, string4, (CacheRelationshipInfo)object2);
                break;
            }
            case 8: 
            case 264: 
            case 520: {
                this.writeListAttribute(string, string3, bl, clazz);
                break;
            }
            case 1: 
            case 257: 
            case 513: {
                bl = false;
                this.writeArrayAttribute(string, string3, bl, clazz);
                break;
            }
            case 17: 
            case 19: 
            case 21: {
                Object object2 = this.mMappingTool.relationshipFor(object);
                this.writeRelationship(string, string4, (CacheRelationshipInfo)object2);
                break;
            }
            case 32: 
            case 64: {
                this.writeStreamAttribute(string, n, string4);
                break;
            }
            default: {
                throw new CacheException("Property " + string2 + " has unknown kind: " + n);
            }
        }
        if (string2 != null && !string.equals(string2)) {
            this.define(213, string2);
        }
        for (Map.Entry entry : map.entrySet()) {
            this.createPropertyParameter((String)entry.getKey(), entry.getValue());
        }
        this.define(290);
    }

    private static void processExceptions(Object object, Set set) {
        if (object instanceof Method) {
            CacheClassGenerator.getExceptionToThrow((Method)object, set);
        } else if (set.isEmpty()) {
            set.add(CacheException.class);
        }
    }

    private void writeSimpleAttribute(String string, String string2, String string3, Map map) throws Exception {
        this.define(201, string);
        this.define(212, string2);
        boolean bl = map.containsKey("MAXLEN");
        if (!bl && string2.endsWith("String")) {
            this.define(222, "4096");
        }
        if (string3 != null) {
            this.define(214, string3);
        }
    }

    private void writeStreamAttribute(String string, int n, String string2) throws Exception {
        String string3;
        this.define(201, string);
        switch (n) {
            case 32: {
                string3 = "%Library.GlobalBinaryStream";
                break;
            }
            case 64: {
                string3 = "%Library.GlobalCharacterStream";
                break;
            }
            default: {
                throw new CacheException("Unknown stream type: " + n);
            }
        }
        this.define(212, string3);
        if (string2 != null) {
            this.define(214, string2);
        }
    }

    private void writeRelationship(String string, String string2, CacheRelationshipInfo cacheRelationshipInfo) throws Exception {
        this.define(205, string);
        this.define(212, cacheRelationshipInfo.inverseClass);
        if (string2 != null) {
            this.define(214, string2);
        }
        boolean bl = false;
        String string3 = null;
        String string4 = cacheRelationshipInfo.parentChild ? (cacheRelationshipInfo.pointsToManyOrChildren ? "children" : "parent") : (cacheRelationshipInfo.pointsToManyOrChildren ? "many" : "one");
        this.mBuilder.defineRelationship(null, string4, cacheRelationshipInfo.inverseField);
        if (bl) {
            this.mBuilder.createForeignKey(null, string + "FKey", string, cacheRelationshipInfo.inverseClass, string3);
        }
    }

    private void writeArrayAttribute(String string, String string2, boolean bl, Class clazz) throws Exception {
        this.define(202, string);
        this.define(212, string2);
        this.define(310, bl);
        if (clazz != null && !Map.class.equals((Object)clazz)) {
            this.define(214, clazz.getName());
        }
    }

    private void writeListAttribute(String string, String string2, boolean bl, Class clazz) throws Exception {
        this.define(203, string);
        this.define(212, string2);
        this.define(310, bl);
        if (clazz != null && !List.class.equals((Object)clazz)) {
            this.define(214, clazz.getName());
        }
    }

    protected void mapClass(Set set, Class clazz) throws Exception {
        CacheIndexInfo[] cacheIndexInfoArray;
        Object object;
        boolean bl;
        if (this.mMappingTool.isClassTransient(clazz)) {
            return;
        }
        String string = this.mapClassName(clazz);
        String string2 = DefaultMappingProvider.javaPackageName(clazz);
        String string3 = this.mMappingTool.cacheMappedClassNameFor(string);
        this.createEmptyClass(string3);
        if (!string3.equals(string)) {
            String string4 = DefaultMappingProvider.javaShortClassName(clazz);
            this.define(11, string4);
        }
        boolean bl2 = !(bl = this.mMappingTool.isSerial(clazz));
        String string5 = this.mMappingTool.getExtendedClass(clazz);
        if (string5 == null) {
            object = clazz.getSuperclass();
            if (object != null && !object.equals(Object.class)) {
                string5 = this.mMappingTool.cacheClassNameFor((Class)object);
                this.mMappingTool.registerDependency((Class)object);
            } else {
                string5 = bl2 ? "%Library.Persistent" : (bl ? "%Library.SerialObject" : "%Library.RegisteredObject");
            }
        }
        if (bl2) {
            this.define(4608);
            object = this.mMappingTool.sqlTableNameFor(clazz);
            this.define(15, (String)object);
        } else if (bl) {
            this.define(22);
        }
        object = this.mMappingTool.getImplementedClasses(clazz);
        boolean bl3 = true;
        boolean bl4 = true;
        for (int i = 0; i < ((String[])object).length; ++i) {
            if ("%Library.Populate".equals(object[i])) {
                bl3 = false;
            } else if ("%XML.Adaptor".equals(object[i])) {
                bl4 = false;
            }
            string5 = string5 + "," + object[i];
        }
        if (bl3 && this.mMappingTool.isPopulatable(clazz)) {
            string5 = string5 + ",%Library.Populate";
        }
        if (bl4 && this.mMappingTool.isXMLSerializable(clazz)) {
            string5 = string5 + ",%XML.Adaptor";
        }
        this.define(51, string5);
        if (string2 != null) {
            this.define(101, string2);
        }
        HashSet hashSet = new HashSet();
        boolean bl5 = this.mapAllFields(set, hashSet, clazz);
        this.mapUnmappedFields(clazz);
        if (bl5 && !hashSet.contains(CacheException.class)) {
            this.define(120, hashSet);
        }
        if ((cacheIndexInfoArray = this.mMappingTool.allIndicesFor(this.mInitialClass)) != null) {
            for (int i = 0; i < cacheIndexInfoArray.length; ++i) {
                CacheIndexInfo cacheIndexInfo = cacheIndexInfoArray[i];
                String string6 = cacheIndexInfo.getProperties();
                if (string6 == null || string6.length() == 0) continue;
                if (cacheIndexInfo.isIdKey()) {
                    this.createIDKey(cacheIndexInfo.getObjectName(), string6);
                    continue;
                }
                this.mBuilder.createIndex(null, cacheIndexInfo.getObjectName(), cacheIndexInfo.getSQLName(), cacheIndexInfo.getProperties(), cacheIndexInfo.isPrimaryKey(), cacheIndexInfo.isUnique(), cacheIndexInfo.getType());
            }
        }
        this.define(999);
    }

    protected void mapUnmappedFields(Class clazz) throws Exception {
        Set set = this.mMappingTool.listUnmappedFields(clazz);
        for (Object e : set) {
            String string = this.mMappingTool.cacheFieldNameFor(e);
            int n = this.mMappingTool.getPropertyKind(e);
            String string2 = this.mMappingTool.cacheFieldTypeFor(e);
            Map map = this.mMappingTool.getPropertyParameters(e);
            this.generateField(string, null, n, e, string2, null, null, map);
        }
    }

    protected void createEmptyClass(String string) throws Exception {
        if (this.mBuilder == null) {
            return;
        }
        if (this.mDeleteOldClasses) {
            this.mBuilder.createEmptyClass(string);
        } else {
            this.mBuilder.loadExistingClass(string);
        }
    }

    protected void define(int n, Set set) throws Exception {
        if (this.mBuilder == null) {
            return;
        }
        this.mBuilder.define(n, set);
    }

    protected void define(int n, String string) throws Exception {
        if (this.mBuilder == null) {
            return;
        }
        this.mBuilder.define(n, string);
    }

    protected void define(int n, boolean bl) throws Exception {
        if (this.mBuilder == null) {
            return;
        }
        if (bl) {
            this.mBuilder.define(n);
        }
    }

    protected void define(int n) throws Exception {
        if (this.mBuilder == null) {
            return;
        }
        this.mBuilder.define(n);
    }

    protected void createPropertyParameter(String string, Object object) throws Exception {
        if (this.mBuilder == null) {
            return;
        }
        this.mBuilder.addPropertyParameter(null, string, object);
    }

    private static void getExceptionToThrow(Method method, Set set) {
        Class clazz;
        Class<CacheRunTimeException> clazz2 = CacheRunTimeException.class;
        HashSet<Class<CacheRunTimeException>> hashSet = new HashSet<Class<CacheRunTimeException>>();
        Class<?>[] classArray = method.getExceptionTypes();
        for (int i = 0; i < classArray.length; ++i) {
            clazz = classArray[i];
            if (clazz.isAssignableFrom(CacheException.class)) {
                hashSet.add(CacheException.class);
                hashSet.add(clazz);
                continue;
            }
            Constructor<?>[] constructorArray = clazz.getConstructors();
            for (int j = 0; j < constructorArray.length; ++j) {
                Class<?>[] object = constructorArray[j].getParameterTypes();
                if (object.length != 1 || !object[0].isAssignableFrom(CacheException.class)) continue;
                hashSet.add(clazz);
            }
        }
        if (hashSet.isEmpty()) {
            hashSet.add(clazz2);
        }
        if (set.isEmpty()) {
            set.addAll(hashSet);
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            clazz = (Class)iterator.next();
            if (clazz.equals(clazz2)) continue;
            boolean bl = false;
            for (Class clazz3 : hashSet) {
                if (!clazz3.isAssignableFrom(clazz)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            iterator.remove();
        }
        if (set.isEmpty()) {
            set.add(clazz2);
        }
    }

    public void deleteOldClasses(boolean bl) {
        this.mDeleteOldClasses = bl;
    }

    public void createPKIndex(String string, String string2) throws Exception {
        this.mBuilder.createIndex(null, string, string, string2, true, true, null);
    }

    public void createIDKey(String string, String string2) throws Exception {
        this.mBuilder.createIDKey(null, string, string, string2);
    }

    protected void setupJavaBlock(String string, Class clazz) throws Exception {
        String string2;
        JavaBlock javaBlock = (JavaBlock)this.mBuilder.getClientProjectionSettings(null);
        javaBlock.setExtends(string);
        String string3 = clazz.getName();
        int n = string3.lastIndexOf(46);
        String string4 = n > 0 ? string3.substring(0, n) : "";
        String string5 = n > 0 ? string3.substring(n + 1) : string3;
        JavaBlockNameSet javaBlockNameSet = javaBlock.getPackage();
        JavaBlockNameSet javaBlockNameSet2 = javaBlock.getJavaShortName();
        if (clazz.isInterface()) {
            javaBlock.setImplements(string3);
            javaBlockNameSet.setInterface(string4);
            javaBlockNameSet2.setInterface(string5);
        } else {
            javaBlockNameSet.setPojo(string4);
            javaBlockNameSet2.setPojo(string5);
        }
        String string6 = this.mMappingTool.getJavaProjectionPackage(clazz);
        if (string6 != null) {
            javaBlockNameSet.setImplementation(string6);
        }
        if ((string2 = this.mMappingTool.getJavaProjectionClassName(clazz)) != null) {
            javaBlockNameSet2.setImplementation(string2);
        }
        javaBlock.setResolveNameCollisions(false);
        int n2 = this.mMappingTool.getAccessType(clazz);
        if (n2 == 12001) {
            javaBlock.setEagerFetchRequired(true);
        }
    }

    public void save() throws Exception {
        this.mBuilder.saveClass(null);
    }
}

