/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.pojo.runtime;

import com.intersys.cache.DetachedCacheManager;
import com.intersys.classes.Persistent;
import com.intersys.objects.CacheException;
import com.intersys.objects.CandidateKey;
import com.intersys.objects.Database;
import com.intersys.objects.Id;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheField;
import com.intersys.objects.reflect.CandidateKeyInfo;
import com.intersys.objects.reflect.SQLColumn;
import com.intersys.pojo.runtime.ObjectFactory;
import com.intersys.pojo.runtime.PojoOperations;
import com.intersys.pojo.runtime.ProfilingDetachedObjectManager;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class DetachedObjectsManager
extends DetachedCacheManager {
    private Map mClassMethodsMap;
    private Map mClasses;
    private ObjectFactory mObjectFactory = new ObjectFactory();

    protected DetachedObjectsManager(Database database) {
        super(database);
    }

    public static DetachedObjectsManager createDetachedObjectsManager(Database database) {
        boolean bl = Boolean.getBoolean("com.intersys.profile.pojoCache");
        if (bl) {
            ProfilingDetachedObjectManager profilingDetachedObjectManager = new ProfilingDetachedObjectManager(database);
            Runtime.getRuntime().addShutdownHook(profilingDetachedObjectManager.createHook(System.out));
            return profilingDetachedObjectManager;
        }
        return new DetachedObjectsManager(database);
    }

    protected int getFetchPolicy() {
        return this.mObjectFactory.getPolicy();
    }

    protected int setFetchPolicy(int n) {
        return this.mObjectFactory.setPolicy(n);
    }

    public synchronized Persistent findProxy(Object object, boolean bl) throws CacheException {
        Persistent persistent = this.findProxyInMemory(object);
        if (persistent != null) {
            return persistent;
        }
        if (bl) {
            return null;
        }
        return this.findProxyInDB(object);
    }

    private Persistent findProxyInDB(Object object) throws CacheException {
        CandidateKey candidateKey;
        CacheClass cacheClass;
        try {
            cacheClass = this.findImplementation(object.getClass());
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        Serializable serializable = PojoOperations.getPojoId(object, cacheClass);
        if (serializable != null) {
            Persistent persistent;
            block17: {
                persistent = null;
                try {
                    persistent = (Persistent)cacheClass.openObject(new Id(serializable.toString()));
                }
                catch (CacheException cacheException) {
                    if (!Number.class.isInstance(serializable) || ((Number)serializable).longValue() != 0L) break block17;
                    return null;
                }
            }
            this.register(persistent, object);
            return persistent;
        }
        if (PojoOperations.idPlaceHolderAvailable(object, cacheClass)) {
            return null;
        }
        try {
            candidateKey = this.findPojoPrimaryKey(object, cacheClass);
            if (candidateKey == null) {
                return null;
            }
        }
        catch (Exception exception) {
            if (exception instanceof CacheException) {
                throw (CacheException)exception;
            }
            throw new CacheException(exception);
        }
        String[] stringArray = candidateKey.toArray();
        boolean bl = true;
        boolean bl2 = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) {
                bl2 = true;
                continue;
            }
            bl = false;
        }
        if (bl) {
            return null;
        }
        try {
            return (Persistent)cacheClass.openByKey(candidateKey);
        }
        catch (CacheException cacheException) {
            if (cacheException.getCode() == 5809) {
                return null;
            }
            if (bl2 && cacheException.getCode() == 400) {
                return null;
            }
            throw cacheException;
        }
    }

    public CandidateKey findPojoPrimaryKey(Object object, CacheClass cacheClass) throws Exception {
        CandidateKeyInfo candidateKeyInfo;
        if (cacheClass == null) {
            cacheClass = this.findImplementation(object.getClass());
        }
        if ((candidateKeyInfo = cacheClass.getBestCandidateKey()) == null) {
            return null;
        }
        CandidateKey candidateKey = cacheClass.createBestCandidateKey();
        SQLColumn[] sQLColumnArray = candidateKeyInfo.getColumns();
        for (int i = 0; i < sQLColumnArray.length; ++i) {
            CacheField cacheField = sQLColumnArray[i].getField();
            String string = cacheField.getJavaName();
            Object object2 = PojoOperations.getValue(object, string, this);
            if (object2 != null && cacheField.isPersistent()) {
                object2 = PojoOperations.getPojoId(object2, this.findImplementation(object2.getClass()));
            }
            String string2 = object2 == null ? null : object2.toString();
            candidateKey.set(i, string2);
        }
        return candidateKey;
    }

    public CacheClass findImplementation(Class clazz) throws ClassNotFoundException {
        String string = null;
        String string2 = null;
        Exception exception = null;
        try {
            Field field = clazz.getDeclaredField("CACHE_CLASS_NAME");
            field.setAccessible(true);
            string = (String)field.get(null);
            CacheClass cacheClass = this.mDB.getCacheClass(string);
            return cacheClass;
        }
        catch (IllegalAccessException illegalAccessException) {
            string2 = "Insufficient access priviliges to determine Cache Class for Java class " + clazz.getName();
            exception = illegalAccessException;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            try {
                return this.findCacheClassForPOJO(clazz.getName());
            }
            catch (CacheException cacheException) {
                string2 = "Can not determine Cache class that corresponds to Java class: " + clazz.getName();
                exception = cacheException;
            }
            catch (SQLException sQLException) {
                string2 = "Can not determine Cache class that corresponds to Java class: " + clazz.getName();
                exception = sQLException;
            }
        }
        catch (CacheException cacheException) {
            string2 = "Can not determine Cache class that produced Java class: " + clazz.getName();
            exception = cacheException;
        }
        throw new ClassNotFoundException(string2, exception);
    }

    public Method getMethod(Class clazz, String string, Class[] classArray) throws NoSuchMethodException {
        Method method;
        ClassMemebers classMemebers = this.getClassMemebers(clazz);
        if (classMemebers.methods == null) {
            classMemebers.methods = new HashMap();
        }
        if ((method = (Method)classMemebers.methods.get(string)) == null) {
            method = clazz.getMethod(string, classArray);
            classMemebers.methods.put(string, method);
        }
        return method;
    }

    public Member getIdSetter(Class clazz, CacheClass cacheClass) {
        ClassMemebers classMemebers = this.getClassMemebers(clazz);
        if (classMemebers.idSetter == null) {
            classMemebers.idSetter = PojoOperations.lookupPojoIdSetter(clazz, cacheClass);
        }
        return classMemebers.idSetter;
    }

    private ClassMemebers getClassMemebers(Class clazz) {
        ClassMemebers classMemebers;
        if (this.mClassMethodsMap == null) {
            this.mClassMethodsMap = new HashMap();
        }
        if ((classMemebers = (ClassMemebers)this.mClassMethodsMap.get(clazz)) == null) {
            classMemebers = new ClassMemebers();
            this.mClassMethodsMap.put(clazz, classMemebers);
        }
        return classMemebers;
    }

    public Class classForName(String string, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> clazz;
        if (this.mClasses == null) {
            this.mClasses = new HashMap();
        }
        if ((clazz = (Class<?>)this.mClasses.get(string)) == null) {
            clazz = Class.forName(string, true, classLoader);
            this.mClasses.put(string, clazz);
        }
        return clazz;
    }

    public ObjectFactory getObjectFactory() {
        return this.mObjectFactory;
    }

    private static class ClassMemebers {
        public Map methods;
        public Map fields;
        public Member idSetter;

        private ClassMemebers() {
        }
    }
}

