/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.MachineInfo;
import com.intersys.jdbc.CacheCallableStatement;
import com.intersys.jdbc.CacheDatabaseMetaData;
import com.intersys.jdbc.CachePooledConnection;
import com.intersys.jdbc.CachePreparedStatement;
import com.intersys.jdbc.CacheResultSet;
import com.intersys.jdbc.CacheStatement;
import com.intersys.jdbc.InStream;
import com.intersys.jdbc.LogFileStream;
import com.intersys.jdbc.OutStream;
import com.intersys.jdbc.QuickStatement;
import com.intersys.jdbc.RegisteredDatabases;
import com.intersys.jgss.GSSSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.SocketException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class CacheConnection
implements Connection {
    private static final int PRE_PREPARSE_CACHE_MAX_SIZE = 50;
    protected HashMap cachedPrepares = null;
    protected int nextServerCursorNumber = 0;
    public LogFileStream logFile = null;
    protected InStream inMessage = null;
    protected OutStream outMessage = null;
    protected String serverVersion;
    protected long cacheJobNumber = -1L;
    protected int delimitedIds = 0;
    protected String url = null;
    protected String user = null;
    protected MessageCount messageCount;
    private Socket socket = null;
    protected InputStream inputStream;
    protected OutputStream outputStream;
    protected int protocolVersion;
    protected int isolationLevel;
    protected int supportedIsolationLevels;
    protected String serverLocale = null;
    private String password = null;
    private boolean closed = true;
    private boolean autoCommit = true;
    private boolean isReadOnly = false;
    protected CachePooledConnection pooled = null;
    private Vector statementPool;
    private Vector preparedStatementPool;
    private Vector callableStatementPool;
    protected boolean isUnicodeServer = false;
    private SQLWarning warnings = null;
    protected HashMap prePreparseCache;
    private int securityLevel;
    private String principalName;
    private RegisteredDatabases registeredDatabases = null;
    protected static final int PROTOCOL_VERSION = 41;
    protected static final byte[] HANDSHAKE = new byte[]{72, 83};
    protected static final byte[] CONNECT = new byte[]{67, 78};
    protected static final byte[] DISCONNECT = new byte[]{68, 67};
    protected static final byte[] PREPARE = new byte[]{80, 80};
    protected static final byte[] DIRECT_UPDATE = new byte[]{68, 85};
    protected static final byte[] DIRECT_QUERY = new byte[]{68, 81};
    protected static final byte[] DIRECT_STORED_PROCEDURE = new byte[]{68, 83};
    protected static final byte[] PREPARED_UPDATE_EXECUTE = new byte[]{80, 85};
    protected static final byte[] PREPARED_QUERY_EXECUTE = new byte[]{80, 81};
    protected static final byte[] FETCH_DATA = new byte[]{70, 68};
    protected static final byte[] CLOSE_CURSOR = new byte[]{67, 67};
    protected static final byte[] CLOSE_STREAM = new byte[]{67, 83};
    protected static final byte[] PREPARE_STORED_PROCEDURE = new byte[]{83, 80};
    protected static final byte[] STORED_PROCEDURE_UPDATE_EXECUTE = new byte[]{83, 85};
    protected static final byte[] STORED_PROCEDURE_QUERY_EXECUTE = new byte[]{83, 81};
    protected static final byte[] STORED_PROCEDURE_FETCH_DATA = new byte[]{83, 70};
    protected static final byte[] EXECUTE_MULTIPLE_RESULT_SETS = new byte[]{77, 83};
    protected static final byte[] MULTIPLE_RESULT_SETS_FETCH_DATA = new byte[]{77, 68};
    protected static final byte[] GET_MORE_RESULTS = new byte[]{77, 82};
    protected static final byte[] GET_STORED_PROCEDURE_STREAM_SIZE = new byte[]{83, 83};
    protected static final byte[] RETRIEVE_STREAM = new byte[]{82, 83};
    protected static final byte[] OPEN_STREAM = new byte[]{79, 83};
    protected static final byte[] READ_STREAM = new byte[]{74, 83};
    protected static final byte[] STREAM_HANDLE = new byte[]{83, 79};
    protected static final byte[] STORE_BINARY_STREAM = new byte[]{83, 66};
    protected static final byte[] STORE_CHARACTER_STREAM = new byte[]{83, 77};
    protected static final byte[] READ_UNICODE_LONGVARCHAR = new byte[]{85, 86};
    protected static final byte[] GET_CACHE_RESULT_SET_OBJECT = new byte[]{70, 82};
    protected static final byte[] GET_STRUCT_OBJECT = new byte[]{70, 83};
    protected static final byte[] GET_CACHE_INFO = new byte[]{67, 73};
    protected static final byte[] COMMIT = new byte[]{84, 67};
    protected static final byte[] ROLLBACK = new byte[]{84, 82};
    protected static final byte[] READ_COMMITTED = new byte[]{82, 67};
    protected static final byte[] READ_UNCOMMITTED = new byte[]{82, 85};
    protected static final byte[] AUTOCOMMIT_OFF = new byte[]{65, 70};
    protected static final byte[] AUTOCOMMIT_ON = new byte[]{65, 78};
    protected static final byte[] TOGGLE_SYNCHRONOUS_COMMIT = new byte[]{84, 83};
    protected static final byte[] GET_AUTO_GENERATED_KEYS = new byte[]{71, 71};
    protected static final byte[] IN_TRANSACTION = new byte[]{73, 84};
    protected static final byte[] JDBC_BESTROWID = new byte[]{66, 82};
    protected static final byte[] JDBC_CATALOGS = new byte[]{67, 65};
    protected static final byte[] JDBC_COLUMNPRIV = new byte[]{67, 80};
    protected static final byte[] JDBC_COLUMNS = new byte[]{67, 79};
    protected static final byte[] JDBC_CROSSREFERENCE = new byte[]{67, 82};
    protected static final byte[] JDBC_EXPORTEDKEYS = new byte[]{69, 75};
    protected static final byte[] JDBC_IMPORTEDKEYS = new byte[]{73, 75};
    protected static final byte[] JDBC_INDEXINFO = new byte[]{73, 73};
    protected static final byte[] JDBC_PRIMARYKEYS = new byte[]{80, 75};
    protected static final byte[] JDBC_PROCEDURECOL = new byte[]{80, 67};
    protected static final byte[] JDBC_PROCEDURES = new byte[]{80, 82};
    protected static final byte[] JDBC_SCHEMAS = new byte[]{83, 67};
    protected static final byte[] JDBC_TABLEPRIV = new byte[]{84, 80};
    protected static final byte[] JDBC_TABLES = new byte[]{84, 65};
    protected static final byte[] JDBC_TABLETYPES = new byte[]{84, 84};
    protected static final byte[] JDBC_TYPEINFO = new byte[]{84, 73};
    protected static final byte[] JDBC_VERSIONCOL = new byte[]{86, 67};
    protected static final byte[] JDBC_UDTS = new byte[]{85, 84};
    protected static final byte[] JDBC_SUPER_TYPES = new byte[]{83, 89};
    protected static final byte[] JDBC_SUPER_TABLES = new byte[]{83, 76};
    protected static final byte[] JDBC_GET_ATTRIBUTES = new byte[]{65, 84};
    public static final byte[] XA_START = new byte[]{88, 83};
    public static final byte[] XA_END = new byte[]{88, 69};
    public static final byte[] XA_FORGET = new byte[]{88, 70};
    public static final byte[] XA_PREPARE = new byte[]{88, 80};
    public static final byte[] XA_COMMIT = new byte[]{88, 67};
    public static final byte[] XA_ROLLBACK = new byte[]{88, 82};
    public static final byte[] XA_RECOVER = new byte[]{88, 86};
    protected static final byte[] EXECUTE_STATIC_CURSOR = new byte[]{69, 88};
    protected static final byte[] DIRECT_STATIC_CURSOR = new byte[]{68, 88};
    protected static final byte[] FETCH_STATIC_CURSOR = new byte[]{70, 88};
    protected static final byte[] UPDATE_CACHE = new byte[]{85, 67};
    protected static final byte[] RESET_CONNECTION = new byte[]{82, 78};
    protected static final byte[] GET_SERVER_ERROR = new byte[]{79, 69};
    protected static final byte[] EXECUTE_STATEMENT_BATCH = new byte[]{69, 66};
    protected static final byte[] CLOSE_STATEMENT = new byte[]{67, 85};
    protected static final byte[] QUICK_LOAD = new byte[]{81, 76};
    protected static final byte[] QUICK_CHILD_TABLE_LOAD = new byte[]{81, 90};
    protected static final byte[] QUICK_CHILD_TABLE_CREATE = new byte[]{81, 88};
    protected static final byte[] QUICK_CHILD_TABLE_REMOVE = new byte[]{81, 75};
    protected static final byte[] QUICK_STORE = new byte[]{81, 83};
    protected static final byte[] QUICK_CREATE = new byte[]{81, 67};
    protected static final byte[] QUICK_REMOVE = new byte[]{81, 82};
    protected static final byte[] QUICK_FIND_ROWID_BY_PK = new byte[]{81, 49};
    protected static final byte[] QUICK_FIND_ROWID_BY_CONSTRAINT = new byte[]{81, 50};
    protected static final byte[] QUICK_FIND_PK_BY_CONSTRAINT = new byte[]{81, 51};
    protected static final byte[] QUICK_REMOVE_BY_PK = new byte[]{81, 52};
    protected static final byte[] QUICK_CREATE_BY_PK = new byte[]{81, 53};
    protected static final byte[] QUICK_STORE_BY_PK = new byte[]{81, 54};
    protected static final byte[] QUICK_LOAD_BY_PK = new byte[]{81, 55};
    protected static final byte[] QUICK_CHILD_TABLE_REMOVE_BY_PK = new byte[]{81, 56};
    protected static final byte[] QUICK_CHILD_TABLE_CREATE_BY_PK = new byte[]{81, 57};
    protected static final byte[] QUICK_CHILD_TABLE_LOAD_BY_PK = new byte[]{81, 65};
    protected static final byte[] QUICK_GET_CHILDREN_PKS = new byte[]{81, 66};
    protected static final byte[] QUICK_GET_CHILDREN_PKS_BY_PK = new byte[]{81, 68};
    protected static final byte[] QUICK_FIND_PK_BY_ROWID = new byte[]{81, 69};
    protected static final byte[] QUICK_BULK_LOAD = new byte[]{81, 77};
    protected static final byte[] QUICK_BULK_CREATE = new byte[]{81, 78};
    protected static final byte[] QUICK_BULK_STORE = new byte[]{81, 79};
    protected static final byte[] STREAM_GET_BYTES = new byte[]{71, 66};
    protected static final byte[] STREAM_GET_POSITION = new byte[]{71, 80};
    protected static final byte[] PING = new byte[]{80, 71};
    protected static final int MAX_CACHE_SIZE = 500;
    protected static final int ITEMS_TO_REMOVE = 100;
    protected static final int MAX_STATEMENT_POOL_SIZE = 40;
    protected static final int ALLOW_ERROR_0 = 0;
    protected static final int ALLOW_ERROR_100 = 100;
    protected static final int ALLOW_ERROR_403 = 403;
    protected static final int ALLOW_ERROR_404 = 404;
    protected static final int ALLOW_ERROR_417 = 417;
    protected static final int ALLOW_ERRORS_100_AND_404 = 504;

    protected CacheConnection(String string, String string2, int n, String string3, String string4, String string5, boolean bl, Properties properties, String string6, String string7) throws SQLException {
        this.init();
        this.url = string;
        String string8 = properties.getProperty("connection security level");
        if (string8 != null) {
            this.securityLevel = Integer.parseInt(string8);
            if (this.securityLevel != 0) {
                this.principalName = properties.getProperty("service principal name");
                if (this.principalName == null) {
                    throw new SQLException("No Service Principal Name: Connection Security Level is: " + this.securityLevel);
                }
            }
        }
        this.user = string6 != null ? string6 : properties.getProperty("user");
        this.password = string7 != null ? string7 : properties.getProperty("password");
        if (string4 != null) {
            try {
                this.logFile = new LogFileStream(string4);
            }
            catch (IOException iOException) {
                this.logFile = null;
            }
        }
        if (!this.closed) {
            return;
        }
        this.connect(string2, n, string3, string5, 0, bl, properties);
    }

    protected CacheConnection(String string, String string2, int n, String string3, String string4, String string5, String string6, PrintWriter printWriter, int n2, boolean bl, CachePooledConnection cachePooledConnection, int n3, String string7) throws SQLException {
        this.init();
        this.securityLevel = n3;
        this.principalName = string7;
        this.url = string;
        this.user = string4;
        this.password = string5;
        this.pooled = cachePooledConnection;
        if (printWriter != null) {
            try {
                this.logFile = new LogFileStream(printWriter);
            }
            catch (IOException iOException) {
                this.logFile = null;
            }
        }
        this.connect(string2, n, string3, string6, n2, bl, null);
    }

    public CacheConnection(Object object, Object object2, Object object3, String string, int n, int n2, Object object4) throws Exception {
        this.init();
        if (this.protocolVersion > n2) {
            this.protocolVersion = n2;
        }
        this.closed = false;
        this.isolationLevel = 1;
        this.socket = (Socket)object3;
        String string2 = MachineInfo.getIPAddress(this.socket.getInetAddress().getHostAddress());
        this.url = "jdbc:Cache://" + string2 + ":" + n + "/" + string;
        this.logFile = (LogFileStream)object4;
        this.user = "_SYSTEM";
        this.password = "sys";
        this.inputStream = ((InStream)object).inputStream;
        this.outputStream = ((OutStream)object2).outputStream;
        this.inMessage = (InStream)object;
        this.outMessage = (OutStream)object2;
    }

    protected void addPrePreparseCache(String string, String string2, int n, int n2, Vector vector, int n3) {
        if (this.prePreparseCache.size() < 50) {
            this.prePreparseCache.put(string, new CachedSQL(string2, n, n2, vector, n3));
        }
    }

    private void init() {
        this.protocolVersion = 41;
        this.securityLevel = 0;
        this.principalName = null;
        this.statementPool = new Vector();
        this.preparedStatementPool = new Vector();
        this.callableStatementPool = new Vector();
        this.cachedPrepares = new HashMap();
        this.messageCount = new MessageCount();
        this.prePreparseCache = new HashMap();
    }

    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007);
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, 1003, 1007);
    }

    public CallableStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(string, 1003, 1007);
    }

    public PreparedStatement prepareStatement(String string, int n, long l) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        CachePreparedStatement cachePreparedStatement = (CachePreparedStatement)this.getStatement(this.preparedStatementPool, 1003, 1007);
        if (cachePreparedStatement == null) {
            return new CachePreparedStatement(this, 1003, string, n, l);
        }
        cachePreparedStatement.prepare(string, n, l);
        return cachePreparedStatement;
    }

    public CallableStatement prepareCall(String string, int n, long l) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        CacheCallableStatement cacheCallableStatement = (CacheCallableStatement)this.getStatement(this.callableStatementPool, 1003, 1007);
        if (cacheCallableStatement == null) {
            return new CacheCallableStatement(this, string, n, l);
        }
        cacheCallableStatement.prepare(string, n, l);
        return cacheCallableStatement;
    }

    public String nativeSQL(String string) throws SQLException {
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        this.autoCommit = bl;
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            if (this.autoCommit) {
                this.outMessage.wire.writeHeader(AUTOCOMMIT_ON);
            } else {
                this.outMessage.wire.writeHeader(AUTOCOMMIT_OFF);
            }
            this.outMessage.send(this.messageCount.getCount());
        }
    }

    public boolean getAutoCommit() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        return this.autoCommit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.wire.writeHeader(COMMIT);
            this.outMessage.send(this.messageCount.getCount());
            this.inMessage.readHeader(0, 0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.wire.writeHeader(ROLLBACK);
            this.outMessage.send(this.messageCount.getCount());
            this.inMessage.readHeader(0, 0, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SQLException {
        if (this.closed) {
            return;
        }
        if (this.pooled != null) {
            this.closePooledConnection();
            return;
        }
        if (this.registeredDatabases != null) {
            this.registeredDatabases.onClose();
        }
        this.closed = true;
        this.cachedPrepares = null;
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.wire.writeHeader(DISCONNECT);
            this.outMessage.send(this.messageCount.getCount());
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket = null;
        if (this.logFile != null) {
            this.logFile.close();
            this.logFile = null;
        }
        this.outMessage = null;
        this.inMessage = null;
    }

    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        return new CacheDatabaseMetaData(this);
    }

    public synchronized void setReadOnly(boolean bl) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        this.isReadOnly = bl;
    }

    public boolean isReadOnly() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        return this.isReadOnly;
    }

    public void setCatalog(String string) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
    }

    public String getCatalog() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setTransactionIsolation(int n) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        if (this.isolationLevel == n) {
            return;
        }
        if (0 == n || 4 == n || 8 == n) {
            throw new SQLException("Unsupported isolation level " + n, "S1000", 460);
        }
        if (this.supportedIsolationLevels == 1 && 2 == n) {
            throw new SQLException("Unsupported isolation level " + n, "S1000", 460);
        }
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            if (n == 1) {
                this.outMessage.wire.writeHeader(READ_UNCOMMITTED);
            } else {
                this.outMessage.wire.writeHeader(READ_COMMITTED);
            }
            this.outMessage.send(this.messageCount.getCount());
        }
        this.isolationLevel = n;
    }

    public int getTransactionIsolation() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        return this.isolationLevel;
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        return this.warnings;
    }

    public void clearWarnings() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        this.warnings = null;
    }

    private final byte[] encode(int n, byte[] byArray) {
        int n2 = 0;
        byte[] byArray2 = new byte[n];
        while (n > 0) {
            int n3 = ((byArray[n2] ^ 0xA7) & 0xFF) + --n & 0xFF;
            byArray2[n] = (byte)(n3 << 5 | n3 >> 3);
            ++n2;
        }
        return byArray2;
    }

    protected int getQueryTimeout() throws SQLException {
        try {
            return this.socket.getSoTimeout() / 1000;
        }
        catch (SocketException socketException) {
            throw new SQLException("Communication link failure: " + socketException.getMessage(), "08S01", 461);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setQueryTimeout(int n) throws SQLException {
        try {
            Socket socket = this.socket;
            synchronized (socket) {
                this.socket.setSoTimeout(n * 1000);
            }
        }
        catch (SocketException socketException) {
            throw new SQLException("Communication link failure: " + socketException.getMessage(), "08S01", 461);
        }
    }

    private void configureSocket(Properties properties) throws SQLException {
        if (properties == null) {
            return;
        }
        try {
            String string = properties.getProperty("TCP_NODELAY");
            if (string != null) {
                this.socket.setTcpNoDelay(Boolean.valueOf(string));
            }
            if ((string = properties.getProperty("SO_SNDBUF")) != null) {
                this.socket.setSendBufferSize(Integer.parseInt(string));
            }
            if ((string = properties.getProperty("SO_RCVBUF")) != null) {
                this.socket.setReceiveBufferSize(Integer.parseInt(string));
            }
        }
        catch (Exception exception) {
            throw new SQLException("Bad socket option: " + exception.getMessage(), "08S01", 461);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void connect(String string, int n, String string2, String string3, int n2, boolean bl, Properties properties) throws SQLException {
        String string4;
        if (this.user == null) {
            this.user = "";
        }
        if (this.password == null) {
            this.password = "";
        }
        this.isolationLevel = 1;
        if (properties != null && (string4 = properties.getProperty("TransactionIsolationLevel")) != null && string4.equals("TRANSACTION_READ_COMMITTED")) {
            this.isolationLevel = 2;
        }
        try {
            this.socket = this.securityLevel == 0 ? new Socket(string, n) : new GSSSocket(string, n, this.principalName, this.securityLevel, this.user, this.password);
            this.socket.setSoTimeout(n2 * 1000);
            this.socket.setTcpNoDelay(bl);
            this.configureSocket(properties);
            this.outputStream = this.socket.getOutputStream();
            this.inputStream = this.socket.getInputStream();
            this.outMessage = new OutStream(this.outputStream, this.logFile);
            this.inMessage = new InStream(this);
            MessageCount messageCount = this.messageCount;
            synchronized (messageCount) {
                this.outMessage.wire.writeHeader(HANDSHAKE);
                this.outMessage.wire.set2ByteInt(this.protocolVersion);
                this.outMessage.send(this.messageCount.getCount());
                if (this.inMessage.readHeader(0, 0, 417) == 417) {
                    throw new SQLException(this.inMessage.wire.getString(), "08S01", 461);
                }
                this.protocolVersion = this.inMessage.wire.get2ByteInt();
                this.outMessage.setProtocolVersion(this.protocolVersion);
                int n3 = this.inMessage.wire.get2ByteInt();
                this.isUnicodeServer = n3 == 1;
                this.serverLocale = this.protocolVersion > 16 ? this.inMessage.wire.readServerEncoding() : null;
                this.inMessage.wire.setServerType(this.isUnicodeServer, this.serverLocale);
                this.outMessage.wire.setServerType(this.isUnicodeServer, this.serverLocale);
                this.outMessage.wire.setMaxItemSize(32000);
                this.outMessage.wire.writeHeader(CONNECT);
                this.outMessage.wire.set(string2);
                this.outMessage.wire.set(this.encode(this.user.length(), this.user.getBytes()));
                this.outMessage.wire.set(this.encode(this.password.length(), this.password.getBytes()));
                this.outMessage.wire.set(MachineInfo.getUserName());
                this.outMessage.wire.set(MachineInfo.getMachineName());
                this.outMessage.wire.set(MachineInfo.getExeName());
                this.outMessage.wire.set(MachineInfo.getOSInfo());
                this.outMessage.wire.set(MachineInfo.getIPAddress(this.socket.getInetAddress().getHostAddress()));
                if (this.protocolVersion > 1) {
                    this.outMessage.wire.set(string3);
                }
                if (this.protocolVersion > 6) {
                    if (this.autoCommit) {
                        this.outMessage.wire.set(1);
                    } else {
                        this.outMessage.wire.set(2);
                    }
                    this.outMessage.wire.set(0);
                }
                this.outMessage.send(this.messageCount.getCount());
                if (this.inMessage.readHeader(0, 0, 417) == 417) {
                    throw new SQLException(this.inMessage.wire.getString(), "08S01", 461);
                }
                this.serverVersion = this.inMessage.wire.getString();
                this.delimitedIds = this.inMessage.wire.getInt();
                int n4 = this.inMessage.wire.getInt();
                this.supportedIsolationLevels = this.protocolVersion > 4 ? this.inMessage.wire.getInt() : 1;
                if (this.protocolVersion > 14) {
                    this.cacheJobNumber = this.inMessage.wire.getLong();
                    if (this.logFile != null) {
                        this.logFile.setJobID(this.cacheJobNumber);
                    }
                }
                if (this.protocolVersion < 41) {
                    this.outMessage.wire.disableIEEEDouble();
                    this.inMessage.wire.disableIEEEDouble();
                }
            }
            this.closed = false;
            this.socket.setSoTimeout(0);
        }
        catch (Exception exception) {
            try {
                this.socket.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw new SQLException("[Cache JDBC] Communication link failure: " + exception.getMessage(), "08S01", 461);
        }
    }

    public boolean isServerUnicode() {
        return this.isUnicodeServer;
    }

    public String getServerLocale() {
        return this.serverLocale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addCachedPrepare(String string, int n, Statement statement, Vector vector, Vector vector2, int n2, int n3) throws SQLException {
        if (string.length() > 5000) {
            return;
        }
        HashMap hashMap = this.cachedPrepares;
        synchronized (hashMap) {
            if (this.cachedPrepares.size() >= 500) {
                this.updateCache();
            }
            this.cachedPrepares.put(new Integer(n), new CachedPrepare(string, n, statement, vector, vector2, n2, n3));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCache() throws SQLException {
        if (this.protocolVersion < 9) {
            return;
        }
        HashMap hashMap = this.cachedPrepares;
        synchronized (hashMap) {
            Iterator iterator = this.cachedPrepares.keySet().iterator();
            if (!iterator.hasNext()) {
                return;
            }
            int[] nArray = new int[100];
            int n = 0;
            while (iterator.hasNext()) {
                Object k = iterator.next();
                CachedPrepare cachedPrepare = (CachedPrepare)this.cachedPrepares.get(k);
                if (cachedPrepare.ownedBy != null) continue;
                nArray[n] = cachedPrepare.serverCursorNumber;
                iterator.remove();
                if (++n != 100) continue;
            }
            if (n == 0) {
                return;
            }
            MessageCount messageCount = this.messageCount;
            synchronized (messageCount) {
                this.outMessage.wire.writeHeader(UPDATE_CACHE);
                this.outMessage.wire.set(n);
                for (int i = 0; i < n; ++i) {
                    this.outMessage.wire.set(nArray[i]);
                }
                this.outMessage.send(this.messageCount.getCount());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearCache(boolean bl) throws SQLException {
        int n = this.cachedPrepares.size();
        if (n == 0) {
            return;
        }
        HashMap hashMap = this.cachedPrepares;
        synchronized (hashMap) {
            Iterator iterator = this.cachedPrepares.keySet().iterator();
            if (bl) {
                MessageCount messageCount = this.messageCount;
                synchronized (messageCount) {
                    this.outMessage.wire.writeHeader(UPDATE_CACHE);
                    this.outMessage.wire.set(n);
                    while (iterator.hasNext()) {
                        Object k = iterator.next();
                        CachedPrepare cachedPrepare = (CachedPrepare)this.cachedPrepares.get(k);
                        this.outMessage.wire.set(cachedPrepare.serverCursorNumber);
                        iterator.remove();
                    }
                    this.outMessage.send(this.messageCount.getCount());
                }
                return;
            }
            while (iterator.hasNext()) {
                Object k = iterator.next();
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendXAMessage(byte[] byArray, String string) throws SQLException {
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.wire.writeHeader(byArray);
            this.outMessage.wire.set(string);
            this.outMessage.send(this.messageCount.getCount());
            return this.inMessage.readHeader(0, 0, 0);
        }
    }

    protected void getServerError(int n) throws SQLException {
        String string = CacheConnection.getSQLState(n);
        if (this.closed) {
            switch (n) {
                case 469: {
                    throw new SQLException("Driver not capable", string, n);
                }
                case 464: {
                    throw new SQLException("Function sequence error", string, n);
                }
                case 462: {
                    throw new SQLException("Memory allocation failure", string, n);
                }
                case 461: {
                    throw new SQLException("Communication link failure", string, n);
                }
                case 460: {
                    throw new SQLException("General error", string, n);
                }
                case 453: {
                    throw new SQLException("Error in User Initialization Code", string, n);
                }
                case 452: {
                    throw new SQLException("Message sequencing error", string, n);
                }
                case 451: {
                    throw new SQLException("Unable to receive server message", string, n);
                }
                case 450: {
                    throw new SQLException("Unable to send client message", string, n);
                }
                case 410: {
                    throw new SQLException("Invalid Directory", string, n);
                }
                case 409: {
                    throw new SQLException("Invalid server function", string, n);
                }
                case 408: {
                    throw new SQLException("Unable to start server", string, n);
                }
                case 407: {
                    throw new SQLException("Unable to Write to Server Master", string, n);
                }
                case 406: {
                    throw new SQLException("Unable to Write to Server", string, n);
                }
                case 405: {
                    throw new SQLException("Unable to read from communication device", string, n);
                }
                case 402: {
                    throw new SQLException("Invalid Username/Password", string, n);
                }
                case 401: {
                    throw new SQLException("Fatal Connection error", string, n);
                }
                case 400: {
                    throw new SQLException("Fatal error occurred", string, n);
                }
                case 112: {
                    throw new SQLException("Access violation", string, n);
                }
                case 99: {
                    throw new SQLException("Privilege Violation", string, n);
                }
                case 98: {
                    throw new SQLException("License Violation", string, n);
                }
            }
            throw new SQLException("General error", string, n);
        }
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.wire.writeHeader(GET_SERVER_ERROR);
            this.outMessage.wire.set(n);
            this.outMessage.send(this.messageCount.getCount());
            int n2 = this.inMessage.readHeader(0, 0, 0);
            if (n2 != 0) {
                throw new SQLException("General error", string, n);
            }
            throw new SQLException(this.inMessage.wire.getString(), string, n);
        }
    }

    private static String getSQLState(int n) {
        switch (n) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 41: 
            case 42: 
            case 51: 
            case 53: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: {
                return "37000";
            }
            case 30: 
            case 33: 
            case 39: {
                return "S0002";
            }
            case 31: {
                return "S0022";
            }
            case 62: {
                return "21S01";
            }
            case 103: {
                return "34000";
            }
            case 104: 
            case 108: {
                return "23000";
            }
            case 1004: {
                return "01004";
            }
            case 1031: {
                return "42000";
            }
            case 7001: {
                return "07001";
            }
            case 7006: {
                return "07006";
            }
            case 22003: {
                return "22003";
            }
            case 22005: {
                return "22005";
            }
            case 22008: {
                return "22008";
            }
            case 24000: {
                return "24000";
            }
            case 402: {
                return "28000";
            }
            case 413: 
            case 452: 
            case 461: {
                return "08S01";
            }
            case 450: {
                return "S1T00";
            }
            case 462: {
                return "S1001";
            }
            case 463: {
                return "S1002";
            }
            case 464: {
                return "S1010";
            }
            case 465: {
                return "S1090";
            }
            case 466: {
                return "S1093";
            }
            case 467: {
                return "S1097";
            }
            case 468: {
                return "S1106";
            }
            case 469: {
                return "S1C00";
            }
            case 470: {
                return "01S02";
            }
            case 471: {
                return "3C000";
            }
        }
        return "S1000";
    }

    public long getCacheJobID() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        return this.cacheJobNumber;
    }

    public byte[] sendCustomMessage(byte[] byArray, byte[] byArray2) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            try {
                this.outMessage.wire.writeHeader(byArray);
                this.outMessage.wire.setRawBytes(byArray2);
                this.outMessage.send(this.messageCount.getCount());
                if (this.protocolVersion < 33) {
                    return this.oldReceiveSentCustomMessage();
                }
                int n = this.inMessage.readHeader(0, 2, 0);
                if (n != 0) {
                    throw new SQLException("Error fetching raw byte array", "00000", n);
                }
                return this.inMessage.getRawBytes();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new SQLException("sendCustomeMessage: " + exception.getMessage());
            }
        }
    }

    private byte[] oldReceiveSentCustomMessage() throws SQLException {
        byte[] byArray = null;
        while (true) {
            int n;
            if ((n = this.inMessage.readHeader(0, 2, 0)) != 0 && n != 414) {
                throw new SQLException("Error fetching raw byte array", "00000", n);
            }
            if (byArray == null) {
                if (n == 0) {
                    return this.inMessage.getRawBytes();
                }
                byArray = this.inMessage.getRawBytes();
                continue;
            }
            byte[] byArray2 = this.inMessage.getRawBytes();
            byte[] byArray3 = new byte[byArray.length + byArray2.length];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
            if (n == 0) {
                return byArray3;
            }
            byArray = byArray3;
        }
    }

    public RegisteredDatabases registerDatabase() {
        if (this.registeredDatabases == null) {
            this.registeredDatabases = new RegisteredDatabases();
        }
        return this.registeredDatabases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isOwner(int n, Statement statement) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        HashMap hashMap = this.cachedPrepares;
        synchronized (hashMap) {
            CachedPrepare cachedPrepare = (CachedPrepare)this.cachedPrepares.get(new Integer(n));
            return cachedPrepare != null && statement == cachedPrepare.ownedBy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markAsNotBeingExecuted(int n, Statement statement) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        HashMap hashMap = this.cachedPrepares;
        synchronized (hashMap) {
            CachedPrepare cachedPrepare = (CachedPrepare)this.cachedPrepares.get(new Integer(n));
            if (cachedPrepare != null && statement == cachedPrepare.ownedBy) {
                cachedPrepare.ownedBy = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markAsBeingExecuted(int n, Statement statement) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        HashMap hashMap = this.cachedPrepares;
        synchronized (hashMap) {
            CachedPrepare cachedPrepare = (CachedPrepare)this.cachedPrepares.get(new Integer(n));
            if (cachedPrepare != null && null == cachedPrepare.ownedBy) {
                cachedPrepare.ownedBy = statement;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void poolStatement(CacheStatement cacheStatement) {
        Vector vector = this.statementPool;
        if (cacheStatement instanceof CacheCallableStatement) {
            vector = this.callableStatementPool;
        } else if (cacheStatement instanceof CachePreparedStatement) {
            vector = this.preparedStatementPool;
        }
        Vector vector2 = vector;
        synchronized (vector2) {
            if (vector.size() >= 40) {
                cacheStatement.input = null;
                cacheStatement.output = null;
                return;
            }
            vector.addElement(cacheStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void closePooledConnection() throws SQLException {
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.messageCount.count = -1;
            this.nextServerCursorNumber = 0;
            this.isolationLevel = 1;
            this.autoCommit = true;
            if (this.protocolVersion > 12) {
                this.clearCache(false);
                this.outMessage.wire.writeHeader(RESET_CONNECTION);
                this.outMessage.wire.set(1);
                this.outMessage.wire.set(0);
                this.outMessage.send(this.messageCount.getCount());
            }
            this.pooled.release();
        }
    }

    public QuickStatement createQuickStatement() throws SQLException {
        return new QuickStatement(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statement getStatement(Vector vector, int n, int n2) {
        Vector vector2 = vector;
        synchronized (vector2) {
            if (vector.isEmpty()) {
                return null;
            }
            CacheStatement cacheStatement = (CacheStatement)vector.elementAt(0);
            cacheStatement.resultSetType = n;
            cacheStatement.closed = false;
            cacheStatement.resultSetConcurrency = n2;
            cacheStatement.serverCursorNumber = 0;
            vector.remove(cacheStatement);
            return cacheStatement;
        }
    }

    protected int processError(int n, int n2) throws SQLException {
        if (n == 100 && (n2 == 100 || n2 == 504)) {
            return 100;
        }
        if (n == 403 && n2 == 403) {
            return 403;
        }
        if (n == 417 && n2 == 417) {
            return 417;
        }
        if (this.protocolVersion < 33 && n == 414) {
            return 414;
        }
        if (n == 404 && (n2 == 404 || n2 == 504)) {
            return 404;
        }
        if (n2 == -1) {
            return n;
        }
        this.getServerError(n);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWarning(SQLWarning sQLWarning) {
        if (this.warnings == null) {
            this.warnings = sQLWarning;
        } else {
            SQLWarning sQLWarning2 = this.warnings;
            synchronized (sQLWarning2) {
                this.warnings.setNextWarning(sQLWarning);
            }
        }
    }

    public Object getOutMessage() {
        return this.outMessage;
    }

    public Object getInMessage() {
        return this.inMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inTransaction() throws SQLException {
        if (this.protocolVersion < 41) {
            throw new SQLException("Not supported for protocol < 41", "IM001");
        }
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            this.outMessage.wire.writeHeader(IN_TRANSACTION);
            this.outMessage.send(this.messageCount.getCount());
            int n = this.inMessage.readHeader(0, 0, -1);
            return n != 0;
        }
    }

    private PreparedStatement prepareStatement(String string, int n, int n2, String string2) throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        CachePreparedStatement cachePreparedStatement = (CachePreparedStatement)this.getStatement(this.preparedStatementPool, n, n2);
        if (cachePreparedStatement == null) {
            cachePreparedStatement = new CachePreparedStatement(this, n, n2, string, string2);
        } else {
            cachePreparedStatement.autoGeneratedKeyColumn = string2;
            cachePreparedStatement.prepare(string);
        }
        return cachePreparedStatement;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ResultSet getCacheResultSet(String string) throws SQLException {
        CacheStatement cacheStatement = new CacheStatement(this, 1003, 1007, null);
        MessageCount messageCount = this.messageCount;
        synchronized (messageCount) {
            cacheStatement.output.wire.writeHeader(0, GET_CACHE_RESULT_SET_OBJECT);
            cacheStatement.output.wire.set(string);
            cacheStatement.output.wire.set(0);
            cacheStatement.output.send(this.messageCount.getCount());
            int n = cacheStatement.input.readHeader(0, 0, 100);
            if (n == 100) {
                cacheStatement.fetchDone = true;
            }
            cacheStatement.columnInfo(cacheStatement.input.wire);
        }
        return new CacheResultSet(cacheStatement, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float ping(int n) throws SQLException {
        long l = System.currentTimeMillis();
        for (int i = 0; i < n; ++i) {
            MessageCount messageCount = this.messageCount;
            synchronized (messageCount) {
                this.outMessage.wire.writeHeader(PING);
                this.outMessage.send(this.messageCount.getCount());
                this.inMessage.readHeader(0, 0, 0);
                continue;
            }
        }
        return (float)(System.currentTimeMillis() - l) / 1000.0f;
    }

    public static String[] getNamespaces(String string, int n, String string2, String string3, String string4) throws Exception {
        LogFileStream logFileStream = null;
        Socket socket = new Socket(string, n);
        if (string4 != null && string4 != "") {
            logFileStream = new LogFileStream(string4);
        }
        OutStream outStream = new OutStream(socket.getOutputStream(), logFileStream);
        InStream inStream = new InStream(socket.getInputStream(), logFileStream);
        return CacheConnection.getNamespaces(inStream, outStream, string2, string3);
    }

    public static String[] getNamespaces(InStream inStream, OutStream outStream, String string, String string2) throws Exception {
        outStream.wire.writeHeader(0, GET_CACHE_INFO);
        outStream.wire.set(string);
        outStream.wire.set(string2);
        outStream.send(0);
        inStream.quickReadHeader();
        int n = inStream.wire.getInt();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = inStream.wire.getString();
        }
        return stringArray;
    }

    public Statement createStatement(int n, int n2) throws SQLException {
        CacheStatement cacheStatement;
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        if (n == 1005) {
            this.addWarning(new SQLWarning("createStatement called with TYPE_SCROLL_SENSITIVE which is not supported: TYPE_SCROLL_INSENSITIVE used instead", "IM001"));
            n = 1004;
        }
        if ((cacheStatement = (CacheStatement)this.getStatement(this.statementPool, n, n2)) == null) {
            cacheStatement = new CacheStatement(this, n, n2, null);
        }
        return cacheStatement;
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        CachePreparedStatement cachePreparedStatement;
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        if (n == 1005) {
            this.addWarning(new SQLWarning("prepareStatement called with TYPE_SCROLL_SENSITIVE which is not supported: TYPE_SCROLL_INSENSITIVE used instead", "IM001"));
            n = 1004;
        }
        if ((cachePreparedStatement = (CachePreparedStatement)this.getStatement(this.preparedStatementPool, n, n2)) == null) {
            return new CachePreparedStatement(this, n, n2, string, null);
        }
        cachePreparedStatement.prepare(string);
        return cachePreparedStatement;
    }

    public CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        CacheCallableStatement cacheCallableStatement;
        if (this.closed) {
            throw new SQLException("Connection not open", "08003");
        }
        if (n != 1003) {
            this.addWarning(new SQLWarning("prepareCall called with unsupported result set type: TYPE_FORWARD_ONLY used instead", "IM001"));
            n = 1003;
        }
        if (n2 != 1007) {
            this.addWarning(new SQLWarning("prepareCall called with CONCUR_UPDATABLE which is not supported: CONCUR_READ_ONLY used instead", "IM001"));
            n2 = 1007;
        }
        if ((cacheCallableStatement = (CacheCallableStatement)this.getStatement(this.callableStatementPool, n, n2)) == null) {
            return new CacheCallableStatement(this, string);
        }
        cacheCallableStatement.prepare(string);
        return cacheCallableStatement;
    }

    public Map getTypeMap() throws SQLException {
        throw new SQLException("Not supported", "IM001");
    }

    public void setTypeMap(Map map) throws SQLException {
        throw new SQLException("Not supported", "IM001");
    }

    public int getHoldability() throws SQLException {
        return 1;
    }

    public void setHoldability(int n) throws SQLException {
        if (n == 2) {
            throw new SQLException("Unsupported holdability", "IM001");
        }
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        if (n3 == 2) {
            throw new SQLException("Unsupported holdability", "IM001");
        }
        return this.createStatement(n, n2);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        if (n3 == 2) {
            throw new SQLException("Unsupported holdability", "IM001");
        }
        return this.prepareStatement(string, n, n2);
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        if (n3 == 2) {
            throw new SQLException("Unsupported holdability", "IM001");
        }
        return this.prepareCall(string, n, n2);
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        if (this.protocolVersion < 35) {
            throw new SQLException("Not supported in this version of Cache; please update your server", "IM001");
        }
        if (n == 1) {
            return this.prepareStatement(string, 1003, 1007, "-1");
        }
        return this.prepareStatement(string, 1003, 1007, null);
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        if (this.protocolVersion < 35) {
            throw new SQLException("Not supported in this version of Cache; please update your server", "IM001");
        }
        if (nArray.length != 1) {
            throw new SQLException("Only a single auto-generated key allowed", "IM001");
        }
        return this.prepareStatement(string, 1003, 1007, Integer.toString(nArray[0]));
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        if (this.protocolVersion < 35) {
            throw new SQLException("Not supported in this version of Cache; please update your server", "IM001");
        }
        if (stringArray.length != 1) {
            throw new SQLException("Only a single auto-generated key allowed", "IM001");
        }
        return this.prepareStatement(string, 1003, 1007, stringArray[0]);
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLException("Not supported", "IM001");
    }

    public Savepoint setSavepoint() throws SQLException {
        throw new SQLException("Not supported", "IM001");
    }

    public Savepoint setSavepoint(String string) throws SQLException {
        throw new SQLException("Not supported", "IM001");
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLException("Not supported", "IM001");
    }

    final class CachedPrepare {
        protected int serverCursorNumber;
        protected Statement ownedBy;
        protected String sqlText;
        protected Vector parameters;
        protected Vector columns;
        protected int statementType;
        protected int hasReturnValue;

        CachedPrepare(String string, int n, Statement statement, Vector vector, Vector vector2, int n2, int n3) {
            this.sqlText = string;
            this.serverCursorNumber = n;
            this.ownedBy = statement;
            if (vector != null) {
                this.columns = (Vector)vector.clone();
            }
            this.parameters = (Vector)vector2.clone();
            this.statementType = n2;
            this.hasReturnValue = n3;
        }
    }

    final class CachedSQL {
        protected int hasReturnValue;
        protected int statementType;
        protected String sqlText;
        protected Vector parameters;
        protected int resultSetConcurrency;

        CachedSQL(String string, int n, int n2, Vector vector, int n3) {
            this.sqlText = string;
            this.statementType = n;
            this.hasReturnValue = n2;
            this.parameters = (Vector)vector.clone();
            this.resultSetConcurrency = n3;
        }
    }

    final class MessageCount {
        protected int count = 0;

        MessageCount() {
        }

        final synchronized int getCount() {
            return ++this.count;
        }
    }
}

