/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.serial;

import com.intersys.cache.CacheObject;
import com.intersys.cache.Dataholder;
import com.intersys.cache.SysDatabase;
import com.intersys.cache.serial.SerialCacheClass;
import com.intersys.cache.serial.SerialField;
import com.intersys.cache.serial.SerialObjectFactory;
import com.intersys.cache.serial.SerialStorageReader;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.Id;
import com.intersys.objects.ObjectClosedException;
import com.intersys.objects.Oid;
import com.intersys.objects.reflect.CacheClass;
import java.sql.SQLException;

public class SerialCacheObject
implements CacheObject {
    private SerialObjectFactory mDB;
    private SerialCacheClass mClass;
    private SerialStorageReader mStorage;

    public SerialCacheObject(SerialObjectFactory serialObjectFactory, SerialCacheClass serialCacheClass, Object object) throws CacheException {
        this.mClass = serialCacheClass;
        this.mDB = serialObjectFactory;
        this.mStorage = new SerialStorageReader(this.mDB, object, this.mClass.getNumberOfSerialElements());
    }

    protected SerialCacheObject() {
    }

    public CacheObject getMe() {
        return this;
    }

    public String getTypeName() {
        return this.mClass.getName();
    }

    public int getOref() throws ObjectClosedException {
        return 0;
    }

    public Object getZRef() throws CacheException {
        return null;
    }

    public SysDatabase getDatabase() {
        return this.mDB;
    }

    public Object newJavaInstance() throws CacheException {
        return this.mClass.newInstance(this);
    }

    public Object newJavaInstance(boolean bl) throws CacheException {
        return this.mClass.newInstance(this, bl);
    }

    public CacheClass getCacheClass() {
        return this.mClass;
    }

    public Oid getOid() {
        return this.mStorage.getOid();
    }

    public Dataholder getProperty(int n, int n2, int n3, String string) throws CacheException {
        SerialField serialField = (SerialField)this.mClass.getField(string);
        if (serialField == null) {
            return Dataholder.create(null);
        }
        Dataholder dataholder = this.mStorage.getProperty(serialField.getIndex(), serialField.getCollectionType(), serialField.getElementType(), serialField.getTypeName());
        return dataholder;
    }

    public Object getSerialState(Object object) throws CacheException {
        if (object == null) {
            object = SysListProxy.createSysList();
        }
        try {
            SysListProxy.setByte(object, this.mStorage.getOriginalSerialState());
            SysListProxy.setString(object, this.mClass.getName());
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException);
        }
        return object;
    }

    public void setCacheClass(CacheClass cacheClass) throws CacheException {
        throw new UnsupportedOperationException("Method setCacheClass() is not implemented in class com.intersys.cache.serial.SerialCacheObject");
    }

    public Id getId() throws CacheException {
        throw new UnsupportedOperationException("Method getId() is not implemented in class com.intersys.cache.serial.SerialCacheObject");
    }

    public int save(boolean bl) throws CacheException {
        throw new UnsupportedOperationException("Method save() is not implemented in class com.intersys.cache.serial.SerialCacheObject");
    }

    public void delete() throws CacheException {
        throw new UnsupportedOperationException("Method delete() is not implemented in class com.intersys.cache.serial.SerialCacheObject");
    }

    public boolean isClosed() {
        throw new UnsupportedOperationException("Method isClosed() is not implemented in class com.intersys.cache.serial.SerialCacheObject");
    }

    public void forceClose() throws CacheException {
        throw new UnsupportedOperationException("Method forceClose() is not implemented in class com.intersys.cache.serial.SerialCacheObject");
    }

    public void increaseReferenceCount() throws CacheException {
        throw new UnsupportedOperationException("Method increaseReferenceCount() is not implemented in class com.intersys.cache.serial.SerialCacheObject");
    }

    public void decreaseReferenceCount() throws CacheException {
        throw new UnsupportedOperationException("Method decreaseReferenceCount() is not implemented in class com.intersys.cache.serial.SerialCacheObject");
    }

    public void setProperty(int n, int n2, int n3, int n4, String string, Dataholder dataholder) throws CacheException {
        throw new UnsupportedOperationException("Method setProperty() is not implemented in class com.intersys.cache.serial.SerialCacheObject");
    }

    public Dataholder[] runInstanceMethod(String string, int[] nArray, Dataholder[] dataholderArray, int n) throws CacheException {
        throw new UnsupportedOperationException("Method runInstanceMethod() is not implemented in class com.intersys.cache.serial.SerialCacheObject");
    }

    public Dataholder runInstanceMethod(String string, Dataholder[] dataholderArray, int n) throws CacheException {
        throw new UnsupportedOperationException("Method runInstanceMethod() is not implemented in class com.intersys.cache.serial.SerialCacheObject");
    }

    public void setUserData(Object object) {
        throw new UnsupportedOperationException("Method setUserData() is not implemented in class com.intersys.cache.serial.SerialCacheObject");
    }

    public Object getUserData() {
        throw new UnsupportedOperationException("Method getUserData() is not implemented in class com.intersys.cache.serial.SerialCacheObject");
    }

    public void increaseCount() throws CacheException {
    }

    public void decreaseCount() throws CacheException {
    }

    public void assertNotClosed(boolean bl) throws CacheException {
        throw new UnsupportedOperationException("Method assertNotClosed() is not implemented in class com.intersys.cache.serial.SerialCacheObject");
    }

    public String toOrefString() throws CacheException {
        return "<serial>@" + this.mClass.getName();
    }

    public int getState() {
        throw new UnsupportedOperationException("Method getState() is not implemented in class com.intersys.cache.serial.SerialCacheObject");
    }

    public void clearState() {
        throw new UnsupportedOperationException("Method clearState() is not implemented in class com.intersys.cache.serial.SerialCacheObject");
    }

    public void setStateReadDirty() {
        throw new UnsupportedOperationException("Method setStateReadDirty() is not implemented in class com.intersys.cache.serial.SerialCacheObject");
    }
}

