/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.quick;

import com.intersys.cache.Dataholder;
import com.intersys.cache.quick.QuickCacheObject;
import com.intersys.cache.quick.TableBasedClass;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheReader;
import com.intersys.objects.CacheWriter;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;

class QuickReaderObject
extends QuickCacheObject {
    private Reader mIS;
    private CharArrayWriter mOS;
    private QuickCacheWriter mOut = null;
    private QuickCacheReader mIn = null;

    public QuickReaderObject(TableBasedClass tableBasedClass, Reader reader, CharArrayWriter charArrayWriter) {
        super(tableBasedClass);
        this.mIS = reader;
        this.mOS = charArrayWriter;
    }

    public Dataholder getProperty(int n, int n2, int n3, String string) throws CacheException {
        return null;
    }

    public void setProperty(int n, int n2, int n3, int n4, String string, Dataholder dataholder) throws CacheException {
    }

    public Object newJavaInstance() throws CacheException {
        return this.getIn();
    }

    public Object newJavaInstance(boolean bl) throws CacheException {
        return this.newJavaInstance();
    }

    public int save(boolean bl) throws CacheException {
        return 0;
    }

    public CacheReader getIn() throws CacheException {
        if (this.mIn == null) {
            this.mIn = new QuickCacheReader();
        }
        return this.mIn;
    }

    public CacheWriter getOut() throws CacheException {
        if (this.mOut == null) {
            this.mOut = new QuickCacheWriter();
        }
        return this.mOut;
    }

    protected Reader getInForSetting() throws CacheException {
        if (this.mOut == null) {
            return null;
        }
        return this.getIn();
    }

    class QuickCacheReader
    extends CacheReader {
        public QuickCacheReader() throws CacheException {
            super(null);
        }

        public synchronized String read(int n) throws IOException {
            char[] cArray = new char[n];
            this.check();
            int n2 = QuickReaderObject.this.mIS.read(cArray);
            if (n2 > 0) {
                return new String(cArray, 0, n2);
            }
            return "";
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            this.check();
            return QuickReaderObject.this.mIS.read(cArray, n, n2);
        }

        public boolean ready() throws IOException {
            this.check();
            return QuickReaderObject.this.mIS.ready();
        }

        public boolean markSupported() {
            if (QuickReaderObject.this.mIS == null) {
                return true;
            }
            return QuickReaderObject.this.mIS.markSupported();
        }

        public synchronized void reset() throws IOException {
            if (QuickReaderObject.this.mIS == null) {
                throw new IOException("Either nothing was marked or write occured afterwards");
            }
            QuickReaderObject.this.mIS.reset();
        }

        public synchronized void mark(int n) throws IOException {
            this.check();
            QuickReaderObject.this.mIS.mark(n);
        }

        public void close() {
            QuickReaderObject.this.mIS = null;
        }

        public void rewind() throws CacheException {
            throw new CacheException("Operation is not supported with Light connection");
        }

        public void seek(long l) throws IOException {
            throw new IOException("Operation is not supported with Light connection");
        }

        public synchronized long tell() {
            throw new RuntimeException("Operation is not supported with Light connection");
        }

        private void check() {
            if (QuickReaderObject.this.mIS == null) {
                QuickReaderObject.this.mIS = new CharArrayReader(QuickReaderObject.this.mOS.toCharArray());
            }
        }
    }

    class QuickCacheWriter
    extends CacheWriter {
        public QuickCacheWriter() throws CacheException {
            super(null);
        }

        public void rewind() throws CacheException {
            throw new CacheException("Operation is not supported by Light connection");
        }

        public void write(char[] cArray) throws IOException {
            QuickReaderObject.this.mOS.write(cArray);
            QuickReaderObject.this.mIS = null;
        }

        public void write(char[] cArray, int n, int n2) throws IOException {
            QuickReaderObject.this.mOS.write(cArray, n, n2);
            QuickReaderObject.this.mIS = null;
        }

        public void close() throws IOException {
        }

        public void flush() throws IOException {
            QuickReaderObject.this.mOS.flush();
        }
    }
}

