/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.metadata;

import com.intersys.cache.CacheObject;
import com.intersys.cache.SysDatabase;
import com.intersys.cache.metadata.CacheClassMetadataImpl;
import com.intersys.cache.metadata.JDBCCacheQuery;
import com.intersys.cache.metadata.JDBCColumn;
import com.intersys.cache.metadata.JavaClassController;
import com.intersys.classes.Compiler.LG.JavaClassDef;
import com.intersys.classes.Compiler.LG.JavaColumnDef;
import com.intersys.classes.Compiler.LG.MetaQueryDef;
import com.intersys.classes.Persistent;
import com.intersys.classes.SerialObject;
import com.intersys.objects.CacheException;
import com.intersys.objects.CandidateKey;
import com.intersys.objects.Database;
import com.intersys.objects.Id;
import com.intersys.objects.Oid;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheQueryDefinition;
import com.intersys.objects.reflect.CandidateKeyInfo;
import com.intersys.objects.reflect.SQLColumn;

public abstract class AbstractCacheClass
extends CacheClassMetadataImpl
implements CacheClass {
    protected static CacheClass SERIAL_CLASS = null;
    protected static CacheClass PERSISTENT_CLASS = null;
    private JavaClassController mController = null;

    public AbstractCacheClass(Database database, String string, boolean bl, boolean bl2) throws CacheException {
        super((SysDatabase)database, string, bl, bl2);
    }

    public AbstractCacheClass(JavaClassDef javaClassDef) throws CacheException {
        super(javaClassDef);
    }

    public AbstractCacheClass(CacheClassMetadataImpl cacheClassMetadataImpl) throws CacheException {
        super(cacheClassMetadataImpl);
    }

    private JavaClassController getController() {
        if (this.mController == null) {
            this.mController = new JavaClassController(this.getDatabase(), this);
        }
        return this.mController;
    }

    protected CacheQueryDefinition createQueryDef(MetaQueryDef metaQueryDef) throws CacheException {
        return new JDBCCacheQuery(this, metaQueryDef);
    }

    protected SQLColumn createColumn(JavaColumnDef javaColumnDef) throws CacheException {
        return new JDBCColumn(this.getSQLTableMetadata(), this, javaColumnDef);
    }

    protected static void checkPersistentClass(Database database) throws CacheException {
        if (PERSISTENT_CLASS == null) {
            PERSISTENT_CLASS = database.getCacheClass(Persistent.getCacheClassName());
        }
        if (SERIAL_CLASS == null) {
            SERIAL_CLASS = database.getCacheClass(SerialObject.getCacheClassName());
        }
    }

    public Class getJavaClass() throws CacheException {
        return this.getController().getJavaClass();
    }

    public Class getJavaClass(boolean bl) throws CacheException {
        return this.getController().getJavaClass(bl);
    }

    public void setJavaClass(String string, boolean bl) throws CacheException {
        this.getController().setJavaClass(string, bl);
    }

    public boolean isJavaClassSet() {
        return this.getController().isJavaClassSet();
    }

    public Object openObject(Id id) throws CacheException {
        return this.getController().openObject(id);
    }

    public Object openObject(Oid oid) throws CacheException {
        return this.getController().openObject(oid);
    }

    public void deleteObject(Id id) throws CacheException {
        this.getDatabase().deleteObject(this.getName(), id);
    }

    public CandidateKey createKey(String string) throws CacheException {
        CandidateKeyInfo candidateKeyInfo = this.getKeyInfo(string);
        if (candidateKeyInfo == null) {
            return null;
        }
        return new CandidateKey(candidateKeyInfo);
    }

    public CandidateKey createKey(String string, String string2) throws CacheException {
        CandidateKeyInfo candidateKeyInfo = this.getKeyInfo(string);
        if (candidateKeyInfo == null) {
            return null;
        }
        return new CandidateKey(candidateKeyInfo, string2);
    }

    public CandidateKey createBestCandidateKey() throws CacheException {
        CandidateKeyInfo candidateKeyInfo = this.getBestCandidateKey();
        if (candidateKeyInfo == null) {
            return null;
        }
        return new CandidateKey(candidateKeyInfo);
    }

    public CandidateKey createPrimaryKey(String string) throws CacheException {
        CandidateKeyInfo candidateKeyInfo = this.getSQLTableMetadata().getPrimaryKey();
        if (candidateKeyInfo == null) {
            return null;
        }
        return new CandidateKey(candidateKeyInfo, string);
    }

    public CandidateKey createPrimaryKey() throws CacheException {
        CandidateKeyInfo candidateKeyInfo = this.getSQLTableMetadata().getPrimaryKey();
        if (candidateKeyInfo == null) {
            return null;
        }
        return new CandidateKey(candidateKeyInfo);
    }

    public Object openByKey(CandidateKey candidateKey) throws CacheException {
        return this.getController().openByKey(candidateKey);
    }

    public Object openByPrimaryKey(String string) throws CacheException {
        return this.openByKey(this.createPrimaryKey(string));
    }

    public boolean deleteObjectByKey(CandidateKey candidateKey) throws CacheException {
        return this.getDatabase().deleteObject(this.getName(), candidateKey);
    }

    public boolean deleteObjectByPrimaryKey(String string) throws CacheException {
        CandidateKey candidateKey = this.createPrimaryKey(string);
        if (candidateKey == null) {
            throw new CacheException("No primary key is defined in class: " + this.getName());
        }
        return this.deleteObjectByKey(candidateKey);
    }

    public Object newInstance(String string) throws CacheException {
        return this.getController().newInstance(string);
    }

    public Object newInstance(CacheObject cacheObject) throws CacheException {
        return this.getController().newInstance(cacheObject);
    }

    public Object newInstance(CacheObject cacheObject, boolean bl) throws CacheException {
        return this.getController().newInstance(cacheObject, bl);
    }

    public Object createClientObject() throws CacheException {
        AbstractCacheClass abstractCacheClass = (AbstractCacheClass)this.getDatabase().getLightDatabase().getCacheClass(this.getName());
        abstractCacheClass.getJavaClass(true);
        CacheObject cacheObject = this.getDatabase().newClientObject(this.getName());
        return this.newInstance(cacheObject, true);
    }

    public boolean isVerified() {
        return this.getController().isVerified();
    }

    public void verifyClass() throws CacheException {
        this.getController().verifyClass();
    }
}

