/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache;

import com.intersys.cache.util.BackgroundStreamReceiver;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

public class JavaCompiler {
    public static boolean compile(String[] stringArray, String string, String string2, String string3) throws ClassNotFoundException {
        return JavaCompiler.compile(stringArray, string, string2, string3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compile(String[] stringArray, String string, String string2, String string3, PrintStream printStream) throws ClassNotFoundException {
        int n;
        String[] stringArray2 = new String[]{"-g", "-classpath", JavaCompiler.getClassPath() + File.pathSeparatorChar + string2, "-sourcepath", string, "-d", string3};
        String[] stringArray3 = new String[stringArray2.length + stringArray.length];
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray3[n] = stringArray2[n];
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray3[n] = stringArray[n2];
            ++n2;
            ++n;
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName("com.sun.tools.javac.Main");
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = null;
        }
        if (clazz != null) {
            Class<?> clazz2 = clazz;
            synchronized (clazz2) {
                return JavaCompiler.compileInternal(clazz, stringArray3, printStream);
            }
        }
        Runtime runtime = Runtime.getRuntime();
        synchronized (runtime) {
            return JavaCompiler.compileExternal(stringArray3, printStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean compileInternal(Class clazz, String[] stringArray, PrintStream printStream) throws ClassNotFoundException {
        ByteArrayOutputStream byteArrayOutputStream = null;
        if (printStream == null) {
            byteArrayOutputStream = new ByteArrayOutputStream();
            printStream = new PrintStream(byteArrayOutputStream, true);
        }
        PrintStream printStream2 = System.out;
        PrintStream printStream3 = System.err;
        System.setOut(printStream);
        System.setErr(printStream);
        try {
            Object object;
            int n = -1;
            String string = stringArray[stringArray.length - 1];
            try {
                object = clazz.newInstance();
                Class[] classArray = new Class[]{new String[0].getClass()};
                Method method = clazz.getMethod("compile", classArray);
                n = (Integer)method.invoke(object, new Object[]{stringArray});
            }
            catch (Exception exception) {
                throw new ClassNotFoundException("Failed to compile file " + string, exception);
            }
            if (n != 0) {
                object = "javac ";
                for (int i = 0; i < stringArray.length; ++i) {
                    object = object + stringArray[i] + " ";
                }
                String string2 = "Errors compiling " + string + ": " + object;
                if (byteArrayOutputStream != null) {
                    string2 = string2 + byteArrayOutputStream.toString();
                }
                throw new ClassNotFoundException(string2);
            }
            boolean bl = n == 0;
            return bl;
        }
        finally {
            System.setOut(printStream2);
            System.setErr(printStream3);
        }
    }

    private static boolean compileExternal(String[] stringArray, PrintStream printStream) throws ClassNotFoundException {
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = "javac";
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i + 1] = stringArray[i];
        }
        String string = stringArray[stringArray.length - 1];
        try {
            Process process = Runtime.getRuntime().exec(stringArray2);
            BackgroundStreamReceiver backgroundStreamReceiver = new BackgroundStreamReceiver(process.getInputStream(), printStream, "Compilation Output", 1, false);
            BackgroundStreamReceiver backgroundStreamReceiver2 = new BackgroundStreamReceiver(process.getErrorStream(), printStream, "Compilation Errors", 1, false);
            backgroundStreamReceiver.start();
            backgroundStreamReceiver2.start();
            Thread thread = Thread.currentThread();
            int n = thread.getPriority();
            thread.setPriority(1);
            while (backgroundStreamReceiver.isAlive() || backgroundStreamReceiver2.isAlive()) {
                try {
                    backgroundStreamReceiver.checkException();
                    backgroundStreamReceiver2.checkException();
                }
                catch (Exception exception) {
                    process.destroy();
                    throw exception;
                }
            }
            int n2 = process.waitFor();
            thread.setPriority(n);
            backgroundStreamReceiver.join();
            backgroundStreamReceiver2.join();
            backgroundStreamReceiver.checkException();
            backgroundStreamReceiver2.checkException();
            if (n2 != 0) {
                String string2 = "";
                for (int i = 0; i < stringArray2.length; ++i) {
                    string2 = string2 + stringArray2[i] + " ";
                }
                throw new ClassNotFoundException("Errors compiling " + string + ": " + string2 + "\n" + backgroundStreamReceiver.getResult() + "; " + backgroundStreamReceiver2.getResult());
            }
            return n2 == 0;
        }
        catch (Exception exception) {
            if (exception instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)exception;
            }
            if (printStream != null) {
                exception.printStackTrace(printStream);
            }
            throw new ClassNotFoundException("Failed to compile file " + string, exception);
        }
    }

    private static String getClassPath() {
        ClassLoader classLoader = JavaCompiler.class.getClassLoader();
        if (!(classLoader instanceof URLClassLoader)) {
            return System.getProperty("java.class.path");
        }
        URLClassLoader uRLClassLoader = (URLClassLoader)classLoader;
        URL[] uRLArray = uRLClassLoader.getURLs();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < uRLArray.length; ++i) {
            stringBuffer.append(uRLArray[i].getFile());
            if (i >= uRLArray.length - 1) continue;
            stringBuffer.append(File.pathSeparator);
        }
        return stringBuffer.toString();
    }
}

