/*
 * Decompiled with CFR 0.152.
 */
package com.eg.agent.visitor;

import com.eg.agent.EgClassFileTransformer;
import com.eg.agent.adapter.EgPojoMethodAdviceAdapter;
import com.eg.agent.adapter.EgServletMethodAdviceAdapter;
import com.eg.agent.matcher.HttpServletMethodMatcher;
import com.eg.jtm.PropsManager;
import com.eg.org.objectweb.asm.ClassVisitor;
import com.eg.org.objectweb.asm.MethodVisitor;

public class EgServletClassVisitor
extends ClassVisitor {
    private String className;
    private boolean isExcludePojoClass;
    private int classFileVersion;

    public EgServletClassVisitor(ClassVisitor classVisitor, String className, ClassLoader loader, int classFileVersion) {
        super(327680, classVisitor);
        this.className = className;
        this.classFileVersion = classFileVersion;
        this.isExcludePojoClass = EgClassFileTransformer.isClassPresentExcludePojo(className);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        if ((access & 0x100) != 0 || (access & 0x400) != 0) {
            return mv;
        }
        if (name.equals("<clinit>") || name.equals("<init>") || name.equals("init")) {
            return mv;
        }
        if (mv != null && !this.className.startsWith("org/apache/catalina/servlets/") && !this.className.startsWith("org/apache/jasper/servlet/JspServlet")) {
            HttpServletMethodMatcher httpServletMethodMatcher = new HttpServletMethodMatcher(this.className, name, desc);
            boolean doMethodMatch = httpServletMethodMatcher.isHttpServletMatch();
            if (doMethodMatch) {
                mv = new EgServletMethodAdviceAdapter(access, mv, name, desc, this.className, "HTTPSERVLET", this.classFileVersion);
            } else if (PropsManager.isPojoTrack()) {
                boolean isProceed = true;
                if (this.isExcludePojoClass || name.indexOf("$") > 0) {
                    isProceed = false;
                }
                if (isProceed) {
                    mv = new EgPojoMethodAdviceAdapter(access, mv, name, desc, this.className, this.classFileVersion);
                }
            }
        }
        return mv;
    }
}

