/*
 * Decompiled with CFR 0.152.
 */
package com.eg.agent.trace;

import com.eg.agent.trace.utils.TraceUtils;
import com.eg.jtm.JTMLog;
import com.eg.jtm.JTMPojoBoolean;
import com.eg.jtm.JTMSqlBoolean;
import com.eg.jtm.JTMUtils;
import com.eg.jtm.MethodEventProcessor;
import com.eg.jtm.MethodInfo;
import com.eg.jtm.PropsManager;
import com.eg.jtm.RequestIdentifier;
import com.eg.jtm.UPDManager;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;

public class RootTracer {
    private static final String INS_2_JTM_TBLS = "INSERT INTO JavaTransactionsTest";
    private static final int INS_2_JTM_LEN = "INSERT INTO JavaTransactionsTest".length();
    private static Hashtable statmentTable = new Hashtable();
    public static ThreadLocal<JTMPojoBoolean> pojoBlockLocal = new ThreadLocal();
    public static ThreadLocal<JTMSqlBoolean> sqlBlockLocal = new ThreadLocal();

    private static HashMap getRequestMap(Object requestObj, RequestIdentifier reqId) {
        HashMap reqPropsMap = new HashMap();
        if (reqId == null) {
            reqPropsMap = TraceUtils.requestDetails(requestObj);
        }
        return reqPropsMap;
    }

    public static boolean doFilterMethodBegin(Object servletReqObj, String className, String methodName, String desc) {
        if (!PropsManager.TalkingToAgent) {
            return false;
        }
        RequestIdentifier reqId = MethodEventProcessor.getRequestIdentifier();
        HashMap reqPropsMap = RootTracer.getRequestMap(servletReqObj, reqId);
        List urlPatternsMatched = null;
        if (reqPropsMap != null && reqPropsMap.containsKey("MATCH")) {
            urlPatternsMatched = (List)reqPropsMap.remove("MATCH");
        }
        String callType = "FILTER";
        return MethodEventProcessor.eventStarted(reqId, reqPropsMap, callType, className, methodName, desc, JTMUtils.getTimeStamp(), urlPatternsMatched);
    }

    public static void doFilterMethodEnd(String className, String methodName, String desc, boolean beginFlag, int code) {
        if (!beginFlag) {
            return;
        }
        RequestIdentifier reqId = MethodEventProcessor.getRequestIdentifier();
        if (reqId == null) {
            return;
        }
        if (code == 191) {
            MethodEventProcessor.eventEnded(reqId, true, true, JTMUtils.getTimeStamp());
        } else {
            MethodEventProcessor.eventEnded(reqId, true, false, JTMUtils.getTimeStamp());
        }
    }

    public static boolean structsDoMethodBegin(Object requestObj, String className, String methodName, String desc) {
        if (!PropsManager.TalkingToAgent) {
            return false;
        }
        RequestIdentifier reqId = MethodEventProcessor.getRequestIdentifier();
        HashMap reqPropsMap = RootTracer.getRequestMap(requestObj, reqId);
        List urlPatternsMatched = null;
        if (reqPropsMap != null && reqPropsMap.containsKey("MATCH")) {
            urlPatternsMatched = (List)reqPropsMap.remove("MATCH");
        }
        return MethodEventProcessor.eventStarted(reqId, reqPropsMap, "STRUTS", className, methodName, desc, JTMUtils.getTimeStamp(), urlPatternsMatched);
    }

    public static void structsDoMethodEnd(String className, String methodName, String desc, boolean beginFlag, int code) {
        if (!beginFlag) {
            return;
        }
        RequestIdentifier reqId = MethodEventProcessor.getRequestIdentifier();
        if (reqId == null) {
            return;
        }
        if (code == 191) {
            MethodEventProcessor.eventEnded(reqId, true, true, JTMUtils.getTimeStamp());
        } else {
            MethodEventProcessor.eventEnded(reqId, true, false, JTMUtils.getTimeStamp());
        }
    }

    public static boolean httpServletDoMethodBegin(Object requestObj, String className, String methodName, String desc) {
        if (!PropsManager.TalkingToAgent) {
            return false;
        }
        RequestIdentifier reqId = MethodEventProcessor.getRequestIdentifier();
        HashMap reqPropsMap = RootTracer.getRequestMap(requestObj, reqId);
        List urlPatternsMatched = null;
        if (reqPropsMap != null && reqPropsMap.containsKey("MATCH")) {
            urlPatternsMatched = (List)reqPropsMap.remove("MATCH");
        }
        return MethodEventProcessor.eventStarted(reqId, reqPropsMap, "HTTPSERVLET", className, methodName, desc, JTMUtils.getTimeStamp(), urlPatternsMatched);
    }

    public static void httpServletDoMethodEnd(String className, String methodName, String desc, boolean beginFlag, int code) {
        if (!beginFlag) {
            return;
        }
        RequestIdentifier reqId = MethodEventProcessor.getRequestIdentifier();
        if (reqId == null) {
            return;
        }
        if (code == 191) {
            MethodEventProcessor.eventEnded(reqId, true, true, JTMUtils.getTimeStamp());
        } else {
            MethodEventProcessor.eventEnded(reqId, true, false, JTMUtils.getTimeStamp());
        }
    }

    public static boolean mailMethodBegin(Object transportObj, String className, String methodName, String desc) {
        RequestIdentifier reqId = MethodEventProcessor.getRequestIdentifier();
        if (reqId == null || reqId.isPointcutLimitReached()) {
            return false;
        }
        return MethodEventProcessor.eventStarted(reqId, null, "EMAIL", className, methodName, desc, JTMUtils.getTimeStamp(), null);
    }

    public static void mailMethodEnd(String className, String methodName, String desc, boolean beginFlag, int code) {
        if (beginFlag) {
            RequestIdentifier reqId = MethodEventProcessor.getRequestIdentifier();
            if (code == 191) {
                MethodEventProcessor.eventEnded(reqId, false, true, JTMUtils.getTimeStamp());
            } else {
                MethodEventProcessor.eventEnded(reqId, false, false, JTMUtils.getTimeStamp());
            }
        }
    }

    public static boolean pojoMethodBegin(String className, String methodName, String desc) {
        JTMPojoBoolean flag = pojoBlockLocal.get();
        if (flag == null || flag.isPojoFlag()) {
            return false;
        }
        RequestIdentifier reqId = MethodEventProcessor.getRequestIdentifier();
        if (reqId != null) {
            return reqId.onMethodStart(className, methodName, desc, JTMUtils.getTimeStamp(), null, "POJO", null, false);
        }
        pojoBlockLocal.set(null);
        return false;
    }

    public static void pojoMethodEnd(String className, String methodName, String desc, boolean beginFlag, int code) {
        if (beginFlag) {
            RequestIdentifier reqId = MethodEventProcessor.getRequestIdentifier();
            if (code == 191) {
                MethodEventProcessor.eventEnded(reqId, false, true, JTMUtils.getTimeStamp());
            } else {
                MethodEventProcessor.pojoEventEnded(reqId, false, false, JTMUtils.getTimeStamp());
            }
        }
    }

    public static boolean jspServiceMethodBegin(Object requestObj, String className, String methodName, String desc) {
        if (!PropsManager.TalkingToAgent) {
            return false;
        }
        RequestIdentifier reqId = MethodEventProcessor.getRequestIdentifier();
        HashMap reqPropsMap = RootTracer.getRequestMap(requestObj, reqId);
        List urlPatternsMatched = null;
        if (reqPropsMap != null && reqPropsMap.containsKey("MATCH")) {
            urlPatternsMatched = (List)reqPropsMap.remove("MATCH");
        }
        return MethodEventProcessor.eventStarted(reqId, reqPropsMap, "JSP", className, methodName, desc, JTMUtils.getTimeStamp(), urlPatternsMatched);
    }

    public static void jspServiceMethodEnd(String className, String methodName, String desc, boolean beginFlag, int code) {
        if (!beginFlag) {
            return;
        }
        RequestIdentifier reqId = MethodEventProcessor.getRequestIdentifier();
        if (reqId == null) {
            return;
        }
        if (code == 191) {
            MethodEventProcessor.eventEnded(reqId, true, true, JTMUtils.getTimeStamp());
        } else {
            MethodEventProcessor.eventEnded(reqId, true, false, JTMUtils.getTimeStamp());
        }
    }

    public static boolean jdbcConnectionMethodBegin(String className, String methodName, String desc) {
        RequestIdentifier reqId = MethodEventProcessor.getRequestIdentifier();
        if (reqId == null || reqId.isPointcutLimitReached()) {
            return false;
        }
        return MethodEventProcessor.eventStarted(reqId, null, "JDBC", className, methodName, desc, JTMUtils.getTimeStamp(), null);
    }

    public static void jdbcConnectionMethodEnd(String className, String methodName, String desc, boolean beginFlag, int code) {
        if (beginFlag) {
            RequestIdentifier reqId = MethodEventProcessor.getRequestIdentifier();
            if (code == 191) {
                MethodEventProcessor.eventEnded(reqId, false, true, JTMUtils.getTimeStamp());
            } else {
                MethodEventProcessor.eventEnded(reqId, false, false, JTMUtils.getTimeStamp());
            }
        }
    }

    public static boolean jdbcPrepareCallPreparedStatmentMethodBegin(String className, String methodName, String desc) {
        RequestIdentifier reqId = MethodEventProcessor.getRequestIdentifier();
        if (reqId == null || reqId.isPointcutLimitReached()) {
            return false;
        }
        return MethodEventProcessor.eventStarted(reqId, null, "JDBC", className, methodName, desc, JTMUtils.getTimeStamp(), null);
    }

    public static void jdbcPrepareCallPreparedStatmentMethodEnd(Object callOrPrepareStmtObj, String sqlQueryString, String className, String methodName, String desc, boolean beginFlag, int code) {
        if (beginFlag) {
            RequestIdentifier reqId = MethodEventProcessor.getRequestIdentifier();
            if (callOrPrepareStmtObj != null && sqlQueryString != null) {
                statmentTable.put(callOrPrepareStmtObj, sqlQueryString);
            }
            if (code == 191) {
                MethodEventProcessor.eventEnded(reqId, false, true, JTMUtils.getTimeStamp());
            } else {
                MethodEventProcessor.eventEnded(reqId, false, false, JTMUtils.getTimeStamp());
            }
        }
    }

    public static boolean jdbcCommitCloseRollbackMethodBegin(String className, String methodName, String desc) {
        RequestIdentifier reqId = MethodEventProcessor.getRequestIdentifier();
        if (reqId == null || reqId.isPointcutLimitReached()) {
            return false;
        }
        return MethodEventProcessor.eventStarted(reqId, null, "JDBC", className, methodName, desc, JTMUtils.getTimeStamp(), null);
    }

    public static void jdbcCommitCloseRollbackMethodEnd(String className, String methodName, String desc, boolean beginFlag, int code) {
        if (beginFlag) {
            RequestIdentifier reqId = MethodEventProcessor.getRequestIdentifier();
            if (code == 191) {
                MethodEventProcessor.eventEnded(reqId, false, true, JTMUtils.getTimeStamp());
            } else {
                MethodEventProcessor.eventEnded(reqId, false, false, JTMUtils.getTimeStamp());
            }
        }
    }

    public static boolean jdbcStatmentMethodBegin(Object stmtObj, String className, String methodName, String desc) {
        RequestIdentifier reqId;
        if (stmtObj != null && methodName.equals("close") && desc.equals("()V") && statmentTable != null && statmentTable.size() > 0) {
            statmentTable.remove(stmtObj);
        }
        if ((reqId = MethodEventProcessor.getRequestIdentifier()) == null || reqId.isPointcutLimitReached()) {
            return false;
        }
        return MethodEventProcessor.eventStarted(reqId, null, "JDBC", className, methodName, desc, JTMUtils.getTimeStamp(), null);
    }

    public static void jdbcStatmentMethodEnd(String className, String methodName, String desc, boolean beginFlag, int code) {
        if (beginFlag) {
            RequestIdentifier reqId = MethodEventProcessor.getRequestIdentifier();
            if (code == 191) {
                MethodEventProcessor.eventEnded(reqId, false, true, JTMUtils.getTimeStamp());
            } else {
                MethodEventProcessor.eventEnded(reqId, false, false, JTMUtils.getTimeStamp());
            }
        }
    }

    public static boolean jtdsStatmentMethodBegin(Object StmtObj, String sqlQryString, String className, String methodName, String desc) {
        RequestIdentifier requestIdentifier;
        String jdbcUrl;
        block6: {
            JTMSqlBoolean flag = sqlBlockLocal.get();
            if (flag == null || flag.isSqlFlag()) {
                return false;
            }
            boolean isStatmentObj = StmtObj instanceof Statement;
            jdbcUrl = "-";
            if (isStatmentObj) {
                try {
                    Connection conObj = ((Statement)StmtObj).getConnection();
                    DatabaseMetaData dbMetaData = conObj.getMetaData();
                    jdbcUrl = dbMetaData.getURL();
                }
                catch (Exception e) {
                    if (!PropsManager.jtmDebugEnabled) break block6;
                    JTMLog.debugLogger.error("EXCEPTION - [jtdsStatmentMethodBegin]", e);
                }
            }
        }
        if ((requestIdentifier = MethodEventProcessor.getRequestIdentifier()) != null) {
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("sqlStmt", JTMUtils.prepQryForUI(sqlQryString));
            props.put("jdbcUrl", jdbcUrl);
            if (sqlQryString.length() > INS_2_JTM_LEN && INS_2_JTM_TBLS.equalsIgnoreCase(sqlQryString.substring(0, INS_2_JTM_LEN))) {
                props.put("sqlStmt", "JavaTransactionsTest");
                long timeStamp = JTMUtils.getTimeStamp();
                return MethodEventProcessor.eventStarted(requestIdentifier, props, "SQL", className, methodName, desc, timeStamp, null);
            }
            long timeStamp = JTMUtils.getTimeStamp();
            return MethodEventProcessor.eventStarted(requestIdentifier, props, "SQL", className, methodName, desc, timeStamp, null);
        }
        sqlBlockLocal.set(null);
        return false;
    }

    public static void jtdsStatmentMethodEnd(String className, String methodName, String desc, boolean beginFlag, int code) {
        if (beginFlag) {
            RequestIdentifier reqId = MethodEventProcessor.getRequestIdentifier();
            if (code == 191) {
                MethodEventProcessor.eventEnded(reqId, false, true, JTMUtils.getTimeStamp());
            } else {
                MethodEventProcessor.eventEnded(reqId, false, false, JTMUtils.getTimeStamp());
            }
        }
    }

    public static boolean jtdsCallableOrPreparedStatmentMethodBegin(Object callOrPrepareStmtObj, String className, String methodName, String desc) {
        JTMSqlBoolean flag = sqlBlockLocal.get();
        if (flag == null || flag.isSqlFlag()) {
            return false;
        }
        RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
        if (requestIdentifier != null) {
            String jdbcUrl;
            String sqlQueryString;
            block7: {
                sqlQueryString = "-";
                if (callOrPrepareStmtObj != null && statmentTable.containsKey(callOrPrepareStmtObj)) {
                    sqlQueryString = (String)statmentTable.get(callOrPrepareStmtObj);
                }
                if (sqlQueryString.equals("-")) {
                    return false;
                }
                boolean isStatmentObj = callOrPrepareStmtObj instanceof Statement;
                jdbcUrl = "-";
                if (isStatmentObj) {
                    try {
                        Connection conObj = ((Statement)callOrPrepareStmtObj).getConnection();
                        DatabaseMetaData dbMetaData = conObj.getMetaData();
                        jdbcUrl = dbMetaData.getURL();
                    }
                    catch (Exception e) {
                        if (!PropsManager.jtmDebugEnabled) break block7;
                        JTMLog.debugLogger.error("EXCEPTION - [jtdsCallableOrPreparedStatmentMethodBegin]", e);
                    }
                }
            }
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("sqlStmt", JTMUtils.prepQryForUI(sqlQueryString));
            props.put("jdbcUrl", jdbcUrl);
            long timeStamp = JTMUtils.getTimeStamp();
            return MethodEventProcessor.eventStarted(requestIdentifier, props, "SQL", className, methodName, desc, timeStamp, null);
        }
        sqlBlockLocal.set(null);
        return false;
    }

    public static void jtdsCallableOrPreparedStatmentMethodEnd(String className, String methodName, String desc, boolean beginFlag, int code) {
        if (beginFlag) {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (code == 191) {
                MethodEventProcessor.eventEnded(requestIdentifier, false, true, JTMUtils.getTimeStamp());
            } else {
                MethodEventProcessor.eventEnded(requestIdentifier, false, false, JTMUtils.getTimeStamp());
            }
        }
    }

    public static boolean sqlStatmentMethodBegin(Object object, String queryString, String className, String methodName, String desc) {
        JTMSqlBoolean flag = sqlBlockLocal.get();
        if (flag == null || flag.isSqlFlag()) {
            return false;
        }
        RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
        if (requestIdentifier != null) {
            String jdbcUrl;
            block6: {
                boolean isStatmentObj = object instanceof Statement;
                jdbcUrl = "-";
                if (isStatmentObj) {
                    try {
                        Connection conObj = ((Statement)object).getConnection();
                        DatabaseMetaData dbMetaData = conObj.getMetaData();
                        jdbcUrl = dbMetaData.getURL();
                    }
                    catch (Exception e) {
                        if (!PropsManager.jtmDebugEnabled) break block6;
                        JTMLog.debugLogger.error("EXCEPTION - [jtdsStatmentMethodBegin]", e);
                    }
                }
            }
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("sqlStmt", JTMUtils.prepQryForUI(queryString));
            props.put("jdbcUrl", jdbcUrl);
            if (queryString.length() > INS_2_JTM_LEN && INS_2_JTM_TBLS.equalsIgnoreCase(queryString.substring(0, INS_2_JTM_LEN))) {
                props.put("sqlStmt", "JavaTransactionsTest");
                long timeStamp = JTMUtils.getTimeStamp();
                return MethodEventProcessor.eventStarted(requestIdentifier, props, "SQL", className, methodName, desc, timeStamp, null);
            }
            long timeStamp = JTMUtils.getTimeStamp();
            return MethodEventProcessor.eventStarted(requestIdentifier, props, "SQL", className, methodName, desc, timeStamp, null);
        }
        sqlBlockLocal.set(null);
        return false;
    }

    public static void sqlStatmentMethodEnd(Object object, String queryString, String className, String methodName, String desc, boolean beginFlag, int code) {
        if (beginFlag) {
            RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
            if (code == 191) {
                MethodEventProcessor.eventEnded(requestIdentifier, false, true, JTMUtils.getTimeStamp());
            } else {
                MethodEventProcessor.eventEnded(requestIdentifier, false, false, JTMUtils.getTimeStamp());
            }
        }
    }

    public static final boolean soapWebServiceMethodBegin(Object soapMsgObject, Object urlObject, String className, String methodName, String desc) {
        RequestIdentifier reqId = MethodEventProcessor.getRequestIdentifier();
        if (reqId == null || reqId.isPointcutLimitReached()) {
            return false;
        }
        HashMap props = TraceUtils.getSOAPCallInfo(soapMsgObject, urlObject);
        return MethodEventProcessor.eventStarted(reqId, props, "WEBSERVICE", className, methodName, desc, JTMUtils.getTimeStamp(), null);
    }

    public static final void soapWebServiceMethodEnd(String className, String methodName, String desc, boolean beginFlag, int code) {
        if (beginFlag) {
            RequestIdentifier reqId = MethodEventProcessor.getRequestIdentifier();
            if (code == 191) {
                MethodEventProcessor.eventEnded(reqId, false, true, JTMUtils.getTimeStamp());
            } else {
                MethodEventProcessor.eventEnded(reqId, false, false, JTMUtils.getTimeStamp());
            }
        }
    }

    public static final boolean axisWebServiceMethodBegin(Object object, String className, String methodName, String desc) {
        RequestIdentifier reqId = MethodEventProcessor.getRequestIdentifier();
        if (reqId == null || reqId.isPointcutLimitReached()) {
            return false;
        }
        HashMap props = TraceUtils.getAxisCallInfo(object);
        return MethodEventProcessor.eventStarted(reqId, props, "WEBSERVICE", className, methodName, desc, JTMUtils.getTimeStamp(), null);
    }

    public static final void axisWebServiceMethodEnd(String className, String methodName, String desc, boolean beginFlag, int code) {
        if (beginFlag) {
            RequestIdentifier reqId = MethodEventProcessor.getRequestIdentifier();
            if (code == 191) {
                MethodEventProcessor.eventEnded(reqId, false, true, JTMUtils.getTimeStamp());
            } else {
                MethodEventProcessor.eventEnded(reqId, false, false, JTMUtils.getTimeStamp());
            }
        }
    }

    public static final boolean httpUrlConnMethodBegin(Object httpUrlConnObj, String className, String methodName, String desc) {
        RequestIdentifier reqId = MethodEventProcessor.getRequestIdentifier();
        if (reqId == null || reqId.isPointcutLimitReached()) {
            return false;
        }
        HashMap props = TraceUtils.getHttpCallInfo(httpUrlConnObj);
        return MethodEventProcessor.eventStarted(reqId, props, "HTTP", className, methodName, desc, JTMUtils.getTimeStamp(), null);
    }

    public static final void httpUrlConnMethodEnd(String className, String methodName, String desc, boolean beginFlag, int code) {
        if (beginFlag) {
            RequestIdentifier reqId = MethodEventProcessor.getRequestIdentifier();
            if (code == 191) {
                MethodEventProcessor.eventEnded(reqId, false, true, JTMUtils.getTimeStamp());
            } else {
                MethodEventProcessor.eventEnded(reqId, false, false, JTMUtils.getTimeStamp());
            }
        }
    }

    public static final void recordPOJOException(Object pojoExpObject, String className, String methodName, String desc, boolean beginFlag) {
        MethodInfo currentMInfo;
        Throwable pojoExceptionObject;
        if (!beginFlag) {
            return;
        }
        RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
        if (requestIdentifier == null) {
            return;
        }
        boolean isException = pojoExpObject instanceof Throwable;
        if (isException && RootTracer.isFirstPOJOThrown(pojoExceptionObject = (Throwable)pojoExpObject, requestIdentifier) && (currentMInfo = requestIdentifier.getCurrentMinfo()) != null) {
            RootTracer.registerPOJOException(pojoExceptionObject, currentMInfo, requestIdentifier);
            currentMInfo.setDontRemove(true);
        }
    }

    public static final void recordEntryPointException(Object entryPointExceptionObject, String className, String methodName, String desc, boolean beginFlag) {
        Throwable entryPointExpObject;
        if (!beginFlag) {
            return;
        }
        RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
        if (requestIdentifier == null) {
            return;
        }
        if (PropsManager.isExceptionMatchedIgnoreExceptionList(entryPointExceptionObject.getClass().getName())) {
            MethodInfo currentInfo = requestIdentifier.getCurrentMinfo();
            String ignoredExpclass = entryPointExceptionObject.getClass().getName();
            currentInfo.setIgnoredException(ignoredExpclass);
            return;
        }
        MethodInfo currentMInfo = requestIdentifier.getCurrentMinfo();
        if (!currentMInfo.isStartComponent()) {
            RootTracer.recordPOJOException(entryPointExceptionObject, className, methodName, desc, beginFlag);
            return;
        }
        boolean isException = entryPointExceptionObject instanceof Throwable;
        if (isException && RootTracer.isFirstEntryAndSqlThrown(entryPointExpObject = (Throwable)entryPointExceptionObject, requestIdentifier)) {
            MethodInfo exceptionMethodInfo = null;
            Throwable causeObj = entryPointExpObject.getCause();
            if (causeObj == null) {
                causeObj = entryPointExpObject;
            }
            exceptionMethodInfo = requestIdentifier.getObjectFromPOJOExceptionTracker(causeObj);
            HashMap<String, String> exceptionProperties = new HashMap<String, String>();
            if (exceptionMethodInfo != null) {
                MethodInfo expInfoParent;
                exceptionProperties.put("EXCEPTION", TraceUtils.partialSTEs2Str(causeObj, PropsManager.getMaxExceptionLineCount()));
                exceptionMethodInfo.setType("EXCEPTION");
                exceptionMethodInfo.setProperties(exceptionProperties);
                double exeTime = exceptionMethodInfo.getExecutionTime();
                if (!(!(exeTime <= UPDManager.getMethExecCutOff()) || currentMInfo.equals(exceptionMethodInfo) || (expInfoParent = exceptionMethodInfo.getParent()) != null && currentMInfo.equals(expInfoParent))) {
                    exceptionMethodInfo.getChildMinfos().clear();
                    exceptionMethodInfo.setExecutionTime();
                    currentMInfo.getChildMinfos().add(exceptionMethodInfo);
                    requestIdentifier.removeObjectFromPOJOExceptionTracker(causeObj);
                }
            } else {
                RootTracer.recordEntryandSqlException(entryPointExpObject, className, methodName, desc, requestIdentifier);
            }
        }
    }

    public static final void recordSQLException(Object sqlExceptionObject, String className, String methodName, String desc, boolean beginFlag) {
        Throwable sqlExpObject;
        if (!beginFlag) {
            return;
        }
        RequestIdentifier requestIdentifier = MethodEventProcessor.getRequestIdentifier();
        if (requestIdentifier == null) {
            return;
        }
        if (PropsManager.isExceptionMatchedIgnoreExceptionList(sqlExceptionObject.getClass().getName())) {
            MethodInfo currentInfo = requestIdentifier.getCurrentMinfo();
            String ignoredExpclass = sqlExceptionObject.getClass().getName();
            currentInfo.setIgnoredException(ignoredExpclass);
            return;
        }
        boolean isExceptionObj = sqlExceptionObject instanceof Throwable;
        if (isExceptionObj && RootTracer.isFirstEntryAndSqlThrown(sqlExpObject = (Throwable)sqlExceptionObject, requestIdentifier)) {
            MethodInfo currentMInfo = requestIdentifier.getCurrentMinfo();
            MethodInfo rootMInfo = requestIdentifier.getRootMinfo();
            RootTracer.recordEntryandSqlException(sqlExpObject, className, methodName, desc, requestIdentifier);
            ArrayList<Object> aList = new ArrayList<Object>();
            aList.add(currentMInfo);
            aList.add(sqlExceptionObject);
            requestIdentifier.addObjectToCutOffMethodTracker(rootMInfo, aList);
        }
    }

    private static void recordEntryandSqlException(Throwable entryAndSqlException, String className, String methodName, String desc, RequestIdentifier requestIdentifier) {
        if (requestIdentifier == null || requestIdentifier.isPointcutLimitReached()) {
            return;
        }
        RootTracer.registerEntryAndSqlException(entryAndSqlException, requestIdentifier);
        HashMap<String, String> excpnProps = new HashMap<String, String>();
        excpnProps.put("EXCEPTION", TraceUtils.partialSTEs2Str(entryAndSqlException, PropsManager.getMaxExceptionLineCount()));
        long startTime = JTMUtils.getTimeStamp();
        boolean result = MethodEventProcessor.eventStarted(requestIdentifier, excpnProps, "EXCEPTION", className, methodName, desc, startTime, null);
        if (result) {
            MethodEventProcessor.eventEnded(false, startTime);
        }
    }

    private static boolean isFirstPOJOThrown(Object t, RequestIdentifier requestIdentifier) {
        return requestIdentifier.getObjectFromPOJOExceptionTracker(t) == null;
    }

    private static void registerPOJOException(Object t, MethodInfo exceptionMethodInfo, RequestIdentifier requestIdentifier) {
        requestIdentifier.addObjectToPOJOExceptionTracker(t, exceptionMethodInfo);
    }

    private static boolean isFirstEntryAndSqlThrown(Object t, RequestIdentifier requestIdentifier) {
        return requestIdentifier.getObjectFromEntryAndSQLTracker(t) == null;
    }

    private static void registerEntryAndSqlException(Object t, RequestIdentifier requestIdentifier) {
        requestIdentifier.addObjectToEntryAndSQLTracker(t);
    }
}

