/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.agent.trace.RootTracer;
import com.eg.jtm.EgScheduledThreadPoolExecutor;
import com.eg.jtm.JTMLog;
import com.eg.jtm.JTMPojoBoolean;
import com.eg.jtm.JTMSqlBoolean;
import com.eg.jtm.LongRunningTrackerThread;
import com.eg.jtm.MethodEventProcessor;
import com.eg.jtm.MethodInfo;
import com.eg.jtm.PropsManager;
import com.eg.jtm.UPDManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class RequestIdentifier {
    private MethodInfo rootMinfo = null;
    private MethodInfo currentMinfo = null;
    private int pojoInvokeCount = 0;
    private int sqlInvokeCount = 0;
    private int otherPointcutCount = 0;
    private long reqStartTime = -1L;
    private boolean isTracking = false;
    private static long maxAliveTime = 60000L;
    private LongRunningTrackerThread trackerThread = null;
    private ScheduledFuture<?> scheduledFuture = null;
    private boolean isPointcutLimitReached = false;
    private int recursiveCount = 0;
    private HashMap<Object, Integer> entryAndSQLtrackerMap = new HashMap();
    private HashMap<Object, MethodInfo> POJOExceptionTracker = new HashMap();
    private HashMap<MethodInfo, ArrayList> cutOffMethodTracker = new HashMap();
    private static final Integer dummyIntVal = new Integer(1);
    private String reqGUID = null;

    public RequestIdentifier(MethodInfo Minfo) {
        this.rootMinfo = Minfo;
        this.setCurrentMinfo(Minfo);
        UUID thisUid = UUID.randomUUID();
        this.reqGUID = thisUid.toString();
    }

    public MethodInfo getRootMinfo() {
        return (MethodInfo)this.rootMinfo.getChildMinfos().get(0);
    }

    public MethodInfo getCurrentMinfo() {
        return this.currentMinfo;
    }

    private void setCurrentMinfo(MethodInfo currMinfo) {
        this.currentMinfo = currMinfo;
    }

    public boolean onMethodStart(String className, String methodName, String desc, long timeStamp, Map reqProps, String compType, List urlPatternsMatched, boolean isRootMethodInfo) {
        MethodInfo Minfo;
        boolean result;
        block20: {
            result = false;
            Minfo = null;
            if (isRootMethodInfo) {
                Minfo = new MethodInfo(className, methodName, desc, this.currentMinfo, urlPatternsMatched);
                this.reqStartTime = timeStamp;
            } else {
                Minfo = new MethodInfo(className, methodName, desc, this.currentMinfo);
                long diffTime = timeStamp - this.reqStartTime;
                if (diffTime >= PropsManager.getMaxTracePeriod()) {
                    RootTracer.pojoBlockLocal.remove();
                    RootTracer.pojoBlockLocal.set(null);
                    if (!this.isTracking) {
                        this.isTracking = true;
                        this.doTraceLongRunningRequest();
                    }
                }
                if (compType.equals("POJO")) {
                    ++this.pojoInvokeCount;
                    Minfo.setLineNo(this.pojoInvokeCount);
                    if (this.pojoInvokeCount >= PropsManager.getMaxPOJOTraceMethods()) {
                        RootTracer.pojoBlockLocal.remove();
                        RootTracer.pojoBlockLocal.set(null);
                    }
                } else if (compType.equals("SQL")) {
                    if ((long)this.sqlInvokeCount >= PropsManager.getMaxSQLTraceCount()) {
                        RootTracer.sqlBlockLocal.remove();
                        RootTracer.sqlBlockLocal.set(null);
                        return false;
                    }
                } else if (!MethodInfo.isFrontEndComp(compType)) {
                    ++this.otherPointcutCount;
                    if (this.otherPointcutCount >= PropsManager.getOtherPointcutMethodLimit()) {
                        this.isPointcutLimitReached = true;
                        JTMLog.logger.warn("Pointcut Limit is Reached for the URL : " + this.getRootMinfo().getRawURL());
                    }
                }
                ++this.recursiveCount;
                if (this.recursiveCount >= PropsManager.getRecursionTraceLimit()) {
                    JTMLog.logger.warn("Afraid to trace this request " + this.getRootMinfo().getRawURL() + " So, removing the request from threadlocal");
                    MethodEventProcessor.removeFromThreadLocal();
                }
            }
            Minfo.setStartTime(timeStamp);
            if (reqProps != null) {
                Minfo.setProperties(reqProps);
            }
            Minfo.setType(compType);
            try {
                this.currentMinfo.addChildMinfo(Minfo);
            }
            catch (Exception e) {
                if (!PropsManager.jtmDebugEnabled) break block20;
                JTMLog.debugLogger.error("EXception onMethodStart...", e);
            }
        }
        this.setCurrentMinfo(Minfo);
        if (compType.equals("EXCEPTION")) {
            MethodInfo rootMethodInfo = this.getRootMinfo();
            rootMethodInfo.setErrorURL(true);
        } else if (compType.equals("HTTP") || compType.equals("WEBSERVICE")) {
            MethodInfo rootMethodInfo = this.getRootMinfo();
            rootMethodInfo.setExtCallURL(true);
            Minfo.setDontRemove(true);
            MethodInfo nowInfo = this.currentMinfo;
            while (nowInfo != null) {
                nowInfo.setDontRemove(true);
                nowInfo = nowInfo.getParent();
            }
        }
        result = true;
        return result;
    }

    private void removeCurrentMinfo(boolean flag) {
        if (this.currentMinfo.getParent() != null) {
            MethodInfo tempMinfo = this.currentMinfo;
            this.setCurrentMinfo(this.currentMinfo.getParent());
            this.currentMinfo.removeChildMinfo(tempMinfo);
            if (flag && tempMinfo.getChildMinfos().size() > 0) {
                Stack<MethodInfo> blocks = new Stack<MethodInfo>();
                blocks.push(tempMinfo);
                MethodInfo result = tempMinfo;
                while (!blocks.isEmpty()) {
                    ArrayList MIList;
                    result = (MethodInfo)blocks.pop();
                    String type = result.getType();
                    if (type.equals("SQL") || type.equals("HTTP") || type.equals("WEBSERVICE") || type.equals("EXCEPTION")) {
                        this.currentMinfo.addChildMinfo(result);
                    }
                    if ((MIList = (ArrayList)result.getChildMinfos()) == null || MIList.size() <= 0) continue;
                    blocks.addAll(MIList);
                }
                Object var3_3 = null;
            }
            Object var2_2 = null;
        }
    }

    public boolean onMethodEnd(boolean hasMethodFailed, long timeStamp) {
        MethodInfo parentMethod;
        String parentMethodType;
        String thisType = this.currentMinfo.getType();
        if (thisType != null && thisType.equalsIgnoreCase("unknown")) {
            this.removeCurrentMinfo(false);
            return true;
        }
        --this.recursiveCount;
        if (hasMethodFailed) {
            this.currentMinfo.setEndTime(timeStamp, true);
        } else {
            this.currentMinfo.setEndTime(timeStamp, false);
        }
        double thisExecutionTime = this.currentMinfo.getExecutionTime();
        if ((thisType.equals("POJO") || thisType.equals("JDBC") || thisType.equals("JNDI")) && !this.currentMinfo.isDontRemove() && thisExecutionTime < UPDManager.getMethExecCutOff()) {
            this.removeCurrentMinfo(true);
            return true;
        }
        boolean overLoadedMethod = false;
        if (this.currentMinfo.getParent() != null && !thisType.equals("POJO") && thisType.equals(parentMethodType = (parentMethod = this.currentMinfo.getParent()).getType()) && this.currentMinfo.getClassName().equals(parentMethod.getClassName()) && this.currentMinfo.getMethodName().equals(parentMethod.getMethodName())) {
            overLoadedMethod = true;
        }
        if (overLoadedMethod) {
            this.removeCurrentMinfo(false);
        } else if (thisType.equals("HTTP") || thisType.equals("WEBSERVICE")) {
            this.setCurrentMinfo(this.currentMinfo.getParent());
        } else if (thisType.equals("SQL")) {
            if (PropsManager.isCutOffSql && thisExecutionTime < UPDManager.getMethExecCutOff()) {
                this.removeCurrentMinfo(false);
            } else {
                boolean isWrapper = this.sqlWrapperClassCheck(this.currentMinfo);
                if (isWrapper) {
                    this.removeCurrentMinfo(false);
                } else {
                    ++this.sqlInvokeCount;
                    this.currentMinfo.setLineNo(this.sqlInvokeCount);
                    this.setCurrentMinfo(this.currentMinfo.getParent());
                }
            }
        } else {
            this.setCurrentMinfo(this.currentMinfo.getParent());
        }
        return true;
    }

    private boolean sqlWrapperClassCheck(MethodInfo currentMethodInfo) {
        boolean result = false;
        Map currentProperties = currentMethodInfo.getProperties();
        if (currentProperties != null && currentProperties.containsKey("sqlStmt")) {
            String parentQuery;
            String currentQuery;
            MethodInfo parentMInfo = currentMethodInfo.getParent();
            Map parentProperties = parentMInfo.getProperties();
            if (parentMInfo != null && parentProperties != null && parentProperties.containsKey("sqlStmt") && (currentQuery = (String)currentProperties.get("sqlStmt")).equalsIgnoreCase(parentQuery = (String)parentProperties.get("sqlStmt"))) {
                result = true;
            }
        }
        return result;
    }

    private void doTraceLongRunningRequest() {
        JTMPojoBoolean pojoBooleanObject = RootTracer.pojoBlockLocal.get();
        JTMSqlBoolean sqlBooleanObject = RootTracer.sqlBlockLocal.get();
        this.trackerThread = new LongRunningTrackerThread(this, pojoBooleanObject, sqlBooleanObject, Thread.currentThread());
        this.scheduledFuture = EgScheduledThreadPoolExecutor.getExecutor().schedule(this.trackerThread, maxAliveTime, TimeUnit.MILLISECONDS);
    }

    public void removeFromScheduledThreadPoolExecutor() {
        if (this.scheduledFuture != null && this.trackerThread != null) {
            boolean isDone = this.scheduledFuture.isDone();
            if (isDone) {
                return;
            }
            boolean removeFromPool = this.scheduledFuture.cancel(true);
            long remainingTime = this.scheduledFuture.getDelay(TimeUnit.MILLISECONDS);
            if (removeFromPool) {
                MethodEventProcessor.removeObjectFromThreadLocal();
            } else {
                JTMLog.logger.warn("Could Not be Removed the RequestIdentifier Object from EgScheduledThreadPoolExecutor:" + this + ": removeFromPool :" + removeFromPool + "  " + remainingTime);
            }
        }
    }

    public Object getObjectFromEntryAndSQLTracker(Object keyObject) {
        return this.entryAndSQLtrackerMap.get(keyObject);
    }

    public void addObjectToEntryAndSQLTracker(Object keyObject) {
        try {
            this.entryAndSQLtrackerMap.put(keyObject, dummyIntVal);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public MethodInfo getObjectFromPOJOExceptionTracker(Object keyObject) {
        return this.POJOExceptionTracker.get(keyObject);
    }

    public void removeObjectFromPOJOExceptionTracker(Object keyObject) {
        this.POJOExceptionTracker.remove(keyObject);
    }

    public void addObjectToPOJOExceptionTracker(Object keyObject, MethodInfo methodInfo) {
        try {
            this.POJOExceptionTracker.put(keyObject, methodInfo);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public ArrayList getObjectFromCutOffMethodTracker(MethodInfo keyObject) {
        return this.cutOffMethodTracker.get(keyObject);
    }

    public void addObjectToCutOffMethodTracker(MethodInfo rootMethodInfo, ArrayList aList) {
        try {
            this.cutOffMethodTracker.put(rootMethodInfo, aList);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void removeObjectFromCutOffMethodTracker(MethodInfo keyObject) {
        try {
            this.cutOffMethodTracker.remove(keyObject);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void freeMemory() {
        this.entryAndSQLtrackerMap = null;
        this.POJOExceptionTracker = null;
        this.cutOffMethodTracker = null;
    }

    public boolean isPointcutLimitReached() {
        return this.isPointcutLimitReached;
    }

    public String getReqGUID() {
        return this.reqGUID;
    }
}

