/*
 * Decompiled with CFR 0.152.
 */
package com.eg.ch.qos.logback.core.joran.spi;

import java.io.IOException;
import java.io.OutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ConsoleTarget {
    SystemOut("System.out", new OutputStream(){

        public void write(int b) throws IOException {
            System.out.write(b);
        }

        public void write(byte[] b) throws IOException {
            System.out.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            System.out.write(b, off, len);
        }

        public void flush() throws IOException {
            System.out.flush();
        }
    }),
    SystemErr("System.err", new OutputStream(){

        public void write(int b) throws IOException {
            System.err.write(b);
        }

        public void write(byte[] b) throws IOException {
            System.err.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            System.err.write(b, off, len);
        }

        public void flush() throws IOException {
            System.err.flush();
        }
    });

    private final String name;
    private final OutputStream stream;

    public static ConsoleTarget findByName(String name) {
        ConsoleTarget[] consoleTargetArray = ConsoleTarget.values();
        int n = consoleTargetArray.length;
        int n2 = 0;
        while (n2 < n) {
            ConsoleTarget target = consoleTargetArray[n2];
            if (target.name.equalsIgnoreCase(name)) {
                return target;
            }
            ++n2;
        }
        return null;
    }

    private ConsoleTarget(String name, OutputStream stream) {
        this.name = name;
        this.stream = stream;
    }

    public String getName() {
        return this.name;
    }

    public OutputStream getStream() {
        return this.stream;
    }

    public String toString() {
        return this.name;
    }
}

