/*
 * Decompiled with CFR 0.152.
 */
package com.eg.agent.visitor;

import com.eg.agent.EgClassFileTransformer;
import com.eg.agent.adapter.EgPojoMethodAdviceAdapter;
import com.eg.org.objectweb.asm.ClassVisitor;
import com.eg.org.objectweb.asm.MethodVisitor;

public class EgPojoClassVisitor
extends ClassVisitor {
    private String className;
    private boolean isExcludePojoClass = false;
    private boolean bootLoader = false;
    private boolean byteCodeChanged = false;
    private int classFileVersion;

    public EgPojoClassVisitor(ClassVisitor classVisitor, String className, ClassLoader loader, int classFileVersion) {
        super(327680, classVisitor);
        this.className = className;
        this.bootLoader = loader == null;
        this.classFileVersion = classFileVersion;
        this.isExcludePojoClass = EgClassFileTransformer.isClassPresentExcludePojo(className);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        if (this.bootLoader || this.isExcludePojoClass) {
            return mv;
        }
        if ((access & 0x100) != 0) {
            return mv;
        }
        if ((access & 0x400) != 0 || (access & 0xB4) != 0) {
            return mv;
        }
        if (name.equals("<init>") || name.equals("<clinit>")) {
            return mv;
        }
        if (mv != null) {
            mv = new EgPojoMethodAdviceAdapter(access, mv, name, desc, this.className, this.classFileVersion);
            this.byteCodeChanged = true;
        }
        return mv;
    }

    public boolean isByteCodeChanged() {
        return this.byteCodeChanged;
    }
}

