/*
 * Decompiled with CFR 0.152.
 */
package com.eg.agent.visitor;

import com.eg.agent.EgClassFileTransformer;
import com.eg.agent.adapter.EgPojoMethodAdviceAdapter;
import com.eg.agent.adapter.EgServletMethodAdviceAdapter;
import com.eg.jtm.PropsManager;
import com.eg.org.objectweb.asm.ClassVisitor;
import com.eg.org.objectweb.asm.MethodVisitor;

public class EgGenericServletClassVisitor
extends ClassVisitor {
    private String className;
    private boolean isExcludePojoClass;
    private int classFileVersion;
    private static final String SERVLET_SERVICE_METHOD_DESC = "(Ljavax/servlet/ServletRequest;Ljavax/servlet/ServletResponse;)V";

    public EgGenericServletClassVisitor(ClassVisitor classVisitor, String className, ClassLoader loader, int classFileVersion) {
        super(327680, classVisitor);
        this.className = className;
        this.classFileVersion = classFileVersion;
        this.isExcludePojoClass = EgClassFileTransformer.isClassPresentExcludePojo(className);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        if ((access & 0x100) != 0 || (access & 0x400) != 0) {
            return mv;
        }
        if (name.equals("<clinit>") || name.equals("<init>") || name.indexOf("$") > 0) {
            return mv;
        }
        if (mv != null) {
            boolean doMethodMatch = this.isGenericServletMethodMatch(this.className, desc);
            if (doMethodMatch) {
                mv = new EgServletMethodAdviceAdapter(access, mv, name, desc, this.className, "GENERICSERVLET", this.classFileVersion);
            } else if (PropsManager.isPojoTrack()) {
                if (this.isExcludePojoClass) {
                    return mv;
                }
                mv = new EgPojoMethodAdviceAdapter(access, mv, name, desc, this.className, this.classFileVersion);
            }
        }
        return mv;
    }

    private boolean isGenericServletMethodMatch(String methodName, String description) {
        boolean match = false;
        if (methodName.equals("service") && description.equals(SERVLET_SERVICE_METHOD_DESC)) {
            match = true;
        }
        return match;
    }
}

