/*
 * Decompiled with CFR 0.152.
 */
package com.eg.org.objectweb.asm.tree;

import com.eg.org.objectweb.asm.MethodVisitor;
import com.eg.org.objectweb.asm.tree.LabelNode;
import com.eg.org.objectweb.asm.tree.TypeAnnotationNode;
import java.util.List;

public class TryCatchBlockNode {
    public LabelNode start;
    public LabelNode end;
    public LabelNode handler;
    public String type;
    public List<TypeAnnotationNode> visibleTypeAnnotations;
    public List<TypeAnnotationNode> invisibleTypeAnnotations;

    public TryCatchBlockNode(LabelNode start, LabelNode end, LabelNode handler, String type) {
        this.start = start;
        this.end = end;
        this.handler = handler;
        this.type = type;
    }

    public void updateIndex(int index) {
        int newTypeRef = 0x42000000 | index << 8;
        if (this.visibleTypeAnnotations != null) {
            for (TypeAnnotationNode tan : this.visibleTypeAnnotations) {
                tan.typeRef = newTypeRef;
            }
        }
        if (this.invisibleTypeAnnotations != null) {
            for (TypeAnnotationNode tan : this.invisibleTypeAnnotations) {
                tan.typeRef = newTypeRef;
            }
        }
    }

    public void accept(MethodVisitor mv) {
        TypeAnnotationNode an;
        mv.visitTryCatchBlock(this.start.getLabel(), this.end.getLabel(), this.handler == null ? null : this.handler.getLabel(), this.type);
        int n = this.visibleTypeAnnotations == null ? 0 : this.visibleTypeAnnotations.size();
        int i = 0;
        while (i < n) {
            an = this.visibleTypeAnnotations.get(i);
            an.accept(mv.visitTryCatchAnnotation(an.typeRef, an.typePath, an.desc, true));
            ++i;
        }
        n = this.invisibleTypeAnnotations == null ? 0 : this.invisibleTypeAnnotations.size();
        i = 0;
        while (i < n) {
            an = this.invisibleTypeAnnotations.get(i);
            an.accept(mv.visitTryCatchAnnotation(an.typeRef, an.typePath, an.desc, false));
            ++i;
        }
    }
}

