/*
 * Decompiled with CFR 0.152.
 */
package com.eg.agent.visitor;

import com.eg.agent.EgClassFileTransformer;
import com.eg.agent.adapter.EgPojoMethodAdviceAdapter;
import com.eg.agent.adapter.EgStructsMethodAdviceAdapter;
import com.eg.jtm.PropsManager;
import com.eg.org.objectweb.asm.ClassVisitor;
import com.eg.org.objectweb.asm.MethodVisitor;

public class EgStrutsTwoClassVisitor
extends ClassVisitor {
    private String className;
    private boolean isExcludePojoClass = false;
    private int classFileVersion;
    private static final String FILTER_METHOD_DESC = "(Ljavax/servlet/ServletRequest;Ljavax/servlet/ServletResponse;Ljavax/servlet/FilterChain;)V";

    public EgStrutsTwoClassVisitor(ClassVisitor classVisitor, String className, ClassLoader loader, int classFileVersion) {
        super(327680, classVisitor);
        this.className = className;
        this.classFileVersion = classFileVersion;
        this.isExcludePojoClass = EgClassFileTransformer.isClassPresentExcludePojo(className);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = this.cv.visitMethod(access, name, desc, signature, exceptions);
        if ((access & 0x100) != 0 || (access & 0x400) != 0) {
            return mv;
        }
        if (name.equals("<clinit>") || name.equals("<init>") || name.equals("init")) {
            return mv;
        }
        if (mv != null) {
            boolean isMatch = false;
            if (name.equals("doFilter") && desc.equals(FILTER_METHOD_DESC)) {
                isMatch = true;
            }
            if (isMatch) {
                mv = new EgStructsMethodAdviceAdapter(access, mv, name, desc, this.className, this.classFileVersion);
            } else if (PropsManager.isPojoTrack()) {
                boolean isProceed = true;
                if (this.isExcludePojoClass || name.indexOf("$") > 0) {
                    isProceed = false;
                }
                if (isProceed) {
                    mv = new EgPojoMethodAdviceAdapter(access, mv, name, desc, this.className, this.classFileVersion);
                }
            }
        }
        return mv;
    }
}

