/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.controls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSortKey;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEREnumerated;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERTag;
import netscape.ldap.client.JDAPBERTagDecoder;

public class LDAPSortControl
extends LDAPControl {
    public static final String SORTREQUEST = "1.2.840.113556.1.4.473";
    public static final String SORTRESPONSE = "1.2.840.113556.1.4.474";
    private String m_failedAttribute = null;
    private int m_resultCode = 0;
    private LDAPSortKey[] m_keys;
    static /* synthetic */ Class class$netscape$ldap$controls$LDAPSortControl;

    static {
        try {
            LDAPControl.register(SORTRESPONSE, class$netscape$ldap$controls$LDAPSortControl != null ? class$netscape$ldap$controls$LDAPSortControl : (class$netscape$ldap$controls$LDAPSortControl = LDAPSortControl.class$("netscape.ldap.controls.LDAPSortControl")));
        }
        catch (LDAPException lDAPException) {}
    }

    public LDAPSortControl(String string, boolean bl, byte[] byArray) throws LDAPException, IOException {
        super(string, bl, byArray);
        if (!string.equals(SORTRESPONSE)) {
            throw new LDAPException("oid must be LDAPSortControl.SORTRESPONSE", 89);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        BERSequence bERSequence = new BERSequence();
        JDAPBERTagDecoder jDAPBERTagDecoder = new JDAPBERTagDecoder();
        int[] nArray = new int[1];
        BERSequence bERSequence2 = (BERSequence)BERElement.getElement(jDAPBERTagDecoder, byteArrayInputStream, nArray);
        int n = ((BEREnumerated)bERSequence2.elementAt(0)).getValue();
        if (bERSequence2.size() == 1) {
            return;
        }
        BEROctetString bEROctetString = (BEROctetString)bERSequence2.elementAt(1);
        try {
            this.m_failedAttribute = new String(bEROctetString.getValue(), "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
    }

    public LDAPSortControl(LDAPSortKey lDAPSortKey, boolean bl) {
        super(SORTREQUEST, bl, null);
        LDAPSortKey[] lDAPSortKeyArray = new LDAPSortKey[]{lDAPSortKey};
        this.m_keys = lDAPSortKeyArray;
        this.m_value = this.createSortSpecification(lDAPSortKeyArray);
    }

    public LDAPSortControl(LDAPSortKey[] lDAPSortKeyArray, boolean bl) {
        super(SORTREQUEST, bl, null);
        this.m_keys = lDAPSortKeyArray;
        this.m_value = this.createSortSpecification(lDAPSortKeyArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private byte[] createSortSpecification(LDAPSortKey[] lDAPSortKeyArray) {
        BERSequence bERSequence = new BERSequence();
        int n = 0;
        while (n < lDAPSortKeyArray.length) {
            BERSequence bERSequence2 = new BERSequence();
            bERSequence2.addElement(new BEROctetString(lDAPSortKeyArray[n].getKey()));
            if (lDAPSortKeyArray[n].getMatchRule() != null) {
                bERSequence2.addElement(new BERTag(128, new BEROctetString(lDAPSortKeyArray[n].getMatchRule()), true));
            }
            if (lDAPSortKeyArray[n].getReverse()) {
                bERSequence2.addElement(new BERTag(129, new BEREnumerated(129), true));
            }
            bERSequence.addElement(bERSequence2);
            ++n;
        }
        return this.flattenBER(bERSequence);
    }

    public String getFailedAttribute() {
        return this.m_failedAttribute;
    }

    public int getResultCode() {
        return this.m_resultCode;
    }

    public static String parseResponse(LDAPControl[] lDAPControlArray, int[] nArray) {
        String string;
        block5: {
            string = null;
            LDAPControl lDAPControl = null;
            int n = 0;
            while (lDAPControlArray != null && n < lDAPControlArray.length) {
                if (lDAPControlArray[n].getID().equals(SORTRESPONSE)) {
                    lDAPControl = lDAPControlArray[n];
                    break;
                }
                ++n;
            }
            if (lDAPControl == null) break block5;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(lDAPControl.getValue());
            BERSequence bERSequence = new BERSequence();
            JDAPBERTagDecoder jDAPBERTagDecoder = new JDAPBERTagDecoder();
            int[] nArray2 = new int[]{0};
            try {
                BERSequence bERSequence2 = (BERSequence)BERElement.getElement(jDAPBERTagDecoder, byteArrayInputStream, nArray2);
                int n2 = ((BEREnumerated)bERSequence2.elementAt(0)).getValue();
                if (nArray != null && nArray.length > 0) {
                    nArray[0] = n2;
                }
                BEROctetString bEROctetString = (BEROctetString)bERSequence2.elementAt(1);
                string = new String(bEROctetString.getValue(), "UTF8");
            }
            catch (Exception exception) {}
        }
        return string;
    }

    String reqToString() {
        StringBuffer stringBuffer = new StringBuffer("{SortCtrl:");
        stringBuffer.append(" isCritical=");
        stringBuffer.append(this.isCritical());
        stringBuffer.append(" ");
        int n = 0;
        while (n < this.m_keys.length) {
            stringBuffer.append(this.m_keys[n]);
            ++n;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    String rspToString() {
        StringBuffer stringBuffer = new StringBuffer("{SortResponseCtrl:");
        stringBuffer.append(" isCritical=");
        stringBuffer.append(this.isCritical());
        if (this.m_failedAttribute != null) {
            stringBuffer.append(" failedAttr=");
            stringBuffer.append(this.m_failedAttribute);
        }
        stringBuffer.append(" resultCode=");
        stringBuffer.append(this.m_resultCode);
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getID() == SORTREQUEST ? this.reqToString() : this.rspToString();
    }
}

