/*
 * Decompiled with CFR 0.152.
 */
package com.eg.org.apache.commons.lang3.text.translate;

import com.eg.org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;

public class LookupTranslator
extends CharSequenceTranslator {
    private final HashMap<CharSequence, CharSequence> lookupMap = new HashMap();
    private final int shortest;
    private final int longest;

    public LookupTranslator(CharSequence[] ... lookup) {
        int _shortest = Integer.MAX_VALUE;
        int _longest = 0;
        if (lookup != null) {
            CharSequence[][] charSequenceArray = lookup;
            int n = lookup.length;
            int n2 = 0;
            while (n2 < n) {
                CharSequence[] seq = charSequenceArray[n2];
                this.lookupMap.put(seq[0], seq[1]);
                int sz = seq[0].length();
                if (sz < _shortest) {
                    _shortest = sz;
                }
                if (sz > _longest) {
                    _longest = sz;
                }
                ++n2;
            }
        }
        this.shortest = _shortest;
        this.longest = _longest;
    }

    public int translate(CharSequence input, int index, Writer out) throws IOException {
        int max = this.longest;
        if (index + this.longest > input.length()) {
            max = input.length() - index;
        }
        int i = max;
        while (i >= this.shortest) {
            CharSequence subSeq = input.subSequence(index, index + i);
            CharSequence result = this.lookupMap.get(subSeq);
            if (result != null) {
                out.write(result.toString());
                return i;
            }
            --i;
        }
        return 0;
    }
}

