/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xbill.DNS.CNAMERecord;
import org.xbill.DNS.Cache;
import org.xbill.DNS.DClass;
import org.xbill.DNS.DNAMERecord;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Message;
import org.xbill.DNS.Mnemonic;
import org.xbill.DNS.Name;
import org.xbill.DNS.NameTooLongException;
import org.xbill.DNS.Options;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Rcode;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ResolverConfig;
import org.xbill.DNS.SetResponse;
import org.xbill.DNS.TextParseException;
import org.xbill.DNS.Type;

public final class Lookup {
    private static Resolver defaultResolver;
    private static Name[] defaultSearchPath;
    private static Map defaultCaches;
    private static int defaultNdots;
    private Resolver resolver;
    private Name[] searchPath;
    private Cache cache;
    private boolean temporary_cache;
    private int credibility;
    private Name name;
    private int type;
    private int dclass;
    private boolean verbose;
    private int iterations;
    private boolean foundAlias;
    private boolean done;
    private boolean doneCurrent;
    private List aliases;
    private Record[] answers;
    private int result;
    private String error;
    private boolean nxdomain;
    private boolean badresponse;
    private String badresponse_error;
    private boolean networkerror;
    private boolean timedout;
    private boolean nametoolong;
    private boolean referral;
    private static final Name[] noAliases;
    public static final int SUCCESSFUL = 0;
    public static final int UNRECOVERABLE = 1;
    public static final int TRY_AGAIN = 2;
    public static final int HOST_NOT_FOUND = 3;
    public static final int TYPE_NOT_FOUND = 4;

    public static synchronized void refreshDefault() {
        try {
            defaultResolver = new ExtendedResolver();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Failed to initialize resolver");
        }
        defaultSearchPath = ResolverConfig.getCurrentConfig().searchPath();
        defaultCaches = new HashMap();
        defaultNdots = ResolverConfig.getCurrentConfig().ndots();
    }

    public static synchronized Resolver getDefaultResolver() {
        return defaultResolver;
    }

    public static synchronized void setDefaultResolver(Resolver resolver) {
        defaultResolver = resolver;
    }

    public static synchronized Cache getDefaultCache(int dclass) {
        DClass.check(dclass);
        Cache c = (Cache)defaultCaches.get(Mnemonic.toInteger(dclass));
        if (c == null) {
            c = new Cache(dclass);
            defaultCaches.put(Mnemonic.toInteger(dclass), c);
        }
        return c;
    }

    public static synchronized void setDefaultCache(Cache cache, int dclass) {
        DClass.check(dclass);
        defaultCaches.put(Mnemonic.toInteger(dclass), cache);
    }

    public static synchronized Name[] getDefaultSearchPath() {
        return defaultSearchPath;
    }

    public static synchronized void setDefaultSearchPath(Name[] domains) {
        defaultSearchPath = domains;
    }

    public static synchronized void setDefaultSearchPath(String[] domains) throws TextParseException {
        if (domains == null) {
            defaultSearchPath = null;
            return;
        }
        Name[] newdomains = new Name[domains.length];
        for (int i = 0; i < domains.length; ++i) {
            newdomains[i] = Name.fromString(domains[i], Name.root);
        }
        defaultSearchPath = newdomains;
    }

    private final void reset() {
        this.iterations = 0;
        this.foundAlias = false;
        this.done = false;
        this.doneCurrent = false;
        this.aliases = null;
        this.answers = null;
        this.result = -1;
        this.error = null;
        this.nxdomain = false;
        this.badresponse = false;
        this.badresponse_error = null;
        this.networkerror = false;
        this.timedout = false;
        this.nametoolong = false;
        this.referral = false;
        if (this.temporary_cache) {
            this.cache.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup(Name name, int type, int dclass) {
        Type.check(type);
        DClass.check(dclass);
        if (!Type.isRR(type) && type != 255) {
            throw new IllegalArgumentException("Cannot query for meta-types other than ANY");
        }
        this.name = name;
        this.type = type;
        this.dclass = dclass;
        Class clazz = Lookup.class;
        synchronized (clazz) {
            this.resolver = Lookup.getDefaultResolver();
            this.searchPath = Lookup.getDefaultSearchPath();
            this.cache = Lookup.getDefaultCache(dclass);
        }
        this.credibility = 3;
        this.verbose = Options.check("verbose");
        this.result = -1;
    }

    public Lookup(Name name, int type) {
        this(name, type, 1);
    }

    public Lookup(Name name) {
        this(name, 1, 1);
    }

    public Lookup(String name, int type, int dclass) throws TextParseException {
        this(Name.fromString(name), type, dclass);
    }

    public Lookup(String name, int type) throws TextParseException {
        this(Name.fromString(name), type, 1);
    }

    public Lookup(String name) throws TextParseException {
        this(Name.fromString(name), 1, 1);
    }

    public void setResolver(Resolver resolver) {
        this.resolver = resolver;
    }

    public void setSearchPath(Name[] domains) {
        this.searchPath = domains;
    }

    public void setSearchPath(String[] domains) throws TextParseException {
        if (domains == null) {
            this.searchPath = null;
            return;
        }
        Name[] newdomains = new Name[domains.length];
        for (int i = 0; i < domains.length; ++i) {
            newdomains[i] = Name.fromString(domains[i], Name.root);
        }
        this.searchPath = newdomains;
    }

    public void setCache(Cache cache) {
        if (cache == null) {
            this.cache = new Cache(this.dclass);
            this.temporary_cache = true;
        } else {
            this.cache = cache;
            this.temporary_cache = false;
        }
    }

    public void setNdots(int ndots) {
        if (ndots < 0) {
            throw new IllegalArgumentException("Illegal ndots value: " + ndots);
        }
        defaultNdots = ndots;
    }

    public void setCredibility(int credibility) {
        this.credibility = credibility;
    }

    private void follow(Name name, Name oldname) {
        this.foundAlias = true;
        this.badresponse = false;
        this.networkerror = false;
        this.timedout = false;
        this.nxdomain = false;
        this.referral = false;
        ++this.iterations;
        if (this.iterations >= 6 || name.equals(oldname)) {
            this.result = 1;
            this.error = "CNAME loop";
            this.done = true;
            return;
        }
        if (this.aliases == null) {
            this.aliases = new ArrayList();
        }
        this.aliases.add(oldname);
        this.lookup(name);
    }

    private void processResponse(Name name, SetResponse response) {
        if (response.isSuccessful()) {
            RRset[] rrsets = response.answers();
            ArrayList l = new ArrayList();
            for (int i = 0; i < rrsets.length; ++i) {
                Iterator it = rrsets[i].rrs();
                while (it.hasNext()) {
                    l.add(it.next());
                }
            }
            this.result = 0;
            this.answers = l.toArray(new Record[l.size()]);
            this.done = true;
        } else if (response.isNXDOMAIN()) {
            this.nxdomain = true;
            this.doneCurrent = true;
            if (this.iterations > 0) {
                this.result = 3;
                this.done = true;
            }
        } else if (response.isNXRRSET()) {
            this.result = 4;
            this.answers = null;
            this.done = true;
        } else if (response.isCNAME()) {
            CNAMERecord cname = response.getCNAME();
            this.follow(cname.getTarget(), name);
        } else if (response.isDNAME()) {
            DNAMERecord dname = response.getDNAME();
            try {
                this.follow(name.fromDNAME(dname), name);
            }
            catch (NameTooLongException e) {
                this.result = 1;
                this.error = "Invalid DNAME target";
                this.done = true;
            }
        } else if (response.isDelegation()) {
            this.referral = true;
        }
    }

    private void lookup(Name current) {
        SetResponse sr = this.cache.lookupRecords(current, this.type, this.credibility);
        if (this.verbose) {
            System.err.println("lookup " + current + " " + Type.string(this.type));
            System.err.println(sr);
        }
        this.processResponse(current, sr);
        if (this.done || this.doneCurrent) {
            return;
        }
        Record question = Record.newRecord(current, this.type, this.dclass);
        Message query = Message.newQuery(question);
        Message response = null;
        try {
            response = this.resolver.send(query);
        }
        catch (IOException e) {
            if (e instanceof InterruptedIOException) {
                this.timedout = true;
            } else {
                this.networkerror = true;
            }
            return;
        }
        int rcode = response.getHeader().getRcode();
        if (rcode != 0 && rcode != 3) {
            this.badresponse = true;
            this.badresponse_error = Rcode.string(rcode);
            return;
        }
        if (!query.getQuestion().equals(response.getQuestion())) {
            this.badresponse = true;
            this.badresponse_error = "response does not match query";
            return;
        }
        sr = this.cache.addMessage(response);
        if (sr == null) {
            sr = this.cache.lookupRecords(current, this.type, this.credibility);
        }
        if (this.verbose) {
            System.err.println("queried " + current + " " + Type.string(this.type));
            System.err.println(sr);
        }
        this.processResponse(current, sr);
    }

    private void resolve(Name current, Name suffix) {
        this.doneCurrent = false;
        Name tname = null;
        if (suffix == null) {
            tname = current;
        } else {
            try {
                tname = Name.concatenate(current, suffix);
            }
            catch (NameTooLongException e) {
                this.nametoolong = true;
                return;
            }
        }
        this.lookup(tname);
    }

    public Record[] run() {
        if (this.done) {
            this.reset();
        }
        if (this.name.isAbsolute()) {
            this.resolve(this.name, null);
        } else if (this.searchPath == null) {
            this.resolve(this.name, Name.root);
        } else {
            if (this.name.labels() > defaultNdots) {
                this.resolve(this.name, Name.root);
            }
            if (this.done) {
                return this.answers;
            }
            for (int i = 0; i < this.searchPath.length; ++i) {
                this.resolve(this.name, this.searchPath[i]);
                if (this.done) {
                    return this.answers;
                }
                if (this.foundAlias) break;
            }
        }
        if (!this.done) {
            if (this.badresponse) {
                this.result = 2;
                this.error = this.badresponse_error;
                this.done = true;
            } else if (this.timedout) {
                this.result = 2;
                this.error = "timed out";
                this.done = true;
            } else if (this.networkerror) {
                this.result = 2;
                this.error = "network error";
                this.done = true;
            } else if (this.nxdomain) {
                this.result = 3;
                this.done = true;
            } else if (this.referral) {
                this.result = 1;
                this.error = "referral";
                this.done = true;
            } else if (this.nametoolong) {
                this.result = 1;
                this.error = "name too long";
                this.done = true;
            }
        }
        return this.answers;
    }

    private void checkDone() {
        if (this.done && this.result != -1) {
            return;
        }
        StringBuffer sb = new StringBuffer("Lookup of " + this.name + " ");
        if (this.dclass != 1) {
            sb.append(DClass.string(this.dclass) + " ");
        }
        sb.append(Type.string(this.type) + " isn't done");
        throw new IllegalStateException(sb.toString());
    }

    public Record[] getAnswers() {
        this.checkDone();
        return this.answers;
    }

    public Name[] getAliases() {
        this.checkDone();
        if (this.aliases == null) {
            return noAliases;
        }
        return this.aliases.toArray(new Name[this.aliases.size()]);
    }

    public int getResult() {
        this.checkDone();
        return this.result;
    }

    public String getErrorString() {
        this.checkDone();
        if (this.error != null) {
            return this.error;
        }
        switch (this.result) {
            case 0: {
                return "successful";
            }
            case 1: {
                return "unrecoverable error";
            }
            case 2: {
                return "try again";
            }
            case 3: {
                return "host not found";
            }
            case 4: {
                return "type not found";
            }
        }
        throw new IllegalStateException("unknown result");
    }

    static {
        noAliases = new Name[0];
        Lookup.refreshDefault();
    }
}

