/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import com.sun.mail.iap.ParsingException;
import com.sun.mail.imap.protocol.FetchResponse;
import com.sun.mail.imap.protocol.Item;
import com.sun.mail.util.MailDateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class INTERNALDATE
implements Item {
    public static char[] name = new char[]{'I', 'N', 'T', 'E', 'R', 'N', 'A', 'L', 'D', 'A', 'T', 'E'};
    public int msgno;
    protected Date date;
    private static MailDateFormat mailDateFormat = new MailDateFormat();
    private static SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss ", Locale.US);
    private static String tz_offset;

    public INTERNALDATE(FetchResponse fetchResponse) throws ParsingException {
        this.msgno = fetchResponse.getNumber();
        fetchResponse.skipSpaces();
        String string = fetchResponse.readString();
        try {
            this.date = mailDateFormat.parse(string);
            return;
        }
        catch (ParseException parseException) {
            throw new ParsingException("INTERNALDATE parse error");
        }
    }

    public Date getDate() {
        return this.date;
    }

    public static String format(Date date) {
        StringBuffer stringBuffer = new StringBuffer();
        df.format(date, stringBuffer, new FieldPosition(0));
        stringBuffer.append(tz_offset);
        return stringBuffer.toString();
    }

    static {
        TimeZone timeZone = TimeZone.getDefault();
        int n = timeZone.getRawOffset();
        StringBuffer stringBuffer = new StringBuffer();
        if (n < 0) {
            stringBuffer.append('-');
            n = -n;
        } else {
            stringBuffer.append('+');
        }
        int n2 = n / 60 / 1000;
        int n3 = n2 / 60;
        int n4 = n2 % 60;
        stringBuffer.append(Character.forDigit(n3 / 10, 10));
        stringBuffer.append(Character.forDigit(n3 % 10, 10));
        stringBuffer.append(Character.forDigit(n4 / 10, 10));
        stringBuffer.append(Character.forDigit(n4 % 10, 10));
        tz_offset = stringBuffer.toString();
    }
}

