'use strict'

var semver = require('semver')
var shimmer = require('../shimmer')
var logger = require('../../logger')
var appendMsg = "Kafka :"
module.exports = function (kafka, agent, version, enabled) {

    if (!semver.satisfies(version, '>=1.2.3')) {
        logger.debug(appendMsg , 'kafka version ', version, ' not supported')
        return kafka
    } else {
        logger.debug(appendMsg ,'kafka version ', version, ' is supported')
    }

    if (!enabled) return kafka

    shimmer.wrap(kafka.Producer.prototype, 'send', function wrapSend(orig) {
        return function wrappedSend() {
            var span = agent.buildSpan()
            var id = span && span.transaction.id
            var hasCallback = false

            logger.debug(appendMsg ,'new kafka producer.send() call  :  ', {
                id: id
            })

            if (span) {
                span.name = 'kafka producer send call'
                span.type = 'kafka'

                var len = arguments.length - 1
                var cbfn = arguments[len]

                if (typeof cbfn === 'function') {
                    arguments[len] = wrapCallback(cbfn)
                } else {
                    span.start()
                }

                var params = {}
                params.host = this.client.options.kafkaHost || ''
                params.port = 9092 //Setting defau;t port
                params.topic = arguments[0][0].topic
                params.resTime = ''
                params.serverType = 'kafka'
                params.error = ''
                params.nodeOrder = ''
                params.query = '';
                span.options = params;
            }

            var result = orig.apply(this, arguments)

            //If callback not found we need use emitter to end span
            //Note:- this is for if the call back is not found then we need to use the emit function

            if (span && result && !hasCallback) {
                result.then(function () {
                    span.end()
                })
            }

            return result

            function wrapCallback(cb) {
                hasCallback = true
                span.start()
                return function wrappedCallback(err) {

                    //Capture error 
                    if (err) {
                        span.options.error = err.toString();
                        if (err.stack) span.options.error = JSON.stringify(err.stack)
                    }
                    span.end()
                    return cb.apply(this, arguments)
                }
            }
        }

    })

    shimmer.wrap(kafka.Consumer.prototype, 'emit', function wrapEmit(orig) {
        return function wrappedSend(eventType, message) {
            
            if (eventType !== 'message') {
                return orig.apply(this, arguments)
            }

            var span = agent.buildSpan()
            var id = span && span.transaction.id
            var hasCallback = false

            logger.debug(appendMsg ,'new kafka consumer.emit() call  :  ', {
                id: id
            })

            if (span) {
                span.name = 'kafka consumer emit call'
                span.type = 'kafka'

                var len = arguments.length - 1
                var cbfn = arguments[len]

                if (typeof cbfn === 'function') {
                    arguments[len] = wrapCallback(cbfn)
                } else {
                    span.start()
                }

                var params = {}
                params.host = this.client.options.kafkaHost || ''
                params.port = 9092 //Setting defau;t port
                params.topic = message.topic
                params.resTime = ''
                params.serverType = 'kafka'
                params.error = ''
                params.nodeOrder = ''
                params.query = '';
                span.options = params;
            }

            var result = original.apply(this, arguments)

            //If callback not found we need use emitter to end span
            //Note:- this is for if the call back is not found then we need to use the emit function

            if (span && result && !hasCallback) {
                result.then(function () {
                    span.end()
                })
            }

            return result

            function wrapCallback(cb) {
                hasCallback = true
                span.start()
                return function wrappedCallback(err) {

                    //Capture error 
                    if (err) {
                        span.options.error = err.toString();
                        if (err.stack) span.options.error = JSON.stringify(err.stack)
                    }
                    span.end()
                    return cb.apply(this, arguments)
                }
            }
        }
    })

    return kafka
}