'use strict'

var semver = require('semver')

var shimmer = require('../shimmer')
var log = require('../../logger')
var massWrap = shimmer.massWrap
var wrap = shimmer.wrap
var appendMsg = 'BlueBird :'

var BLUEBIRD_FNS = ['_then', '_addCallbacks']

module.exports = function (bluebird, agent, version) {
  var ins = agent._instrumentation

  if (!semver.satisfies(version, '>=2 <4')) {
    log.debug(appendMsg, 'bluebird version ',version,' not supported - aborting...')
    return bluebird
  }

  log.debug(appendMsg,'wrapping bluebird.prototype functions:', BLUEBIRD_FNS)
  massWrap(bluebird.prototype, BLUEBIRD_FNS, wrapThen)

  log.debug(appendMsg, 'wrapping bluebird.config')
  wrap(bluebird, 'config', function wrapConfig (original) {
    return function wrappedConfig () {
      var result = original.apply(this, arguments)

      log.debug(appendMsg, 'wrapping bluebird.prototype._attachCancellationCallback')
      wrap(bluebird.prototype, '_attachCancellationCallback', function wrapAttachCancellationCallback (original) {
        return function wrappedAttachCancellationCallback (onCancel) {
          if (arguments.length !== 1) return original.apply(this, arguments)
          return original.call(this, ins.bindFunction(onCancel))
        }
      })

      return result
    }
  })

  if (semver.satisfies(version, '<3')) {
    log.debug(appendMsg, 'wrapping bluebird.each')
    wrap(bluebird, 'each', function wrapEach (original) {
      return function wrappedEach (promises, fn) {
        if (arguments.length !== 2) return original.apply(this, arguments)
        return original.call(this, promises, ins.bindFunction(fn))
      }
    })

    log.debug(appendMsg, 'wrapping bluebird.prototype.each')
    wrap(bluebird.prototype, 'each', function wrapEach (original) {
      return function wrappedEach (fn) {
        if (arguments.length !== 1) return original.apply(this, arguments)
        return original.call(this, ins.bindFunction(fn))
      }
    })
  }

  return bluebird

  function wrapThen (original) {
    return function wrappedThen () {
      var args = Array.prototype.slice.call(arguments)
      if (typeof args[0] === 'function') args[0] = ins.bindFunction(args[0])
      if (typeof args[1] === 'function') args[1] = ins.bindFunction(args[1])
      return original.apply(this, args)
    }
  }
}
