/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class DMSNLSupport {
    public static final String DMS_MESSAGE_FILE = "oracle.dms.util.dms";
    private static final ResourceBundle DEFAULT_BUNDLE;
    private static final Locale DEFAULT_LOCALE;

    public static ResourceBundle getDefaultResourceBundle() {
        return DEFAULT_BUNDLE;
    }

    public static String getString(String string) {
        return DMSNLSupport.getString(string, null);
    }

    public static String getString(String string, String string2) {
        return DMSNLSupport.getString(string, string2, DEFAULT_BUNDLE);
    }

    public static String getString(String string, String string2, Locale locale) {
        if (locale == null) {
            return DMSNLSupport.getString(string, string2);
        }
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle(DMS_MESSAGE_FILE, locale);
        }
        catch (MissingResourceException missingResourceException) {
            return string2;
        }
        return DMSNLSupport.getString(string, string2, resourceBundle);
    }

    private static String getString(String string, String string2, ResourceBundle resourceBundle) {
        if (string == null || resourceBundle == null) {
            return string2;
        }
        try {
            return resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string2;
        }
    }

    public static String getMessage(String string, Object[] objectArray) {
        return DMSNLSupport.getMessage(string, objectArray, null);
    }

    public static String getMessage(String string, Object[] objectArray, String string2) {
        return DMSNLSupport.getMessage(string, objectArray, string2, DEFAULT_BUNDLE);
    }

    public static String getMessage(String string, Object[] objectArray, String string2, Locale locale) {
        if (locale == null) {
            return DMSNLSupport.getMessage(string, objectArray, string2);
        }
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle(DMS_MESSAGE_FILE, locale);
        }
        catch (MissingResourceException missingResourceException) {
            return string2;
        }
        return DMSNLSupport.getMessage(string, objectArray, string2, resourceBundle);
    }

    private static String getMessage(String string, Object[] objectArray, String string2, ResourceBundle resourceBundle) {
        if (string == null || resourceBundle == null) {
            return string2;
        }
        String string3 = null;
        try {
            string3 = resourceBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return string2;
        }
        if (objectArray == null) {
            return string3;
        }
        return MessageFormat.format(string3, objectArray);
    }

    private DMSNLSupport() {
    }

    static {
        DEFAULT_LOCALE = Locale.getDefault();
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle(DMS_MESSAGE_FILE);
        }
        catch (MissingResourceException missingResourceException) {
            missingResourceException.printStackTrace();
        }
        DEFAULT_BUNDLE = resourceBundle;
    }
}

