/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.spy;

import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.Vector;
import oracle.dms.clock.Clock;
import oracle.dms.clock.ClockManager;
import oracle.dms.clock.ClockState;
import oracle.dms.instrument.DMSConsole;
import oracle.dms.instrument.Event;
import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.Level;
import oracle.dms.instrument.Log;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.State;
import oracle.dms.spy.Metric;
import oracle.dms.spy.PropertiesStates;
import oracle.dms.util.DMSNLSupport;
import oracle.dms.util.DMSUtil;
import oracle.dms.util.Indentation;

public class StatisticsProducer
implements GroupRefresh {
    long _startTime = System.currentTimeMillis();
    private static Noun _cn;
    private static Noun _jn;
    private static Noun _measNoun;
    static State _nodes_state;
    private static State _freeMem;
    private static State _totalMem;
    private static State _uptime;
    private static State _threads;
    private static State _thrGrps;
    private static State _startTimeState;
    private static int _numThreads;
    private static int _numThrGrps;
    public static Event _nounCreate;
    public static Event _sensorCreate;
    public static Event _nounDestroy;
    public static Event _sensorDestroy;
    static State lastID;
    public static Event sampleVal;
    public static State _clockTime;
    public static int _nounCreateCount;
    private static final int _version = 2;
    private static boolean _alive;
    private Indentation _indent = new Indentation();
    public static final String JAVA_DMS = "DMS-Internal";
    private static final String PREFIX = "PROD_";
    private static final String MEASUREMENT = "Measurement";
    private static final String NODES = "treeNodes";
    private static final String LAST_ID = "lastTreeNodeID";
    private static final String NOUN_CREATE = "createNoun";
    private static final String NOUN_DESTROY = "destroyNoun";
    private static final String SENSOR_CREATE = "createSensor";
    private static final String SENSOR_DESTROY = "destroySensor";
    private static final String SAMPLE_VAL = "sampleMetric";
    private static final String START_TIME = "startTime";
    private static final String SENSOR_WEIGHT = "sensorWeight";
    private static final String CLOCK = "Clock";
    private static final String CLOCK_NAME = "name";
    private static final String REQUESTED_UNITS = "requestedUnits";
    private static final String MEASURED_FREQ = "measuredFrequency";
    private static final String REPORTED_FREQ = "reportedFrequency";
    private static final String CLOCK_OVERHEAD = "overheadPerCall";
    private static final String MEASURED_RESOLUTION = "measuredResolution";
    private static final String CLOCK_TIME = "clockTime";
    private static final String JVM = "JVM";
    private static final String JVM_TOTAL_MEM = "totalMemory";
    private static final String JVM_FREE_MEM = "freeMemory";
    private static final String JVM_THREADS = "activeThreads";
    private static final String JVM_THRGRPS = "activeThreadGroups";
    private static final String JSPY_UPTIME = "upTime";
    private static final String THRREFRERR = "threadRefreshError";

    StatisticsProducer(String string) {
        _alive = true;
        Noun noun = Noun.getRoot();
        if (noun != null) {
            noun.setName(string);
        }
        this.initSpyMetrics();
    }

    synchronized void exit() {
        if (!_alive) {
            return;
        }
        if (_measNoun != null) {
            _measNoun.destroy();
        }
        if (_jn != null) {
            _jn.destroy();
        }
        if (_cn != null) {
            _cn.destroy();
        }
        _nodes_state = null;
        _freeMem = null;
        _totalMem = null;
        _uptime = null;
        _threads = null;
        _thrGrps = null;
        _startTimeState = null;
        _nounCreate = null;
        _sensorCreate = null;
        _nounDestroy = null;
        _sensorDestroy = null;
        lastID = null;
        sampleVal = null;
        _clockTime = null;
        _numThreads = 0;
        _numThrGrps = 0;
        _nounCreateCount = 1;
        PropertiesStates.exit();
        _alive = false;
    }

    void initSpyMetrics() {
        Noun.create("/DMS-Internal", DMSNLSupport.getString("PROD_DMS-Internal"));
        _measNoun = Noun.create(DMSUtil.genCompNounPath(MEASUREMENT), DMSNLSupport.getString("PROD_Measurement"));
        _nodes_state = new State(_measNoun, NODES, "", DMSNLSupport.getString("PROD_treeNodes"), 0);
        _nodes_state.configureLogging(null, Level.OFF);
        _nodes_state.deriveMetric(8);
        String string = DMSNLSupport.getString("PROD_lastTreeNodeID");
        lastID = new State(_measNoun, LAST_ID, "", string, 0);
        lastID.configureLogging(null, Level.OFF);
        _nounCreate = Event.create(_measNoun, NOUN_CREATE, DMSNLSupport.getString("PROD_createNoun"));
        for (int i = 0; i < _nounCreateCount; ++i) {
            _nounCreate.occurred();
        }
        _nounDestroy = Event.create(_measNoun, NOUN_DESTROY, DMSNLSupport.getString("PROD_destroyNoun"));
        _sensorCreate = Event.create(_measNoun, SENSOR_CREATE, DMSNLSupport.getString("PROD_createSensor"));
        _sensorDestroy = Event.create(_measNoun, SENSOR_DESTROY, DMSNLSupport.getString("PROD_destroySensor"));
        sampleVal = Event.create(_measNoun, SAMPLE_VAL, DMSNLSupport.getString("PROD_sampleMetric"));
        State state = State.create(_measNoun, SENSOR_WEIGHT, "", DMSNLSupport.getString("PROD_sensorWeight"), DMSConsole.getSensorWeight());
        _cn = Noun.create("/DMS-Internal/Clock", DMSNLSupport.getString("PROD_Clock"));
        Clock clock = DMSConsole.getClock();
        State state2 = State.create(_cn, CLOCK_NAME, "", DMSNLSupport.getString("PROD_Clockname"), (Object)clock.getName());
        String string2 = ClockManager.getUnits(DMSConsole.UNITS);
        state2 = State.create(_cn, REQUESTED_UNITS, "", DMSNLSupport.getString("PROD_requestedUnits"), (Object)DMSNLSupport.getString(string2.toUpperCase()));
        state2 = State.create(_cn, MEASURED_FREQ, DMSNLSupport.getString("TICKS"), DMSNLSupport.getString("PROD_measuredFrequency"), clock.getMeasuredFrequency());
        state2 = State.create(_cn, REPORTED_FREQ, DMSNLSupport.getString("TICKS"), DMSNLSupport.getString("PROD_reportedFrequency"), clock.getReportedFrequency());
        String string3 = clock.getUnits().toUpperCase();
        state2 = State.create(_cn, CLOCK_OVERHEAD, DMSNLSupport.getString(string3), DMSNLSupport.getString("PROD_overheadPerCall"), clock.getOverhead());
        state2 = State.create(_cn, MEASURED_RESOLUTION, DMSNLSupport.getString(string3), DMSNLSupport.getString("PROD_measuredResolution"), clock.getDescription().getResolution());
        long l = 0L;
        _clockTime = State.create(_cn, CLOCK_TIME, DMSNLSupport.getString(string3), DMSNLSupport.getString("PROD_clockTime"), l);
        ClockState.init(_clockTime);
        _jn = Noun.create("/JVM", DMSNLSupport.getString("PROD_JVM"));
        PropertiesStates propertiesStates = PropertiesStates.create(_jn);
        _totalMem = State.create(_jn, JVM_TOTAL_MEM, DMSNLSupport.getString("KB"), DMSNLSupport.getString("PROD_totalMemory"), (int)(Runtime.getRuntime().totalMemory() / 1024L));
        _totalMem.deriveMetric(12);
        _freeMem = State.create(_jn, JVM_FREE_MEM, DMSNLSupport.getString("KB"), DMSNLSupport.getString("PROD_freeMemory"), (int)(Runtime.getRuntime().freeMemory() / 1024L));
        _freeMem.deriveMetric(12);
        _uptime = State.create(_jn, JSPY_UPTIME, DMSNLSupport.getString("MSECS"), DMSNLSupport.getString("PROD_upTime"), System.currentTimeMillis() - this._startTime);
        StatisticsProducer.refreshThreadStats();
        _threads = State.create(_jn, JVM_THREADS, DMSNLSupport.getString("THREADS"), DMSNLSupport.getString("PROD_activeThreads"), _numThreads);
        _threads.deriveMetric(12);
        _thrGrps = State.create(_jn, JVM_THRGRPS, DMSNLSupport.getString("GROUPS"), DMSNLSupport.getString("PROD_activeThreadGroups"), _numThrGrps);
        _thrGrps.deriveMetric(12);
        _startTimeState = State.create(_jn, START_TIME, DMSNLSupport.getString("MSECS"), DMSNLSupport.getString("PROD_startTime"), this._startTime);
        _totalMem.setRefresh(this);
        _freeMem.setRefresh(this);
        _uptime.setRefresh(this);
        _threads.setRefresh(this);
        _thrGrps.setRefresh(this);
    }

    public void refresh() {
        _freeMem.update((int)(Runtime.getRuntime().freeMemory() / 1024L));
        _totalMem.update((int)(Runtime.getRuntime().totalMemory() / 1024L));
        _uptime.update(System.currentTimeMillis() - this._startTime);
        StatisticsProducer.refreshThreadStats();
        _threads.update(_numThreads);
        _thrGrps.update(_numThrGrps);
    }

    private static void refreshThreadStats() {
        try {
            ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
            if (threadGroup == null) {
                return;
            }
            ThreadGroup threadGroup2 = StatisticsProducer.getParent(threadGroup);
            while (threadGroup2 != null) {
                threadGroup = threadGroup2;
                threadGroup2 = StatisticsProducer.getParent(threadGroup);
            }
            _numThreads = threadGroup.activeCount();
            _numThrGrps = threadGroup.activeGroupCount();
        }
        catch (Exception exception) {
            Log.log("/JVM/threadRefreshError", DMSNLSupport.getString("PROD_threadRefreshError"), Level.ERROR, null);
        }
    }

    private static ThreadGroup getParent(final ThreadGroup threadGroup) {
        ThreadGroup threadGroup2 = (ThreadGroup)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return threadGroup.getParent();
            }
        });
        return threadGroup2;
    }

    synchronized void dump(PrintWriter printWriter, boolean bl) {
        printWriter.println("<DMSDUMP version='2.0'>");
        StringBuffer stringBuffer = new StringBuffer(64);
        long l = System.currentTimeMillis();
        stringBuffer.append("<timestamp>");
        stringBuffer.append(l);
        stringBuffer.append(" (");
        Date date = new Date(l);
        stringBuffer.append(date);
        stringBuffer.append(")</timestamp>");
        printWriter.println(stringBuffer.toString());
        this.dumpNodes(Noun.getRoot(), printWriter, bl, new Vector());
        printWriter.println("</DMSDUMP>");
    }

    private synchronized void dumpNodes(Noun noun, PrintWriter printWriter, boolean bl, Vector vector) {
        if (bl) {
            this._indent.indent(printWriter);
            printWriter.print(noun.getName() + '\n');
        }
        Vector vector2 = noun.getMetrics();
        for (int i = vector2.size() - 1; i >= 0; --i) {
            Metric metric = (Metric)vector2.elementAt(i);
            metric.refresh(vector);
            Object object = metric.getValue(false);
            if (bl) {
                this._indent.increIndent();
                this._indent.indent(printWriter);
                printWriter.println(metric.getName() + ":\t" + object + " " + metric.getUnits());
                this._indent.decreIndent();
                continue;
            }
            printWriter.println("" + metric + ": " + object);
        }
        Vector vector3 = noun.getNouns();
        this._indent.increIndent();
        for (int i = vector3.size() - 1; i >= 0; --i) {
            this.dumpNodes((Noun)vector3.elementAt(i), printWriter, bl, vector);
        }
        this._indent.decreIndent();
    }

    static {
        _nounCreateCount = 1;
        _alive = false;
    }
}

