/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.reporter;

import java.io.PrintWriter;
import oracle.dms.http.Request;
import oracle.dms.reporter.MetricTreeletNode;
import oracle.dms.reporter.NounTreeletNode;
import oracle.dms.reporter.TreeletNode;
import oracle.dms.reporter.TreeletReporter;
import oracle.dms.spy.ErrorObject;
import oracle.dms.util.DMSUtil;

public class PdmlReporter
extends TreeletReporter {
    public PdmlReporter(Request request) {
        super(request);
        this.m_isOrdered = true;
    }

    void printHeading(PrintWriter printWriter) {
        printWriter.print("<?xml version='1.0'?>\n<!DOCTYPE pdml>\n<pdml version='");
        printWriter.print("9.0.4");
        printWriter.print("' id='");
        printWriter.print(this.m_id);
        printWriter.print("' host='");
        printWriter.print(DMSUtil.getLocalHostname());
        printWriter.print("' name='");
        printWriter.print(this.m_name);
        printWriter.print("' timestamp='");
        long l = System.currentTimeMillis();
        printWriter.print(l);
        printWriter.print("'>\n");
    }

    void printEnding(PrintWriter printWriter) {
        printWriter.print("</pdml>\n");
    }

    void startPrintNounNode(NounTreeletNode nounTreeletNode, PrintWriter printWriter) {
        printWriter.print("<noun name='");
        printWriter.print(nounTreeletNode.getName());
        printWriter.print("' type='");
        printWriter.print(nounTreeletNode.getTable());
        printWriter.print("'>\n");
    }

    void printMetricNode(MetricTreeletNode metricTreeletNode, PrintWriter printWriter) {
        Object object;
        printWriter.print("<metric name='");
        printWriter.print(metricTreeletNode.getName());
        if (this.m_includeDescriptions) {
            object = metricTreeletNode.getDescription();
            printWriter.print("' description='");
            if (object != null && ((String)object).length() > 0) {
                printWriter.print((String)object);
            }
        }
        if (this.m_includeUnits) {
            object = metricTreeletNode.getUnit();
            printWriter.print("' units='");
            if (object != null && ((String)object).length() > 0) {
                printWriter.print((String)object);
            }
        }
        printWriter.print("'>\n");
        if (this.m_includeValues) {
            object = metricTreeletNode.getObjValue();
            if (object == null) {
                printWriter.print("<null/>\n");
            } else if (object instanceof ErrorObject) {
                printWriter.print("<error/>\n");
            } else {
                printWriter.print("<value type='");
                printWriter.print(TreeletNode.getValueType(object));
                printWriter.print("'><![CDATA[");
                printWriter.print(DMSUtil.xmlEscape(object.toString()));
                printWriter.print("]]></value>\n");
            }
        }
        printWriter.print("</metric>\n");
    }

    void endPrintNounNode(NounTreeletNode nounTreeletNode, PrintWriter printWriter) {
        printWriter.print("</noun>\n");
    }
}

