/*
 * Decompiled with CFR 0.152.
 */
package oracle.dms.instrument;

import java.util.HashSet;
import java.util.Hashtable;
import oracle.dms.instrument.Descriptor;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.SensorDescriptor;

public class NounDescriptor
extends Descriptor {
    private Hashtable m_children = new Hashtable(31);
    private HashSet m_ancestorTypes = new HashSet(31);
    private HashSet m_parentTypes = new HashSet(31);
    private HashSet m_nouns = new HashSet(31);
    private boolean m_isTraceable = false;
    private volatile long m_lastUpdateTime = System.currentTimeMillis();

    public NounDescriptor(String string) {
        super(string);
        this.setTraceable();
    }

    public SensorDescriptor getSensorDescriptor(String string) {
        return (SensorDescriptor)this.m_children.get(string);
    }

    public void addSensorDescriptor(SensorDescriptor sensorDescriptor) {
        if (sensorDescriptor == null) {
            return;
        }
        if (this.m_children.put(sensorDescriptor.getName(), sensorDescriptor) == null) {
            this.m_lastUpdateTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getSensorNames() {
        String[] stringArray = null;
        Hashtable hashtable = this.m_children;
        synchronized (hashtable) {
            stringArray = new String[this.m_children.size()];
            this.m_children.keySet().toArray(stringArray);
        }
        return stringArray;
    }

    public int getSensorCount() {
        return this.m_children.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAncestorTypes() {
        String[] stringArray = null;
        HashSet hashSet = this.m_ancestorTypes;
        synchronized (hashSet) {
            stringArray = new String[this.m_ancestorTypes.size()];
            this.m_ancestorTypes.toArray(stringArray);
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAncestorCount() {
        HashSet hashSet = this.m_ancestorTypes;
        synchronized (hashSet) {
            return this.m_ancestorTypes.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getParentTypes() {
        String[] stringArray = null;
        HashSet hashSet = this.m_parentTypes;
        synchronized (hashSet) {
            stringArray = new String[this.m_parentTypes.size()];
            this.m_parentTypes.toArray(stringArray);
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getParentCount() {
        HashSet hashSet = this.m_parentTypes;
        synchronized (hashSet) {
            return this.m_parentTypes.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addAncestorTypes(Noun noun) {
        if (noun == null) {
            return;
        }
        NounDescriptor nounDescriptor = null;
        boolean bl = false;
        Noun noun2 = Noun.getRoot();
        while (noun != noun2) {
            nounDescriptor = noun.getDescriptor();
            if (nounDescriptor != null) {
                HashSet hashSet = this.m_ancestorTypes;
                synchronized (hashSet) {
                    bl |= this.m_ancestorTypes.addAll(nounDescriptor.m_ancestorTypes);
                    bl |= this.m_ancestorTypes.addAll(nounDescriptor.m_parentTypes);
                }
                hashSet = this.m_parentTypes;
                synchronized (hashSet) {
                }
                if (bl |= this.m_parentTypes.add(noun.getType())) {
                    this.m_lastUpdateTime = System.currentTimeMillis();
                }
                return;
            }
            noun = noun.getParent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNoun(Noun noun) {
        if (noun == null) {
            return;
        }
        HashSet hashSet = this.m_nouns;
        synchronized (hashSet) {
            this.m_nouns.add(noun);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeNoun(Noun noun) {
        if (noun == null) {
            return false;
        }
        HashSet hashSet = this.m_nouns;
        synchronized (hashSet) {
            return this.m_nouns.remove(noun);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNounCount() {
        HashSet hashSet = this.m_nouns;
        synchronized (hashSet) {
            return this.m_nouns.size();
        }
    }

    public boolean isTraceable() {
        return this.m_isTraceable;
    }

    public void setTraceable(boolean bl) {
        this.m_isTraceable = bl;
    }

    private void setTraceable() {
        String string = this.getName();
        if (string.startsWith("oc4j_url") || string.startsWith("oc4j_servlet") || string.startsWith("oc4j_ejb") || string.startsWith("oc4j_jsp(") || string.startsWith("JDBC_")) {
            this.setTraceable(true);
        } else {
            this.setTraceable(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Noun[] getNouns() {
        Noun[] nounArray;
        HashSet hashSet = this.m_nouns;
        synchronized (hashSet) {
            nounArray = new Noun[this.m_nouns.size()];
            this.m_nouns.toArray(nounArray);
        }
        return nounArray;
    }

    public void setLastUpdateTime(long l) {
        this.m_lastUpdateTime = l;
    }

    public long getLastUpdateTime() {
        return this.m_lastUpdateTime;
    }
}

