/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.apm.APMUtils;
import com.eg.apm.JavaBTMOffloadLogger;
import com.eg.jtm.PropsManager;
import com.eg.jtm.URLPatternData;
import com.eg.jtm.URLPatternMeasure;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public final class UPDManager {
    private Hashtable<String, URLPatternData> UPDTblWC1_AUTO = new Hashtable();
    private Hashtable<String, URLPatternData> UPDTblWC2_AUTO = new Hashtable();
    private Hashtable<String, URLPatternMeasure> UPMTblTC_AUTO = new Hashtable();
    private boolean workingCopy1_isProcessing_auto = false;
    private Hashtable<String, URLPatternData> UPDTblWC1_MANUAL = new Hashtable();
    private Hashtable<String, URLPatternData> UPDTblWC2_MANUAL = new Hashtable();
    private Hashtable<String, URLPatternMeasure> UPMTblTC_MANUAL = new Hashtable();
    private boolean workingCopy1_isProcessing_manual = false;
    private ArrayList previousAutoFilteredPatternList = new ArrayList();
    private ArrayList previousManualFilteredPatternList = new ArrayList();
    public Hashtable<String, String> manualPatternTable = new Hashtable();
    public Hashtable<String, String> autoPatternTable = new Hashtable();
    private Hashtable<String, URLPatternMeasure> UPMTblTC_SUMMARY = new Hashtable();
    private Hashtable<String, Integer> unModifiedPatterns = new Hashtable();
    private long lastCleanUpTime = System.currentTimeMillis();
    private boolean isValidPattern = true;
    private static String loggerDispStr = "[UPDManager]";
    PropsManager propsManager;

    public UPDManager(PropsManager propsManager) {
        this.propsManager = propsManager;
        this.updateTables4Summary();
    }

    public void updateKeyPatternData(String patternsString) {
        ArrayList<String> currentPatternsList = new ArrayList<String>();
        Hashtable<String, String> manualPatterns = new Hashtable<String, String>();
        if (patternsString != null) {
            if (patternsString.equalsIgnoreCase("none")) {
                this.setValidPattern(false);
            } else {
                String[] patterns = patternsString.split(",");
                if (patterns.length != 0) {
                    String[] stringArray = patterns;
                    int n = patterns.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String pattern = stringArray[n2];
                        String[] patternNameAndStr = pattern.split(":");
                        String patternName = patternNameAndStr[0].trim();
                        String patternValue = patternNameAndStr[1].trim();
                        currentPatternsList.add(patternName);
                        manualPatterns.put(patternName, patternValue);
                        ++n2;
                    }
                    if (manualPatterns.size() > 0) {
                        this.isValidPattern = true;
                    } else {
                        this.setValidPattern(false);
                    }
                }
            }
        } else {
            this.setValidPattern(false);
        }
        if (this.isValidPattern) {
            Hashtable cloneTable = (Hashtable)this.manualPatternTable.clone();
            Enumeration patternEnum = cloneTable.keys();
            this.setValidPattern(true);
            while (patternEnum.hasMoreElements()) {
                String pName = (String)patternEnum.nextElement();
                this.removeManualPatternData(pName);
            }
            int initialManualPatternSize = this.manualPatternTable.size();
            int k = 0;
            while (k < currentPatternsList.size()) {
                String currentPattern = (String)currentPatternsList.get(k);
                if (initialManualPatternSize < this.propsManager.getMaxLimit4ManualGroupedURL()) {
                    String patternValue = (String)manualPatterns.get(currentPattern);
                    JavaBTMOffloadLogger.btmOffLoadLogger.info("{} Updating Key Pattern : {}  with its value : {} ", new Object[]{loggerDispStr, currentPattern, patternValue});
                    this.manualPatternTable.put(currentPattern, patternValue);
                    ++initialManualPatternSize;
                } else {
                    JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Could not be added the Pattern {} Since max grouped URL limit is reached {} ", new Object[]{loggerDispStr, currentPattern, this.propsManager.getMaxLimit4ManualGroupedURL()});
                }
                ++k;
            }
        }
        this.updateTables4Manual();
        currentPatternsList.clear();
        currentPatternsList = null;
        manualPatterns.clear();
        manualPatterns = null;
    }

    public void setValidPattern(boolean isValidPattern) {
        if (!isValidPattern) {
            this.manualPatternTable.clear();
            this.UPDTblWC1_MANUAL.clear();
            this.UPDTblWC2_MANUAL.clear();
            this.UPMTblTC_MANUAL.clear();
        }
    }

    public void updateAutoFilteredPatternsTbl(String patternsString) {
        if (!patternsString.equalsIgnoreCase("None") && patternsString.trim().length() != 0) {
            if (this.previousAutoFilteredPatternList.contains(patternsString)) {
                JavaBTMOffloadLogger.btmOffLoadLogger.info("{} Both current Filtered Pattern and Previous Filterd Patterns are Same", (Object)loggerDispStr);
            } else {
                String[] patterns;
                this.propsManager.autoFilteredPatternsList.clear();
                String[] stringArray = patterns = patternsString.split(",");
                int n = patterns.length;
                int n2 = 0;
                while (n2 < n) {
                    String pattern = stringArray[n2];
                    this.propsManager.autoFilteredPatternsList.add(pattern.trim());
                    ++n2;
                }
                this.previousAutoFilteredPatternList.clear();
                this.previousAutoFilteredPatternList.add(patternsString);
            }
        }
    }

    public void updateManualFilteredPatternsTbl(String patternsString) {
        if (!patternsString.equalsIgnoreCase("None") && patternsString.trim().length() != 0) {
            if (this.previousManualFilteredPatternList.contains(patternsString)) {
                JavaBTMOffloadLogger.btmOffLoadLogger.info("{} Both current Filtered Pattern and Previous Filterd Patterns are Same", (Object)loggerDispStr);
            } else {
                String[] patterns;
                this.propsManager.manualFilteredPatternsList.clear();
                String[] stringArray = patterns = patternsString.split(",");
                int n = patterns.length;
                int n2 = 0;
                while (n2 < n) {
                    String pattern = stringArray[n2];
                    this.propsManager.manualFilteredPatternsList.add(pattern.trim());
                    ++n2;
                }
                this.previousManualFilteredPatternList.clear();
                this.previousManualFilteredPatternList.add(patternsString);
            }
        }
    }

    public Hashtable getUPDTblWC(boolean keyTransaction) {
        if (keyTransaction) {
            if (this.workingCopy1_isProcessing_manual) {
                return this.UPDTblWC2_MANUAL;
            }
            return this.UPDTblWC1_MANUAL;
        }
        if (this.workingCopy1_isProcessing_auto) {
            return this.UPDTblWC2_AUTO;
        }
        return this.UPDTblWC1_AUTO;
    }

    private Hashtable getUPMTablesAutoTC() {
        return this.UPMTblTC_AUTO;
    }

    private Hashtable getUPMTablesManualTC() {
        return this.UPMTblTC_MANUAL;
    }

    public void updateTransmitCopy4Auto() {
        URLPatternMeasure summaryPatternUPM = this.UPMTblTC_SUMMARY.get("SUMMARY_PATTERN");
        if (this.workingCopy1_isProcessing_auto) {
            this.workingCopy1_isProcessing_auto = false;
            Set<String> workingCopy2Keys = this.autoPatternTable.keySet();
            for (String workingCopy2Pattern : workingCopy2Keys) {
                URLPatternData UPD = this.UPDTblWC2_AUTO.remove(workingCopy2Pattern);
                this.UPDTblWC2_AUTO.put(workingCopy2Pattern, new URLPatternData(workingCopy2Pattern, this.propsManager));
                if (UPD.modified) {
                    URLPatternMeasure UPM = this.UPMTblTC_AUTO.get(workingCopy2Pattern);
                    UPM.update(UPD, summaryPatternUPM, true);
                    this.unModifiedPatterns.remove(workingCopy2Pattern);
                    UPD = null;
                    continue;
                }
                UPD = null;
                Integer countObject = this.unModifiedPatterns.get(workingCopy2Pattern);
                if (countObject != null) {
                    countObject = countObject + 1;
                    this.unModifiedPatterns.put(workingCopy2Pattern, countObject);
                    continue;
                }
                this.unModifiedPatterns.put(workingCopy2Pattern, new Integer(1));
            }
        } else {
            this.workingCopy1_isProcessing_auto = true;
            Set<String> workingCopy1Keys = this.autoPatternTable.keySet();
            for (String workingCopy1Pattern : workingCopy1Keys) {
                URLPatternData UPD = this.UPDTblWC1_AUTO.remove(workingCopy1Pattern);
                this.UPDTblWC1_AUTO.put(workingCopy1Pattern, new URLPatternData(workingCopy1Pattern, this.propsManager));
                if (UPD.modified) {
                    URLPatternMeasure UPM = this.UPMTblTC_AUTO.get(workingCopy1Pattern);
                    UPM.update(UPD, summaryPatternUPM, true);
                    this.unModifiedPatterns.remove(workingCopy1Pattern);
                    UPD = null;
                    continue;
                }
                UPD = null;
                Integer countObject = this.unModifiedPatterns.get(workingCopy1Pattern);
                if (countObject != null) {
                    countObject = countObject + 1;
                    this.unModifiedPatterns.put(workingCopy1Pattern, countObject);
                    continue;
                }
                this.unModifiedPatterns.put(workingCopy1Pattern, new Integer(1));
            }
        }
    }

    public void updateTransmitCopy4Manual() {
        URLPatternMeasure summaryPatternUPM = this.UPMTblTC_SUMMARY.get("SUMMARY_PATTERN");
        if (this.workingCopy1_isProcessing_manual) {
            this.workingCopy1_isProcessing_manual = false;
            Set<String> workingCopy2Keys = this.manualPatternTable.keySet();
            for (String workingCopy2Pattern : workingCopy2Keys) {
                URLPatternData UPD = this.UPDTblWC2_MANUAL.remove(workingCopy2Pattern);
                this.UPDTblWC2_MANUAL.put(workingCopy2Pattern, new URLPatternData(workingCopy2Pattern, this.propsManager));
                if (UPD.modified) {
                    URLPatternMeasure UPM = this.UPMTblTC_MANUAL.get(workingCopy2Pattern);
                    UPM.update(UPD, summaryPatternUPM, false);
                }
                UPD = null;
            }
        } else {
            this.workingCopy1_isProcessing_manual = true;
            Set<String> workingCopy1Keys = this.manualPatternTable.keySet();
            for (String workingCopy1Pattern : workingCopy1Keys) {
                URLPatternData UPD = this.UPDTblWC1_MANUAL.remove(workingCopy1Pattern);
                this.UPDTblWC1_MANUAL.put(workingCopy1Pattern, new URLPatternData(workingCopy1Pattern, this.propsManager));
                if (UPD.modified) {
                    URLPatternMeasure UPM = this.UPMTblTC_MANUAL.get(workingCopy1Pattern);
                    UPM.update(UPD, summaryPatternUPM, false);
                }
                UPD = null;
            }
        }
    }

    public void updateTables4Auto() {
        Enumeration<String> patternEnum = this.autoPatternTable.keys();
        while (patternEnum.hasMoreElements()) {
            String pName = patternEnum.nextElement();
            this.updateTblWC4Auto(pName, null);
            this.updateTblTC4Auto(pName, null);
        }
    }

    public void updateTables4Summary() {
        URLPatternMeasure summaryUPM = new URLPatternMeasure(this.propsManager);
        this.UPMTblTC_SUMMARY.put("SUMMARY_PATTERN", summaryUPM);
    }

    private void updateTblWC4Auto(String pName, String pStr) {
        URLPatternData UPD = this.UPDTblWC1_AUTO.get(pName);
        if (UPD == null) {
            UPD = new URLPatternData(pName, this.propsManager);
            this.UPDTblWC1_AUTO.put(pName, UPD);
        }
        if ((UPD = this.UPDTblWC2_AUTO.get(pName)) == null) {
            UPD = new URLPatternData(pName, this.propsManager);
            this.UPDTblWC2_AUTO.put(pName, UPD);
        }
    }

    private void updateTblTC4Auto(String pName, String pStr) {
        URLPatternMeasure UPM = this.UPMTblTC_AUTO.get(pName);
        if (UPM == null) {
            UPM = new URLPatternMeasure(pName, this.propsManager);
            this.UPMTblTC_AUTO.put(pName, UPM);
        }
    }

    public void updateTables4Manual() {
        Enumeration<String> patternEnum = this.manualPatternTable.keys();
        while (patternEnum.hasMoreElements()) {
            String pName = patternEnum.nextElement();
            this.updateTblWC4Manual(pName, null);
            this.updateTblTC4Manual(pName, null);
        }
    }

    private void updateTblTC4Manual(String pName, String pStr) {
        URLPatternMeasure UPM = this.UPMTblTC_MANUAL.get(pName);
        if (UPM == null) {
            UPM = new URLPatternMeasure(pName, this.propsManager);
            this.UPMTblTC_MANUAL.put(pName, UPM);
        }
    }

    private void updateTblWC4Manual(String pName, String pStr) {
        URLPatternData UPD = this.UPDTblWC1_MANUAL.get(pName);
        if (UPD == null) {
            UPD = new URLPatternData(pName, this.propsManager);
            this.UPDTblWC1_MANUAL.put(pName, UPD);
        }
        if ((UPD = this.UPDTblWC2_MANUAL.get(pName)) == null) {
            UPD = new URLPatternData(pName, this.propsManager);
            this.UPDTblWC2_MANUAL.put(pName, UPD);
        }
    }

    private void removeAutoPatternData(String pName) {
        this.autoPatternTable.remove(pName);
        this.UPDTblWC1_AUTO.remove(pName);
        this.UPDTblWC2_AUTO.remove(pName);
        this.UPMTblTC_AUTO.remove(pName);
    }

    private void removeManualPatternData(String pName) {
        this.manualPatternTable.remove(pName);
        this.UPDTblWC1_MANUAL.remove(pName);
        this.UPDTblWC2_MANUAL.remove(pName);
        this.UPMTblTC_MANUAL.remove(pName);
    }

    public long getRASwitchOverCutoff() {
        return this.propsManager.RASwitchOverCutoff;
    }

    /*
     * Unable to fully structure code
     */
    public Hashtable getMeasures(boolean discard, String entityName) {
        mainMeasure = new Hashtable();
        try {
            block49: {
                block45: {
                    block46: {
                        block48: {
                            block47: {
                                mainMeasureHT = new Hashtable<String, Hashtable>();
                                patternEntryList = null;
                                errorPatternEntryList = null;
                                patternCount = 0;
                                if (!entityName.equals("BusinessTransTest")) break block45;
                                patternSize = this.autoPatternTable.size();
                                if (patternSize <= this.propsManager.getMaxLimit4AutoGroupedURL()) break block46;
                                if (!discard) break block47;
                                patsEnum = this.autoPatternTable.keys();
                                while (patsEnum.hasMoreElements()) {
                                    pName = patsEnum.nextElement();
                                    UPM = (URLPatternMeasure)this.getUPMTablesAutoTC().get(pName);
                                    if (UPM == null) continue;
                                    cloneCopy = UPM.getMeasureTbl();
                                    cloneCopy = null;
                                }
                                break block48;
                            }
                            patsEnum = this.autoPatternTable.keys();
                            patternTable = new Hashtable<String, Double>();
                            errorPatternTable = new Hashtable<String, Double>();
                            JavaBTMOffloadLogger.btmOffLoadLogger.info("{} Deciding Top 'N' Patterns from the pattern list of {}", (Object)UPDManager.loggerDispStr, (Object)this.autoPatternTable.size());
                            while (patsEnum.hasMoreElements()) {
                                pName = patsEnum.nextElement();
                                UPM = (URLPatternMeasure)this.getUPMTablesAutoTC().get(pName);
                                errorURLExists = UPM.isErrorURLExists();
                                averageResponseTime = UPM.getAverageResponseTime();
                                if (errorURLExists) {
                                    errorPatternTable.put(pName, averageResponseTime);
                                    continue;
                                }
                                patternTable.put(pName, averageResponseTime);
                            }
                            errorPatternEntryList = new ArrayList<Map.Entry<K, V>>(errorPatternTable.entrySet());
                            patternEntryList = new ArrayList<Map.Entry<K, V>>(patternTable.entrySet());
                            Collections.sort(errorPatternEntryList, new Comparator(){

                                public int compare(Object o1, Object o2) {
                                    Map.Entry e1 = (Map.Entry)o1;
                                    Map.Entry e2 = (Map.Entry)o2;
                                    Double first = (Double)e1.getValue();
                                    Double second = (Double)e2.getValue();
                                    return second.compareTo(first);
                                }
                            });
                            JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} No. of Patterns with Error URLs - {} ", (Object)UPDManager.loggerDispStr, errorPatternEntryList);
                            errorPatternsize = errorPatternEntryList.size();
                            maxLimit = this.propsManager.getMaxLimit4AutoGroupedURL();
                            if (errorPatternsize >= maxLimit) {
                                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} No. of Patterns with Error URLs MaxLimit {}  is reached, So discarding remaining Gropued URLs", (Object)UPDManager.loggerDispStr, (Object)maxLimit);
                            } else {
                                Collections.sort(patternEntryList, new Comparator(){

                                    public int compare(Object o1, Object o2) {
                                        Map.Entry e1 = (Map.Entry)o1;
                                        Map.Entry e2 = (Map.Entry)o2;
                                        Double first = (Double)e1.getValue();
                                        Double second = (Double)e2.getValue();
                                        return second.compareTo(first);
                                    }
                                });
                                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Grouped URL's are sorted based on the avg.response time. Sorted list is : {} ", (Object)UPDManager.loggerDispStr, patternEntryList);
                            }
                            dataDiscard = false;
                            k = 0;
                            while (k < errorPatternsize) {
                                entry = errorPatternEntryList.get(k);
                                patternName = (String)entry.getKey();
                                UPM = (URLPatternMeasure)this.getUPMTablesAutoTC().get(patternName);
                                if (UPM == null) ** GOTO lbl69
                                cloneCopy = UPM.getMeasureTbl();
                                if (dataDiscard) {
                                    try {
                                        cloneCopy.clear();
                                        cloneCopy = null;
                                    }
                                    catch (Exception var20_30) {}
                                } else {
                                    if (cloneCopy != null) {
                                        mainMeasureHT.put(patternName, cloneCopy);
                                        ++patternCount;
                                    } else {
                                        JavaBTMOffloadLogger.btmOffLoadLogger.info("{} {} -> No data to transmit.......", (Object)UPDManager.loggerDispStr, (Object)patternName);
                                    }
lbl69:
                                    // 3 sources

                                    if (patternCount >= this.propsManager.getMaxLimit4AutoGroupedURL()) {
                                        dataDiscard = true;
                                    }
                                }
                                ++k;
                            }
                            asize = patternEntryList.size();
                            k = 0;
                            while (k < asize) {
                                entry = patternEntryList.get(k);
                                patternName = (String)entry.getKey();
                                UPM = (URLPatternMeasure)this.getUPMTablesAutoTC().get(patternName);
                                if (UPM == null) ** GOTO lbl94
                                cloneCopy = UPM.getMeasureTbl();
                                if (dataDiscard) {
                                    try {
                                        cloneCopy.clear();
                                        cloneCopy = null;
                                    }
                                    catch (Exception var21_32) {}
                                } else {
                                    if (cloneCopy != null) {
                                        mainMeasureHT.put(patternName, cloneCopy);
                                        ++patternCount;
                                    } else {
                                        JavaBTMOffloadLogger.btmOffLoadLogger.info("{} {} -> No data to transmit.......", (Object)UPDManager.loggerDispStr, (Object)patternName);
                                    }
lbl94:
                                    // 3 sources

                                    if (patternCount >= this.propsManager.getMaxLimit4AutoGroupedURL()) {
                                        dataDiscard = true;
                                    }
                                }
                                ++k;
                            }
                        }
                        summaryPattern = this.UPMTblTC_SUMMARY.get("SUMMARY_PATTERN");
                        if (summaryPattern == null) break block49;
                        cloneCopy = summaryPattern.getSummaryMeasures();
                        if (discard) {
                            cloneCopy = null;
                        } else if (cloneCopy != null) {
                            mainMeasureHT.put("SUMMARY_PATTERN", cloneCopy);
                            JavaBTMOffloadLogger.btmOffLoadLogger.info("{} Included summary about total transactions", (Object)UPDManager.loggerDispStr);
                        } else {
                            JavaBTMOffloadLogger.btmOffLoadLogger.info("{} {} -> No data to transmit.......", (Object)UPDManager.loggerDispStr, (Object)"SUMMARY_PATTERN");
                        }
                        break block49;
                    }
                    patsEnum = this.autoPatternTable.keys();
                    while (patsEnum.hasMoreElements()) {
                        pName = patsEnum.nextElement();
                        UPM = (URLPatternMeasure)this.getUPMTablesAutoTC().get(pName);
                        if (UPM != null) {
                            cloneCopy = UPM.getMeasureTbl();
                            if (discard) {
                                cloneCopy = null;
                                continue;
                            }
                            if (cloneCopy != null) {
                                mainMeasureHT.put(pName, cloneCopy);
                                continue;
                            }
                            JavaBTMOffloadLogger.btmOffLoadLogger.info("{} {} -> No data to transmit.......", (Object)UPDManager.loggerDispStr, (Object)pName);
                            continue;
                        }
                        JavaBTMOffloadLogger.btmOffLoadLogger.info("{} Mismatch between current pattern list and pattern measure data. No data found for pattern : {} ", (Object)UPDManager.loggerDispStr, (Object)pName);
                    }
                    summaryPattern = this.UPMTblTC_SUMMARY.get("SUMMARY_PATTERN");
                    if (summaryPattern == null) break block49;
                    cloneCopy = summaryPattern.getSummaryMeasures();
                    if (discard) {
                        cloneCopy = null;
                    } else if (cloneCopy != null) {
                        mainMeasureHT.put("SUMMARY_PATTERN", cloneCopy);
                        JavaBTMOffloadLogger.btmOffLoadLogger.info("{} Included summary about total transactions", (Object)UPDManager.loggerDispStr);
                    } else {
                        JavaBTMOffloadLogger.btmOffLoadLogger.info("{} {} -> No data to transmit.......", (Object)UPDManager.loggerDispStr, (Object)"SUMMARY_PATTERN");
                    }
                    break block49;
                }
                if (entityName.equals("KBusinessTransTest")) {
                    patsEnum = this.manualPatternTable.keys();
                    while (patsEnum.hasMoreElements()) {
                        pName = patsEnum.nextElement();
                        UPM = (URLPatternMeasure)this.getUPMTablesManualTC().get(pName);
                        if (UPM != null) {
                            cloneCopy = UPM.getMeasureTbl();
                            if (discard) {
                                cloneCopy = null;
                                continue;
                            }
                            if (cloneCopy != null) {
                                mainMeasureHT.put(pName, cloneCopy);
                                continue;
                            }
                            JavaBTMOffloadLogger.btmOffLoadLogger.info("{} {} -> No data to transmit.......", (Object)UPDManager.loggerDispStr, (Object)pName);
                            continue;
                        }
                        JavaBTMOffloadLogger.btmOffLoadLogger.info("{} Mismatch between current pattern list and pattern measure data. No data found for pattern : {} ", (Object)UPDManager.loggerDispStr, (Object)pName);
                    }
                }
            }
            if (!discard) {
                JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} mainMeasureHT : {}", (Object)UPDManager.loggerDispStr, mainMeasureHT);
                mainMeasure = (Hashtable)mainMeasureHT.clone();
            }
            if (mainMeasureHT != null) {
                mainMeasureHT.clear();
                mainMeasureHT = null;
            }
            if (patternEntryList != null && patternCount < patternEntryList.size()) {
                k = patternCount;
                while (k < patternEntryList.size()) {
                    entry = (Map.Entry)patternEntryList.get(k);
                    patternName = (String)entry.getKey();
                    UPM = (URLPatternMeasure)this.getUPMTablesAutoTC().get(patternName);
                    if (UPM != null) {
                        cloneCopy = UPM.getMeasureTbl();
                        cloneCopy = null;
                    }
                    ++k;
                }
            }
        }
        catch (Exception e) {
            JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Exception sending data back to agent. {}", (Object)UPDManager.loggerDispStr, (Object)e);
        }
        return mainMeasure;
    }

    public void setNoOfURLSegments(String urlLevel) {
        boolean modified;
        block5: {
            int currentLevel = this.propsManager.getURLLevel();
            modified = false;
            try {
                int level = Integer.parseInt(urlLevel);
                if (level <= 0) {
                    level = 3;
                }
                if (currentLevel != level) {
                    this.propsManager.setURLLevel(level);
                    modified = true;
                }
            }
            catch (NumberFormatException nfe) {
                if (currentLevel == 3) break block5;
                this.propsManager.setURLLevel(3);
                modified = true;
            }
        }
        if (modified) {
            this.removeAutoPatternData(this.propsManager.getURLLevel());
        }
    }

    private void removeAutoPatternData(int urlLevel) {
        Hashtable cloneTable = (Hashtable)this.autoPatternTable.clone();
        Enumeration patternEnum = cloneTable.keys();
        while (patternEnum.hasMoreElements()) {
            String pName = (String)patternEnum.nextElement();
            this.removeAutoPatternData(pName);
        }
    }

    public void clearStoredData() {
        this.UPDTblWC1_AUTO.clear();
        this.UPDTblWC2_AUTO.clear();
        this.UPMTblTC_AUTO.clear();
        this.UPDTblWC1_AUTO = new Hashtable();
        this.UPDTblWC2_AUTO = new Hashtable();
        this.UPMTblTC_AUTO = new Hashtable();
        this.autoPatternTable.clear();
        this.UPDTblWC1_MANUAL.clear();
        this.UPDTblWC2_MANUAL.clear();
        this.UPMTblTC_MANUAL.clear();
        this.UPDTblWC1_MANUAL = new Hashtable();
        this.UPDTblWC2_MANUAL = new Hashtable();
        this.UPMTblTC_MANUAL = new Hashtable();
        this.manualPatternTable.clear();
        this.UPMTblTC_SUMMARY.clear();
        this.updateTables4Summary();
    }

    public void clearStoredDataForBusinessTransTest() {
        this.UPDTblWC1_AUTO.clear();
        this.UPDTblWC2_AUTO.clear();
        this.UPMTblTC_AUTO.clear();
        this.UPDTblWC1_AUTO = new Hashtable();
        this.UPDTblWC2_AUTO = new Hashtable();
        this.UPMTblTC_AUTO = new Hashtable();
        this.autoPatternTable.clear();
    }

    public void clearStoredDataForKbusinessTransTest() {
        this.UPDTblWC1_MANUAL.clear();
        this.UPDTblWC2_MANUAL.clear();
        this.UPMTblTC_MANUAL.clear();
        this.UPDTblWC1_MANUAL = new Hashtable();
        this.UPDTblWC2_MANUAL = new Hashtable();
        this.UPMTblTC_MANUAL = new Hashtable();
        this.manualPatternTable.clear();
    }

    public void cleanupDeadPatterns() {
        long maxWaitTime;
        long currentTime;
        long diff;
        if (this.unModifiedPatterns != null && this.unModifiedPatterns.size() > 0 && (diff = (currentTime = APMUtils.getTimeStamp()) - this.lastCleanUpTime) > (maxWaitTime = 2L * this.propsManager.getEgMeasPeriod())) {
            long measTimeInMinutes = this.propsManager.getEgMeasPeriod() / 1000L / 60L;
            int maxSnapShotCount = (int)(2L * measTimeInMinutes);
            Set<String> deadKeys = this.unModifiedPatterns.keySet();
            Iterator<String> deadKeyItr = deadKeys.iterator();
            while (deadKeyItr.hasNext()) {
                String deadPattern = deadKeyItr.next();
                Integer value = this.unModifiedPatterns.get(deadPattern);
                if (value < maxSnapShotCount) continue;
                this.removeAutoPatternData(deadPattern);
                deadKeyItr.remove();
                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Since the pattern {} is not active, so removed", (Object)loggerDispStr, (Object)deadPattern);
            }
            this.lastCleanUpTime = currentTime;
        }
    }
}

