/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

public class StringMaker {
    private String value;
    private String indexing;
    private int begin;
    private int end;

    public StringMaker(String string) {
        this.value = string;
        this.indexing = string;
        this.end = string.length();
    }

    private StringMaker(String string, int n, int n2) {
        this.value = string;
        this.indexing = string;
        this.begin = n;
        this.end = n2;
    }

    public StringMaker lower() {
        this.indexing = this.indexing.toLowerCase();
        return this;
    }

    public StringMaker upper() {
        this.indexing = this.indexing.toUpperCase();
        return this;
    }

    public StringMaker reset() {
        this.indexing = this.value;
        return this;
    }

    public StringMaker after(char c) {
        int n = this.indexing.indexOf(c, this.begin);
        if (n < 0 || n > this.end) {
            return this;
        }
        this.begin = n + 1 > this.end ? this.end : n + 1;
        return this;
    }

    public StringMaker after(String string) {
        int n = this.indexing.indexOf(string, this.begin);
        if (n < 0 || n > this.end) {
            return this;
        }
        this.begin = n + string.length() > this.end ? this.end : n + string.length();
        return this;
    }

    public StringMaker before(char c) {
        int n = this.indexing.indexOf(c, this.begin);
        if (n < 0 || n > this.end) {
            return this;
        }
        this.end = n < this.begin ? this.begin : n;
        return this;
    }

    public StringMaker before(char c, char c2) {
        int n = this.indexOf(c, c2);
        if (n < 0 || n > this.end) {
            return this;
        }
        this.end = n < this.begin ? this.begin : n;
        return this;
    }

    private int indexOf(char c, char c2) {
        for (int i = this.begin; i < this.indexing.length(); ++i) {
            char c3 = this.indexing.charAt(i);
            if (c3 != c && c3 != c2) continue;
            return i;
        }
        return -1;
    }

    public StringMaker before(String string) {
        int n = this.indexing.indexOf(string, this.begin);
        if (n < 0 || n > this.end) {
            return this;
        }
        this.end = n < this.begin ? this.begin : n;
        return this;
    }

    public StringMaker afterLast(char c) {
        int n = this.indexing.lastIndexOf(c, this.end);
        if (n < this.begin) {
            return this;
        }
        this.begin = n + 1 > this.end ? this.end : n + 1;
        return this;
    }

    public int getBeginIndex() {
        return this.begin;
    }

    public int getEndIndex() {
        return this.end;
    }

    public StringMaker afterLast(char c, char c2) {
        int n = this.lastIndexOf(this.indexing, this.end, c, c2);
        if (n < this.begin) {
            return this;
        }
        this.begin = n + 1 > this.end ? this.end : n + 1;
        return this;
    }

    int lastIndexOf(String string, int n, char c, char c2) {
        for (int i = n; i >= this.begin; --i) {
            char c3 = string.charAt(i - 1);
            if (c != c3 && c2 != c3) continue;
            return i - 1;
        }
        return -1;
    }

    public StringMaker afterLast(String string) {
        int n = this.indexing.lastIndexOf(string, this.end);
        if (n < this.begin) {
            return this;
        }
        this.begin = n + string.length() > this.end ? this.end : n + string.length();
        return this;
    }

    public StringMaker beforeLast(char c) {
        int n = this.indexing.lastIndexOf(c, this.end);
        if (n < this.begin) {
            return this;
        }
        this.end = n;
        return this;
    }

    public StringMaker beforeLast(char c, char c2) {
        int n = this.lastIndexOf(this.indexing, this.end, c, c2);
        if (n < this.begin) {
            return this;
        }
        this.end = n;
        return this;
    }

    public StringMaker beforeLast(String string) {
        int n = this.indexing.lastIndexOf(string, this.end);
        if (n < this.begin) {
            return this;
        }
        this.end = n;
        return this;
    }

    public StringMaker prev() {
        this.end = this.begin;
        this.begin = 0;
        return this;
    }

    public StringMaker next() {
        this.begin = this.end;
        this.end = this.indexing.length();
        return this;
    }

    public StringMaker clear() {
        this.begin = 0;
        this.end = this.indexing.length();
        return this;
    }

    public boolean isEmpty() {
        return this.begin == this.end;
    }

    public String value() {
        return this.value.substring(this.begin, this.end);
    }

    public StringMaker duplicate() {
        return new StringMaker(this.value, this.begin, this.end);
    }

    public String toString() {
        return this.value();
    }
}

