/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.BaseDatabaseInfo;
import com.eg.jtm.OracleKeyValue;
import com.eg.jtm.OracleNetConnectionDescriptorParser;
import com.eg.jtm.StringMaker;
import com.eg.org.slf4j.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDatabaseInfo
extends BaseDatabaseInfo {
    private static final String URL_PREFIX = "jdbc:oracle:";
    private static final String DATADIRECT_URL_PREFIX = "jdbc:datadirect:oracle://";
    private boolean isUrlRAC = false;
    private static final String DEFAULT_PORT = "1521";
    private List<HashMap<String, String>> hostList = null;

    public OracleDatabaseInfo(String jdbcUrl, String dbType, Logger logger) {
        super(jdbcUrl, dbType, logger);
    }

    @Override
    public Hashtable<String, String> getDBInfo() {
        this.parseUrl();
        Hashtable<String, String> OracleDetails = new Hashtable<String, String>();
        boolean parsingFailure = this.isParsingFailure();
        String dataBaseType = this.getDataBaseType();
        if (parsingFailure) {
            OracleDetails.put("SERVERTYPE", dataBaseType);
            OracleDetails.put("SERVERNAME", this.jdbcUrl);
            OracleDetails.put("DATABASENAME", "-");
            OracleDetails.put("PORTNUMBER", "-");
        } else {
            String dataBaseName = this.getDataBaseName();
            String hostName = this.getHostName();
            String portNo = this.getPortNo();
            String clusterDetailsString = null;
            List<HashMap<String, String>> hostList = this.getHostList();
            if (hostList != null) {
                StringBuffer clusterBuffer = new StringBuffer();
                int i = 0;
                while (i < hostList.size()) {
                    HashMap<String, String> hostDetailsMap = hostList.get(i);
                    String host = hostDetailsMap.get("host");
                    String port = hostDetailsMap.get("port");
                    if (port == null) {
                        port = DEFAULT_PORT;
                    }
                    clusterBuffer.append(host).append(":").append(port).append(",");
                    ++i;
                }
                clusterDetailsString = clusterBuffer.toString();
                if (clusterDetailsString.endsWith(",")) {
                    clusterDetailsString = clusterDetailsString.substring(0, clusterDetailsString.lastIndexOf(","));
                }
            }
            if (dataBaseName == null) {
                dataBaseName = "-";
            }
            if (hostName == null) {
                hostName = this.jdbcUrl;
            }
            if (portNo == null) {
                portNo = "-";
            }
            OracleDetails.put("SERVERTYPE", dataBaseType);
            OracleDetails.put("DATABASENAME", dataBaseName);
            if (hostList != null) {
                OracleDetails.put("SERVERNAME", clusterDetailsString);
            } else {
                OracleDetails.put("SERVERNAME", hostName);
            }
            OracleDetails.put("PORTNUMBER", portNo);
        }
        return OracleDetails;
    }

    private String getHostName() {
        return this.hostName;
    }

    private String getDataBaseType() {
        if (this.isUrlRAC && this.hostList != null && this.hostList.size() > 1) {
            return "Oracle_cluster_service";
        }
        return this.dbType;
    }

    private String getDataBaseName() {
        return this.databaseName;
    }

    private String getJdbcUrl() {
        return this.jdbcUrl;
    }

    private String getPortNo() {
        return this.portNo;
    }

    private boolean isCluterType() {
        return this.hostList != null && this.hostList.size() > 1;
    }

    private boolean isParsingFailure() {
        return this.isParsingFailure;
    }

    private List<HashMap<String, String>> getHostList() {
        return this.hostList;
    }

    private void parseUrl() {
        if (this.jdbcUrl == null) {
            this.logger.warn("[" + this.dbType + " - parseUrl] jdbcUrl must not be null");
            return;
        }
        String normalizedUrl = this.jdbcUrl.toLowerCase();
        StringMaker maker = new StringMaker(normalizedUrl);
        if (normalizedUrl.startsWith(URL_PREFIX)) {
            maker.after(URL_PREFIX).after(":");
            String description = maker.after('@').value().trim();
            this.logger.debug("[" + this.dbType + " - parseUrl] description :" + description);
            if (description.startsWith("(")) {
                this.isUrlRAC = true;
                this.parseNetConnectionUrl();
            } else {
                this.parseSimpleUrl(description);
            }
        } else if (normalizedUrl.startsWith(DATADIRECT_URL_PREFIX)) {
            maker.after(DATADIRECT_URL_PREFIX);
            this.parseWeblogicConnectionUrl(maker, DEFAULT_PORT);
            if (this.databaseName == null) {
                this.databaseName = "-";
            }
        }
    }

    private void parseSimpleUrl(String sourceString) {
        this.logger.debug("[" + this.dbType + " - parseSimpleUrl]- sourceString :" + sourceString);
        if (sourceString.startsWith("[")) {
            this.parseIPv6Url(sourceString);
            return;
        }
        if (sourceString.startsWith("///")) {
            this.hostName = "localhost";
            this.portNo = DEFAULT_PORT;
            this.databaseName = sourceString.substring(3);
            this.logger.debug("[" + this.dbType + " - parseSimpleUrl]-  hostName :" + this.hostName + "  " + this.portNo + "  " + this.databaseName);
            return;
        }
        if (sourceString.startsWith("//")) {
            sourceString = sourceString.substring(2);
        } else {
            int double_slash_index = sourceString.indexOf("//");
            int equal_index = sourceString.indexOf("=");
            if (equal_index > 0 || double_slash_index > 2) {
                this.isParsingFailure = true;
                this.logger.warn("[" + this.dbType + " - parseSimpleUrl] JDBC Url format is different, so not parsing , " + this.jdbcUrl);
                return;
            }
        }
        int slash_index = sourceString.lastIndexOf("/");
        if (slash_index > 0) {
            this.databaseName = sourceString.substring(slash_index + 1);
            sourceString = sourceString.substring(0, slash_index);
        } else {
            int last_colon_index = sourceString.lastIndexOf(":");
            if (last_colon_index > 0) {
                this.databaseName = sourceString.substring(last_colon_index + 1);
                sourceString = sourceString.substring(0, last_colon_index);
            } else {
                this.isParsingFailure = true;
                this.logger.warn("[" + this.dbType + " - parseSimpleUrl] JDBC Url format is different, so not parsing, " + this.jdbcUrl);
                return;
            }
        }
        int colon_index = sourceString.indexOf(":");
        if (colon_index == 0) {
            this.hostName = "localhost";
            this.portNo = sourceString.substring(1);
        } else if (colon_index > 0) {
            this.hostName = sourceString.substring(0, colon_index);
            this.portNo = sourceString.substring(colon_index + 1);
        } else {
            this.portNo = DEFAULT_PORT;
            this.hostName = sourceString;
        }
        this.logger.info("[" + this.dbType + " - parseSimpleUrl]- hostName :" + this.hostName + "  " + this.portNo + "  " + this.databaseName);
    }

    private void parseIPv6Url(String sourceString) {
        int last_colon;
        int end_index = sourceString.indexOf("]");
        if (end_index > 0) {
            this.hostName = sourceString.substring(0, end_index + 1);
            sourceString = sourceString.substring(end_index + 1);
        }
        if (sourceString.startsWith(":")) {
            sourceString = sourceString.substring(1);
        }
        if ((last_colon = sourceString.lastIndexOf(":")) > -1) {
            this.databaseName = sourceString.substring(last_colon + 1);
            sourceString = sourceString.substring(0, last_colon);
        } else {
            int slash_index = sourceString.lastIndexOf("/");
            if (slash_index > -1) {
                this.databaseName = sourceString.substring(slash_index + 1);
                sourceString = sourceString.substring(0, slash_index);
            }
        }
        this.portNo = sourceString != null && sourceString.length() > 0 ? sourceString : DEFAULT_PORT;
        this.logger.info("[" + this.dbType + " -  IPv6 Block]- hostName :" + this.hostName + "  " + this.portNo + "  " + this.databaseName);
    }

    private void parseList(String keyString, List<OracleKeyValue> keyValueList) {
        int t = 0;
        while (t < keyValueList.size()) {
            OracleKeyValue kv = keyValueList.get(t);
            String keyStr = kv.getKeyString();
            if (keyString.equals("address")) {
                HashMap<String, String> hostPortMap = new HashMap<String, String>();
                int k = 0;
                while (k < keyValueList.size()) {
                    OracleKeyValue addkv = keyValueList.get(k);
                    String addkeyStr = addkv.getKeyString();
                    String addvalueStr = addkv.getValueString();
                    if (addkeyStr.equals("host") || addkeyStr.equals("port")) {
                        hostPortMap.put(addkeyStr, addvalueStr);
                    }
                    ++k;
                }
                if (this.hostList == null) {
                    this.hostList = new ArrayList<HashMap<String, String>>();
                }
                this.hostList.add(hostPortMap);
                break;
            }
            String valueStr = kv.getValueString();
            if (valueStr == null) {
                this.parseList(keyStr, kv.getKeyValueList());
            }
            if (keyStr.equals("service_name") || keyStr.equals("sid")) {
                this.databaseName = valueStr;
            }
            ++t;
        }
    }

    private void parseNetConnectionUrl() {
        OracleNetConnectionDescriptorParser parser = new OracleNetConnectionDescriptorParser(this.jdbcUrl);
        OracleKeyValue keyValue = parser.parse();
        List<OracleKeyValue> list = keyValue.getKeyValueList();
        int size = list.size();
        int i = 0;
        while (i < size) {
            OracleKeyValue keyValuePair = list.get(i);
            String keyString = keyValuePair.getKeyString();
            String valueString = keyValuePair.getValueString();
            if (valueString == null) {
                List<OracleKeyValue> keyValueList = keyValuePair.getKeyValueList();
                this.parseList(keyString, keyValueList);
            }
            ++i;
        }
        if (this.hostList != null && this.hostList.size() == 1) {
            HashMap<String, String> hostPortMap = this.hostList.get(0);
            this.hostName = hostPortMap.get("host");
            this.portNo = hostPortMap.get("port");
            this.hostList = null;
        }
    }

    public static void main(String[] args) {
        String jdbcUrl = "jdbc:oracle:thin:@(DESCRIPTION = (ADDRESS = (PROTOCOL = TCP)(HOST = oraclehost1)(PORT = 1521))(ADDRESS = (PROTOCOL = TCP)(HOST = oraclehost2)(PORT = 1521)) (LOAD_BALANCE = yes)(CONNECT_DATA = (SERVER = DEDICATED)(SERVICE_NAME = REPORTER)))";
        jdbcUrl = "jdbc:oracle:thin:FCDBB001_PRD/fc3ldb#mmk!@(DESCRIPTION_LIST=(LOAD_BALANCE=off)(FAILOVER=on)(DESCRIPTION=(ADDRESS_LIST=(LOAD_BALANCE=on)(ADDRESS=(PROTOCOL=TCP)(HOST=dc01-scan.kbzbank.com.mm)(PORT=1580)))(CONNECT_DATA=(SERVICE_NAME=fcdboltp.kbzbank.com.mm))))";
        System.out.println("jdbcUrl :" + jdbcUrl);
        OracleDatabaseInfo info = new OracleDatabaseInfo(jdbcUrl, "Oracle_server", null);
        Hashtable<String, String> result = info.getDBInfo();
        System.out.println("Result :" + result);
    }
}

