/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.EgAgentInfo;
import com.eg.EgInstallInfo;
import com.eg.apm.APMCleanUpUtils;
import com.eg.apm.APMComponentIDRepository;
import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.APMNodeWorker;
import com.eg.apm.APMWorker;
import com.eg.apm.ApmConfigManager;
import com.eg.apm.ApmDemoInfo;
import com.eg.apm.JavaAPMComponent;
import com.eg.apm.JavaBTMLogger;
import com.eg.apm.JavaBTMOffloadLogger;
import com.eg.apm.Status;
import com.eg.jtm.BTMConstants;
import com.eg.jtm.PropsManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimerTask;

final class ComponentWatcher
extends TimerTask {
    protected static String loggerDispStr = "[ComponentWatcher]";
    public static HashMap previousTable = new HashMap();
    public long lastModifiedTime = -1L;
    String egApmIniFile = EgInstallInfo.getInstallDir() + BTMConstants.agentConfigPath + "eg_apm.ini";
    EgAgentInfo egApmIniInfo = new EgAgentInfo("agent", this.egApmIniFile);
    private boolean isFirstTime = true;
    private boolean prepareCpcData = true;
    private boolean doReadForDeletedComponent = false;
    boolean isEgApmIniModified = false;
    public long lastHeartBeatTimeCheck = -1L;
    public static String[] offloadTestNames = null;

    public void run() {
        try {
            if (ApmDemoInfo.isDemoMode() && ApmDemoInfo.checkForUpdate()) {
                ApmConfigManager.getInstance().updateDemoConfigs();
            }
            ApmConfigManager.getInstance().checkForUpdate();
            try {
                APMNodeWorker.snapShotTaker();
            }
            catch (Exception exception) {
                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Unable to do Snapshot taker for NODE BTM : {}", (Object)loggerDispStr, (Object)exception);
            }
            if (!ApmConfigManager.getInstance().isAPMMonitoringEnabled()) {
                return;
            }
            this.isEgApmIniModified = this.egApmIniInfo.checkForUpdate();
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} isEgApmIniModified : {}", (Object)loggerDispStr, (Object)this.isEgApmIniModified);
            try {
                this.componentWatcher();
            }
            catch (Exception exception) {
                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Unable to do component watcher tracker : {} ", (Object)loggerDispStr, (Object)exception);
            }
            try {
                this.getCPCData();
            }
            catch (Exception exception) {
                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Unable to get Custom BTM configuration from eg_apm.ini : {}", (Object)loggerDispStr, (Object)exception);
            }
            try {
                boolean bl = ApmConfigManager.getInstance().isCleanUpEnabled();
                if (bl) {
                    APMCleanUpUtils aPMCleanUpUtils = new APMCleanUpUtils();
                    aPMCleanUpUtils.initCleanUpProcess(this.isEgApmIniModified);
                }
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Unable to do ini clean up process {}", (Object)loggerDispStr, (Object)exception);
            }
            this.isFirstTime = false;
        }
        catch (Exception exception) {
            JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Unable to do component watcher tracker : {}", (Object)loggerDispStr, (Object)exception);
        }
    }

    private HashMap computeCpcdata(String string, HashMap hashMap, boolean bl) {
        String[] stringArray = this.egApmIniInfo.getVariables(string);
        if (stringArray != null && stringArray.length > 0) {
            List<String> list = Arrays.asList(stringArray);
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} Offload CPC components from eg_apm.ini :  {} ", (Object)loggerDispStr, list);
            for (int i = 0; i < list.size(); ++i) {
                HashMap hashMap2;
                String string2 = list.get(i);
                string2 = string2 != null ? string2 : "";
                String[] stringArray2 = string2.split(":");
                if (stringArray2 == null || stringArray2.length != 3) continue;
                String string3 = stringArray2[0];
                String string4 = stringArray2[1];
                String string5 = stringArray2[2];
                String string6 = string3 + ":" + string4;
                if (!APMComponentIDRepository.isSiteIdAvailable(string6)) continue;
                String string7 = this.egApmIniInfo.getValue(string, string2);
                String string8 = string7 = string7 != null ? string7 : "";
                if (bl) {
                    string7 = string5 + "#B=" + string7;
                } else {
                    int n = 1;
                    if (hashMap.containsKey(string6)) {
                        hashMap2 = (HashMap)hashMap.get(string6);
                        n = hashMap2.size();
                    }
                    string7 = "CPC" + n + "#KB=" + string7;
                }
                HashMap hashMap3 = this.parseCpcData(string7);
                if (hashMap.containsKey(string6)) {
                    hashMap2 = (HashMap)hashMap.get(string6);
                    hashMap2.putAll(hashMap3);
                    hashMap.put(string6, hashMap2);
                    continue;
                }
                hashMap.put(string6, hashMap3);
            }
        }
        return hashMap;
    }

    private void getCPCData() {
        try {
            if (this.isEgApmIniModified || this.isFirstTime || this.prepareCpcData) {
                HashMap hashMap = new HashMap();
                String string = "CUSTOM_PATTERN_CONFIGURATION_BT";
                hashMap = this.computeCpcdata(string, hashMap, true);
                string = "CUSTOM_PATTERN_CONFIGURATION_KBT";
                hashMap = this.computeCpcdata(string, hashMap, false);
                JavaBTMOffloadLogger.btmOffLoadLogger.trace("{}  fullCPCData : {}", (Object)loggerDispStr, (Object)hashMap);
                if (hashMap.size() > 0) {
                    this.setCpcTable(hashMap);
                }
                this.checkForDeletedComponents();
                this.prepareCpcData = false;
            }
        }
        catch (Exception exception) {
            JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Unable to get Custom BTM configuration from eg_apm.ini : {} ", (Object)loggerDispStr, (Object)exception);
        }
    }

    private void heartBeatCheck(EgAgentInfo egAgentInfo) {
        try {
            boolean bl = false;
            long l = System.currentTimeMillis();
            if (this.lastHeartBeatTimeCheck > 0L) {
                long l2 = l - this.lastHeartBeatTimeCheck;
                if (l2 > 300000L) {
                    bl = true;
                    this.lastHeartBeatTimeCheck = l;
                }
            } else {
                this.lastHeartBeatTimeCheck = l;
                bl = true;
            }
            if (bl) {
                Hashtable hashtable = (Hashtable)APMComponentIDRepository.getComponentRepository().clone();
                for (Map.Entry entry : hashtable.entrySet()) {
                    String string = (String)entry.getKey();
                    if (string != null && string.startsWith("DISCOVER_ME_")) continue;
                    JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} Doing heartbeat check for : {}", (Object)loggerDispStr, (Object)string);
                    JavaAPMComponent javaAPMComponent = APMComponentIDRepository.getJavaAPMComponent(string);
                    if (javaAPMComponent == null) continue;
                    this.checkAutoUnmanage(javaAPMComponent);
                    this.prepareConfigs(javaAPMComponent, egAgentInfo);
                }
            }
        }
        catch (Exception exception) {
            JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Unable to do heartbeat time check BTM : {}", (Object)loggerDispStr, (Object)exception);
        }
    }

    private void prepareConfigs(JavaAPMComponent javaAPMComponent, EgAgentInfo egAgentInfo) {
        if (javaAPMComponent.isPrepareJvmTestConfigs()) {
            JavaBTMLogger.btmLogger.info("{} [eGTest_Config_Request] Preparing jvm test configs for {} - {}", new Object[]{loggerDispStr, javaAPMComponent.getID(), javaAPMComponent.getNickWithPort()});
            this.getEnabledTestsAndConfigsFromIni(javaAPMComponent, egAgentInfo, true, false);
            javaAPMComponent.setPrepareJvmTestConfigs(false);
        }
        if (javaAPMComponent.isPrepareCpcConfigs()) {
            JavaBTMLogger.btmLogger.info("{} [eGTest_Config_Request] Preparing cpc configs for {} - {}", new Object[]{loggerDispStr, javaAPMComponent.getID(), javaAPMComponent.getNickWithPort()});
            this.prepareCpcData = true;
            javaAPMComponent.setPrepareCpcConfigs(false);
        }
    }

    private void setCpcTable(HashMap hashMap) {
        for (Map.Entry entry : hashMap.entrySet()) {
            String string = (String)entry.getKey();
            HashMap hashMap2 = (HashMap)entry.getValue();
            JavaAPMComponent javaAPMComponent = APMComponentIDRepository.getJavaAPMComponent(string);
            if (javaAPMComponent == null) continue;
            javaAPMComponent.setCPCPatternMap(hashMap2);
        }
    }

    private void checkForDeletedComponents() {
        Hashtable hashtable = new Hashtable();
        hashtable = (Hashtable)APMComponentIDRepository.getComponentRepository().clone();
        for (Map.Entry entry : hashtable.entrySet()) {
            String string = (String)entry.getKey();
            JavaAPMComponent javaAPMComponent = APMComponentIDRepository.getJavaAPMComponent(string);
            HashMap hashMap = javaAPMComponent.getCPCPatternMap();
            if (hashMap != null) continue;
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            hashMap2.put("cpcInfo", "cpcInfo");
            javaAPMComponent.setCPCPatternMap(hashMap);
        }
    }

    private HashMap parseCpcData(String string) {
        String[] stringArray;
        HashMap hashMap = new HashMap();
        if (string != null && string.length() > 0 && string != null && string.length() > 0 && (stringArray = string.split(",")) != null && stringArray.length > 0) {
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (string2 == null || string2.length() <= 0) continue;
                String string3 = string2.substring(0, string2.indexOf("=")).trim();
                String string4 = string2.substring(string2.indexOf("=") + 1).trim();
                if (string3 == null || string3.length() <= 0 || string4 == null || string4.length() <= 0) continue;
                hashMap2.put(string3, string4);
            }
            if (hashMap2 != null && hashMap2.size() > 0) {
                hashMap.putAll(hashMap2);
                hashMap.put("cpcInfo", "cpcInfo");
            }
        }
        return hashMap;
    }

    private void getOffloadTestNamesFromIni() {
        try {
            String[] stringArray;
            if ((this.isEgApmIniModified || this.isFirstTime) && (stringArray = this.egApmIniInfo.getVariables("OFFLOAD_SUPPORTING_TEST_NAMES")) != null && stringArray.length > 0) {
                offloadTestNames = stringArray;
            }
        }
        catch (Exception exception) {
            JavaBTMOffloadLogger.btmOffLoadLogger.error("{} unable to get offloadtestnames from eg_apm.Ini {}", (Object)loggerDispStr, (Object)exception);
        }
    }

    private void componentWatcher() {
        int n = APMComponentIDRepository.getComponentRepository().size();
        if (n == 0) {
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} APM Component repository is empty.", (Object)loggerDispStr);
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        EgAgentInfo egAgentInfo = new EgAgentInfo("agent");
        long l = egAgentInfo.lastModified();
        if (this.lastModifiedTime > -1L) {
            if (l != this.lastModifiedTime) {
                bl2 = true;
                this.lastModifiedTime = l;
            }
        } else {
            this.lastModifiedTime = l;
            bl2 = true;
        }
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} isAgentsIniModified : {}", (Object)loggerDispStr, (Object)bl2);
        if (bl2 || this.isFirstTime) {
            this.getOffloadTestNamesFromIni();
            if (JavaBTMOffloadLogger.btmOffLoadLogger.isTraceEnabled()) {
                JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} eg_agents.ini is modified {} ", (Object)loggerDispStr, (Object)l);
                JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} isFirstTime : {}", (Object)loggerDispStr, (Object)this.isFirstTime);
                JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} offloadTestNames : {}", (Object)loggerDispStr, (Object)offloadTestNames);
                JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} ComponentIDTable : {}", (Object)loggerDispStr, (Object)APMComponentIDRepository.getComponentRepository());
            }
            if (offloadTestNames == null || offloadTestNames.length == 0) {
                JavaBTMOffloadLogger.btmOffLoadLogger.info("{} offloadTestNames is null or empty, trying to read offloadTestNames from eg_apm.ini", (Object)loggerDispStr);
                this.isEgApmIniModified = true;
                this.getOffloadTestNamesFromIni();
            }
            if (offloadTestNames == null || offloadTestNames.length == 0) {
                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} offloadTestNames is null or empty, Skipping further processes of ComponentWatcher Tracker ", (Object)loggerDispStr);
                return;
            }
            Hashtable hashtable = (Hashtable)APMComponentIDRepository.getComponentRepository().clone();
            for (Map.Entry entry : hashtable.entrySet()) {
                String string = (String)entry.getKey();
                if (string != null && string.startsWith("DISCOVER_ME_")) continue;
                JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} Doing Component tracker task for : {}", (Object)loggerDispStr, (Object)string);
                JavaAPMComponent javaAPMComponent = APMComponentIDRepository.getJavaAPMComponent(string);
                if (javaAPMComponent == null) continue;
                this.checkAutoUnmanage(javaAPMComponent);
                bl = true;
                this.getEnabledTestsAndConfigsFromIni(javaAPMComponent, egAgentInfo, bl2, true);
            }
            this.doReadForDeletedComponent = false;
        }
        if (!bl) {
            this.heartBeatCheck(egAgentInfo);
        }
    }

    private void getEnabledTestsAndConfigsFromIni(JavaAPMComponent javaAPMComponent, EgAgentInfo egAgentInfo, boolean bl, boolean bl2) {
        boolean bl3 = false;
        if (javaAPMComponent.isComponentOrEntityStatus()) {
            bl3 = true;
        }
        String string = javaAPMComponent.getNickName();
        String string2 = javaAPMComponent.getHostPort();
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} doReadForDeletedCommonent : {}", (Object)loggerDispStr, (Object)this.doReadForDeletedComponent);
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} doReadForNewComponent : {}", (Object)loggerDispStr, (Object)bl3);
        if (bl || bl3 || this.doReadForDeletedComponent) {
            Object object;
            String[] stringArray = egAgentInfo.getTestsForTarget(string, "offload");
            if (stringArray == null) {
                object = egAgentInfo.getSubjectForThisCompoent(string, string2, offloadTestNames);
                if (object == null) {
                    String string3 = javaAPMComponent.getID();
                    JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} SECTION not found in eg_agents.ini {} - {}", new Object[]{loggerDispStr, string, object});
                    JavaBTMOffloadLogger.btmOffLoadLogger.error("{} SECTION not found in eg_agents.ini for {}. Marking as unmanaged component and removed from respository ", (Object)loggerDispStr, (Object)string3);
                    APMComponentIDRepository.unRegisterJavaComponent(string3, false, false);
                    this.doReadForDeletedComponent = true;
                    return;
                }
                JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} SECTION found in eg_agents.ini for {} - {}", new Object[]{loggerDispStr, string, object});
                stringArray = egAgentInfo.getTestsForTarget((String)object, "offload");
            }
            object = egAgentInfo.getTests(stringArray, "offload");
            this.updateTestConfigs(javaAPMComponent, stringArray, (String[])object, false, bl2);
            APMWorker.clearRepository(javaAPMComponent);
            if (bl3) {
                javaAPMComponent.changeComponentOrEntityStatus();
            }
        }
    }

    private void updateTestConfigs(JavaAPMComponent javaAPMComponent, String[] stringArray, String[] stringArray2, boolean bl, boolean bl2) {
        if (offloadTestNames == null || offloadTestNames.length == 0) {
            return;
        }
        String string = javaAPMComponent.getHostPort();
        List<String> list = Arrays.asList(stringArray2);
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} Enabled agents tests with port:  {}", (Object)loggerDispStr, list);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = javaAPMComponent.getID();
        for (int i = 0; i < offloadTestNames.length; ++i) {
            String string3 = offloadTestNames[i];
            String string4 = string3 + "_" + string;
            int n = list.indexOf(string4);
            if (n < 0) {
                javaAPMComponent.removeEntity(string3);
                hashMap.put(string3, "false");
                continue;
            }
            String string5 = stringArray[n];
            HashMap hashMap2 = this.getFullConfigs(string5, string3);
            String string6 = (String)hashMap2.get("egMeasPeriod");
            if (string6 != null) {
                hashMap.put(string3, "true");
                hashMap.put(string3 + "Frequency", string6);
            }
            if (string3.startsWith("Jvm")) {
                String string7;
                boolean bl3 = false;
                try {
                    string7 = (String)hashMap2.get("metric_collection_type");
                    if (string7 != null && string7.equalsIgnoreCase("false")) {
                        bl3 = true;
                    }
                }
                catch (Exception exception) {
                    JavaBTMOffloadLogger.btmOffLoadLogger.debug("Exception while finding metric_collection_mode for the {} and entity {} - {}", new Object[]{string2, string3, exception.getMessage()});
                }
                if (bl3) {
                    String string8;
                    if (string3.equalsIgnoreCase("JvmMemoryDetailsTest")) {
                        string7 = (String)hashMap2.get("Heap_Analysis");
                        string8 = (String)hashMap2.get("Java_Home");
                        if (string7 != null) {
                            hashMap.put("Heap_Analysis", string7);
                        }
                        if (string8 != null) {
                            hashMap.put("Heap_Analysis", string7);
                        }
                    } else if (string3.equalsIgnoreCase("JvmThreadTest")) {
                        string7 = "-1";
                        hashMap.put("Thread_Dump_Limit", string7);
                        string8 = (String)hashMap2.get("Thread_Dump_Limit");
                        try {
                            int n2 = Integer.parseInt(string8);
                            hashMap.put("Thread_Dump_Limit", string8);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (bl3) {
                    hashMap.put("JVM_METRIC_COLLECTION", "true");
                } else {
                    hashMap.put("JVM_METRIC_COLLECTION", "false");
                }
                string7 = (String)hashMap2.get("agentless");
                if (string7 != null && string7.length() > 0 && string7.equalsIgnoreCase("y")) {
                    bl = true;
                    hashMap.put("isAgentLess", "true");
                } else {
                    hashMap.put("isAgentLess", "false");
                }
            }
            APMComponentIDRepository.registerJavaComponent(string2, string3);
        }
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} Offload test config:- compareWithPreviousData - {} ", (Object)loggerDispStr, (Object)bl2);
        if (hashMap.size() > 0) {
            HashMap hashMap3 = new HashMap(hashMap);
            previousTable.put(string2, hashMap3);
            hashMap.put("JVMTestsInfo", "JVMTestsInfo");
            javaAPMComponent.setJVMTestConfig(hashMap);
        }
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} Current JVM Configuration for ({}) : {}", new Object[]{loggerDispStr, string2, javaAPMComponent.getJVMTestConfig()});
    }

    private HashMap getFullConfigs(String string, String string2) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string3 = string.substring(string.indexOf("-host") + 1, string.lastIndexOf(","));
        string3 = string3.replace("   ", " ");
        string3 = string3.replace("  ", " ");
        String[] stringArray = string3.split(" -");
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i].split(" ");
            hashMap.put(stringArray2[0], stringArray2[1]);
        }
        return hashMap;
    }

    private void checkAutoUnmanage(JavaAPMComponent javaAPMComponent) {
        long l = System.currentTimeMillis();
        boolean bl = javaAPMComponent.getHeartbeatStatus() == Status.HEART_BEATING;
        long l2 = javaAPMComponent.getHeartBeatTime();
        long l3 = System.currentTimeMillis() - l2;
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} lastHeartBeatTime :{} , currenTime :{} ,diffs :{}", new Object[]{loggerDispStr, l2, l, l3});
        if (l2 < 0L) {
            return;
        }
        PropsManager propsManager = javaAPMComponent.getPropsManager();
        if (propsManager == null) {
            return;
        }
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} Measure period for {} :{}", new Object[]{loggerDispStr, javaAPMComponent.getID(), propsManager.getEgMeasPeriod()});
        if (l3 >= 6L * propsManager.getEgMeasPeriod() && bl) {
            JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Doing  BTM repository reset due to no heart beat for a few couple of measure peroid : {} ", (Object)loggerDispStr, (Object)javaAPMComponent.getID());
            javaAPMComponent.setHeartBeatStatus(Status.NO_HEART_BEATING);
            javaAPMComponent.reset();
        }
    }

    protected static HashMap getModifiedConfig(HashMap hashMap, HashMap hashMap2) {
        HashMap<String, String> hashMap3 = new HashMap<String, String>();
        if (hashMap != null && hashMap.size() > 0) {
            Set set = hashMap.keySet();
            for (String string : set) {
                String string2 = (String)hashMap.get(string);
                if (hashMap2.containsKey(string)) {
                    String string3 = (String)hashMap2.get(string);
                    if (string2.equals(string3)) continue;
                    hashMap3.put(string, string2);
                    continue;
                }
                hashMap3.put(string, string2);
            }
        }
        return hashMap3;
    }
}

