/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.AgentStartupLogger;
import com.eg.apm.ComponentWatcherTracker;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;

public abstract class AgentSocketServer {
    private final String logPrefix = " [" + this.getClass().getName() + "] ";

    public AgentSocketServer() {
        ComponentWatcherTracker.isWatcherNull(true);
    }

    private void closeServerSocket(ServerSocket serverSocket) {
        if (serverSocket != null) {
            try {
                if (!serverSocket.isClosed()) {
                    serverSocket.close();
                }
            }
            catch (IOException ioe) {
                AgentStartupLogger.logger.error("{} I/O Error when try to close server socket port  : {} ", (Object)this.logPrefix, (Object)ioe);
            }
        }
        serverSocket = null;
    }

    protected ServerSocket createServerSocket(ServerSocket serverSocket, int serverSocketPort, String bindIp) {
        this.closeServerSocket(serverSocket);
        try {
            serverSocket = new ServerSocket();
            serverSocket.bind(new InetSocketAddress(bindIp, serverSocketPort));
            AgentStartupLogger.logger.info("{} BTM Offload Server Socket is listening on bindIp: {} \t serverSocketPort: {} ", new Object[]{this.logPrefix, bindIp, serverSocketPort});
            return serverSocket;
        }
        catch (IOException ioe) {
            System.err.println("BTM Offload - Unable to create agent server socket on port :" + serverSocketPort + ". Port may be already in use. " + ioe.getMessage());
            AgentStartupLogger.logger.error("{} BTM Offload - Unable to create agent server socket on port : {} \t . Port may be already in use. {} ", new Object[]{this.logPrefix, serverSocketPort, ioe});
        }
        catch (SecurityException se) {
            System.err.println("BTM Offload - Security Manager settings not allowing to create server socket " + se.getMessage());
            AgentStartupLogger.logger.error("{} BTM Offload - Security Manager settings not allowing to create server socket{}", (Object)this.logPrefix, (Object)se);
        }
        catch (IllegalArgumentException iae) {
            System.err.println("BTM Offload - Specified server socket port " + serverSocketPort + " is out of range or invalid " + iae.getMessage());
            AgentStartupLogger.logger.error("{} Given agent server socket port is out of range or invalid :{} {}", new Object[]{this.logPrefix, serverSocketPort, iae});
        }
        catch (Exception e) {
            System.err.println("BTM Offload - Unable to create server socket due to " + e.getMessage());
            AgentStartupLogger.logger.error("{} BTM Offload - Unable to create server socket due to {}", (Object)this.logPrefix, (Object)e);
        }
        return null;
    }

    protected void sleepMethod(long sleeptime) {
        try {
            Thread.sleep(sleeptime);
        }
        catch (Exception e) {
            AgentStartupLogger.logger.error("{} Unable to sleep   : {}", (Object)this.logPrefix, (Object)e);
        }
    }
}

