/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.eg.IniHelper;
import com.eg.apm.APMFileOperations;
import com.eg.apm.EgApmFilesSync;
import com.eg.apm.JavaTransactionFlowUtility;
import com.eg.jtm.BTMConstants;
import com.eg.org.slf4j.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class APMUtils {
    static final String loggerDispStr = "[APMUtils]";
    private static final HashMap<String, String> CONTAINER_NAME_MAPPINGS = new HashMap();
    private static boolean isConstainerHostIpAvailable = false;
    private static String containerIp = "127.0.0.1";
    public static boolean isWindows;

    private APMUtils() {
    }

    public static void removeComponentZipFile(String string) {
        if (string == null || string.length() <= 0) {
            return;
        }
        String string2 = string.substring(1, string.lastIndexOf(":"));
        String string3 = string.substring(string.lastIndexOf(":") + 1, string.lastIndexOf("]"));
        String string4 = string2 + "_" + string3 + ".zip";
        APMFileOperations aPMFileOperations = new APMFileOperations();
        String string5 = EgInstallInfo.getInstallDir() + BTMConstants.apmOffloadFolderPath + string4;
        aPMFileOperations.deleteFile(string5);
    }

    public static double String2Double(String string) {
        double d = -1.0;
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return d;
    }

    public static long String2Long(String string) {
        long l = -1L;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return l;
    }

    public static int String2Integer(String string) {
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public static long getTimeStamp() {
        return System.currentTimeMillis();
    }

    public static String readJvmGUID(String string) {
        IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + BTMConstants.AGENT_APM_GUID_FILEPATH);
        String string2 = iniFile.getValue("APM_GUID_MAPPING_WITH_NICK", string);
        return string2;
    }

    public static boolean storeGuidWithNick(String string, String string2, Logger logger) {
        if (string == null || string.length() == 0 || string2 == null) {
            return false;
        }
        boolean bl = false;
        try {
            bl = JavaTransactionFlowUtility.storeToIni("JAVA_UNIQUE_GUID_COMPONENT_NAME_MAPPING", string, string2);
            logger.trace("{} Writtern {}:{} into {} ", new Object[]{loggerDispStr, string, string2, BTMConstants.APM_DISCOVERY_FILEPATH});
        }
        catch (Exception exception) {
            logger.warn("{}  Unable to write {} with {}:{} - {} ", new Object[]{loggerDispStr, BTMConstants.APM_DISCOVERY_FILEPATH, string, string2, exception});
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void storeGuidWithIpPort(String string, String string2, String string3, Logger logger) {
        if (string == null) return;
        if (string.length() == 0) {
            return;
        }
        IniFile iniFile = EgApmFilesSync.getInstance(EgInstallInfo.getInstallDir() + BTMConstants.UNIQUE_JVM_FILEPATH);
        try {
            try {
                if (string3 != null) {
                    iniFile.setValue("NEW_UNIQUE_JVM_DETAILS", string3, string);
                }
                if (string2 != null) {
                    iniFile.setValue("NEW_UNIQUE_JVM_DETAILS", string, string2);
                }
                logger.trace("{} Writtern {}:{} into {} ", new Object[]{loggerDispStr, string, string2, BTMConstants.UNIQUE_JVM_FILEPATH});
                logger.trace("{} Writtern {}:{} into {} ", new Object[]{loggerDispStr, string3, string, BTMConstants.UNIQUE_JVM_FILEPATH});
            }
            catch (Exception exception) {
                logger.warn("{}  Unable to write {} with {}:{} - {} ", new Object[]{loggerDispStr, BTMConstants.UNIQUE_JVM_FILEPATH, string, string2, exception});
                Object var7_6 = null;
                iniFile.saveFile();
                EgApmFilesSync.releaseInstance(iniFile);
                return;
            }
            Object var7_5 = null;
            iniFile.saveFile();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            iniFile.saveFile();
            EgApmFilesSync.releaseInstance(iniFile);
            throw throwable;
        }
        EgApmFilesSync.releaseInstance(iniFile);
    }

    public static void sleep(Long l) {
        try {
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static boolean isContainerHostIpAvailable() {
        return isConstainerHostIpAvailable;
    }

    public static String getContainerHostIp() {
        return containerIp;
    }

    public static void setContainerHostIp(String string, Logger logger) {
        if (string != null && string.length() > 0 && !string.equalsIgnoreCase("localhost") && !string.equalsIgnoreCase("127.0.0.1")) {
            containerIp = string;
            isConstainerHostIpAvailable = true;
        } else {
            logger.info("{} {} not a valid Docker host internal IP. ", (Object)loggerDispStr, (Object)string);
        }
    }

    public static IniHelper getIniHelper(final String string, final String string2, final String string3) {
        IniHelper iniHelper = new IniHelper(string, string2, string3){

            public String toString() {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string);
                stringBuilder.append("  ");
                stringBuilder.append(string2);
                stringBuilder.append("=");
                stringBuilder.append(string3);
                return stringBuilder.toString();
            }
        };
        return iniHelper;
    }

    public static String getServerType(String string) {
        String string2 = null;
        if (string.equals("eG_Manager") || string.equals("Atlassian_Confluence")) {
            string2 = string;
        } else {
            Set<String> set = CONTAINER_NAME_MAPPINGS.keySet();
            for (String string3 : set) {
                if (string3.equals("JBoss") && string.indexOf(string3) > -1) {
                    int n;
                    String string4 = APMUtils.getServerInfoVersion(string3);
                    if (string4 != null && (n = Integer.parseInt((string4 = string4.trim()).substring(0, string4.indexOf(".")))) < 6) {
                        string2 = "JBoss_server";
                        break;
                    }
                    string2 = CONTAINER_NAME_MAPPINGS.get(string3);
                    break;
                }
                if (string3.equals("WebSphere") && string3.indexOf("Liberty") > -1) {
                    string2 = CONTAINER_NAME_MAPPINGS.get("Liberty");
                    break;
                }
                if (string.indexOf("Tomcat") > -1) {
                    string2 = CONTAINER_NAME_MAPPINGS.get("Tomcat");
                    break;
                }
                if (string.indexOf(string3) <= -1) continue;
                string2 = CONTAINER_NAME_MAPPINGS.get(string3);
                break;
            }
        }
        return string2;
    }

    private static String getServerInfoVersion(String string) {
        int n = string.indexOf(47);
        if (n == -1) {
            return null;
        }
        int n2 = string.indexOf(32, n);
        if (n2 == -1) {
            n2 = string.length();
        }
        return string.substring(n + 1, n2);
    }

    public static boolean isDetailsAvailable(Map map, String string) {
        return map.containsKey(string);
    }

    public static boolean isDetailsAvailableInFile(IniFile iniFile, String string, String string2, String string3) {
        String string4 = iniFile.getValue(string3, string);
        return string4 != null && string4.length() > 0 && string2.equalsIgnoreCase(string4);
    }

    public static String getAndValidateStringValue(IniFile iniFile, String string, String string2, String string3) {
        String string4 = iniFile.getValue(string, string2);
        if (string4 != null && string4.length() > 0) {
            return string4;
        }
        string4 = string3;
        return string4;
    }

    public static int getAndValidateIntegerValue(IniFile iniFile, String string, String string2, int n) {
        int n2 = n;
        String string3 = iniFile.getValue(string, string2);
        if (string3 != null && string3.length() > 0) {
            try {
                n2 = Integer.parseInt(string3);
            }
            catch (Exception exception) {
                n2 = n;
            }
        }
        return n2;
    }

    public static long getAndValidateLongValue(IniFile iniFile, String string, String string2, long l, long l2, Logger logger) {
        long l3 = l2;
        String string3 = iniFile.getValue(string, string2);
        logger.trace("{} Sub:{} Var :{}  Value: {} ", new Object[]{loggerDispStr, string, string2, string3});
        if (string3 != null && string3.length() > 0) {
            try {
                double d = Double.parseDouble(string3) * (double)l;
                l3 = (long)d;
            }
            catch (Exception exception) {
                logger.warn("{} Exception Occurred in getAndValidateLongValue() :{} ", (Object)loggerDispStr, (Object)exception);
            }
        }
        return l3;
    }

    public static boolean getAndValidateBooleanValue(IniFile iniFile, String string, String string2) {
        boolean bl = false;
        String string3 = iniFile.getValue(string, string2);
        if (string3 != null && string3.length() > 0) {
            try {
                bl = Boolean.parseBoolean(string3);
            }
            catch (Exception exception) {
                bl = false;
            }
        }
        return bl;
    }

    private static void findOS() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string != null && string.indexOf("win") > -1) {
            isWindows = true;
        }
    }

    public static HashMap getLinesAsMap(IniFile iniFile, String string, Logger logger) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            String[] stringArray = iniFile.getLinesUnderSubject(string);
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    int n = string2.indexOf("=");
                    if (n < 0) continue;
                    String string3 = string2.substring(0, n);
                    String string4 = string2.substring(n + 1);
                    hashMap.put(string3, string4);
                }
            }
        }
        catch (Exception exception) {
            logger.warn("{} Exception Occurred in getLinesAsMap() :{} ", (Object)loggerDispStr, (Object)exception);
        }
        return hashMap;
    }

    static {
        CONTAINER_NAME_MAPPINGS.put("Tomcat", "Tomcat_server");
        CONTAINER_NAME_MAPPINGS.put("JBoss", "JBoss_server");
        CONTAINER_NAME_MAPPINGS.put("WildFly", "WildFly");
        CONTAINER_NAME_MAPPINGS.put("WebLogic", "WebLogic_server");
        CONTAINER_NAME_MAPPINGS.put("WebSphere", "WebSphere_server");
        CONTAINER_NAME_MAPPINGS.put("GlassFish", "GlassFish_server");
        CONTAINER_NAME_MAPPINGS.put("Liberty", "IBMWLP");
        CONTAINER_NAME_MAPPINGS.put("java", "Java_virtual_machine");
        APMUtils.findOS();
    }
}

