/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class XIOSCIBsTest
extends XtremIOBase {
    private static final int XTREM_IO_STORAGE_CONTROLLERS_IB_MEASURE_COUNT = 9;

    public XIOSCIBsTest(String[] stringArray) {
        super(stringArray);
        try {
            this.setMeasureCount(9);
        }
        catch (Exception exception) {
            this.printOut("Error in constructor " + exception.toString());
            this.putErrorMessageToLogfile("Error in constructor " + exception.toString());
        }
    }

    public void debugComputeMeasures(Hashtable hashtable, boolean bl) {
        if (this.xioAPIVersion <= 1.0) {
            this.printOut("This test supports EMC XtremIO API version 2 and above only ");
            this.putWarningMessageToLogfile("This test supports EMC XtremIO API version 2 and above only ");
            return;
        }
        Hashtable hashtable2 = this.getStorageControllers();
        if (hashtable2 == null || hashtable2.isEmpty() || hashtable2.size() == 0) {
            this.printOut("Could not collect the  data ,so test returing ");
            this.putWarningMessageToLogfile("Could not collect the  data ,so test returing ");
            return;
        }
        this.printOut("Storage controrllers IBs " + hashtable2, debug);
        Enumeration enumeration = hashtable2.keys();
        while (enumeration != null && enumeration.hasMoreElements()) {
            Object object;
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable2.get(string);
            if (string2.lastIndexOf("/") > -1 && this.xioAPIVersion > 1.0) {
                object = string2;
                object = ((String)object).substring(0, ((String)object).lastIndexOf("/"));
                this.printOut("Temp href :" + (String)object);
                string2 = (String)object + "?name=" + string + "&cluster-name=" + this.monitoredCluster;
            }
            this.printOut("Storage controllers name  :" + string + " href  :" + string2);
            object = this.getSCIBsdata(string2);
            String string3 = string + "/" + "ib1";
            String string4 = string + "/" + "ib2";
            if (object != null && !((ArrayList)object).isEmpty() && ((ArrayList)object).size() > 0) {
                int n;
                ArrayList arrayList = new ArrayList();
                ArrayList arrayList2 = new ArrayList();
                for (n = 0; n < 9; ++n) {
                    arrayList.add(((ArrayList)object).get(n));
                }
                for (n = 9; n < 18; ++n) {
                    arrayList2.add(((ArrayList)object).get(n));
                }
                if (bl) continue;
                this.addNewMeasure(string3, arrayList);
                this.addNewMeasure(string4, arrayList2);
                continue;
            }
            this.printOut("Could not get the Storage controller IBs data ");
            this.putWarningMessageToLogfile("Could not get the Storage controller IBs data ");
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        this.debugComputeMeasures(hashtable, false);
    }

    public static void main(String[] stringArray) {
        XIOSCIBsTest xIOSCIBsTest = new XIOSCIBsTest(stringArray);
        xIOSCIBsTest.debugComputeMeasures(new Hashtable(), true);
    }

    private ArrayList getSCIBsdata(String string) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        String string2 = this.getJSONDataFromURL(string);
        JSONObject jSONObject = null;
        if (string2 != null && string2.length() > 0) {
            JSONParser jSONParser = new JSONParser();
            try {
                jSONObject = (JSONObject)jSONParser.parse(string2);
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
            }
            JSONObject jSONObject2 = (JSONObject)jSONObject.get((Object)"content");
            String string3 = (String)jSONObject2.get((Object)"ib1-link-health-level");
            double d = this.ibHealthLevel(string3);
            this.printOut("Storage controllers ib1 Link Health Level:" + d);
            arrayList.add(new Double(d));
            String string4 = (String)jSONObject2.get((Object)"ib1-port-state");
            double d2 = this.ibPortState(string4);
            this.printOut("Storage controllers ib1 Port State:" + d2);
            arrayList.add(new Double(d2));
            String string5 = (String)jSONObject2.get((Object)"ib1-port-misconnection");
            double d3 = this.ibPortConnection(string5);
            this.printOut("Storage controllers ib1 Port MisConnection:" + d3);
            arrayList.add(new Double(d3));
            double d4 = this.getValueFromJSONObject(jSONObject2, "ib1-link-downed");
            this.printOut("Storage controllers ib1 Link Downed:" + d4);
            arrayList.add(new Double(d4));
            double d5 = this.getValueFromJSONObject(jSONObject2, "ib1-link-error-recoveries");
            this.printOut("Storage controllers ib1 Link Error Recovery:" + d5);
            arrayList.add(new Double(d5));
            double d6 = this.getValueFromJSONObject(jSONObject2, "ib1-local-link-integrity-errors");
            this.printOut("Storage controllers ib1 Local Link Integrity Error:" + d6);
            arrayList.add(new Double(d6));
            double d7 = this.getValueFromJSONObject(jSONObject2, "ib1-port-rcv-errors");
            this.printOut("Storage controllers ib1 Port Rcv Error:" + d7);
            arrayList.add(new Double(d7));
            double d8 = this.getValueFromJSONObject(jSONObject2, "ib1-port-rcv-remote-physical-errors");
            this.printOut("Storage controllers ib1 Port Rcv Remote Physical Errors:" + d8);
            arrayList.add(new Double(d8));
            double d9 = this.getValueFromJSONObject(jSONObject2, "ib1-symbol-errors");
            this.printOut("Storage controllers ib1 Symbol Errors:" + d9);
            arrayList.add(new Double(d9));
            String string6 = (String)jSONObject2.get((Object)"ib2-link-health-level");
            double d10 = this.ibHealthLevel(string6);
            this.printOut("Storage controllers ib2 Link Health Level:" + d10);
            arrayList.add(new Double(d10));
            String string7 = (String)jSONObject2.get((Object)"ib2-port-state");
            double d11 = this.ibPortState(string7);
            this.printOut("Storage controllers ib2 Port State:" + d11);
            arrayList.add(new Double(d11));
            String string8 = (String)jSONObject2.get((Object)"ib2-port-misconnection");
            double d12 = this.ibPortConnection(string8);
            this.printOut("Storage controllers ib2 Port MisConnection:" + d12);
            arrayList.add(new Double(d12));
            double d13 = this.getValueFromJSONObject(jSONObject2, "ib2-link-downed");
            this.printOut("Storage controllers ib2 Link Downed:" + d13);
            arrayList.add(new Double(d13));
            double d14 = this.getValueFromJSONObject(jSONObject2, "ib2-link-error-recoveries");
            this.printOut("Storage controllers ib2 Link Error Recovery:" + d14);
            arrayList.add(new Double(d14));
            double d15 = this.getValueFromJSONObject(jSONObject2, "ib2-local-link-integrity-errors");
            this.printOut("Storage controllers ib2 Local Link Integrity Error:" + d15);
            arrayList.add(new Double(d15));
            double d16 = this.getValueFromJSONObject(jSONObject2, "ib2-port-rcv-errors");
            this.printOut("Storage controllers ib2 Port Rcv Error:" + d16);
            arrayList.add(new Double(d16));
            double d17 = this.getValueFromJSONObject(jSONObject2, "ib2-port-rcv-remote-physical-errors");
            this.printOut("Storage controllers ib2 Port Rcv Remote Physical Errors:" + d17);
            arrayList.add(new Double(d17));
            double d18 = this.getValueFromJSONObject(jSONObject2, "ib2-symbol-errors");
            this.printOut("Storage controllers ib2 Symbol Errors:" + d18);
            arrayList.add(new Double(d18));
        }
        return arrayList;
    }

    private double ibPortConnection(String string) {
        double d = -5.0;
        d = string == null || string.trim().length() == 0 ? -5.0 : (string.equalsIgnoreCase("healthy") ? 0.0 : (string.equalsIgnoreCase("not_node") ? 1.0 : (string.equalsIgnoreCase("wrong_port") ? 2.0 : -1.0)));
        return d;
    }

    private double ibPortState(String string) {
        double d = -5.0;
        d = string == null || string.trim().length() == 0 ? -5.0 : (string.equalsIgnoreCase("up") ? 0.0 : (string.equalsIgnoreCase("down") ? 1.0 : (string.equalsIgnoreCase("unknown") ? -1.0 : -1.0)));
        return d;
    }

    private double ibHealthLevel(String string) {
        double d = -5.0;
        d = string == null || string.trim().length() == 0 ? -5.0 : (string.equalsIgnoreCase("level_1_clear") ? 0.0 : (string.equalsIgnoreCase("level_2_unknown") ? 1.0 : (string.equalsIgnoreCase("level_3_warning") ? 2.0 : (string.equalsIgnoreCase("level_4_minor") ? 3.0 : (string.equalsIgnoreCase("level_5_major") ? 4.0 : (string.equalsIgnoreCase("level_6_critical") ? 5.0 : -1.0))))));
        return d;
    }
}

