/*
 * Decompiled with CFR 0.152.
 */
import com.eg.IPV6Helper;
import java.net.URLEncoder;
import java.util.ArrayList;

public class WsTest
extends EgWebSphere {
    private String uri = "egurkha/egurkha/EgWebSphere.jsp";
    private String webServerPort = "80";
    public boolean isSsl = false;
    private String url = "";
    private String ndmanager = "none";
    private String connectorport = "none";
    private String user = "none";
    private String password = "none";
    private String encryptPass = "false";
    private String userPassword = "none";
    private String server = "";
    private String ssl = "";
    private String serverName = null;
    private static int pctHeapUsedIndex = 0;
    private static int availabilityIndex = 1;
    private double heapUsedPct = 0.0;
    private int availability = 0;
    private String tempHost = "";

    public WsTest(String[] stringArray) {
        super(stringArray);
        this.numOutputFields = 2;
        this.ndmanager = this.getValueForParam("ndmanager");
        this.connectorport = this.getValueForParam("connectorport");
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.serverName = this.getValueForParam("serverHostName");
        this.url = this.getValueForParam("url");
        this.webServerPort = this.getValueForParam("webServerPort");
        this.encryptPass = this.getValueForParam("encryptPass");
        this.server = this.getValueForParam("serverName");
        this.ssl = this.getValueForParam("ssl");
        if (this.ssl != null) {
            this.isSsl = new Boolean(this.ssl);
        }
        if (this.serverName == null || this.serverName.equalsIgnoreCase("localhost")) {
            this.serverName = this.getHostName();
        }
        if (this.server == null) {
            this.server = "";
        }
        if (this.encryptPass != null && this.encryptPass.equalsIgnoreCase("true")) {
            this.password = EgCrypt.encrypt(this.password, true);
        }
        if (this.user != null && !this.user.equalsIgnoreCase("none")) {
            this.userPassword = this.user + ":" + EgCrypt.decrypt(this.password);
        }
        this.ndmanager = URLEncoder.encode(this.ndmanager);
        this.serverName = URLEncoder.encode(this.serverName);
        this.server = URLEncoder.encode(this.server);
        this.user = URLEncoder.encode(this.user);
    }

    public static void main(String[] stringArray) {
        WsTest wsTest = new WsTest(stringArray);
        wsTest.executeTest();
    }

    public boolean executeTest() {
        try {
            this.initTest();
            String string = this.siteName + siteAndInfoSeparator + infoFieldSeparator;
            this.tempHost = IPV6Helper.getValidIPAddress(this.targetHost);
            this.url = this.isSsl ? "https://" + this.tempHost + ":" + this.webServerPort : "http://" + this.tempHost + ":" + this.webServerPort;
            String string2 = this.url + "/" + this.uri + "?module=jvmRuntimeModule&summary=true&hostname=" + this.serverName + "&ndmanager=" + this.ndmanager + "&connectorport=" + this.connectorport + "&user=" + this.user + "&password=" + this.password + "&server=" + this.server;
            ArrayList arrayList = this.returnMeasures(string2, "jvmRuntime", this.isSsl, this.userPassword);
            if (arrayList == null) {
                this.updateAllResultSets();
                this.errorMsg = new String("Measures from eG WebSphere monitoring component is null eG  Enterprise Application may not be running. Check in WebSphere Advanced Administrative Console");
                return false;
            }
            this.tokenizeMeasureString(arrayList);
            String[] stringArray = this.getInfo();
            if (stringArray == null || stringArray.length == 0) {
                this.updateAllResultSets();
                this.errorMsg = new String("Measures from eG WebSphere monitoring component is null eG Enterprise Application may not be running. Check in WebSphere Advanced Administrative Console");
                return false;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = new String();
                int n = stringArray[i].lastIndexOf("jvmRuntimeModule");
                if (n < 0) continue;
                string3 = stringArray[i].substring(0, n - 1);
                double d = this.getValue(stringArray[i], "totalMemory", false);
                double d2 = this.getValue(stringArray[i], "usedMemory", false);
                if (d <= 0.0 || d2 <= 0.0) {
                    this.addValueToResultSet(string + string3, pctHeapUsedIndex, -1.0);
                    this.addValueToResultSet(string + string3, availabilityIndex, -1.0);
                    continue;
                }
                this.heapUsedPct = d2 / d * 100.0;
                this.availability = 100;
                this.addValueToResultSet(string + string3, pctHeapUsedIndex, this.heapUsedPct);
                this.addValueToResultSet(string + string3, availabilityIndex, this.availability);
            }
            this.updateAllResultSets(true);
            return true;
        }
        catch (Exception exception) {
            this.updateAllResultSets();
            return true;
        }
    }
}

