/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

public class WLEJBCacheTest
extends WLBaseTest_F {
    private double activationCount_last = -5.0;
    private double passivationCount_last = -5.0;
    private double cacheHitCount_last = -5.0;
    private double cacheAccessCount_last = -5.0;
    private Hashtable lastMeasures = new Hashtable();
    private Hashtable newLastMeasures = new Hashtable();
    private String s_useWarFile = "Yes";
    private boolean b_useWarFile = true;
    private String weblogicJarLoc = "";
    private String protocol = "t3";
    private boolean useJMX = false;

    public WLEJBCacheTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(6);
        this.isDynamicInfoTest = true;
        this.needToStoreMeasuresForDD = true;
        this.doNotTakeAverageList.add(new Integer(1));
        this.doNotTakeAverageList.add(new Integer(2));
        this.doNotTakeAverageList.add(new Integer(3));
        this.doNotTakeAverageList.add(new Integer(4));
        this.doNotTakeAverageList.add(new Integer(6));
    }

    public void computeMeasures(Hashtable hashtable) {
        Object object;
        String string;
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.server = this.getValueForParam("server");
        this.ssl = this.getValueForParam("ssl");
        this.url = this.getValueForParam("url");
        this.s_useWarFile = this.getValueForParam("useWarFile");
        if (this.s_useWarFile == null || this.s_useWarFile.equalsIgnoreCase("Yes") || this.s_useWarFile.equalsIgnoreCase("true")) {
            this.b_useWarFile = true;
        } else {
            this.b_useWarFile = false;
            this.weblogicJarLoc = this.getValueForParam("weblogicJarLocation");
            if (this.weblogicJarLoc == null || this.weblogicJarLoc.trim().length() == 0) {
                this.weblogicJarLoc = "";
            }
            this.weblogicJarLoc = WLCommandExecute.findAndReplaceString(this.weblogicJarLoc, "\\", "/");
            this.weblogicJarLoc = this.weblogicJarLoc + "/weblogic.jar";
        }
        String string2 = this.getValueForParam("showServerName");
        if (string2 != null && string2.equalsIgnoreCase("false")) {
            this.showServer = false;
        }
        if ((string = this.getValueForParam("encryptPass")) != null && string.equalsIgnoreCase("true")) {
            this.password = EgCrypt.encrypt(this.password, true);
        }
        this.newLastMeasures = new Hashtable();
        if (this.weblogicVersion == 0) {
            String string3 = this.getValueForParam("version");
            if (!string3.equalsIgnoreCase("none")) {
                int n = string3.indexOf(".");
                if (n >= 0) {
                    string3 = string3.substring(0, n);
                }
                try {
                    this.weblogicVersion = Integer.parseInt(string3);
                }
                catch (Exception exception) {
                    this.weblogicVersion = 0;
                }
            }
            if (this.weblogicVersion == 0) {
                this.discovery();
            }
        }
        System.out.println(this.entity + ":" + this.reportingName + " weblogicVersion :" + this.weblogicVersion);
        if (this.weblogicVersion < 6) {
            this.lastMeasures = new Hashtable();
            this.logToErrorFile("Error", "WLEJBCacheTest", "WebLogic version number is " + this.weblogicVersion + ". Can't monitor WebLogic Server version prior to 6");
            return;
        }
        boolean bl = false;
        bl = this.ssl != null && (this.ssl.trim().equalsIgnoreCase("true") || this.ssl.trim().equalsIgnoreCase("yes"));
        this.protocol = bl ? "t3s" : "t3";
        if (this.weblogicVersion >= 12) {
            this.useJMX = true;
        }
        ArrayList arrayList = null;
        if (!this.b_useWarFile) {
            if (this.targetHost == null || this.targetHost.trim().length() == 0 || this.portNo == null || this.portNo.trim().length() == 0 || this.server == null || this.server.trim().length() == 0 || this.user == null || this.user.trim().length() == 0 || this.password == null) {
                this.logToErrorFile("Error", "WLEJBCacheTest.computeMeasures", "Invalid arguments " + this.targetHost + " " + this.portNo + " " + this.server + " " + this.user);
                this.lastMeasures = new Hashtable();
                this.addNewMeasure(null);
                return;
            }
            object = new WLCommandExecute();
            arrayList = this.useJMX ? ((WLCommandExecute)object).executeProgram(this.weblogicJarLoc, this.targetHost, this.portNo, this.user, this.password, this.server, this.protocol, "getWLEJBCacheTestUsingJMX") : ((WLCommandExecute)object).executeProgram(this.weblogicJarLoc, this.targetHost, this.portNo, this.user, this.password, this.server, this.protocol, "getWLEJBCacheTest");
        } else {
            arrayList = this.useJMX ? this.getMeasuresFromJSP("WLEJBCacheTestUsingJMX") : this.getMeasuresFromJSP("WLEJBCacheTest");
        }
        if (arrayList == null || arrayList.size() == 0) {
            this.lastMeasures = new Hashtable();
            this.addNewMeasure(null);
            return;
        }
        object = this.getComponentsToBeMonitored();
        String string4 = this.server + "_";
        int n = string4.length();
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            int n3;
            String string5 = (String)arrayList.get(i);
            if (string5 == null || (n3 = string5.indexOf(":")) == -1 || (n3 = (string5 = string5.substring(n3 + 1)).indexOf(",")) == -1) continue;
            String string6 = string5.substring(0, n3);
            if (!this.showServer && string6.startsWith(string4)) {
                string6 = string6.substring(n);
            }
            if (!this.isAuto && object != null && ((Vector)object).size() > 0 && !((Vector)object).contains(string6)) continue;
            string5 = string5.substring(n3 + 1);
            try {
                n3 = string5.indexOf(",");
                if (n3 == -1) continue;
                double d = Double.parseDouble(string5.substring(0, n3));
                System.out.println("Activation count for " + string6 + " " + d);
                string5 = string5.substring(n3 + 1);
                n3 = string5.indexOf(",");
                if (n3 == -1) continue;
                double d2 = Double.parseDouble(string5.substring(0, n3));
                if ((n3 = (string5 = string5.substring(n3 + 1)).indexOf(",")) == -1) continue;
                double d3 = Double.parseDouble(string5.substring(0, n3));
                if ((n3 = (string5 = string5.substring(n3 + 1)).indexOf(",")) == -1) continue;
                double d4 = Double.parseDouble(string5.substring(0, n3));
                string5 = string5.substring(n3 + 1);
                double d5 = Double.parseDouble(string5);
                this.populateLastMeasures(string6);
                ArrayList<Double> arrayList2 = new ArrayList<Double>();
                if (this.activationCount_last == -5.0) {
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(-5.0));
                    arrayList2.add(new Double(-5.0));
                } else {
                    double d6 = d - this.activationCount_last;
                    arrayList2.add(new Double(d6 >= 0.0 ? d6 / this.timeSinceLastTest : -5.0));
                    d6 = d2 - this.passivationCount_last;
                    arrayList2.add(new Double(d6 >= 0.0 ? d6 / this.timeSinceLastTest : -5.0));
                    d6 = d4 - this.cacheHitCount_last;
                    arrayList2.add(new Double(d6 >= 0.0 ? d6 / this.timeSinceLastTest : -5.0));
                    d6 = d5 - this.cacheAccessCount_last - d6;
                    arrayList2.add(new Double(d6 >= 0.0 ? d6 / this.timeSinceLastTest : -5.0));
                    if (d5 - this.cacheAccessCount_last == 0.0) {
                        arrayList2.add(new Double(100.0));
                    } else {
                        d6 = (d4 - this.cacheHitCount_last) / (d5 - this.cacheAccessCount_last) * 100.0;
                        arrayList2.add(new Double(d6));
                    }
                }
                arrayList2.add(new Double(d3));
                this.activationCount_last = d;
                this.passivationCount_last = d2;
                this.cacheHitCount_last = d4;
                this.cacheAccessCount_last = d5;
                this.addNewMeasure(string6, arrayList2);
                this.saveLastMeasures(string6);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                this.logToErrorFile("Error", "WLEJBCacheTest.computeMeasures: ", string6 + " : " + numberFormatException.toString());
                numberFormatException.printStackTrace();
            }
        }
        this.lastMeasures = this.newLastMeasures;
    }

    private void populateLastMeasures(String string) {
        if (!this.lastMeasures.isEmpty() && this.lastMeasures.containsKey(string)) {
            String string2 = (String)this.lastMeasures.get(string);
            int n = string2.indexOf(",");
            this.activationCount_last = Double.parseDouble(string2.substring(0, n));
            string2 = string2.substring(n + 1);
            n = string2.indexOf(",");
            this.passivationCount_last = Double.parseDouble(string2.substring(0, n));
            string2 = string2.substring(n + 1);
            n = string2.indexOf(",");
            this.cacheHitCount_last = Double.parseDouble(string2.substring(0, n));
            this.cacheAccessCount_last = Double.parseDouble(string2.substring(n + 1));
            return;
        }
        this.activationCount_last = -5.0;
        this.passivationCount_last = -5.0;
        this.cacheHitCount_last = -5.0;
        this.cacheAccessCount_last = -5.0;
    }

    private void saveLastMeasures(String string) {
        String string2 = this.activationCount_last + "," + this.passivationCount_last + "," + this.cacheHitCount_last + "," + this.cacheAccessCount_last;
        this.newLastMeasures.put(string, string2);
    }
}

