/*
 * Decompiled with CFR 0.152.
 */
import com.eg.Base64Coder;
import com.eg.EgSSL;
import com.eg.EgURLEncoder;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class WASSIBDurSubscrTest
extends GenericTest {
    private static final int WAS_SIB_DURABLE_SUBSCRIPTION_MEASURE_COUNT = 4;
    private String uri = "egurkha/egurkha/EgWebSphere";
    private String webServerPort = "80";
    private String url = "";
    private String connectorport = "none";
    private String user = "none";
    private String password = "none";
    private String serverHostName = null;
    private String serverName = null;
    private String nodeName = null;
    private String ssl = null;
    public boolean isSsl = false;
    private Hashtable lastMeasure = new Hashtable();

    public WASSIBDurSubscrTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(4);
        this.webServerPort = this.getValueForParam("appport");
        this.serverHostName = this.getValueForParam("serverhostname");
        this.nodeName = this.getValueForParam("nodename");
        this.serverName = this.getValueForParam("servername");
        this.connectorport = this.getValueForParam("connectorport");
        this.user = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.ssl = this.getValueForParam("ssl");
        if ("true".equalsIgnoreCase(this.ssl)) {
            this.url = "https://";
            this.isSsl = true;
        } else {
            this.url = "http://";
        }
        this.nodeName = URLEncoder.encode(this.nodeName);
        this.serverHostName = URLEncoder.encode(this.serverHostName);
        this.serverName = URLEncoder.encode(this.serverName);
        this.user = URLEncoder.encode(this.user);
        this.password = EgCrypt.encrypt(this.password, true);
    }

    public static void main(String[] stringArray) {
        WASSIBDurSubscrTest wASSIBDurSubscrTest = new WASSIBDurSubscrTest(stringArray);
        int n = 0;
        while (++n < 5) {
            wASSIBDurSubscrTest.computeMeasures(new Hashtable());
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        ArrayList arrayList = this.returnMeasures();
        if (arrayList == null || arrayList.size() == 0) {
            this.addNewMeasure(null);
            this.lastMeasure = new Hashtable();
            return;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            ArrayList<Double> arrayList2 = new ArrayList<Double>();
            String string = (String)arrayList.get(i);
            if (string == null || string.length() <= 0) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            if (stringTokenizer.countTokens() < 2) {
                System.out.println("Error in WASSIBDurSubscrTest for line " + string + " for " + this.targetHost + " " + this.portNo);
                continue;
            }
            String string2 = stringTokenizer.nextToken();
            System.out.println("info :" + string2);
            String string3 = stringTokenizer.nextToken();
            System.out.println("Measure :" + string3);
            String string4 = (String)this.lastMeasure.get(string2);
            if (string4 == null || string4.length() <= 0) {
                this.addNewMeasure(null);
                this.lastMeasure.put(string2, string3);
                continue;
            }
            stringTokenizer = new StringTokenizer(string3, ",");
            System.out.println("st count :" + stringTokenizer.countTokens());
            StringTokenizer stringTokenizer2 = new StringTokenizer(string4, ",");
            System.out.println("st1 count :" + stringTokenizer2.countTokens());
            try {
                if (stringTokenizer.countTokens() != 4 || stringTokenizer2.countTokens() != 4) continue;
                double d = Double.parseDouble(stringTokenizer.nextToken());
                double d2 = Double.parseDouble(stringTokenizer2.nextToken());
                double d3 = d;
                d = Double.parseDouble(stringTokenizer.nextToken());
                d2 = Double.parseDouble(stringTokenizer2.nextToken());
                double d4 = d;
                d = Double.parseDouble(stringTokenizer.nextToken());
                d2 = Double.parseDouble(stringTokenizer2.nextToken());
                double d5 = d >= 0.0 && d2 >= 0.0 && d - d2 >= 0.0 ? d - d2 : -5.0;
                d = Double.parseDouble(stringTokenizer.nextToken());
                d2 = Double.parseDouble(stringTokenizer2.nextToken());
                double d6 = d >= 0.0 && d2 >= 0.0 && d - d2 >= 0.0 ? d - d2 : -5.0;
                arrayList2.add(new Double(d3));
                arrayList2.add(new Double(d4));
                arrayList2.add(new Double(d5));
                arrayList2.add(new Double(d6));
                System.out.println("Info :" + string2 + "Measure ArrayList :" + arrayList2);
                this.addNewMeasure(string2, arrayList2);
                this.lastMeasure.put(string2, string3);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Exception line is " + string);
                exception.printStackTrace();
            }
        }
    }

    private ArrayList returnMeasures() {
        HttpURLConnection httpURLConnection = null;
        Object var2_2 = null;
        Object var3_3 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.url + this.targetHost + ":" + this.webServerPort;
        String string2 = null;
        try {
            string2 = string + "/" + this.uri + "?module=SIBDurableSubscription&hostname=" + this.serverHostName + "&connectorport=" + this.connectorport + "&user=" + this.user + "&password=" + EgURLEncoder.encode(this.password, "UTF-8") + "&server=" + this.serverName + "&nodename=" + this.nodeName;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        System.out.println("Measure url = " + string2);
        URL uRL = null;
        if (this.isSsl) {
            EgSSL egSSL = EgSSL.getInstance();
            egSSL.enableSSL();
            SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
            Object var10_14 = null;
            try {
                Object object;
                Object object2;
                MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
                KeyManager[] keyManagerArray = null;
                TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
                SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
                HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
                uRL = new URL(string2);
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
                if (this.user != null && !this.user.equalsIgnoreCase("none")) {
                    object2 = this.user + ":" + EgCrypt.decrypt(this.password);
                    object = Base64Coder.encodeString((String)object2);
                    httpURLConnection.setRequestProperty("Authorization", "Basic " + (String)object);
                }
                httpURLConnection.connect();
                object2 = new ConnectionThread(httpURLConnection, false);
                object = null;
                int n = 0;
                boolean bl = this.checkForTimeout((ConnectionThread)object2);
                if (bl) {
                    n = ((ConnectionThread)object2).code;
                    object = ((ConnectionThread)object2).data;
                }
                object2 = null;
                httpURLConnection.disconnect();
                httpURLConnection = null;
                if (!bl || n != 200) {
                    return null;
                }
                if (object == null || ((ArrayList)object).size() == 0) {
                    return null;
                }
                for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                    String string3 = (String)((ArrayList)object).get(i);
                    if (arrayList.contains(string3)) continue;
                    arrayList.add(string3);
                }
            }
            catch (Exception exception) {
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
                exception.printStackTrace();
                System.out.println("WASSIBDurSubscrTest Error " + exception.toString() + " " + uRL.toString());
                return null;
            }
        }
        try {
            Object object;
            Object object3;
            uRL = new URL(string2);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            if (this.user != null && !this.user.equalsIgnoreCase("none")) {
                object3 = this.user + ":" + EgCrypt.decrypt(this.password);
                object = Base64Coder.encodeString((String)object3);
                httpURLConnection.setRequestProperty("Authorization", "Basic " + (String)object);
            }
            httpURLConnection.connect();
            object3 = new ConnectionThread(httpURLConnection, false);
            object = null;
            int n = 0;
            boolean bl = this.checkForTimeout((ConnectionThread)object3);
            if (bl) {
                n = ((ConnectionThread)object3).code;
                object = ((ConnectionThread)object3).data;
            }
            object3 = null;
            httpURLConnection.disconnect();
            httpURLConnection = null;
            if (!bl || n != 200) {
                return null;
            }
            if (object == null || ((ArrayList)object).size() == 0) {
                return null;
            }
            for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                String string4 = (String)((ArrayList)object).get(i);
                arrayList.add(string4);
            }
        }
        catch (Exception exception) {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            exception.printStackTrace();
            System.out.println("WASSIBDurSubscrTest Error " + exception.toString() + " " + uRL.toString());
            return null;
        }
        return arrayList;
    }

    private boolean checkForTimeout(ConnectionThread connectionThread) {
        long l;
        long l2 = 0L;
        long l3 = 250L;
        do {
            this.suspendForPeriod(l3);
            if (connectionThread.done) {
                return true;
            }
            if ((l2 += l3) >= this.timeout) {
                connectionThread.interrupt();
                Thread.currentThread();
                Thread.yield();
                connectionThread.stop();
                return false;
            }
            l = l3;
            if (this.timeout - l2 >= l) continue;
            l = this.timeout - l2;
        } while ((l3 = l) > 0L);
        connectionThread.interrupt();
        Thread.currentThread();
        Thread.yield();
        connectionThread.stop();
        return false;
    }

    public String round(double d, int n) {
        if (n <= 0) {
            String string = "" + (int)(d + (d > 0.0 ? 0.5 : -0.5));
            return string;
        }
        String string = "";
        if (d < 0.0) {
            string = string + "-";
            d = -d;
        }
        if ((d += 0.5 * Math.pow(10.0, -n)) > 1.0) {
            long l = (long)d;
            string = string + l;
            d -= (double)l;
        } else {
            string = string + "0";
        }
        if (d > 0.0) {
            String string2 = "" + (long)((d += 1.0) * Math.pow(10.0, n));
            string = string + "." + string2.substring(1);
        }
        return string;
    }

    private void suspendForPeriod(long l) {
        long l2 = System.currentTimeMillis() + l;
        while (l > 0L) {
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
            long l3 = System.currentTimeMillis();
            l = l2 - l3;
        }
    }
}

