/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;

public class VCFlxEncloserTest
extends EgSnmpGenericTest {
    private boolean isFirst = true;

    public VCFlxEncloserTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(1);
        this.isNewDynamicInfoTest = true;
        this.snmpPortNo = this.getValueForParam("snmpPort");
        this.snmpVersion = this.getValueForParam("snmpVersion");
        this.community = this.getValueForParam("snmpCommunity");
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            Hashtable hashtable2 = this.getMeasures(".1.3.6.1.4.1.11.5.7.5.2.1.1.2.1.1.2");
            Hashtable hashtable3 = this.getMeasures(".1.3.6.1.4.1.11.5.7.5.2.1.1.2.1.1.3");
            if (hashtable2 == null || hashtable2.size() == 0) {
                if (this.isFirst) {
                    this.logToErrorFile("Info :", "VCFlxEncloserTest No enclosure available for", this.targetHost);
                    this.isFirst = false;
                }
                return;
            }
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)hashtable2.get(string);
                String string3 = (String)hashtable3.get(string);
                double d = this.getDoubleValue(string3);
                if (d == 8.0) {
                    d = 0.0;
                }
                if (d == 6.0) {
                    d = 7.0;
                }
                if (d == 7.0) {
                    d = 6.0;
                }
                ArrayList<Double> arrayList = new ArrayList<Double>();
                arrayList.add(new Double(d));
                System.out.println(this.entity + "Info:" + string2 + " MeasureList :" + arrayList);
                this.addNewMeasure(string2, arrayList);
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception :", "VCFlxEncloserTest Exception occured in computeMeasures for " + this.targetHost, exception.toString());
        }
    }

    private double getDoubleValue(String string) {
        double d = -5.0;
        try {
            if (string != null && string.trim().length() > 0) {
                d = Double.parseDouble(string);
                if (d < 0.0) {
                    d = -5.0;
                }
            } else {
                d = -5.0;
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception :", "VCFlxEncloserTest Exception occured in getDoubleValue() for " + this.targetHost, exception.toString());
            d = -5.0;
        }
        return d;
    }

    private Hashtable getMeasures(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            String string2 = "";
            String string3 = "";
            boolean bl = this.runSnmpCmdForOid(string);
            if (bl) {
                for (int i = 0; i < this.lhs.length; ++i) {
                    string3 = this.lhs[i].trim();
                    if (this.rhs[i] == null || this.rhs[i].trim().length() <= 0) continue;
                    string2 = this.rhs[i].trim();
                    hashtable.put(string3, string2);
                }
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Exception :", "VCFlxEncloserTest Exception occured in getMeasureHash() for " + this.targetHost, exception.toString());
        }
        return hashtable;
    }

    public static void main(String[] stringArray) {
        VCFlxEncloserTest vCFlxEncloserTest = new VCFlxEncloserTest(stringArray);
        vCFlxEncloserTest.computeMeasures(new Hashtable());
    }
}

