/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.eg.apm.APMWorker;
import com.eg.apm.EgLogbackManager;
import com.eg.apm.JavaTransactionFlowUtility;
import com.eg.jtm.BTMConstants;
import com.eg.jtm.BTMDiscovery;
import com.eg.org.slf4j.Logger;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

public class TransactionFlowTest
extends BusinessTransTestBase {
    private static ArrayList defaultValueList = null;
    private static final Double zeroValue = new Double(0.0);
    private static final String WEB_TOTAL_KEY = "THIS_NODE#TOTAL_Web";
    private static final String WEB_SELF_KEY = "THIS_NODE#SELF_Web";
    private static final String THREAD_TOTAL_KEY = "THIS_NODE#TOTAL_Thread";
    private static final String THREAD_SELF_KEY = "THIS_NODE#SELF_Thread";
    private static final String SELF_NODE_SYNC_KEY = "THIS_NODE_Sync:SELF";
    private static final String SELF_NODE_ASYNC_KEY = "THIS_NODE_Async:SELF";
    private static final String NODE_TOTAL_SYNC_KEY = "THIS_NODE_Sync:TOTAL";
    private static final String NODE_TOTAL_ASYNC_KEY = "THIS_NODE_Async:TOTAL";
    protected String loggerDispStr;
    protected static Logger logger = EgLogbackManager.getInstance().getLogger("TFT_LOGGER");
    private static final Hashtable KEY_MAPPING = new Hashtable();
    protected Vector allExternalCallDetails;
    protected Set egHostIpList;

    public TransactionFlowTest(String[] stringArray) {
        super(stringArray);
        this.loggerDispStr = "[" + this.reportingName + ":" + this.portNo + "] [TransactionFlowTest]";
        this.isNewDynamicInfoTest = true;
        if (defaultValueList == null) {
            defaultValueList = this.createDefaultValueList();
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        Object object;
        Object object2;
        Object object3;
        this.getJvmGuid();
        HashMap hashMap = this.getComponentsForAppflow();
        JavaTransactionFlowUtility.storeAutoNameIntoIniFile(hashMap, "NEW_APPFLOW_AUTO_NAME_MAPPING", "SEND_APPFLOW_AUTO_NAME_MAPPING", this.NodeID, logger);
        HashMap hashMap2 = TransactionFlowTest.getNodeorderForTargetnames(hashMap);
        JavaTransactionFlowUtility.storeAutoNameIntoIniFile(hashMap2, "NEW_APPFLOW_NODE_ORDER_MAPPING", "SEND_APPFLOW_NODE_ORDER_MAPPING", this.NodeID, logger);
        logger.debug("{} nodeOrder  : {} ", (Object)this.loggerDispStr, (Object)hashMap2);
        logger.debug("{} autoNames  : {} ", (Object)this.loggerDispStr, (Object)hashMap);
        Hashtable<String, Long> hashtable2 = new Hashtable<String, Long>();
        hashtable2.put("MEASURE_PERIOD", new Long(this.measurePeriod));
        BTMDiscovery bTMDiscovery = JavaTransactionFlowUtility.getBTMDiscoveryObject(this.jvmGUID);
        if (bTMDiscovery == null) {
            logger.debug("{} No TRANSACTION_FLOW_DETAILS data available for : {} ", (Object)this.loggerDispStr, (Object)this.jvmGUID);
            return;
        }
        Hashtable hashtable3 = bTMDiscovery.cloneTransmitCopy();
        this.allExternalCallDetails = (Vector)hashtable3.get("tftDetails");
        this.egHostIpList = (Set)hashtable3.get("hostPortDetails");
        logger.debug("{}  allExternalCallDetails ===> {}", (Object)this.loggerDispStr, (Object)this.allExternalCallDetails);
        logger.debug("{}  egHostIpList ===> {}", (Object)this.loggerDispStr, (Object)this.egHostIpList);
        if (this.egHostIpList == null) {
            logger.debug("{} New Ip/Port 'Not' found for Application Flow Test MultiNode Setup....", (Object)this.loggerDispStr);
        } else {
            logger.info("{} New Ip/Port found for Application Flow Test MultiNode Setup....", (Object)this.loggerDispStr);
        }
        Hashtable hashtable4 = new Hashtable();
        if (this.allExternalCallDetails != null && this.allExternalCallDetails.size() > 0) {
            try {
                object3 = this.allExternalCallDetails.elements();
                while (object3.hasMoreElements()) {
                    object2 = (HashMap)object3.nextElement();
                    for (Map.Entry object4 : ((HashMap)object2).entrySet()) {
                        Object object5;
                        double d;
                        double d2;
                        double d3;
                        object = object4.getKey().toString();
                        double[] n = (double[])object4.getValue();
                        if (((String)object).equalsIgnoreCase("NODE_DETAILS_Web")) {
                            double n2 = n[0];
                            d3 = n[1];
                            d2 = n[2];
                            d = n[3];
                            this.updateExternalCalls(WEB_TOTAL_KEY, new double[]{1.0, n2, d2, d}, hashtable4);
                            this.updateExternalCalls(WEB_SELF_KEY, new double[]{1.0, d3, d2, -5.0}, hashtable4);
                            continue;
                        }
                        if (((String)object).equalsIgnoreCase("NODE_DETAILS_Thread")) {
                            double string = n[0];
                            d3 = n[1];
                            d2 = n[2];
                            d = n[3];
                            this.updateExternalCalls(THREAD_TOTAL_KEY, new double[]{1.0, string, d2, d}, hashtable4);
                            this.updateExternalCalls(THREAD_SELF_KEY, new double[]{1.0, d3, d2, -5.0}, hashtable4);
                            continue;
                        }
                        int n3 = n.length;
                        if (n3 == 3) {
                            double d4 = n[0];
                            double d5 = n[1];
                            double d6 = n[2];
                            double d7 = -5.0;
                            n = new double[]{d4, d5, d6, d7};
                        }
                        if (KEY_MAPPING.containsKey(object)) {
                            object5 = (String)KEY_MAPPING.get(object);
                            this.updateExternalCalls((String)object5, n, hashtable4);
                            continue;
                        }
                        object5 = null;
                        if (((String)object).startsWith("EMAIL") || ((String)object).startsWith("HTTP") || ((String)object).startsWith("WEBSERVICE") || ((String)object).startsWith("EJB_HIDE") || ((String)object).startsWith("RMI") || ((String)object).startsWith("Custom_")) {
                            object5 = this.formatKeyString((String)object);
                        }
                        if (object5 == null) {
                            object5 = object;
                        }
                        KEY_MAPPING.put(object, object5);
                        this.updateExternalCalls((String)object5, n, hashtable4);
                    }
                }
            }
            catch (Exception exception) {
                logger.error("Exception occured while processing TFT data {} ", (Throwable)exception);
            }
        }
        if ((object3 = this.computeCallDetails(hashtable4)) == null) {
            logger.debug("{} No details found, so skipping measure sending", (Object)this.loggerDispStr);
            return;
        }
        object2 = ((Hashtable)object3).keySet();
        Iterator<Object> iterator = object2.iterator();
        while (iterator.hasNext()) {
            String string;
            String string2 = (String)iterator.next();
            object = (ArrayList)((Hashtable)object3).get(string2);
            logger.debug("{} Adding New Measure for descriptor : {} value : {} ", new Object[]{this.loggerDispStr, string2, object});
            this.addNewMeasure(string2, (ArrayList)object);
            int n = string2.indexOf("_Sync:");
            if (n > 0) {
                string = string2.replace("_Sync:", "_Async:");
                if (((Hashtable)object3).containsKey(string)) continue;
                logger.debug("{} Adding additional descriptor : {} with default values : {} ", new Object[]{this.loggerDispStr, string, defaultValueList});
                this.addNewMeasure(string, defaultValueList);
                continue;
            }
            string = string2.replace("_Async:", "_Sync:");
            if (((Hashtable)object3).containsKey(string)) continue;
            logger.debug("{} Adding additional descriptor : {} with default values : {} ", new Object[]{this.loggerDispStr, string, defaultValueList});
            this.addNewMeasure(string, defaultValueList);
        }
    }

    private static HashMap getNodeorderForTargetnames(HashMap hashMap) {
        if (hashMap == null || hashMap.size() < 0) {
            return null;
        }
        Hashtable<String, Integer> hashtable = APMWorker.getAutoNameHT();
        if (hashtable == null || hashtable.size() < 0) {
            return null;
        }
        Iterator iterator = hashMap.entrySet().iterator();
        HashMap hashMap2 = new HashMap();
        while (iterator.hasNext()) {
            HashSet<String> hashSet = new HashSet<String>();
            Map.Entry entry = iterator.next();
            String string = entry.getKey().toString();
            TreeSet treeSet = (TreeSet)entry.getValue();
            for (String string2 : treeSet) {
                Set<String> set = hashtable.keySet();
                Iterator<String> iterator2 = set.iterator();
                while (iterator2.hasNext()) {
                    String string3 = iterator2.next().toString();
                    if (string3.startsWith(string2)) {
                        hashSet.add(string3);
                        APMWorker.addEntryIntoComputedNodeOrders(string3);
                        continue;
                    }
                    if (!string3.startsWith(string)) continue;
                    hashSet.add(string3);
                }
            }
            if (hashSet.size() <= 0) continue;
            hashMap2.put(string, hashSet);
        }
        return hashMap2;
    }

    private HashMap getComponentsForAppflow() {
        HashMap hashMap = this.getUniqueGUIDMappingFromIniFile();
        HashMap hashMap2 = JavaTransactionFlowUtility.getAppflowTargetJvms();
        HashMap hashMap3 = this.replaceGuidWithComponentName(hashMap, hashMap2);
        logger.debug("{}  uniqueGuidMapping  : {} ", (Object)this.loggerDispStr, (Object)hashMap);
        logger.debug("{} targetguid  : {} ", (Object)this.loggerDispStr, (Object)hashMap2);
        logger.debug("{} targerComponentNames  : {} ", (Object)this.loggerDispStr, (Object)hashMap3);
        return hashMap3;
    }

    private HashMap replaceGuidWithComponentName(HashMap hashMap, HashMap hashMap2) {
        if (hashMap == null && hashMap.size() < 0 || hashMap2 == null && hashMap2.size() < 0) {
            return null;
        }
        HashMap hashMap3 = new HashMap();
        for (Map.Entry entry : hashMap2.entrySet()) {
            String string = (String)entry.getKey();
            TreeSet treeSet = (TreeSet)entry.getValue();
            String string2 = (String)hashMap.get(string);
            if (string2 == null) continue;
            Iterator iterator = treeSet.iterator();
            TreeSet<String> treeSet2 = new TreeSet<String>();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                String string4 = (String)hashMap.get(string3);
                if (string4 == null) continue;
                treeSet2.add(string4);
            }
            if (treeSet2.size() <= 0) continue;
            hashMap3.put(string2, treeSet2);
        }
        return hashMap3;
    }

    private HashMap getUniqueGUIDMappingFromIniFile() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + BTMConstants.APM_DISCOVERY_FILEPATH);
            String[] stringArray = iniFile.getVariables("JAVA_UNIQUE_GUID_COMPONENT_NAME_MAPPING");
            if (stringArray != null && stringArray.length > 0) {
                long l = stringArray.length;
                int n = 0;
                while ((long)n < l) {
                    String string = iniFile.getValue("JAVA_UNIQUE_GUID_COMPONENT_NAME_MAPPING", stringArray[n]);
                    if (string.startsWith("[")) {
                        hashMap.put(stringArray[n], string);
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            logger.error("{} Exception while reading data from INI files {}", (Object)this.loggerDispStr, (Object)exception);
        }
        return hashMap;
    }

    private void updateExternalCalls(String string, double[] dArray, Hashtable hashtable) {
        try {
            if (hashtable.containsKey(string)) {
                double[] dArray2 = (double[])hashtable.get(string);
                dArray2[0] = dArray2[0] + dArray[0];
                dArray2[1] = dArray2[1] + dArray[1];
                dArray2[2] = dArray2[2] + dArray[2];
                if (dArray.length > 3 && dArray2[3] < dArray[3]) {
                    dArray2[3] = dArray[3];
                }
            } else {
                hashtable.put(string, dArray);
            }
        }
        catch (NullPointerException nullPointerException) {
            hashtable = new Hashtable<String, double[]>();
            hashtable.put(string, dArray);
        }
    }

    private String formatKeyString(String string) {
        try {
            String string2 = null;
            int n = string.lastIndexOf("_");
            if (n > 0) {
                string2 = string.substring(n);
            }
            String string3 = string.substring(0, n);
            int n2 = string3.indexOf("#");
            String string4 = string3.substring(0, n2);
            String string5 = string3.substring(n2 + 1);
            int n3 = 0;
            if (string5 != null) {
                n3 = string5.length();
            }
            if (string4.equals("EMAIL")) {
                string5 = n3 == 0 ? "EMAIL" : this.getEmailEndPoint(string5);
            }
            if (string4.equals("RMI")) {
                string5 = string5.substring(1, n3 - 1);
            }
            if (string4.equals("EJB_HIDE") && !string5.startsWith("//")) {
                string5 = string5.substring(string5.indexOf("/"), n3);
            }
            if (string4.equals("Custom_")) {
                string4 = "CUSTOM";
            }
            string5 = string4 + "#" + string5 + string2;
            logger.debug("{} Found suitable Key for the input {} , it is {}", new Object[]{this.loggerDispStr, string, string5});
            return string5;
        }
        catch (Exception exception) {
            logger.error("Exception occur while forming key {} ", (Throwable)exception);
            return null;
        }
    }

    private String HttpAndWebserviceUrlCreator(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            URL uRL = new URL(string);
            if (uRL.getPort() < 0) {
                stringBuffer.append(uRL.getProtocol()).append("://").append(uRL.getHost()).append(":").append(uRL.getDefaultPort());
            } else {
                stringBuffer.append(uRL.getProtocol()).append("://").append(uRL.getHost()).append(":").append(uRL.getPort());
            }
        }
        catch (Exception exception) {
            logger.error("{} Error while creating webservice and http TFT URL : {}", (Object)this.loggerDispStr, (Object)exception);
        }
        return stringBuffer.toString();
    }

    private Hashtable computeCallDetails(Hashtable hashtable) {
        if (hashtable == null || hashtable.size() == 0) {
            return null;
        }
        Hashtable hashtable2 = new Hashtable();
        Set set = hashtable.keySet();
        Iterator iterator = set.iterator();
        long l = this.measurePeriod / 1000L / 60L;
        logger.debug("{} Transaction Flow Test Frequency :{} in minutes", (Object)this.loggerDispStr, (Object)l);
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            double[] dArray = (double[])hashtable.get(string);
            double d = dArray[0];
            double d2 = dArray[1];
            double d3 = dArray[2];
            double d4 = dArray[3];
            double d5 = d / (double)l;
            double d6 = d3 / (double)l;
            double d7 = 0.0;
            double d8 = 0.0;
            if (d > 0.0) {
                d7 = d3 / d * 100.0;
                d8 = d2 / d;
            }
            String string2 = null;
            String string3 = null;
            int n = string.indexOf("#");
            if (n > 0) {
                string2 = string.substring(0, n);
                string3 = string.substring(n + 1);
            }
            String string4 = null;
            String string5 = null;
            int n2 = string3.lastIndexOf("_");
            if (n2 > 0) {
                string5 = string3.substring(0, n2);
                string4 = string3.substring(n2);
            }
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(new Double(d));
            arrayList.add(new Double(d8));
            arrayList.add(new Double(d5));
            arrayList.add(new Double(d3));
            arrayList.add(new Double(d6));
            arrayList.add(new Double(d7));
            arrayList.add(new Double(d4));
            String string6 = "DB_Sync:";
            if (string2.equals("SQL")) {
                Hashtable hashtable3 = this.DataBaseInfo(string5);
                if (hashtable3 == null || hashtable3.size() <= 0) continue;
                String string7 = (String)hashtable3.get("SERVERTYPE");
                String string8 = (String)hashtable3.get("SERVERNAME");
                String string9 = (String)hashtable3.get("PORTNUMBER");
                String string10 = (String)hashtable3.get("DATABASENAME");
                if (string4.equals("_Thread")) {
                    string6 = "DB_Async:";
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(string6).append(string7).append(":").append(string8).append(":").append(string9).append("_").append(string10);
                String string11 = stringBuffer.toString();
                hashtable2.put(string11, arrayList);
                continue;
            }
            if (string2.endsWith("_")) {
                string2 = string2.substring(0, string2.lastIndexOf("_"));
            }
            string6 = string4.equals("_Thread") ? string2 + "_Async:" : string2 + "_Sync:";
            hashtable2.put(string6 + string5, arrayList);
        }
        return hashtable2;
    }

    private ArrayList createDefaultValueList() {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(zeroValue);
        arrayList.add(zeroValue);
        arrayList.add(zeroValue);
        arrayList.add(zeroValue);
        arrayList.add(zeroValue);
        arrayList.add(zeroValue);
        arrayList.add(minusFive);
        logger.debug("{} Created default value list ....{}", (Object)this.loggerDispStr, arrayList);
        return arrayList;
    }
}

