/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgSSL;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class ThroughputTest
extends GenericTest {
    String strUrl;
    long tout = 0L;
    long numBytes_upload = 0L;
    long numBytes_download = 0L;

    public ThroughputTest(String[] stringArray) {
        super(stringArray);
        String string;
        this.setMeasureCount(4);
        String string2 = this.getValueForParam("uploadsize");
        String string3 = this.getValueForParam("downloadsize");
        this.numBytes_upload = Long.parseLong(string2) * 1024L;
        this.numBytes_download = Long.parseLong(string3) * 1024L;
        this.strUrl = this.getValueForParam("URL");
        if (this.strUrl.endsWith("/")) {
            this.strUrl = this.strUrl.substring(0, this.strUrl.length() - 1);
        }
        if (this.strUrl.startsWith("https:")) {
            this.enableSsl();
        }
        if ((string = this.getValueForParam("timeout")) != null) {
            this.tout = Integer.parseInt(string) * 1000;
        }
    }

    public double[] getUpLink() {
        String string = this.strUrl + "/final/servlet/com.eg.UpLinkTestServlet";
        HttpURLConnection httpURLConnection = null;
        URL uRL = null;
        try {
            uRL = new URL(string);
            long l = System.currentTimeMillis();
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            LinkConnThread linkConnThread = new LinkConnThread(httpURLConnection, this.numBytes_upload, false);
            int n = 0;
            long l2 = 0L;
            while (!linkConnThread.done) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                    if ((l2 += 100L) < this.tout) continue;
                    break;
                }
                catch (Exception exception) {
                }
            }
            if (linkConnThread.done) {
                n = linkConnThread.code;
            }
            double d = linkConnThread.endTime;
            linkConnThread = null;
            httpURLConnection.disconnect();
            httpURLConnection = null;
            double d2 = (d - (double)l) / 1000.0;
            double d3 = -5.0;
            if (d2 > 0.0) {
                d3 = (double)(this.numBytes_upload * 8L) / (d2 * 1024.0);
            }
            if (n != 200) {
                double[] dArray = new double[]{0.0, -5.0};
                return dArray;
            }
            double[] dArray = new double[]{100.0, d3};
            return dArray;
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println(malformedURLException.toString());
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            return null;
        }
    }

    public double[] getDownLink() {
        String string = this.strUrl + "/final/servlet/com.eg.DownLinkTestServlet?noofbytes=" + this.numBytes_download;
        HttpURLConnection httpURLConnection = null;
        URL uRL = null;
        try {
            uRL = new URL(string);
            long l = System.currentTimeMillis();
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.connect();
            LinkConnThread linkConnThread = new LinkConnThread(httpURLConnection, this.numBytes_download, true);
            int n = 0;
            long l2 = 0L;
            while (!linkConnThread.done) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                    if ((l2 += 200L) < this.tout) continue;
                    break;
                }
                catch (Exception exception) {
                }
            }
            if (linkConnThread.done) {
                n = linkConnThread.code;
            }
            double d = linkConnThread.endTime;
            linkConnThread = null;
            httpURLConnection.disconnect();
            httpURLConnection = null;
            double d2 = (d - (double)l) / 1000.0;
            double d3 = -5.0;
            if (d2 > 0.0) {
                d3 = (double)(this.numBytes_download * 8L) / (d2 * 1024.0);
            }
            if (n != 200) {
                double[] dArray = new double[]{0.0, -5.0};
                return dArray;
            }
            double[] dArray = new double[]{100.0, d3};
            return dArray;
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println(malformedURLException.toString());
            return null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            return null;
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        if (this.numBytes_upload <= 0L) {
            dArray[0] = -5.0;
            dArray[1] = -5.0;
        } else {
            dArray = this.getUpLink();
            if (dArray == null) {
                dArray = new double[]{-5.0, -5.0};
            }
            System.out.println("Uplink status: Availability: " + dArray[0] + "; Throughput (Kbps): " + dArray[1]);
        }
        if (this.numBytes_download <= 0L) {
            dArray2[0] = -5.0;
            dArray2[1] = -5.0;
        } else {
            dArray2 = this.getDownLink();
            if (dArray2 == null) {
                dArray2 = new double[]{-5.0, -5.0};
            }
            System.out.println("Downlink status: Availability: " + dArray2[0] + "; Throughput (Kbps): " + dArray2[1]);
        }
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(new Double(dArray[0]));
        arrayList.add(new Double(dArray[1]));
        arrayList.add(new Double(dArray2[0]));
        arrayList.add(new Double(dArray2[1]));
        this.addNewMeasure(arrayList);
    }

    private void enableSsl() {
        EgSSL egSSL = EgSSL.getInstance();
        egSSL.enableSSL();
        SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        Object var3_3 = null;
        try {
            MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
            KeyManager[] keyManagerArray = null;
            TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
            SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
            HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
        }
        catch (Exception exception) {
            System.out.println("Exception in ThroughputTest of enableSsl ... " + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        ThroughputTest throughputTest = new ThroughputTest(stringArray);
        throughputTest.computeMeasures(new Hashtable());
    }
}

