/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgLangInfo;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class TcpPortTest
extends RunNetstat {
    private Double d1;
    private Double d2 = null;
    private String str_Ip = null;
    private String str_Port = null;
    private String str_RIp = null;
    private String str_RP = null;
    private String str_info = null;
    private double i_syn_sent = 0.0;
    private double i_syn_received = 0.0;
    private double i_established = 0.0;
    private double i_close_wait = 0.0;
    private double i_fin_wait_1 = 0.0;
    private double i_fin_wait_2 = 0.0;
    private double i_time_wait = 0.0;
    private double i_sendq = 0.0;
    private double i_reciveq = 0.0;
    private String info = null;
    private String str_cmd = null;
    private double send = 0.0;
    private double rcv = 0.0;
    private String argsSeparator = ",";

    public TcpPortTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(9);
        this.real_sid = this.getValueForParam("info");
    }

    public void computeMeasures(Hashtable hashtable) {
        this.runNetstat();
        this.filter(hashtable);
    }

    public void filter(Hashtable hashtable) {
        String string = null;
        StringTokenizer stringTokenizer = null;
        string = (String)hashtable.get("targetAppPorts");
        if (string != null) {
            stringTokenizer = new StringTokenizer(string, this.argsSeparator);
            String string2 = null;
            while (stringTokenizer.hasMoreTokens()) {
                boolean bl = false;
                string2 = stringTokenizer.nextToken();
                this.parsePorts(string2);
            }
        }
    }

    public void parsePorts(String string) {
        ArrayList arrayList = new ArrayList();
        if (al_localIps != null && al_localIps.size() > 0) {
            int n = al_localIps.size();
            for (int i = 0; i < n; ++i) {
                arrayList.add(new Boolean(false));
            }
        }
        if (this.split(string)) {
            if (!this.str_Ip.equals("*")) {
                arrayList = this.removeUnwanted(al_localIps, arrayList, this.str_Ip);
            }
            if (!this.str_Port.equals("*")) {
                arrayList = this.removeUnwanted(al_localPorts, arrayList, this.str_Port);
            }
            if (!this.str_RIp.equals("*")) {
                arrayList = this.removeUnwanted(al_remoteIps, arrayList, this.str_RIp);
            }
            if (!this.str_RP.equals("*")) {
                arrayList = this.removeUnwanted(al_remotePorts, arrayList, this.str_RP);
            }
        }
        this.populateMeasures(arrayList, this.str_info);
    }

    private ArrayList removeUnwanted(ArrayList arrayList, ArrayList arrayList2, String string) {
        try {
            if (arrayList2 != null && arrayList2.size() > 0 && arrayList != null && arrayList.size() > 0) {
                int n = arrayList2.size();
                for (int i = 0; i < n; ++i) {
                    String string2;
                    Boolean bl = (Boolean)arrayList2.get(i);
                    if (bl.booleanValue() || TcpPortTest.isMatch(string2 = (String)arrayList.get(i), string)) continue;
                    arrayList2.set(i, new Boolean(true));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList2;
    }

    public boolean split(String string) {
        try {
            int n = string.indexOf(":");
            this.str_info = string.substring(0, n);
            string = string.substring(n + 1);
            n = string.indexOf(":");
            this.str_Ip = string.substring(0, n);
            int n2 = string.indexOf("@");
            this.str_Port = string.substring(n + 1, n2);
            n = string.indexOf(":", n2);
            this.str_RIp = string.substring(n2 + 1, n);
            this.str_RP = string.substring(n + 1);
            return true;
        }
        catch (Exception exception) {
            System.out.println("Caught in split : " + exception);
            exception.printStackTrace();
            return false;
        }
    }

    public void populateMeasures(ArrayList arrayList, String string) {
        this.i_syn_sent = 0.0;
        this.i_syn_received = 0.0;
        this.i_established = 0.0;
        this.i_close_wait = 0.0;
        this.i_fin_wait_1 = 0.0;
        this.i_fin_wait_2 = 0.0;
        this.i_time_wait = 0.0;
        this.i_sendq = 0.0;
        this.i_reciveq = 0.0;
        this.send = 0.0;
        this.rcv = 0.0;
        String string2 = EgLangInfo.getAgentCommandSearch("netstat", "syn_sent");
        String string3 = EgLangInfo.getAgentCommandSearch("netstat", "syn_received");
        String string4 = EgLangInfo.getAgentCommandSearch("netstat", "established");
        String string5 = EgLangInfo.getAgentCommandSearch("netstat", "close_wait");
        String string6 = EgLangInfo.getAgentCommandSearch("netstat", "fin_wait_1");
        String string7 = EgLangInfo.getAgentCommandSearch("netstat", "fin_wait1");
        String string8 = EgLangInfo.getAgentCommandSearch("netstat", "fin_wait_2");
        String string9 = EgLangInfo.getAgentCommandSearch("netstat", "fin_wait2");
        String string10 = EgLangInfo.getAgentCommandSearch("netstat", "time_wait");
        if (arrayList != null && arrayList.size() > 0) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                Boolean bl = (Boolean)arrayList.get(i);
                if (bl.booleanValue()) continue;
                String string11 = (String)al_state_local.get(i);
                if (string11.equalsIgnoreCase(string2)) {
                    this.i_syn_sent += 1.0;
                } else if (string11.equalsIgnoreCase(string3)) {
                    this.i_syn_received += 1.0;
                } else if (string11.equalsIgnoreCase(string4)) {
                    this.i_established += 1.0;
                } else if (string11.equalsIgnoreCase(string5)) {
                    this.i_close_wait += 1.0;
                } else if (string11.equalsIgnoreCase(string6) || string11.equalsIgnoreCase(string7)) {
                    this.i_fin_wait_1 += 1.0;
                } else if (string11.equalsIgnoreCase(string8) || string11.equalsIgnoreCase(string9)) {
                    this.i_fin_wait_2 += 1.0;
                } else if (string11.equalsIgnoreCase(string10)) {
                    this.i_time_wait += 1.0;
                }
                String string12 = (String)al_sendQ.get(i);
                double d = Double.parseDouble(string12);
                string12 = (String)al_receiveQ.get(i);
                double d2 = Double.parseDouble(string12);
                this.send += d;
                this.rcv += d2;
            }
        }
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        arrayList2.add(new Double(this.i_syn_sent));
        arrayList2.add(new Double(this.i_syn_received));
        arrayList2.add(new Double(this.i_established));
        arrayList2.add(new Double(this.i_close_wait));
        arrayList2.add(new Double(this.i_fin_wait_1));
        arrayList2.add(new Double(this.i_fin_wait_2));
        arrayList2.add(new Double(this.i_time_wait));
        if (!this.isWindows) {
            arrayList2.add(new Double(this.send));
            arrayList2.add(new Double(this.rcv));
        } else {
            arrayList2.add(new Double(0.0));
            arrayList2.add(new Double(0.0));
        }
        this.addNewMeasure(this.str_info, arrayList2);
    }
}

