/*
 * Decompiled with CFR 0.152.
 */
import com.sybase.jdbcx.SybConnection;
import com.sybase.jdbcx.SybStatement;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class SybEngineTest
extends GenericTest {
    private String user;
    private String passwd;
    private String s_debug = "false";
    private boolean isDebug = false;
    private String driver = "com.sybase.jdbc2.jdbc.SybDriver";
    private static final int i_measureCount = 4;
    private Hashtable prevHash = new Hashtable();
    private String curTimeSecs = "";
    private String prevTimeSecs = "";
    private String query = "";
    private boolean isFirstTime = true;
    private String defaultCharSet = "iso_1";

    public SybEngineTest(String[] stringArray) {
        super(stringArray);
        Comparable<Boolean> comparable;
        this.setMeasureCount(4);
        this.isDynamicInfoTest = true;
        this.user = this.getValueForParam("user");
        this.passwd = this.getValueForParam("password");
        this.s_debug = this.getValueForParam("isdebug");
        try {
            comparable = new Boolean(this.s_debug);
            this.isDebug = (Boolean)comparable;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.isDebug = false;
        }
        comparable = new StringBuffer();
        ((StringBuffer)comparable).append(" select EngineNumber engine_no, CPUTime cpu_time, ");
        ((StringBuffer)comparable).append(" SystemCPUTime sys_cpu_time, UserCPUTime user_cpu_time, ");
        ((StringBuffer)comparable).append(" IdleCPUTime idle_cpu_time, getdate()  as cur_date from monEngine ");
        this.query = ((StringBuffer)comparable).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        String string;
        if (this.isFirstTime) {
            string = SybDbStats.getCharSetName(this.targetHost, this.portNo, this.user, this.passwd);
            if (string != null && string.length() > 0) {
                this.defaultCharSet = string;
                this.isFirstTime = false;
            } else {
                this.isFirstTime = true;
                return;
            }
        }
        string = this.getConnection(this.targetHost, this.portNo, this.user, this.passwd);
        SybStatement sybStatement = null;
        ResultSet resultSet = null;
        if (string == null) {
            return;
        }
        try {
            sybStatement = (SybStatement)string.createStatement();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            if (string != null) {
                this.closeConn((SybConnection)string);
            }
            return;
        }
        Hashtable hashtable2 = new Hashtable();
        ArrayList<Double> arrayList = new ArrayList<Double>();
        String string2 = "";
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        try {
            try {
                resultSet = sybStatement.executeQuery(this.query);
                while (resultSet.next()) {
                    string2 = resultSet.getString(1);
                    d = resultSet.getDouble(2);
                    d2 = resultSet.getDouble(3);
                    d3 = resultSet.getDouble(4);
                    d4 = resultSet.getDouble(5);
                    this.curTimeSecs = resultSet.getString(6);
                    arrayList = new ArrayList();
                    arrayList.add(new Double(d));
                    arrayList.add(new Double(d2));
                    arrayList.add(new Double(d3));
                    arrayList.add(new Double(d4));
                    hashtable2.put(string2, arrayList);
                }
                if (this.prevHash != null && this.prevHash.size() > 0) {
                    Enumeration enumeration = hashtable2.keys();
                    while (enumeration.hasMoreElements()) {
                        String string3 = (String)enumeration.nextElement();
                        ArrayList arrayList2 = (ArrayList)hashtable2.get(string3);
                        ArrayList arrayList3 = (ArrayList)this.prevHash.get(string3);
                        if (arrayList3 == null) continue;
                        double d5 = (Double)arrayList2.get(0);
                        double d6 = (Double)arrayList3.get(0);
                        double d7 = (Double)arrayList2.get(1);
                        double d8 = (Double)arrayList3.get(1);
                        double d9 = (Double)arrayList2.get(2);
                        double d10 = (Double)arrayList3.get(2);
                        double d11 = (Double)arrayList2.get(3);
                        double d12 = (Double)arrayList3.get(3);
                        double d13 = 0.0;
                        double d14 = 0.0;
                        double d15 = 0.0;
                        d13 = this.getFreqSecs(this.curTimeSecs);
                        if (d13 >= (d14 = this.getFreqSecs(this.prevTimeSecs))) {
                            d15 = d13 - d14;
                        }
                        double d16 = 0.0;
                        double d17 = 0.0;
                        double d18 = 0.0;
                        double d19 = 0.0;
                        double d20 = -5.0;
                        double d21 = -5.0;
                        double d22 = -5.0;
                        double d23 = -5.0;
                        if (d15 > 0.0) {
                            if (d7 >= d8) {
                                d17 = d7 - d8;
                                d21 = d17 / d15 * 100.0;
                            } else {
                                d21 = -5.0;
                            }
                            if (d9 >= d10) {
                                d18 = d9 - d10;
                                d22 = d18 / d15 * 100.0;
                            } else {
                                d22 = -5.0;
                            }
                            if (d11 >= d12) {
                                d19 = d11 - d12;
                                d23 = d19 / d15 * 100.0;
                            } else {
                                d23 = -5.0;
                            }
                            d20 = (d17 + d18) / d15 * 100.0;
                        }
                        ArrayList<Double> arrayList4 = new ArrayList<Double>();
                        arrayList4.add(new Double(d20));
                        arrayList4.add(new Double(d21));
                        arrayList4.add(new Double(d22));
                        arrayList4.add(new Double(d23));
                        String string4 = "Engine" + string3;
                        if (this.isDebug) {
                            System.out.println("[" + this.getClass().getName() + "]-Final MeasureList : " + string4 + "-->" + arrayList4);
                        }
                        this.addNewMeasure(string4, arrayList4);
                    }
                }
                this.prevHash = (Hashtable)hashtable2.clone();
                this.prevTimeSecs = this.curTimeSecs;
            }
            catch (Exception exception) {
                this.logToErrorFile("Error :", " SybEngineTest execute query ", exception.toString());
                exception.printStackTrace();
                Object var61_40 = null;
                if (resultSet != null) {
                    this.closeRs(resultSet);
                }
                if (sybStatement != null) {
                    this.closeStmt(sybStatement);
                }
                if (string != null) {
                    this.closeConn((SybConnection)string);
                }
            }
            Object var61_39 = null;
            if (resultSet != null) {
                this.closeRs(resultSet);
            }
            if (sybStatement != null) {
                this.closeStmt(sybStatement);
            }
            if (string != null) {
                this.closeConn((SybConnection)string);
            }
        }
        catch (Throwable throwable) {
            Object var61_41 = null;
            if (resultSet != null) {
                this.closeRs(resultSet);
            }
            if (sybStatement != null) {
                this.closeStmt(sybStatement);
            }
            if (string != null) {
                this.closeConn((SybConnection)string);
            }
            throw throwable;
        }
    }

    private double getFreqSecs(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = simpleDateFormat.parse(string, parsePosition);
        long l = date.getTime();
        double d = l / 1000L;
        return d;
    }

    private SybConnection getConnection(String string, String string2, String string3, String string4) {
        try {
            Class.forName(this.driver);
            String string5 = "jdbc:sybase:Tds:" + string + ":" + string2;
            Properties properties = new Properties();
            properties.put("user", string3);
            properties.put("password", string4);
            properties.put("charset", this.defaultCharSet);
            properties.put("IS_CLOSED_TEST", "INTERNAL");
            properties.put("REPEAT_READ", "false");
            SybConnection sybConnection = (SybConnection)DriverManager.getConnection(string5, properties);
            sybConnection.setAutoCommit(false);
            return sybConnection;
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "Exception while Connection ", exception.toString());
            exception.printStackTrace();
            return null;
        }
    }

    private void closeRs(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
                resultSet = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeStmt(SybStatement sybStatement) {
        if (sybStatement != null) {
            try {
                sybStatement.close();
                sybStatement = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void closeConn(SybConnection sybConnection) {
        if (sybConnection != null) {
            try {
                sybConnection.close();
                sybConnection = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public static void main(String[] stringArray) {
        SybEngineTest sybEngineTest = new SybEngineTest(stringArray);
        sybEngineTest.computeMeasures(new Hashtable());
    }
}

