/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;

public class RedisMemoryTest
extends RedisBase {
    private static final String REDIS_MEMORY_COMMAND = "Memory";
    private static final String indexSubject = "REDIS_MEMORY_MEASURE_INDEX";
    private static final String nameSubject = "REDIS_MEMORY_MEASURE";
    private static Hashtable measureIndexTable = new Hashtable();
    private static Hashtable measureNameTable = new Hashtable();
    private static ArrayList redisNameList = new ArrayList();
    private long lastModifiedTime = 0L;
    private static final boolean isInfoBased = false;
    private static Date modifiedDate;

    public RedisMemoryTest(String[] stringArray) {
        super(stringArray);
        try {
            this.needAgentlessDD = true;
            logger.info(this.logPrefix + " Initializing RedisMemoryTest ...");
            this.setMeasureCount(this.measureCount);
            measureIndexTable = this.getIndexTable(indexSubject);
            measureNameTable = this.getNameTable(nameSubject);
            redisNameList = this.getNameList(nameSubject);
            this.lastModifiedTime = this.getModifiedTime();
            logger.info(this.logPrefix + " RedisMemoryTest initialized successfully");
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " Exception while initializing RedisMemoryTest", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        try {
            logger.debug(this.logPrefix + this.testStart);
            String string = this.getMetrics(REDIS_MEMORY_COMMAND);
            if (string == null || string.length() <= 0) {
                this.finalMeasures(this.measureCount);
                logger.info(this.logPrefix + " Redis Memory Details is null or empty, hence sending -5 values for all measures ");
            } else {
                Hashtable hashtable2 = this.parseMetrics(string, false);
                this.getRedisMeasureForMemory(hashtable2);
            }
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " [computeMeasures]Exception occured in computeMeasures method", (Throwable)exception);
        }
        finally {
            logger.debug(this.logPrefix + this.testEnd);
        }
    }

    public void getRedisMeasureForMemory(Hashtable hashtable) {
        if (hashtable == null || hashtable.size() == 0) {
            logger.debug(this.logPrefix + "[getRedisMeasureForMemory]  metricObject is null or empty ,thus returning null");
            return;
        }
        try {
            long l = this.getModifiedTime();
            if (l - this.lastModifiedTime > 0L) {
                modifiedDate = new Date(l);
                this.updateINIFileObject();
                measureIndexTable = this.getIndexTable(indexSubject);
                measureNameTable = this.getNameTable(nameSubject);
                redisNameList = this.getNameList(nameSubject);
                this.lastModifiedTime = l;
            }
            logger.debug(this.logPrefix + " metricObject :" + hashtable);
            logger.debug(this.logPrefix + " measureIndexTable :" + measureIndexTable);
            logger.debug(this.logPrefix + " measureNameTable  :" + measureNameTable);
            logger.debug(this.logPrefix + " redisNameList     :" + redisNameList);
            ArrayList arrayList = this.finalMeasures(this.measureCount);
            Iterator iterator = (Iterator)((Object)hashtable.keys());
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Hashtable hashtable2 = null;
                try {
                    hashtable2 = (Hashtable)hashtable.get(string);
                    logger.debug(this.logPrefix + " [getRedisMeasureForMemory] The Metric key and value table is : " + hashtable2);
                }
                catch (Exception exception) {
                    logger.error(this.logPrefix + " [getRedisMeasureForMemory] Exception occured while fetching the values from testTable ", (Throwable)exception);
                }
                if (hashtable2 == null || hashtable2.size() <= 0) continue;
                Iterator iterator2 = (Iterator)((Object)hashtable2.keys());
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    Object object = null;
                    try {
                        object = hashtable2.get(string2);
                    }
                    catch (Exception exception) {
                        logger.error(this.logPrefix + " [getRedisMeasureForMemory] Exception occured while getting fetching the values from metricTable ", (Throwable)exception);
                    }
                    if (!redisNameList.contains(string2)) continue;
                    String string3 = (String)measureNameTable.get(string2);
                    int n = Integer.parseInt(measureIndexTable.get(string3).toString());
                    double d = 0.0;
                    try {
                        d = n != 1 ? Double.parseDouble(EgUtils.convertMemoryValues(object.toString(), "B", "MB")) : Double.parseDouble(object.toString());
                        arrayList.set(n, new Double(d));
                        logger.debug(this.logPrefix + " [getRedisMeasureForMemory]  index : " + n + " ==> metric name : " + string2 + " value : " + d);
                    }
                    catch (Exception exception) {
                        logger.error(this.logPrefix + " [getRedisMeasureForMemory] Exception occured while parsing String to Double");
                    }
                }
                logger.info(this.logPrefix + "  [getRedisMeasureForMemory] The ArrayList  measure contains = " + arrayList);
                this.addNewMeasure(arrayList);
            }
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " Exception occered in [getRedisMeasureForMemory] ", (Throwable)exception);
        }
    }

    public static void main(String[] stringArray) {
        RedisMemoryTest redisMemoryTest = new RedisMemoryTest(stringArray);
        redisMemoryTest.computeMeasures(new Hashtable());
    }
}

