/*
 * Decompiled with CFR 0.152.
 */
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;

public class RedisCpuTest
extends RedisBase {
    private static final String REDIS_CPU_COMMAND = "CPU";
    private static final String REDIS_SERVER_COMMAND = "SERVER";
    private static final String cpuIndexSubject = "REDIS_CPU_MEASURE_INDEX";
    private static final String ServerIndexSubject = "REDIS_CPU_CAL_INDEX";
    private static final String cpuIameSubject = "REDIS_CPU_MEASURE";
    private static final String serverNameSubject = "REDIS_CPU_CAL";
    private static Hashtable cpuMeasureIndexTable = new Hashtable();
    private static Hashtable serverMeasureIndexTable = new Hashtable();
    private static Hashtable cpuMeasureNameTable = new Hashtable();
    private static Hashtable serverMeasureNameTable = new Hashtable();
    private static ArrayList cpuRedisNameList = new ArrayList();
    private static ArrayList serverRedisNameList = new ArrayList();
    double previousuptimeSecs = 0.0;
    double previousTotaltime = 0.0;
    private long lastModifiedTime = 0L;
    private static final boolean isInfoBased = false;

    public RedisCpuTest(String[] stringArray) {
        super(stringArray);
        try {
            this.needAgentlessDD = true;
            logger.info(this.logPrefix + " Initializing RedisCpuTest ...");
            this.setMeasureCount(this.measureCount);
            cpuMeasureIndexTable = this.getIndexTable(cpuIndexSubject);
            cpuMeasureNameTable = this.getNameTable(cpuIameSubject);
            cpuRedisNameList = this.getNameList(cpuIameSubject);
            serverMeasureIndexTable = this.getIndexTable(ServerIndexSubject);
            serverMeasureNameTable = this.getNameTable(serverNameSubject);
            serverRedisNameList = this.getNameList(serverNameSubject);
            this.lastModifiedTime = this.getModifiedTime();
            logger.info(this.logPrefix + " RedisCpuTest initialized successfully");
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " Exception while initializing RedisCpuTest", (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        try {
            logger.debug(this.logPrefix + this.testStart);
            ArrayList arrayList = this.finalMeasures(this.measureCount);
            String string = this.getMetrics(REDIS_CPU_COMMAND);
            if (string == null || string.length() <= 0) {
                this.finalMeasures(this.measureCount);
                logger.info(this.logPrefix + " Redis CPU Details is null or empty, hence sending -5 values for all measures ");
            } else {
                Hashtable hashtable2 = this.parseMetrics(string, false);
                double d = 0.0;
                ArrayList arrayList2 = this.getRedisCPUMeasures(hashtable2, cpuIameSubject, cpuIndexSubject, cpuMeasureIndexTable, cpuMeasureNameTable, cpuRedisNameList, this.lastModifiedTime);
                if (arrayList2.size() > 0) {
                    arrayList = arrayList2;
                    for (int i = 1; i < arrayList2.size(); ++i) {
                        d += ((Double)arrayList2.get(i)).doubleValue();
                    }
                }
                string = this.getMetrics(REDIS_SERVER_COMMAND);
                hashtable2 = this.parseMetrics(string, false);
                ArrayList arrayList3 = this.getRedisServerMeasure(hashtable2, serverNameSubject, ServerIndexSubject, serverMeasureIndexTable, serverMeasureNameTable, serverRedisNameList, this.lastModifiedTime);
                Double d2 = (Double)arrayList3.get(0);
                Double d3 = (Double)arrayList3.get(1);
                double d4 = 0.0;
                double d5 = 0.0;
                double d6 = 0.0;
                logger.debug(this.logPrefix + "  [computeMeasures] Previous Redis uptime in seconds = " + this.previousuptimeSecs);
                logger.debug(this.logPrefix + "  [computeMeasures] New Redis uptime in seconds = " + d2);
                if (d2 > this.previousuptimeSecs) {
                    d5 = d2 - this.previousuptimeSecs;
                    this.previousuptimeSecs = d2;
                    logger.debug(this.logPrefix + "  [computeMeasures] Difference of Redis uptime in seconds = " + d5);
                } else {
                    d5 = 0.0;
                }
                logger.debug(this.logPrefix + "  [computeMeasures]  Previous Total CPU time in seconds = " + this.previousTotaltime);
                logger.debug(this.logPrefix + "  [computeMeasures]  New Total CPU time in seconds = " + d);
                if (d > this.previousTotaltime) {
                    d6 = d - this.previousTotaltime;
                    this.previousTotaltime = d;
                    logger.debug(this.logPrefix + "  [computeMeasures]  difference of Total CPU time in seconds = " + d6);
                } else {
                    d6 = 0.0;
                }
                if (d6 > 0.0 && d5 > 0.0) {
                    d4 = 100.0 * (d6 / d5);
                }
                arrayList.set(0, new Double(new DecimalFormat("##.##").format(d4)));
                this.addNewMeasure(arrayList);
                logger.info(this.logPrefix + "  [computeMeasures]  The ArrayList  measure contains = " + arrayList);
            }
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " [computeMeasures]Exception occured in computeMeasures method", (Throwable)exception);
        }
        finally {
            logger.debug(this.logPrefix + this.testEnd);
        }
    }

    public ArrayList getRedisCPUMeasures(Hashtable hashtable, String string, String string2, Hashtable hashtable2, Hashtable hashtable3, ArrayList arrayList, long l) {
        double d = 0.0;
        ArrayList arrayList2 = this.finalMeasures(this.measureCount);
        if (hashtable == null || hashtable.size() == 0) {
            logger.debug(this.logPrefix + "[getRedisCPUMeasures]  metricObject is null or empty ,thus returning null");
            return arrayList2;
        }
        try {
            long l2 = this.getModifiedTime();
            if (l2 - l > 0L) {
                modifiedDate = new Date(l2);
                this.updateINIFileObject();
                hashtable2 = this.getIndexTable(string2);
                hashtable3 = this.getNameTable(string);
                arrayList = this.getNameList(string);
            }
            logger.debug(this.logPrefix + " metricObject :" + hashtable);
            logger.debug(this.logPrefix + " measureIndexTable :" + hashtable2);
            logger.debug(this.logPrefix + " measureNameTable  :" + hashtable3);
            logger.debug(this.logPrefix + " redisNameList     :" + arrayList);
            Iterator iterator = (Iterator)((Object)hashtable.keys());
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                Hashtable hashtable4 = null;
                try {
                    hashtable4 = (Hashtable)hashtable.get(string3);
                    logger.debug(this.logPrefix + " [getRedisCPUMeasures] The Metric key and value table is : " + hashtable4);
                }
                catch (Exception exception) {
                    logger.error(this.logPrefix + " [getRedisCPUMeasures] Exception occured while fetching the values from testTable ", (Throwable)exception);
                }
                if (hashtable4 == null || hashtable4.size() <= 0) continue;
                Iterator iterator2 = (Iterator)((Object)hashtable4.keys());
                while (iterator2.hasNext()) {
                    String string4 = (String)iterator2.next();
                    Object object = null;
                    try {
                        object = hashtable4.get(string4);
                    }
                    catch (Exception exception) {
                        logger.error(this.logPrefix + " [getRedisCPUMeasures] Exception occured while getting fetching the values from metricTable ", (Throwable)exception);
                    }
                    if (!arrayList.contains(string4)) continue;
                    String string5 = (String)hashtable3.get(string4);
                    int n = Integer.parseInt(hashtable2.get(string5).toString());
                    try {
                        double d2 = Double.parseDouble(object.toString());
                        d += d2;
                        arrayList2.set(n, new Double(d2));
                        logger.debug(this.logPrefix + " [getRedisCPUMeasures] index : " + n + " ==> metric name : " + string4 + " value: " + d2);
                    }
                    catch (Exception exception) {
                        logger.error(this.logPrefix + " [getRedisCPUMeasures] Exception occured while parsing String to Double", (Throwable)exception);
                    }
                }
            }
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " Exception occered in [getRedisCPUMeasures] ", (Throwable)exception);
        }
        return arrayList2;
    }

    public ArrayList getRedisServerMeasure(Hashtable hashtable, String string, String string2, Hashtable hashtable2, Hashtable hashtable3, ArrayList arrayList, long l) {
        ArrayList arrayList2 = this.finalMeasures(2);
        if (hashtable == null || hashtable.size() == 0) {
            logger.debug(this.logPrefix + "[getRedisServerMeasure]  metricObject is null or empty ,thus returning null");
            return null;
        }
        try {
            long l2 = this.getModifiedTime();
            if (l2 - l > 0L) {
                serverMeasureIndexTable = this.getIndexTable(string2);
                serverMeasureNameTable = this.getNameTable(string);
                serverRedisNameList = this.getNameList(string);
            }
            logger.debug(this.logPrefix + " metricObject :" + hashtable);
            logger.debug(this.logPrefix + " measureIndexTable :" + hashtable2);
            logger.debug(this.logPrefix + " measureNameTable  :" + hashtable3);
            logger.debug(this.logPrefix + " redisNameList     :" + arrayList);
            Iterator iterator = (Iterator)((Object)hashtable.keys());
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                Hashtable hashtable4 = null;
                try {
                    hashtable4 = (Hashtable)hashtable.get(string3);
                    logger.debug(this.logPrefix + " [getRedisServerMeasure] The Metric key and value table is : " + hashtable4);
                }
                catch (Exception exception) {
                    logger.error(this.logPrefix + " [getRedisServerMeasure] Exception occured while fetching the values from testTable ", (Throwable)exception);
                }
                if (hashtable4 == null || hashtable4.size() <= 0) continue;
                Iterator iterator2 = (Iterator)((Object)hashtable4.keys());
                while (iterator2.hasNext()) {
                    String string4 = (String)iterator2.next();
                    Object object = null;
                    try {
                        object = hashtable4.get(string4);
                    }
                    catch (Exception exception) {
                        logger.error(this.logPrefix + " [getRedisServerMeasure] Exception occured while getting fetching the values from metricTable ", (Throwable)exception);
                    }
                    if (!arrayList.contains(string4)) continue;
                    String string5 = (String)hashtable3.get(string4);
                    int n = Integer.parseInt(hashtable2.get(string5).toString());
                    try {
                        double d = Double.parseDouble(object.toString());
                        arrayList2.set(n, new Double(d));
                        logger.debug(this.logPrefix + " [getRedisServerMeasure] index : " + n + " ==> metric name : " + string4 + " value: " + d);
                    }
                    catch (Exception exception) {
                        logger.error(this.logPrefix + " [getRedisServerMeasure] Exception occured while parsing String to Double", (Throwable)exception);
                    }
                }
            }
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " Exception occered in [getRedisServerMeasure] ", (Throwable)exception);
        }
        return arrayList2;
    }

    public static void main(String[] stringArray) throws InterruptedException {
        RedisCpuTest redisCpuTest = new RedisCpuTest(stringArray);
        while (true) {
            redisCpuTest.computeMeasures(new Hashtable());
            Thread.sleep(120000L);
        }
    }
}

