/*
 * Decompiled with CFR 0.152.
 */
import com.eg.EgUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import redis.clients.jedis.Jedis;

public class RedisClientTest
extends RedisBase {
    private static final String REDIS_CLIENT_COMMAND = "Clients";
    private static final String indexSubject = "REDIS_CLIENT_MEASURE_INDEX";
    private static final String nameSubject = "REDIS_CLIENT_MEASURE";
    private static String iniFilePath = "/agent/config/eg_measures.ini";
    private static Hashtable measureIndexTable = new Hashtable();
    private static Hashtable measureNameTable = new Hashtable();
    private static ArrayList redisNameList = new ArrayList();
    private long lastModifiedTime = 0L;
    private static final boolean isInfoBased = false;
    private static Date modifiedDate;
    private int max_clients = 20;
    private static final int MAX_CLIENT_LIMIT = 200;
    private String clientList = "";

    public RedisClientTest(String[] stringArray) {
        super(stringArray);
        try {
            this.needAgentlessDD = true;
            logger.info(this.logPrefix + " Initializing RedisClientTest ...");
            this.setMeasureCount(this.measureCount);
            measureIndexTable = this.getIndexTable(indexSubject);
            measureNameTable = this.getNameTable(nameSubject);
            redisNameList = this.getNameList(nameSubject);
            this.lastModifiedTime = this.getModifiedTime();
            logger.info(this.logPrefix + " RedisClientTest initialized successfully");
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " Exception while initializing RedisClientTest", (Throwable)exception);
        }
        String string = this.getValueForParam("Max_Clients");
        if (string != null && string.length() > 0) {
            try {
                this.max_clients = Integer.parseInt(string);
            }
            catch (Exception exception) {
                this.max_clients = 20;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        try {
            logger.debug(this.logPrefix + this.testStart);
            String string = this.getMetrics(REDIS_CLIENT_COMMAND);
            if (string == null || string.length() <= 0) {
                this.finalMeasures(this.measureCount);
                logger.info(this.logPrefix + " Redis Client Details is null or empty, hence sending -5 values for all measures ");
            } else {
                Hashtable hashtable2 = this.parseMetrics(string, false);
                this.getRedisMeasureClient(hashtable2);
            }
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " [computeMeasures]Exception occured in computeMeasures method", (Throwable)exception);
        }
        finally {
            logger.debug(this.logPrefix + this.testEnd);
        }
    }

    public void getRedisMeasureClient(Hashtable hashtable) {
        if (hashtable == null || hashtable.size() == 0) {
            logger.debug(this.logPrefix + "[getRedisMeasureClient]  metricObject is null or empty ,thus returning null");
            return;
        }
        try {
            long l = this.getModifiedTime();
            if (l - this.lastModifiedTime > 0L) {
                modifiedDate = new Date(l);
                logger.info(this.logPrefix + " [getModifiedTime] The INI File : " + iniFilePath + " was modified latestly on " + modifiedDate);
                this.updateINIFileObject();
                measureIndexTable = this.getIndexTable(indexSubject);
                measureNameTable = this.getNameTable(nameSubject);
                redisNameList = this.getNameList(nameSubject);
                this.lastModifiedTime = l;
            }
            logger.debug(this.logPrefix + " metricObject :" + hashtable);
            logger.debug(this.logPrefix + " measureIndexTable :" + measureIndexTable);
            logger.debug(this.logPrefix + " measureNameTable  :" + measureNameTable);
            logger.debug(this.logPrefix + " redisNameList     :" + redisNameList);
            ArrayList arrayList = this.finalMeasures(this.measureCount);
            Iterator iterator = (Iterator)((Object)hashtable.keys());
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Hashtable hashtable2 = null;
                try {
                    hashtable2 = (Hashtable)hashtable.get(string);
                    logger.debug(this.logPrefix + " [getRedisMeasureClient] The Metric key and value table is : " + hashtable2);
                }
                catch (Exception exception) {
                    logger.error(this.logPrefix + " [getRedisMeasureClient] Exception occured while fetching the values from testTable ", (Throwable)exception);
                }
                if (hashtable2 == null || hashtable2.size() <= 0) continue;
                Iterator iterator2 = (Iterator)((Object)hashtable2.keys());
                while (iterator2.hasNext()) {
                    String string2 = (String)iterator2.next();
                    Object object = null;
                    try {
                        object = hashtable2.get(string2);
                    }
                    catch (Exception exception) {
                        logger.error(this.logPrefix + " [getRedisMeasureClient] Exception occured while getting fetching the values from metricTable ", (Throwable)exception);
                    }
                    if (!redisNameList.contains(string2)) continue;
                    String string3 = (String)measureNameTable.get(string2);
                    int n = Integer.parseInt(measureIndexTable.get(string3).toString());
                    double d = 0.0;
                    try {
                        d = n != 2 ? Double.parseDouble(object.toString()) : Double.parseDouble(EgUtils.convertMemoryValues(object.toString(), "B", "MB"));
                        arrayList.set(n, new Double(d));
                        logger.debug(this.logPrefix + " [getRedisMeasureClient]  index : " + n + " ==> metric name : " + string2 + " value : " + d);
                    }
                    catch (Exception exception) {
                        logger.error(this.logPrefix + " [getRedisMeasureClient] Exception occured while parsing String to Double", (Throwable)exception);
                    }
                }
                logger.info(this.logPrefix + "  [getRedisMeasurePersistence]  The ArrayList  measure contains = " + arrayList);
                this.addNewMeasure(arrayList);
            }
        }
        catch (Exception exception) {
            logger.error(this.logPrefix + " Exception occered in [getRedisMeasurePersistence] ", (Throwable)exception);
        }
    }

    public int getMaxClient() {
        if (this.max_clients > 200) {
            this.max_clients = 200;
        }
        logger.debug(this.logPrefix + "[getRedisMeasureClient] [getMaxClient] The maximum number of clients :  " + this.max_clients);
        return this.max_clients;
    }

    public String getclientList() {
        Jedis jedis = this.getConnection();
        if (jedis == null) {
            logger.debug("[getRedisMeasureClient] [getclientList] jedis is returning null...");
        } else {
            this.clientList = jedis.clientList();
            logger.debug("[getRedisMeasureClient] [getclientList] The Client List is :  \n" + this.clientList);
            jedis.close();
        }
        return this.clientList;
    }

    public static void main(String[] stringArray) {
        RedisClientTest redisClientTest = new RedisClientTest(stringArray);
        redisClientTest.computeMeasures(new Hashtable());
    }
}

