/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;

public class OraResourceUseTest
extends GenericTest {
    public String oraSid = "";
    public String username = "";
    public String password = "";
    private boolean isOracle12c = false;
    private boolean checkOracleVersion = true;
    private boolean isCDB = false;
    private boolean isMultitenantDb = false;
    private boolean isDataguardEnabled = false;
    private static final int i_measureCount = 5;
    private boolean isInitCheckNeeded = true;
    public boolean isOracleOnCloud = false;

    public OraResourceUseTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(5);
        this.username = this.getValueForParam("username");
        if (this.username == null) {
            this.username = this.getValueForParam("user");
        }
        this.password = this.getValueForParam("password");
        this.oraSid = this.getValueForParam("info");
        if (this.oraSid == null) {
            this.oraSid = this.getValueForParam("oracle_sid");
        }
        String string = this.getValueForParam("cloud_hosted");
        if (this.username == null || this.username.equalsIgnoreCase("NULL") || this.username.equalsIgnoreCase("none")) {
            this.username = "";
        }
        if (this.password == null || this.password.equalsIgnoreCase("NULL") || this.password.equalsIgnoreCase("none")) {
            this.password = "";
        }
        if (this.oraSid == null || this.oraSid.equalsIgnoreCase("NULL") || this.oraSid.equalsIgnoreCase("none")) {
            this.oraSid = "";
        }
        if (string != null && (string.trim().equalsIgnoreCase("true") || string.trim().equalsIgnoreCase("yes") || string.trim().equalsIgnoreCase("y"))) {
            this.isOracleOnCloud = true;
        }
        if (!this.isOracleOnCloud) {
            this.setSid(this.oraSid);
        }
        this.isNewDynamicInfoTest = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void computeMeasures(Hashtable var1_1) {
        if (this.isInitCheckNeeded) {
            this.isDataguardEnabled = ConnectionManager.checkDataguardAvailability(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, OraResourceUseTest.debug, this.reportingName);
            var2_2 = new ArrayList();
            var2_2 = ConnectionManager.getOracleVersionDetail(this.reportingName + ":" + this.oraSid);
            if (var2_2 != null && var2_2.size() > 2) {
                var3_3 = (Integer)var2_2.get(0);
                var4_6 = (String)var2_2.get(1);
                if (var4_6.equalsIgnoreCase("true")) {
                    this.isCDB = true;
                }
                if (var3_3 >= 12) {
                    this.isOracle12c = true;
                    var5_7 = (String)var2_2.get(2);
                    if (var5_7.equalsIgnoreCase("true")) {
                        this.isMultitenantDb = true;
                    }
                }
                this.isInitCheckNeeded = false;
            } else {
                this.logToErrorFile("Error  :", this.entity, "Failed to find the Oracle version detail for targetHost:" + this.targetHost + " reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
            }
        }
        if (this.isDataguardEnabled) {
            var2_2 = ConnectionManager.getDataGuardStatus(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, OraResourceUseTest.debug, this.reportingName);
            if (var2_2 == null) return;
            if (var2_2.size() == 0) {
                return;
            }
            var3_4 = (ArrayList)var2_2.get(this.reportingName + ":" + this.oraSid);
            if (var3_4 == null) return;
            if (var3_4.size() <= 0) return;
            var4_6 = (String)var3_4.get(2);
            var5_7 = (String)var3_4.get(3);
            if (!var4_6.equalsIgnoreCase("PRIMARY") && var5_7.equalsIgnoreCase("MOUNTED")) {
                return;
            }
        }
        var2_2 = "select resource_name,initial_allocation,current_utilization,max_utilization,limit_value from v$resource_limit where resource_name in ('sessions','processes') ";
        var3_5 = null;
        var4_6 = null;
        var5_7 = null;
        try {
            block40: {
                if (this.isMultitenantDb && !this.isCDB) {
                    var3_5 = ConnectionManager.getOraServiceConn(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, OraResourceUseTest.debug);
                    var2_2 = "select resource_name,initial_allocation,current_utilization,max_utilization,limit_value from v$resource_limit where resource_name in ('sessions') ";
                } else {
                    var3_5 = ConnectionManager.getConnection(this.entity, this.targetHost, this.portNo, this.oraSid, this.username, this.password, OraResourceUseTest.debug);
                }
                if (var3_5 != null) break block40;
                this.logToErrorFile("Error  :", this.entity, "Connection is null targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid);
                var19_8 = null;
                ** GOTO lbl135
            }
            try {
                var4_6 = var3_5.createStatement();
            }
            catch (Exception var6_18) {
                this.logToErrorFile("Error :", "OraResourceUseTest Failed to Create Statement targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, var6_18.toString());
                var6_18.printStackTrace();
                try {
                    if (var3_5 != null) {
                        var3_5.close();
                    }
                }
                catch (Exception var7_21) {
                }
                var19_9 = null;
                try {
                    if (var5_7 != null) {
                        var5_7.close();
                    }
                    if (var4_6 != null) {
                        var4_6.close();
                    }
                    if (var3_5 == null) return;
                    var3_5.close();
                    return;
                }
                catch (Exception var20_14) {
                    System.out.println("Exception Occured in [" + this.getClass().getName() + "].computeMeasures() - finally block :" + var20_14.toString());
                }
                return;
            }
            var5_7 = var4_6.executeQuery((String)var2_2);
            var6_19 = new ArrayList<Double>();
            var7_22 = "";
            var8_23 = -5.0;
            var10_24 = -5.0;
            var12_25 = -5.0;
            var14_26 = -5.0;
            var16_27 = -5.0;
            while (var5_7.next()) {
                var6_19 = new ArrayList<E>();
                var7_22 = var5_7.getString(1);
                var8_23 = Double.parseDouble(var5_7.getString(2));
                var10_24 = Double.parseDouble(var5_7.getString(3));
                var12_25 = Double.parseDouble(var5_7.getString(4));
                var14_26 = Double.parseDouble(var5_7.getString(5));
                var16_27 = var10_24 / var14_26 * 100.0;
                var6_19.add(new Double(var8_23));
                var6_19.add(new Double(var10_24));
                var6_19.add(new Double(var12_25));
                var6_19.add(new Double(var14_26));
                var6_19.add(new Double(var16_27));
                this.addNewMeasure(var7_22, var6_19);
            }
            if (var6_19 == null || var6_19.size() == 0) {
                this.addDefaultMeasure();
            }
            ** GOTO lbl146
        }
        catch (Exception var6_20) {
            this.logToErrorFile("Error  :", this.entity + " ComputeMeasures() exception while uploading targetHost:" + this.targetHost + "  reportingName :" + this.reportingName + " Port :" + this.portNo + " SID :" + this.oraSid, var6_20.toString());
            System.out.println("Exception Occured in [" + this.getClass().getName() + "].computeMeasures():" + var6_20.toString());
            var6_20.printStackTrace();
            if (this.isPassive) {
                this.addDefaultMeasure();
            }
            var19_11 = null;
            try {}
            catch (Exception var20_16) {
                System.out.println("Exception Occured in [" + this.getClass().getName() + "].computeMeasures() - finally block :" + var20_16.toString());
                return;
            }
            if (var5_7 != null) {
                var5_7.close();
            }
            if (var4_6 != null) {
                var4_6.close();
            }
            if (var3_5 == null) return;
            var3_5.close();
            return;
        }
        {
            catch (Throwable var18_28) {
                var19_12 = null;
                ** try [egrp 4[TRYBLOCK] [10 : 1072->1109)] { 
lbl125:
                // 1 sources

                if (var5_7 != null) {
                    var5_7.close();
                }
                if (var4_6 != null) {
                    var4_6.close();
                }
                if (var3_5 == null) throw var18_28;
                var3_5.close();
                throw var18_28;
lbl132:
                // 1 sources

                catch (Exception var20_17) {
                    System.out.println("Exception Occured in [" + this.getClass().getName() + "].computeMeasures() - finally block :" + var20_17.toString());
                }
                throw var18_28;
            }
lbl135:
            // 1 sources

            ** try [egrp 4[TRYBLOCK] [10 : 1072->1109)] { 
lbl136:
            // 1 sources

            if (var5_7 != null) {
                var5_7.close();
            }
            if (var4_6 != null) {
                var4_6.close();
            }
            if (var3_5 == null) return;
            var3_5.close();
            return;
lbl143:
            // 1 sources

            catch (Exception var20_13) {
                System.out.println("Exception Occured in [" + this.getClass().getName() + "].computeMeasures() - finally block :" + var20_13.toString());
            }
            return;
lbl146:
            // 1 sources

            var19_10 = null;
            try {}
            catch (Exception var20_15) {}
            System.out.println("Exception Occured in [" + this.getClass().getName() + "].computeMeasures() - finally block :" + var20_15.toString());
            return;
            if (var5_7 != null) {
                var5_7.close();
            }
            if (var4_6 != null) {
                var4_6.close();
            }
            if (var3_5 == null) return;
            var3_5.close();
            return;
        }
    }

    public void addDefaultMeasure() {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        String string = "sessions";
        String string2 = "processes";
        arrayList.add(new Double(-5.0));
        arrayList.add(new Double(-5.0));
        arrayList.add(new Double(-5.0));
        arrayList.add(new Double(-5.0));
        arrayList.add(new Double(-5.0));
        this.addNewMeasure(string, arrayList);
        this.addNewMeasure(string2, arrayList);
    }

    public static void main(String[] stringArray) {
        OraResourceUseTest oraResourceUseTest = new OraResourceUseTest(stringArray);
        oraResourceUseTest.computeMeasures(new Hashtable());
    }
}

