/*
 * Decompiled with CFR 0.152.
 */
import com.eg.apm.NodeBlockedAt;
import com.eg.apm.NodeDataRepository;
import com.eg.apm.NodeEventloop;
import com.eg.apm.NodeInfra;
import com.eg.apm.NodeInfraCluster;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;

public class NodeELTest
extends NodeBase {
    private HashMap workers = null;
    private NodeBlockedAt[] blockedAtData = null;
    public static final String[] propsOrder = new String[]{"event_loop_stack_collection", "event_stack_collection_threshold"};

    public NodeELTest(String[] stringArray) {
        super(stringArray);
        this.needAgentlessDD = true;
        try {
            logger.info("{} Initializing NodeELTest ...", (Object)this.logPrefix);
            this.setMeasureCount(this.measureCount);
            logger.info("{} NodeELTest initialized successfully", (Object)this.logPrefix);
        }
        catch (Exception exception) {
            logger.error("{} Exception while initializing NodeELTest {} ", (Object)this.logPrefix, (Object)exception);
        }
    }

    @Override
    public void computeMeasures(Hashtable hashtable) {
        logger.debug("{} - Test cycle starting ", (Object)this.logPrefix);
        String string = "[" + this.reportingName + ":" + this.portNo + "]";
        this.checkForPropsChanges(propsOrder);
        try {
            ArrayList<Double> arrayList;
            int n = 0;
            if (NodeDataRepository.isInfraIdExists(string)) {
                n = NodeDataRepository.getInfraById(string).getWorkerCount();
            }
            if (!NodeDataRepository.isInfraIdExists(string)) {
                logger.debug("{} siteId: {} is not available", (Object)this.logPrefix, (Object)string);
                return;
            }
            NodeInfraCluster nodeInfraCluster = NodeDataRepository.getInfraById(string);
            NodeInfra nodeInfra = nodeInfraCluster.getMaster();
            NodeEventloop nodeEventloop = null;
            if (nodeInfra != null) {
                nodeEventloop = nodeInfra.getEventloop();
            }
            if (nodeEventloop != null) {
                this.blockedAtData = nodeEventloop.getBlockedAt();
                arrayList = new ArrayList<Double>();
                arrayList.add(new Double(nodeEventloop.getMax()));
                arrayList.add(new Double(nodeEventloop.getMin()));
                arrayList.add(new Double(nodeEventloop.getSum()));
                arrayList.add(new Double(nodeEventloop.getNum()));
                arrayList.add(new Double(new Double(nodeEventloop.getSum())) / new Double(nodeEventloop.getNum()) * 1000.0);
                arrayList.add(new Double(nodeEventloop.getLag()));
                arrayList.add(new Double(-5.0));
                if (n > 0) {
                    this.addNewMeasure("Master", arrayList);
                } else {
                    this.addNewMeasure(arrayList);
                }
                nodeInfra.setEventloop(null);
                logger.debug("{} Master - measures: {}", (Object)this.logPrefix, arrayList);
            } else {
                logger.debug("{}  {} Master - measure is null", (Object)this.logPrefix, (Object)string);
            }
            this.workers = nodeInfraCluster.getWorkers();
            if (this.workers != null && this.workers.size() > 0) {
                nodeEventloop = NodeDataRepository.aggregateEventloop(this.workers);
                if (nodeEventloop != null) {
                    arrayList = new ArrayList();
                    arrayList.add(new Double(nodeEventloop.getMax()));
                    arrayList.add(new Double(nodeEventloop.getMin()));
                    arrayList.add(new Double(nodeEventloop.getSum()));
                    arrayList.add(new Double(nodeEventloop.getNum()));
                    arrayList.add(new Double(new Double(nodeEventloop.getSum())) / new Double(nodeEventloop.getNum()) * 1000.0);
                    this.blockedAtData = nodeEventloop.getBlockedAt();
                    arrayList.add(new Double(nodeEventloop.getLag()));
                    arrayList.add(new Double(nodeInfraCluster.getWorkerCount()));
                    this.addNewMeasure("Workers", arrayList);
                    logger.debug("{} Worker - measures: {}", (Object)this.logPrefix, arrayList);
                } else {
                    logger.debug("{}  {} Worker - eventloop is null", (Object)this.logPrefix, (Object)string);
                }
            } else {
                logger.debug("{}  {} Worker - measure is null", (Object)this.logPrefix, (Object)string);
            }
        }
        catch (Exception exception) {
            logger.debug("{} Exception occurred while collecting Node eventloop object: {}", (Object)this.logPrefix, (Object)exception);
        }
    }

    public HashMap getWorkers() {
        return this.workers;
    }

    public void setWorkers(HashMap hashMap) {
        this.workers = hashMap;
    }

    public NodeBlockedAt[] getBlockedAtData() {
        return this.blockedAtData;
    }
}

