/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Hashtable;

public class NimbleDiskSpaceTest
extends EgSnmpGenericTest {
    public double byteToGB = 1.073741824E9;

    public NimbleDiskSpaceTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(2);
        this.snmpPortNo = this.getValueForParam("snmpPort");
        this.snmpVersion = this.getValueForParam("snmpVersion");
        this.community = this.getValueForParam("snmpCommunity");
        this.isNewDynamicInfoTest = true;
    }

    public void computeMeasures(Hashtable hashtable) {
        try {
            double d = this.getMeasure(".1.3.6.1.4.1.37447.1.3.12.0");
            double d2 = this.getMeasure(".1.3.6.1.4.1.37447.1.3.14.0");
            if (d > 0.0) {
                d /= this.byteToGB;
            }
            if (d2 > 0.0) {
                d2 /= this.byteToGB;
            }
            ArrayList<Double> arrayList = new ArrayList<Double>();
            arrayList.add(new Double(d));
            arrayList.add(new Double(d2));
            System.out.println("[NimbleDiskSpaceTest]  measureList===>" + arrayList);
            this.addNewMeasure(arrayList);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public double getMeasure(String string) {
        boolean bl = this.runSnmpCmdForOid(string);
        String string2 = "";
        double d = -5.0;
        if (bl) {
            for (int i = 0; i < this.lhs.length; ++i) {
                string2 = this.rhs[i];
                try {
                    d = Double.parseDouble(string2);
                    continue;
                }
                catch (Exception exception) {
                    d = -5.0;
                    exception.printStackTrace();
                }
            }
        }
        return d;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"-host", "192.168.10.170", "-port", "NULL", "-snmpPort", "161", "-snmpversion", "v1", "-snmpCommunity", "public"};
        NimbleDiskSpaceTest nimbleDiskSpaceTest = new NimbleDiskSpaceTest(stringArray2);
        try {
            while (true) {
                nimbleDiskSpaceTest.computeMeasures(new Hashtable());
                Thread.sleep(1000L);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }
}

