/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import netapp.manage.NaElement;
import netapp.manage.NaServer;

class NetCluAggrPerfTest
extends NAUSDCluBase {
    Hashtable prevPerfHT;
    ArrayList excludeList = new ArrayList();
    Hashtable currPerfHT = new Hashtable();
    private int maxRecords = 10;

    public NetCluAggrPerfTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(6);
        String string = this.getValueForParam("exclude_aggregate");
        String string2 = this.getValueForParam("records_per_call");
        this.excludeList = new ArrayList();
        if (string != null && !string.equalsIgnoreCase("none")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            int n = stringTokenizer.countTokens();
            for (int i = 0; i < n; ++i) {
                String string3 = stringTokenizer.nextToken().trim();
                this.excludeList.add(string3);
            }
        }
        if (string2 != null && !string2.equalsIgnoreCase("none")) {
            try {
                this.maxRecords = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.maxRecords = 10;
            }
        }
    }

    public void computeMeasures(Hashtable hashtable) {
        NaServer naServer = null;
        this.currPerfHT = new Hashtable();
        try {
            naServer = this.getConnection();
            if (naServer == null) {
                this.closeConnection(naServer);
                this.logToErrorFile("Error :", "NetCluAggrPerfTest ", "Connection is null");
                this.printOut("Error", "NetCluAggrPerfTest Connection is null");
                return;
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "NetCluAggrPerfTest error occured while connecting ", exception.toString());
            exception.printStackTrace();
        }
        try {
            int n;
            String[] stringArray = new String[]{"cp_reads", "total_transfers", "user_read_blocks", "user_reads", "user_write_blocks", "user_writes"};
            NaElement naElement = new NaElement("perf-object-instance-list-info-iter");
            NaElement naElement2 = new NaElement("objectname", "aggregate");
            naElement.addChildElem(naElement2);
            NaElement naElement3 = this.execONTAPI(naServer, naElement);
            if (naElement3 == null) {
                this.closeConnection(naServer);
                this.printOut("DEBUG", "NetCluAggrPerfTest instance is null");
                return;
            }
            int n2 = naElement3.getChildIntValue("num-records", 0);
            if (n2 <= 0) {
                this.closeConnection(naServer);
                this.printOut("DEBUG", "NetCluAggrPerfTest noOfRecords is zero");
                return;
            }
            List list = naElement3.getChildByName("attributes-list").getChildren();
            Iterator iterator = list.iterator();
            ArrayList<String> arrayList = new ArrayList<String>();
            while (iterator.hasNext()) {
                NaElement naElement4 = (NaElement)iterator.next();
                String string = naElement4.getChildContent("name");
                boolean bl = false;
                if (this.excludeList != null && this.excludeList.size() > 0) {
                    String string2;
                    for (n = 0; n < this.excludeList.size() && !(bl = NetCluAggrPerfTest.isMatch(string, string2 = (String)this.excludeList.get(n))); ++n) {
                    }
                }
                if (bl) continue;
                arrayList.add(string);
            }
            int n3 = arrayList.size();
            if (n3 <= 0) {
                this.closeConnection(naServer);
                this.printOut("DEBUG", "NetCluAggrPerfTest instance list is zero ");
                return;
            }
            ArrayList arrayList2 = new ArrayList();
            n = 0;
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                arrayList2.add(arrayList.get(i));
                if (++n != this.maxRecords && ++n4 != n3) continue;
                this.getOutput(naServer, arrayList2, stringArray);
                n = 0;
                arrayList2 = new ArrayList();
            }
            if (this.currPerfHT == null) {
                this.closeConnection(naServer);
                return;
            }
            if (this.prevPerfHT == null) {
                this.prevPerfHT = (Hashtable)this.currPerfHT.clone();
                this.closeConnection(naServer);
                return;
            }
            Enumeration enumeration = this.currPerfHT.keys();
            String string = null;
            ArrayList arrayList3 = null;
            ArrayList arrayList4 = null;
            ArrayList arrayList5 = null;
            Object var21_27 = null;
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                arrayList3 = (ArrayList)this.currPerfHT.get(string);
                arrayList4 = (ArrayList)this.prevPerfHT.get(string);
                arrayList5 = this.calcPerfMeas(string, arrayList3, arrayList4);
                this.addNewMeasure(string, arrayList5);
            }
            this.prevPerfHT = (Hashtable)this.currPerfHT.clone();
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "NetCluAggrPerfTest error occured in computeMeasure:", exception.toString());
            this.printOut("Error", "NetCluAggrPerfTest error occured in computeMeasure :" + exception.toString());
            exception.printStackTrace();
        }
        this.closeConnection(naServer);
    }

    private void getOutput(NaServer naServer, ArrayList arrayList, String[] stringArray) {
        Hashtable<String, Double> hashtable = new Hashtable<String, Double>();
        try {
            int n;
            int n2 = arrayList.size();
            String[] stringArray2 = new String[n2];
            for (int i = 0; i < n2; ++i) {
                stringArray2[i] = (String)arrayList.get(i);
            }
            NaElement naElement = new NaElement("perf-object-get-instances");
            NaElement naElement2 = new NaElement("objectname", "aggregate");
            naElement.addChildElem(naElement2);
            NaElement naElement3 = new NaElement("instances");
            NaElement naElement4 = new NaElement("counters");
            int n3 = stringArray2.length;
            int n4 = stringArray.length;
            for (n = 0; n < n3; ++n) {
                naElement3.addNewChild("instance", stringArray2[n]);
            }
            for (n = 0; n < n4; ++n) {
                naElement4.addNewChild("counter", stringArray[n]);
            }
            naElement.addChildElem(naElement3);
            naElement.addChildElem(naElement4);
            String string = "";
            Iterator iterator = null;
            Iterator iterator2 = null;
            NaElement naElement5 = this.execONTAPI(naServer, naElement);
            if (naElement5 == null) {
                this.printOut("DEBUG", "Output for NetCluAggrPerfTest is null");
                return;
            }
            String string2 = naElement5.getChildContent("timestamp");
            List list = naElement5.getChildByName("instances").getChildren();
            iterator = list.iterator();
            while (iterator.hasNext()) {
                String string3;
                NaElement naElement6 = (NaElement)iterator.next();
                String string4 = naElement6.getChildContent("name");
                String string5 = naElement6.getChildContent("uuid");
                List list2 = naElement6.getChildByName("counters").getChildren();
                iterator2 = list2.iterator();
                while (iterator2.hasNext()) {
                    NaElement naElement7 = (NaElement)iterator2.next();
                    string3 = naElement7.getChildContent("name");
                    long l = naElement7.getChildLongValue("value", 0L);
                    hashtable.put(string3, new Double(l));
                }
                string3 = null;
                ArrayList arrayList2 = new ArrayList();
                arrayList2 = this.getPerfList(hashtable, stringArray, string2, string3);
                this.currPerfHT.put(string4, arrayList2);
            }
        }
        catch (Exception exception) {
            this.logToErrorFile("Error :", "NetCluAggrPerfTest error occured in getoutput:", exception.toString());
            this.printOut("Error", "NetCluAggrPerfTest error occured in getoutput:" + exception.toString());
            exception.printStackTrace();
        }
    }

    private ArrayList calcPerfMeas(String string, ArrayList arrayList, ArrayList arrayList2) {
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        ArrayList arrayList4 = this.getDiffList(arrayList, arrayList2);
        Object var6_6 = null;
        Object var7_7 = null;
        Double d = this.divide(arrayList4.get(1), arrayList4.get(0));
        Double d2 = this.divide(arrayList4.get(2), arrayList4.get(0));
        Double d3 = this.divide(arrayList4.get(3), arrayList4.get(0));
        Double d4 = this.divide(arrayList4.get(4), arrayList4.get(0));
        Double d5 = this.divide(arrayList4.get(5), arrayList4.get(0));
        Double d6 = this.divide(arrayList4.get(6), arrayList4.get(0));
        arrayList3.add(d);
        arrayList3.add(d2);
        arrayList3.add(d3);
        arrayList3.add(d4);
        arrayList3.add(d5);
        arrayList3.add(d6);
        return arrayList3;
    }

    private ArrayList getPerfList(Hashtable hashtable, String[] stringArray, String string, String string2) {
        Hashtable hashtable2 = new Hashtable();
        int n = stringArray.length;
        Double d = null;
        String string3 = "";
        ArrayList<Double> arrayList = new ArrayList<Double>();
        arrayList.add(new Double(string));
        for (int i = 0; i < n; ++i) {
            string3 = stringArray[i];
            if (string2 != null && string2.equalsIgnoreCase(string3)) continue;
            d = (Double)hashtable.get(string3);
            if (d == null) {
                d = NADbl;
            }
            arrayList.add(d);
        }
        return arrayList;
    }

    public static void main(String[] stringArray) {
        NetCluAggrPerfTest netCluAggrPerfTest = new NetCluAggrPerfTest(stringArray);
        netCluAggrPerfTest.computeMeasures(new Hashtable());
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        netCluAggrPerfTest.computeMeasures(new Hashtable());
    }
}

